/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.aws.deploy.handlers;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancing;
import com.amazonaws.services.elasticloadbalancing.model.ApplySecurityGroupsToLoadBalancerRequest;
import com.amazonaws.services.elasticloadbalancing.model.CreateLoadBalancerListenersRequest;
import com.amazonaws.services.elasticloadbalancing.model.CreateLoadBalancerRequest;
import com.amazonaws.services.elasticloadbalancing.model.DeleteLoadBalancerListenersRequest;
import com.amazonaws.services.elasticloadbalancing.model.Listener;
import com.amazonaws.services.elasticloadbalancing.model.ListenerDescription;
import com.amazonaws.services.elasticloadbalancing.model.LoadBalancerAttributes;
import com.amazonaws.services.elasticloadbalancing.model.LoadBalancerDescription;
import com.amazonaws.services.elasticloadbalancing.model.ModifyLoadBalancerAttributesRequest;
import com.amazonaws.services.elasticloadbalancing.model.SetLoadBalancerPoliciesOfListenerRequest;
import com.netflix.spinnaker.clouddriver.data.task.Task;
import com.netflix.spinnaker.clouddriver.data.task.TaskRepository;
import com.netflix.spinnaker.clouddriver.orchestration.AtomicOperationException;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.lang.ref.SoftReference;
import java.util.Collection;
import java.util.List;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.ArrayUtil;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadBalancerUpsertHandler
implements GroovyObject {
    private static final String BASE_PHASE = "UPSERT_ELB";
    private static Closure notLegacyListener;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo$;
    private static /* synthetic */ SoftReference $callSiteArray;

    @Generated
    public LoadBalancerUpsertHandler() {
        MetaClass metaClass;
        CallSite[] callSiteArray = LoadBalancerUpsertHandler.$getCallSiteArray();
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    private static Task getTask() {
        CallSite[] callSiteArray = LoadBalancerUpsertHandler.$getCallSiteArray();
        return (Task)ScriptBytecodeAdapter.castToType((Object)callSiteArray[0].call(callSiteArray[1].callGetProperty(TaskRepository.class)), Task.class);
    }

    /*
     * WARNING - void declaration
     */
    public static void updateLoadBalancer(AmazonElasticLoadBalancing loadBalancing, LoadBalancerDescription loadBalancer, List<Listener> listeners, Collection<String> securityGroups) {
        void var2_2;
        void var1_1;
        Reference loadBalancing2 = new Reference((Object)loadBalancing);
        Reference loadBalancer2 = new Reference((Object)var1_1);
        Reference listeners2 = new Reference((Object)var2_2);
        CallSite[] callSiteArray = LoadBalancerUpsertHandler.$getCallSiteArray();
        Reference amazonErrors = new Reference((Object)ScriptBytecodeAdapter.createList((Object[])new Object[0]));
        Reference loadBalancerName = new Reference(callSiteArray[2].callGetProperty((Object)((LoadBalancerDescription)loadBalancer2.get())));
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[3].call((Object)((LoadBalancerDescription)loadBalancer2.get()))) && !DefaultTypeTransformation.booleanUnbox(securityGroups)) {
            throw (Throwable)callSiteArray[4].callConstructor(IllegalArgumentException.class, (Object)new GStringImpl(new Object[]{loadBalancerName.get()}, new String[]{"Load balancer ", " must have at least one security group"}));
        }
        if (DefaultTypeTransformation.booleanUnbox(securityGroups)) {
            callSiteArray[5].call((Object)((AmazonElasticLoadBalancing)loadBalancing2.get()), callSiteArray[6].callConstructor(ApplySecurityGroupsToLoadBalancerRequest.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"loadBalancerName", loadBalancerName.get(), "securityGroups", securityGroups})));
        }
        callSiteArray[7].call(callSiteArray[8].callGetProperty(LoadBalancerUpsertHandler.class), (Object)BASE_PHASE, (Object)new GStringImpl(new Object[]{loadBalancerName.get()}, new String[]{"Security groups updated on ", "."}));
        if (DefaultTypeTransformation.booleanUnbox((Object)((List)listeners2.get()))) {
            Object object = callSiteArray[9].call((Object)((List)listeners2.get()), (Object)notLegacyListener);
            listeners2.set((Object)((List)ScriptBytecodeAdapter.castToType((Object)object, List.class)));
            Object existingListeners = callSiteArray[10].call(ScriptBytecodeAdapter.getPropertySpreadSafe(LoadBalancerUpsertHandler.class, (Object)callSiteArray[11].callGetProperty((Object)((LoadBalancerDescription)loadBalancer2.get())), (String)"listener"), (Object)notLegacyListener);
            public final class _updateLoadBalancer_closure1
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference listeners;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;

                public _updateLoadBalancer_closure1(Object _outerInstance, Object _thisObject, Reference listeners) {
                    Reference reference;
                    CallSite[] callSiteArray = _updateLoadBalancer_closure1.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                    this.listeners = reference = listeners;
                }

                public Object doCall(Object it) {
                    CallSite[] callSiteArray = _updateLoadBalancer_closure1.$getCallSiteArray();
                    return !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[0].call(this.listeners.get(), it));
                }

                @Generated
                public List getListeners() {
                    CallSite[] callSiteArray = _updateLoadBalancer_closure1.$getCallSiteArray();
                    return (List)ScriptBytecodeAdapter.castToType((Object)this.listeners.get(), List.class);
                }

                @Generated
                public Object doCall() {
                    CallSite[] callSiteArray = _updateLoadBalancer_closure1.$getCallSiteArray();
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _updateLoadBalancer_closure1.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[1];
                    stringArray[0] = "contains";
                    return new CallSiteArray(_updateLoadBalancer_closure1.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _updateLoadBalancer_closure1.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            }
            Reference listenersToRemove = new Reference(callSiteArray[12].call(existingListeners, (Object)new _updateLoadBalancer_closure1(LoadBalancerUpsertHandler.class, LoadBalancerUpsertHandler.class, listeners2)));
            callSiteArray[13].call((Object)((List)listeners2.get()), listenersToRemove.get());
            callSiteArray[14].call((Object)((List)listeners2.get()), existingListeners);
            public final class _updateLoadBalancer_closure2
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference listenersToRemove;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;

                public _updateLoadBalancer_closure2(Object _outerInstance, Object _thisObject, Reference listenersToRemove) {
                    Reference reference;
                    CallSite[] callSiteArray = _updateLoadBalancer_closure2.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                    this.listenersToRemove = reference = listenersToRemove;
                }

                public Object doCall(Object it) {
                    CallSite[] callSiteArray = _updateLoadBalancer_closure2.$getCallSiteArray();
                    return ScriptBytecodeAdapter.isCase((Object)callSiteArray[0].callGetProperty(it), (Object)this.listenersToRemove.get());
                }

                @Generated
                public Object getListenersToRemove() {
                    CallSite[] callSiteArray = _updateLoadBalancer_closure2.$getCallSiteArray();
                    return this.listenersToRemove.get();
                }

                @Generated
                public Object doCall() {
                    CallSite[] callSiteArray = _updateLoadBalancer_closure2.$getCallSiteArray();
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _updateLoadBalancer_closure2.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[1];
                    stringArray[0] = "listener";
                    return new CallSiteArray(_updateLoadBalancer_closure2.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _updateLoadBalancer_closure2.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            }
            List listenerDescriptionsToRemove = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[15].call(callSiteArray[16].callGetProperty((Object)((LoadBalancerDescription)loadBalancer2.get())), (Object)new _updateLoadBalancer_closure2(LoadBalancerUpsertHandler.class, LoadBalancerUpsertHandler.class, listenersToRemove)), List.class);
            public final class _updateLoadBalancer_closure3
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference loadBalancing;
                private /* synthetic */ Reference loadBalancerName;
                private /* synthetic */ Reference amazonErrors;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;

                public _updateLoadBalancer_closure3(Object _outerInstance, Object _thisObject, Reference loadBalancing, Reference loadBalancerName, Reference amazonErrors) {
                    Reference reference;
                    Reference reference2;
                    Reference reference3;
                    CallSite[] callSiteArray = _updateLoadBalancer_closure3.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                    this.loadBalancing = reference3 = loadBalancing;
                    this.loadBalancerName = reference2 = loadBalancerName;
                    this.amazonErrors = reference = amazonErrors;
                }

                public Object doCall(ListenerDescription listenerDescription, boolean isRollback) {
                    CallSite[] callSiteArray = _updateLoadBalancer_closure3.$getCallSiteArray();
                    try {
                        callSiteArray[0].call(this.loadBalancing.get(), callSiteArray[1].callConstructor(CreateLoadBalancerListenersRequest.class, this.loadBalancerName.get(), (Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{callSiteArray[2].callGetProperty((Object)listenerDescription)})));
                        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[3].call(callSiteArray[4].callGetProperty((Object)listenerDescription)))) {
                            callSiteArray[5].callStatic(LoadBalancerUpsertHandler.class, this.loadBalancerName.get(), (Object)listenerDescription, this.loadBalancing.get());
                        }
                        callSiteArray[6].call(callSiteArray[7].callGroovyObjectGetProperty((Object)this), callSiteArray[8].callGetProperty(LoadBalancerUpsertHandler.class), callSiteArray[9].call((Object)new GStringImpl(new Object[]{isRollback ? "rolled back on" : "added to", this.loadBalancerName.get()}, new String[]{"Listener ", " ", " "}), (Object)new GStringImpl(new Object[]{callSiteArray[10].callGetProperty(callSiteArray[11].callGetProperty((Object)listenerDescription)), callSiteArray[12].callGetProperty(callSiteArray[13].callGetProperty((Object)listenerDescription)), callSiteArray[14].callGetProperty(callSiteArray[15].callGetProperty((Object)listenerDescription))}, new String[]{"(", ":", ":", ")."})));
                    }
                    catch (AmazonServiceException e) {
                        Object exceptionMessage = callSiteArray[16].call(callSiteArray[17].call((Object)new GStringImpl(new Object[]{isRollback ? "roll back" : "add", this.loadBalancerName.get()}, new String[]{"Failed to ", " listener to ", " "}), (Object)new GStringImpl(new Object[]{callSiteArray[18].callGetProperty(callSiteArray[19].callGetProperty((Object)listenerDescription)), callSiteArray[20].callGetProperty(callSiteArray[21].callGetProperty((Object)listenerDescription)), callSiteArray[22].callGetProperty(callSiteArray[23].callGetProperty((Object)listenerDescription))}, new String[]{"(", ":", ":", ") "})), (Object)new GStringImpl(new Object[]{callSiteArray[24].callGetProperty((Object)e)}, new String[]{"- reason: ", "."}));
                        callSiteArray[25].call(callSiteArray[26].callGroovyObjectGetProperty((Object)this), callSiteArray[27].callGetProperty(LoadBalancerUpsertHandler.class), exceptionMessage);
                        callSiteArray[28].call(this.amazonErrors.get(), exceptionMessage);
                        Boolean bl = false;
                        return bl;
                    }
                    return true;
                }

                public Object call(ListenerDescription listenerDescription, boolean isRollback) {
                    CallSite[] callSiteArray = _updateLoadBalancer_closure3.$getCallSiteArray();
                    return callSiteArray[29].callCurrent((GroovyObject)this, (Object)listenerDescription, (Object)isRollback);
                }

                @Generated
                public AmazonElasticLoadBalancing getLoadBalancing() {
                    CallSite[] callSiteArray = _updateLoadBalancer_closure3.$getCallSiteArray();
                    return (AmazonElasticLoadBalancing)ScriptBytecodeAdapter.castToType((Object)this.loadBalancing.get(), AmazonElasticLoadBalancing.class);
                }

                @Generated
                public Object getLoadBalancerName() {
                    CallSite[] callSiteArray = _updateLoadBalancer_closure3.$getCallSiteArray();
                    return this.loadBalancerName.get();
                }

                @Generated
                public Object getAmazonErrors() {
                    CallSite[] callSiteArray = _updateLoadBalancer_closure3.$getCallSiteArray();
                    return this.amazonErrors.get();
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _updateLoadBalancer_closure3.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                    stringArray[0] = "createLoadBalancerListeners";
                    stringArray[1] = "<$constructor$>";
                    stringArray[2] = "listener";
                    stringArray[3] = "isEmpty";
                    stringArray[4] = "policyNames";
                    stringArray[5] = "ensureSetLoadBalancerListenerPolicies";
                    stringArray[6] = "updateStatus";
                    stringArray[7] = "task";
                    stringArray[8] = "BASE_PHASE";
                    stringArray[9] = "plus";
                    stringArray[10] = "loadBalancerPort";
                    stringArray[11] = "listener";
                    stringArray[12] = "protocol";
                    stringArray[13] = "listener";
                    stringArray[14] = "instancePort";
                    stringArray[15] = "listener";
                    stringArray[16] = "plus";
                    stringArray[17] = "plus";
                    stringArray[18] = "loadBalancerPort";
                    stringArray[19] = "listener";
                    stringArray[20] = "protocol";
                    stringArray[21] = "listener";
                    stringArray[22] = "instancePort";
                    stringArray[23] = "listener";
                    stringArray[24] = "errorMessage";
                    stringArray[25] = "updateStatus";
                    stringArray[26] = "task";
                    stringArray[27] = "BASE_PHASE";
                    stringArray[28] = "leftShift";
                    stringArray[29] = "doCall";
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[30];
                    _updateLoadBalancer_closure3.$createCallSiteArray_1(stringArray);
                    return new CallSiteArray(_updateLoadBalancer_closure3.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _updateLoadBalancer_closure3.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            }
            Reference createListener = new Reference((Object)new _updateLoadBalancer_closure3(LoadBalancerUpsertHandler.class, LoadBalancerUpsertHandler.class, loadBalancing2, loadBalancerName, amazonErrors));
            Reference rollback = new Reference((Object)false);
            public final class _updateLoadBalancer_closure4
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference loadBalancing;
                private /* synthetic */ Reference loadBalancerName;
                private /* synthetic */ Reference amazonErrors;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;

                public _updateLoadBalancer_closure4(Object _outerInstance, Object _thisObject, Reference loadBalancing, Reference loadBalancerName, Reference amazonErrors) {
                    Reference reference;
                    Reference reference2;
                    Reference reference3;
                    CallSite[] callSiteArray = _updateLoadBalancer_closure4.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                    this.loadBalancing = reference3 = loadBalancing;
                    this.loadBalancerName = reference2 = loadBalancerName;
                    this.amazonErrors = reference = amazonErrors;
                }

                public Object doCall(Object it) {
                    CallSite[] callSiteArray = _updateLoadBalancer_closure4.$getCallSiteArray();
                    callSiteArray[0].call(this.loadBalancing.get(), callSiteArray[1].callConstructor(DeleteLoadBalancerListenersRequest.class, this.loadBalancerName.get(), (Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{callSiteArray[2].callGetProperty(callSiteArray[3].callGetProperty(it))})));
                    Object object = callSiteArray[4].call(callSiteArray[5].callGroovyObjectGetProperty((Object)this), callSiteArray[6].callGetProperty(LoadBalancerUpsertHandler.class), (Object)new GStringImpl(new Object[]{this.loadBalancerName.get(), callSiteArray[7].callGetProperty(callSiteArray[8].callGetProperty(it)), callSiteArray[9].callGetProperty(callSiteArray[10].callGetProperty(it)), callSiteArray[11].callGetProperty(callSiteArray[12].callGetProperty(it))}, new String[]{"Listener removed from ", " (", ":", ":", ")."}));
                    try {
                        return object;
                    }
                    catch (AmazonServiceException e) {
                        callSiteArray[13].call(callSiteArray[14].callGroovyObjectGetProperty((Object)this), callSiteArray[15].callGetProperty(LoadBalancerUpsertHandler.class), (Object)new GStringImpl(new Object[]{it, callSiteArray[16].callGetProperty((Object)e)}, new String[]{"Failed to remove listener ", ": ", "."}));
                        Object object2 = callSiteArray[17].call(this.amazonErrors.get(), callSiteArray[18].callGetProperty((Object)e));
                        return object2;
                    }
                }

                @Generated
                public AmazonElasticLoadBalancing getLoadBalancing() {
                    CallSite[] callSiteArray = _updateLoadBalancer_closure4.$getCallSiteArray();
                    return (AmazonElasticLoadBalancing)ScriptBytecodeAdapter.castToType((Object)this.loadBalancing.get(), AmazonElasticLoadBalancing.class);
                }

                @Generated
                public Object getLoadBalancerName() {
                    CallSite[] callSiteArray = _updateLoadBalancer_closure4.$getCallSiteArray();
                    return this.loadBalancerName.get();
                }

                @Generated
                public Object getAmazonErrors() {
                    CallSite[] callSiteArray = _updateLoadBalancer_closure4.$getCallSiteArray();
                    return this.amazonErrors.get();
                }

                @Generated
                public Object doCall() {
                    CallSite[] callSiteArray = _updateLoadBalancer_closure4.$getCallSiteArray();
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _updateLoadBalancer_closure4.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                    stringArray[0] = "deleteLoadBalancerListeners";
                    stringArray[1] = "<$constructor$>";
                    stringArray[2] = "loadBalancerPort";
                    stringArray[3] = "listener";
                    stringArray[4] = "updateStatus";
                    stringArray[5] = "task";
                    stringArray[6] = "BASE_PHASE";
                    stringArray[7] = "loadBalancerPort";
                    stringArray[8] = "listener";
                    stringArray[9] = "protocol";
                    stringArray[10] = "listener";
                    stringArray[11] = "instancePort";
                    stringArray[12] = "listener";
                    stringArray[13] = "updateStatus";
                    stringArray[14] = "task";
                    stringArray[15] = "BASE_PHASE";
                    stringArray[16] = "errorMessage";
                    stringArray[17] = "leftShift";
                    stringArray[18] = "errorMessage";
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[19];
                    _updateLoadBalancer_closure4.$createCallSiteArray_1(stringArray);
                    return new CallSiteArray(_updateLoadBalancer_closure4.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _updateLoadBalancer_closure4.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            }
            callSiteArray[17].call((Object)listenerDescriptionsToRemove, (Object)new _updateLoadBalancer_closure4(LoadBalancerUpsertHandler.class, LoadBalancerUpsertHandler.class, loadBalancing2, loadBalancerName, amazonErrors));
            public final class _updateLoadBalancer_closure5
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference loadBalancer;
                private /* synthetic */ Reference createListener;
                private /* synthetic */ Reference rollback;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;

                public _updateLoadBalancer_closure5(Object _outerInstance, Object _thisObject, Reference loadBalancer, Reference createListener, Reference rollback) {
                    Reference reference;
                    Reference reference2;
                    Reference reference3;
                    CallSite[] callSiteArray = _updateLoadBalancer_closure5.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                    this.loadBalancer = reference3 = loadBalancer;
                    this.createListener = reference2 = createListener;
                    this.rollback = reference = rollback;
                }

                public Object doCall(Object listener) {
                    Reference listener2 = new Reference(listener);
                    CallSite[] callSiteArray = _updateLoadBalancer_closure5.$getCallSiteArray();
                    public final class _closure8
                    extends Closure
                    implements GeneratedClosure {
                        private /* synthetic */ Reference listener;
                        private static /* synthetic */ ClassInfo $staticClassInfo;
                        public static transient /* synthetic */ boolean __$stMC;
                        private static /* synthetic */ SoftReference $callSiteArray;

                        public _closure8(Object _outerInstance, Object _thisObject, Reference listener) {
                            Reference reference;
                            CallSite[] callSiteArray = _closure8.$getCallSiteArray();
                            super(_outerInstance, _thisObject);
                            this.listener = reference = listener;
                        }

                        public Object doCall(Object it) {
                            CallSite[] callSiteArray = _closure8.$getCallSiteArray();
                            if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                                return ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[0].callGetProperty(callSiteArray[1].callGetProperty(it)), (Object)callSiteArray[2].callGetProperty(this.listener.get())) && ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[3].callGetProperty(callSiteArray[4].callGetProperty(it)), (Object)callSiteArray[5].callGetProperty(this.listener.get()));
                            }
                            return ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[6].callGetProperty(callSiteArray[7].callGetProperty(it)), (Object)callSiteArray[8].callGetProperty(this.listener.get())) && ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[9].callGetProperty(callSiteArray[10].callGetProperty(it)), (Object)callSiteArray[11].callGetProperty(this.listener.get()));
                        }

                        @Generated
                        public Object getListener() {
                            CallSite[] callSiteArray = _closure8.$getCallSiteArray();
                            return this.listener.get();
                        }

                        @Generated
                        public Object doCall() {
                            CallSite[] callSiteArray = _closure8.$getCallSiteArray();
                            return this.doCall(null);
                        }

                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                            if (((Object)((Object)this)).getClass() != _closure8.class) {
                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                            }
                            ClassInfo classInfo = $staticClassInfo;
                            if (classInfo == null) {
                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                            }
                            return classInfo.getMetaClass();
                        }

                        private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                            stringArray[0] = "loadBalancerPort";
                            stringArray[1] = "listener";
                            stringArray[2] = "loadBalancerPort";
                            stringArray[3] = "protocol";
                            stringArray[4] = "listener";
                            stringArray[5] = "protocol";
                            stringArray[6] = "loadBalancerPort";
                            stringArray[7] = "listener";
                            stringArray[8] = "loadBalancerPort";
                            stringArray[9] = "protocol";
                            stringArray[10] = "listener";
                            stringArray[11] = "protocol";
                        }

                        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                            String[] stringArray = new String[12];
                            _closure8.$createCallSiteArray_1(stringArray);
                            return new CallSiteArray(_closure8.class, stringArray);
                        }

                        private static /* synthetic */ CallSite[] $getCallSiteArray() {
                            CallSiteArray callSiteArray;
                            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                                callSiteArray = _closure8.$createCallSiteArray();
                                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                            }
                            return callSiteArray.array;
                        }
                    }
                    List policyNames = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[0].callGetPropertySafe(callSiteArray[1].call(callSiteArray[2].callGetProperty(this.loadBalancer.get()), (Object)new _closure8((Object)this, this.getThisObject(), listener2))), List.class);
                    ListenerDescription description = (ListenerDescription)ScriptBytecodeAdapter.castToType((Object)callSiteArray[3].callConstructor(ListenerDescription.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"listener", listener2.get(), "policyNames", policyNames})), ListenerDescription.class);
                    if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[4].call(this.createListener.get(), (Object)description, (Object)false))) {
                        boolean bl = true;
                        this.rollback.set((Object)bl);
                        return bl;
                    }
                    return null;
                }

                @Generated
                public LoadBalancerDescription getLoadBalancer() {
                    CallSite[] callSiteArray = _updateLoadBalancer_closure5.$getCallSiteArray();
                    return (LoadBalancerDescription)ScriptBytecodeAdapter.castToType((Object)this.loadBalancer.get(), LoadBalancerDescription.class);
                }

                @Generated
                public Object getCreateListener() {
                    CallSite[] callSiteArray = _updateLoadBalancer_closure5.$getCallSiteArray();
                    return this.createListener.get();
                }

                @Generated
                public Boolean getRollback() {
                    CallSite[] callSiteArray = _updateLoadBalancer_closure5.$getCallSiteArray();
                    return (Boolean)ScriptBytecodeAdapter.castToType((Object)this.rollback.get(), Boolean.class);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _updateLoadBalancer_closure5.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                    stringArray[0] = "policyNames";
                    stringArray[1] = "find";
                    stringArray[2] = "listenerDescriptions";
                    stringArray[3] = "<$constructor$>";
                    stringArray[4] = "call";
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[5];
                    _updateLoadBalancer_closure5.$createCallSiteArray_1(stringArray);
                    return new CallSiteArray(_updateLoadBalancer_closure5.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _updateLoadBalancer_closure5.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            }
            callSiteArray[18].call((Object)((List)listeners2.get()), (Object)new _updateLoadBalancer_closure5(LoadBalancerUpsertHandler.class, LoadBalancerUpsertHandler.class, loadBalancer2, createListener, rollback));
            if (DefaultTypeTransformation.booleanUnbox((Object)amazonErrors.get()) || DefaultTypeTransformation.booleanUnbox((Object)((Boolean)rollback.get()))) {
                public final class _updateLoadBalancer_closure6
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference createListener;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;
                    private static /* synthetic */ SoftReference $callSiteArray;

                    public _updateLoadBalancer_closure6(Object _outerInstance, Object _thisObject, Reference createListener) {
                        Reference reference;
                        CallSite[] callSiteArray = _updateLoadBalancer_closure6.$getCallSiteArray();
                        super(_outerInstance, _thisObject);
                        this.createListener = reference = createListener;
                    }

                    public Object doCall(Object it) {
                        CallSite[] callSiteArray = _updateLoadBalancer_closure6.$getCallSiteArray();
                        return callSiteArray[0].call(this.createListener.get(), it, (Object)true);
                    }

                    @Generated
                    public Object getCreateListener() {
                        CallSite[] callSiteArray = _updateLoadBalancer_closure6.$getCallSiteArray();
                        return this.createListener.get();
                    }

                    @Generated
                    public Object doCall() {
                        CallSite[] callSiteArray = _updateLoadBalancer_closure6.$getCallSiteArray();
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _updateLoadBalancer_closure6.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                        String[] stringArray = new String[1];
                        stringArray[0] = "call";
                        return new CallSiteArray(_updateLoadBalancer_closure6.class, stringArray);
                    }

                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                        CallSiteArray callSiteArray;
                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                            callSiteArray = _updateLoadBalancer_closure6.$createCallSiteArray();
                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                        }
                        return callSiteArray.array;
                    }
                }
                callSiteArray[19].call((Object)listenerDescriptionsToRemove, (Object)new _updateLoadBalancer_closure6(LoadBalancerUpsertHandler.class, LoadBalancerUpsertHandler.class, createListener));
            }
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)amazonErrors.get())) {
            throw (Throwable)callSiteArray[20].callConstructor(AtomicOperationException.class, (Object)"Failed to apply all load balancer updates", amazonErrors.get());
        }
    }

    public static String createLoadBalancer(AmazonElasticLoadBalancing loadBalancing, String loadBalancerName, boolean isInternal, Collection<String> availabilityZones, Collection<String> subnetIds, Collection<Listener> listeners, Collection<String> securityGroups) {
        CallSite[] callSiteArray = LoadBalancerUpsertHandler.$getCallSiteArray();
        return ShortTypeHandling.castToString((Object)callSiteArray[21].callStatic(LoadBalancerUpsertHandler.class, ArrayUtil.createArray((Object)loadBalancing, (Object)loadBalancerName, (Object)isInternal, availabilityZones, subnetIds, listeners, securityGroups, null)));
    }

    public static String createLoadBalancer(AmazonElasticLoadBalancing loadBalancing, String loadBalancerName, boolean isInternal, Collection<String> availabilityZones, Collection<String> subnetIds, Collection<Listener> listeners, Collection<String> securityGroups, LoadBalancerAttributes sourceAttributes) {
        CallSite[] callSiteArray = LoadBalancerUpsertHandler.$getCallSiteArray();
        Object request = callSiteArray[22].callConstructor(CreateLoadBalancerRequest.class, (Object)loadBalancerName);
        if (DefaultTypeTransformation.booleanUnbox(subnetIds)) {
            callSiteArray[23].call(callSiteArray[24].callGetProperty(LoadBalancerUpsertHandler.class), (Object)BASE_PHASE, (Object)new GStringImpl(new Object[]{subnetIds}, new String[]{"Subnets: [", "]"}));
            callSiteArray[25].call(request, subnetIds);
            if (isInternal) {
                String string = "internal";
                ScriptBytecodeAdapter.setProperty((Object)string, null, (Object)request, (String)"scheme");
            }
            callSiteArray[26].call(request, securityGroups);
        } else {
            callSiteArray[27].call(request, availabilityZones);
        }
        callSiteArray[28].call(request, listeners);
        callSiteArray[29].call(callSiteArray[30].callGetProperty(LoadBalancerUpsertHandler.class), (Object)BASE_PHASE, (Object)"Creating load balancer.");
        Object result = callSiteArray[31].call((Object)loadBalancing, request);
        if (DefaultTypeTransformation.booleanUnbox((Object)sourceAttributes)) {
            callSiteArray[32].call(callSiteArray[33].callGetProperty(LoadBalancerUpsertHandler.class), (Object)BASE_PHASE, (Object)"Configuring load balancer attributes.");
            callSiteArray[34].call((Object)loadBalancing, callSiteArray[35].call(callSiteArray[36].call(callSiteArray[37].callConstructor(ModifyLoadBalancerAttributesRequest.class), (Object)sourceAttributes), (Object)loadBalancerName));
        }
        return ShortTypeHandling.castToString((Object)callSiteArray[38].callGetProperty(result));
    }

    private static void ensureSetLoadBalancerListenerPolicies(String loadBalancerName, ListenerDescription listenerDescription, AmazonElasticLoadBalancing loadBalancing) {
        CallSite[] callSiteArray = LoadBalancerUpsertHandler.$getCallSiteArray();
        SetLoadBalancerPoliciesOfListenerRequest policyRequest = (SetLoadBalancerPoliciesOfListenerRequest)ScriptBytecodeAdapter.castToType((Object)callSiteArray[39].call(callSiteArray[40].call(callSiteArray[41].callConstructor(SetLoadBalancerPoliciesOfListenerRequest.class), (Object)loadBalancerName), callSiteArray[42].callGetProperty(callSiteArray[43].callGetProperty((Object)listenerDescription))), SetLoadBalancerPoliciesOfListenerRequest.class);
        try {
            callSiteArray[44].call((Object)loadBalancing, callSiteArray[45].call((Object)policyRequest, callSiteArray[46].callGetProperty((Object)listenerDescription)));
        }
        catch (AmazonServiceException e) {
            Object object = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[47].call((Object)log)) ? callSiteArray[48].call((Object)log, (Object)new GStringImpl(new Object[]{loadBalancerName, callSiteArray[49].callGetProperty((Object)e)}, new String[]{"Failed to set listener policies on loadbalancer ", ": ", ""})) : null;
        }
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != LoadBalancerUpsertHandler.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Generated
    @Internal
    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    @Generated
    @Internal
    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    static {
        public final class __clinit__closure7
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public __clinit__closure7(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = __clinit__closure7.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Listener listener) {
                CallSite[] callSiteArray = __clinit__closure7.$getCallSiteArray();
                if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                    return ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[0].callGetProperty((Object)listener), (Object)0) && ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[1].callGetProperty((Object)listener), (Object)0) && DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[2].callGetProperty((Object)listener));
                }
                return ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[3].callGetProperty((Object)listener), (Object)0) && ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[4].callGetProperty((Object)listener), (Object)0) && DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[5].callGetProperty((Object)listener));
            }

            public Object call(Listener listener) {
                CallSite[] callSiteArray = __clinit__closure7.$getCallSiteArray();
                return callSiteArray[6].callCurrent((GroovyObject)this, (Object)listener);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != __clinit__closure7.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "instancePort";
                stringArray[1] = "loadBalancerPort";
                stringArray[2] = "protocol";
                stringArray[3] = "instancePort";
                stringArray[4] = "loadBalancerPort";
                stringArray[5] = "protocol";
                stringArray[6] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[7];
                __clinit__closure7.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(__clinit__closure7.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = __clinit__closure7.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        __clinit__closure7 __clinit__closure72 = new __clinit__closure7(LoadBalancerUpsertHandler.class, LoadBalancerUpsertHandler.class);
        notLegacyListener = __clinit__closure72;
        Object object = LoadBalancerUpsertHandler.$getCallSiteArray()[50].call(LoggerFactory.class, (Object)"com.netflix.spinnaker.clouddriver.aws.deploy.handlers.LoadBalancerUpsertHandler");
        log = (Logger)ScriptBytecodeAdapter.castToType((Object)object, Logger.class);
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "get";
        stringArray[1] = "threadLocalTask";
        stringArray[2] = "loadBalancerName";
        stringArray[3] = "getVPCId";
        stringArray[4] = "<$constructor$>";
        stringArray[5] = "applySecurityGroupsToLoadBalancer";
        stringArray[6] = "<$constructor$>";
        stringArray[7] = "updateStatus";
        stringArray[8] = "task";
        stringArray[9] = "findAll";
        stringArray[10] = "findAll";
        stringArray[11] = "listenerDescriptions";
        stringArray[12] = "findAll";
        stringArray[13] = "removeAll";
        stringArray[14] = "removeAll";
        stringArray[15] = "findAll";
        stringArray[16] = "listenerDescriptions";
        stringArray[17] = "each";
        stringArray[18] = "each";
        stringArray[19] = "each";
        stringArray[20] = "<$constructor$>";
        stringArray[21] = "createLoadBalancer";
        stringArray[22] = "<$constructor$>";
        stringArray[23] = "updateStatus";
        stringArray[24] = "task";
        stringArray[25] = "withSubnets";
        stringArray[26] = "withSecurityGroups";
        stringArray[27] = "withAvailabilityZones";
        stringArray[28] = "withListeners";
        stringArray[29] = "updateStatus";
        stringArray[30] = "task";
        stringArray[31] = "createLoadBalancer";
        stringArray[32] = "updateStatus";
        stringArray[33] = "task";
        stringArray[34] = "modifyLoadBalancerAttributes";
        stringArray[35] = "withLoadBalancerName";
        stringArray[36] = "withLoadBalancerAttributes";
        stringArray[37] = "<$constructor$>";
        stringArray[38] = "DNSName";
        stringArray[39] = "withLoadBalancerPort";
        stringArray[40] = "withLoadBalancerName";
        stringArray[41] = "<$constructor$>";
        stringArray[42] = "loadBalancerPort";
        stringArray[43] = "listener";
        stringArray[44] = "setLoadBalancerPoliciesOfListener";
        stringArray[45] = "withPolicyNames";
        stringArray[46] = "policyNames";
        stringArray[47] = "isErrorEnabled";
        stringArray[48] = "error";
        stringArray[49] = "errorMessage";
        stringArray[50] = "getLogger";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[51];
        LoadBalancerUpsertHandler.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(LoadBalancerUpsertHandler.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = LoadBalancerUpsertHandler.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

