/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.aws.deploy.ops;

import com.amazonaws.services.autoscaling.model.AutoScalingGroup;
import com.amazonaws.services.autoscaling.model.DescribeAutoScalingGroupsRequest;
import com.amazonaws.services.autoscaling.model.UpdateAutoScalingGroupRequest;
import com.netflix.spinnaker.clouddriver.aws.deploy.description.ResizeAsgDescription;
import com.netflix.spinnaker.clouddriver.aws.event.AfterResizeEvent;
import com.netflix.spinnaker.clouddriver.aws.event.AfterResizeEventHandler;
import com.netflix.spinnaker.clouddriver.aws.security.AmazonClientProvider;
import com.netflix.spinnaker.clouddriver.data.task.Task;
import com.netflix.spinnaker.clouddriver.data.task.TaskRepository;
import com.netflix.spinnaker.clouddriver.model.ServerGroup;
import com.netflix.spinnaker.clouddriver.orchestration.AtomicOperation;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.lang.ref.SoftReference;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.ArrayUtil;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.springframework.beans.factory.annotation.Autowired;

public class ResizeAsgAtomicOperation
implements AtomicOperation<Void>,
GroovyObject {
    private static final String PHASE = "RESIZE";
    @Autowired
    private AmazonClientProvider amazonClientProvider;
    @Autowired
    private List<AfterResizeEventHandler> afterResizeEventHandlers;
    private final ResizeAsgDescription description;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;
    private static /* synthetic */ SoftReference $callSiteArray;

    public ResizeAsgAtomicOperation(ResizeAsgDescription description) {
        MetaClass metaClass;
        List list;
        CallSite[] callSiteArray = ResizeAsgAtomicOperation.$getCallSiteArray();
        this.afterResizeEventHandlers = list = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        this.metaClass = metaClass = this.$getStaticMetaClass();
        ResizeAsgDescription resizeAsgDescription = description;
        this.description = (ResizeAsgDescription)ScriptBytecodeAdapter.castToType((Object)resizeAsgDescription, ResizeAsgDescription.class);
    }

    private static Task getTask() {
        CallSite[] callSiteArray = ResizeAsgAtomicOperation.$getCallSiteArray();
        return (Task)ScriptBytecodeAdapter.castToType((Object)callSiteArray[0].call(callSiteArray[1].callGetProperty(TaskRepository.class)), Task.class);
    }

    public Void operate(List priorOutputs) {
        CallSite[] callSiteArray = ResizeAsgAtomicOperation.$getCallSiteArray();
        public final class _operate_closure1
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _operate_closure1(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _operate_closure1.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _operate_closure1.$getCallSiteArray();
                return callSiteArray[0].call(it);
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _operate_closure1.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _operate_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "toString";
                return new CallSiteArray(_operate_closure1.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _operate_closure1.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        String descriptor = ShortTypeHandling.castToString((Object)callSiteArray[2].call(callSiteArray[3].callGroovyObjectGetProperty((Object)this.description), (Object)new _operate_closure1(this, this)));
        callSiteArray[4].call(callSiteArray[5].callGroovyObjectGetProperty((Object)this), (Object)PHASE, (Object)new GStringImpl(new Object[]{descriptor}, new String[]{"Initializing Resize ASG operation for ", "..."}));
        Object asg = null;
        Iterator iterator = (Iterator)ScriptBytecodeAdapter.castToType((Object)callSiteArray[6].call(callSiteArray[7].callGroovyObjectGetProperty((Object)this.description)), Iterator.class);
        while (iterator.hasNext()) {
            asg = iterator.next();
            callSiteArray[8].callCurrent((GroovyObject)this, callSiteArray[9].callGetProperty(asg), callSiteArray[10].callGetProperty(asg), callSiteArray[11].callGetProperty(asg), callSiteArray[12].callGetProperty(asg));
        }
        callSiteArray[13].call(callSiteArray[14].callGroovyObjectGetProperty((Object)this), (Object)PHASE, (Object)new GStringImpl(new Object[]{descriptor}, new String[]{"Finished Resize ASG operation for ", "."}));
        return (Void)ScriptBytecodeAdapter.castToType(null, Void.class);
    }

    private void resizeAsg(String asgName, String region, ServerGroup.Capacity capacity, ResizeAsgDescription.Constraints constraints) {
        CallSite[] callSiteArray = ResizeAsgAtomicOperation.$getCallSiteArray();
        callSiteArray[15].call(callSiteArray[16].callGroovyObjectGetProperty((Object)this), (Object)PHASE, (Object)new GStringImpl(new Object[]{asgName, region, capacity}, new String[]{"Beginning resize of ", " in ", " to ", "."}));
        if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[17].callGetProperty((Object)capacity), null) && ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[18].callGetProperty((Object)capacity), null) && ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[19].callGetProperty((Object)capacity), null)) {
                callSiteArray[20].call(callSiteArray[21].callGroovyObjectGetProperty((Object)this), (Object)PHASE, (Object)new GStringImpl(new Object[]{asgName, region, capacity}, new String[]{"Skipping resize of ", " in ", ", at least one field in ", " needs to be non-null"}));
                return;
            }
        } else if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[22].callGetProperty((Object)capacity), null) && ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[23].callGetProperty((Object)capacity), null) && ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[24].callGetProperty((Object)capacity), null)) {
            callSiteArray[25].call(callSiteArray[26].callGroovyObjectGetProperty((Object)this), (Object)PHASE, (Object)new GStringImpl(new Object[]{asgName, region, capacity}, new String[]{"Skipping resize of ", " in ", ", at least one field in ", " needs to be non-null"}));
            return;
        }
        Object autoScaling = callSiteArray[27].call((Object)this.amazonClientProvider, callSiteArray[28].callGroovyObjectGetProperty((Object)this.description), (Object)region, (Object)true);
        Object describeAutoScalingGroups = callSiteArray[29].call(autoScaling, callSiteArray[30].call(callSiteArray[31].callConstructor(DescribeAutoScalingGroupsRequest.class), (Object)asgName));
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[32].call(callSiteArray[33].callGetProperty(describeAutoScalingGroups))) || ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[34].callGetProperty(callSiteArray[35].call(callSiteArray[36].callGetProperty(describeAutoScalingGroups), (Object)0)), null)) {
            callSiteArray[37].call(callSiteArray[38].callGroovyObjectGetProperty((Object)this), (Object)PHASE, (Object)new GStringImpl(new Object[]{asgName, region}, new String[]{"Skipping resize of ", " in ", ", server group does not exist"}));
            return;
        }
        callSiteArray[39].callStatic(ResizeAsgAtomicOperation.class, (Object)constraints, callSiteArray[40].call(callSiteArray[41].call(describeAutoScalingGroups), (Object)0));
        Object request = callSiteArray[42].call(callSiteArray[43].call(callSiteArray[44].call(callSiteArray[45].call(callSiteArray[46].callConstructor(UpdateAutoScalingGroupRequest.class), (Object)asgName), callSiteArray[47].callGetProperty((Object)capacity)), callSiteArray[48].callGetProperty((Object)capacity)), callSiteArray[49].callGetProperty((Object)capacity));
        callSiteArray[50].call(autoScaling, request);
        Reference event = new Reference((Object)((AfterResizeEvent)ScriptBytecodeAdapter.castToType((Object)callSiteArray[51].callConstructor(AfterResizeEvent.class, ArrayUtil.createArray((Object)callSiteArray[52].callGroovyObjectGetProperty((Object)this), (Object)callSiteArray[53].call((Object)this.amazonClientProvider, callSiteArray[54].callGroovyObjectGetProperty((Object)this.description), (Object)region, (Object)true), (Object)autoScaling, (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((AutoScalingGroup)ScriptBytecodeAdapter.asType((Object)callSiteArray[55].call(callSiteArray[56].call(describeAutoScalingGroups), (Object)0), AutoScalingGroup.class)), AutoScalingGroup.class), (Object)capacity)), AfterResizeEvent.class)));
        public final class _resizeAsg_closure2
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference event;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _resizeAsg_closure2(Object _outerInstance, Object _thisObject, Reference event) {
                Reference reference;
                CallSite[] callSiteArray = _resizeAsg_closure2.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.event = reference = event;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _resizeAsg_closure2.$getCallSiteArray();
                return callSiteArray[0].call(it, this.event.get());
            }

            @Generated
            public AfterResizeEvent getEvent() {
                CallSite[] callSiteArray = _resizeAsg_closure2.$getCallSiteArray();
                return (AfterResizeEvent)ScriptBytecodeAdapter.castToType((Object)this.event.get(), AfterResizeEvent.class);
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _resizeAsg_closure2.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _resizeAsg_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "handle";
                return new CallSiteArray(_resizeAsg_closure2.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _resizeAsg_closure2.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[57].call(this.afterResizeEventHandlers, (Object)new _resizeAsg_closure2(this, this, event));
        callSiteArray[58].call(callSiteArray[59].callGroovyObjectGetProperty((Object)this), (Object)PHASE, (Object)new GStringImpl(new Object[]{asgName, region}, new String[]{"Completed resize of ", " in ", "."}));
    }

    public static void validateConstraints(ResizeAsgDescription.Constraints constraints, AutoScalingGroup autoScalingGroup) {
        CallSite[] callSiteArray = ResizeAsgAtomicOperation.$getCallSiteArray();
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[60].callGroovyObjectGetPropertySafe((Object)constraints))) {
            return;
        }
        Reference current = new Reference((Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"min", callSiteArray[61].callGetProperty((Object)autoScalingGroup), "desired", callSiteArray[62].callGetProperty((Object)autoScalingGroup), "max", callSiteArray[63].callGetProperty((Object)autoScalingGroup)}));
        Map expected = ScriptBytecodeAdapter.createMap((Object[])new Object[]{"min", callSiteArray[64].callGetProperty(callSiteArray[65].callGroovyObjectGetProperty((Object)constraints)), "desired", callSiteArray[66].callGetProperty(callSiteArray[67].callGroovyObjectGetProperty((Object)constraints)), "max", callSiteArray[68].callGetProperty(callSiteArray[69].callGroovyObjectGetProperty((Object)constraints))});
        public final class _validateConstraints_closure3
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference current;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _validateConstraints_closure3(Object _outerInstance, Object _thisObject, Reference current) {
                Reference reference;
                CallSite[] callSiteArray = _validateConstraints_closure3.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.current = reference = current;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _validateConstraints_closure3.$getCallSiteArray();
                if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                    return ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[0].callGetProperty(it), null) && ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[1].call(this.current.get(), callSiteArray[2].callGetProperty(it)), (Object)callSiteArray[3].callGetProperty(it));
                }
                return ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[4].callGetProperty(it), null) && ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[5].call(this.current.get(), callSiteArray[6].callGetProperty(it)), (Object)callSiteArray[7].callGetProperty(it));
            }

            @Generated
            public Object getCurrent() {
                CallSite[] callSiteArray = _validateConstraints_closure3.$getCallSiteArray();
                return this.current.get();
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _validateConstraints_closure3.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _validateConstraints_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "value";
                stringArray[1] = "getAt";
                stringArray[2] = "key";
                stringArray[3] = "value";
                stringArray[4] = "value";
                stringArray[5] = "getAt";
                stringArray[6] = "key";
                stringArray[7] = "value";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[8];
                _validateConstraints_closure3.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_validateConstraints_closure3.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _validateConstraints_closure3.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        boolean hasViolation = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[70].call((Object)expected, (Object)new _validateConstraints_closure3(ResizeAsgAtomicOperation.class, ResizeAsgAtomicOperation.class, current)));
        if (hasViolation) {
            throw (Throwable)callSiteArray[71].callConstructor(IllegalStateException.class, callSiteArray[72].call(String.class, (Object)"Expected capacity constraint violated (expected: %s, was: %s)", (Object)expected, current.get(), callSiteArray[73].callGetProperty((Object)autoScalingGroup)));
        }
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != ResizeAsgAtomicOperation.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Generated
    @Internal
    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    @Generated
    @Internal
    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    @Generated
    public AmazonClientProvider getAmazonClientProvider() {
        return this.amazonClientProvider;
    }

    @Generated
    public void setAmazonClientProvider(AmazonClientProvider amazonClientProvider) {
        this.amazonClientProvider = amazonClientProvider;
    }

    @Generated
    public List<AfterResizeEventHandler> getAfterResizeEventHandlers() {
        return this.afterResizeEventHandlers;
    }

    @Generated
    public void setAfterResizeEventHandlers(List<AfterResizeEventHandler> list) {
        this.afterResizeEventHandlers = list;
    }

    @Generated
    public final ResizeAsgDescription getDescription() {
        return this.description;
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "get";
        stringArray[1] = "threadLocalTask";
        stringArray[2] = "collect";
        stringArray[3] = "asgs";
        stringArray[4] = "updateStatus";
        stringArray[5] = "task";
        stringArray[6] = "iterator";
        stringArray[7] = "asgs";
        stringArray[8] = "resizeAsg";
        stringArray[9] = "serverGroupName";
        stringArray[10] = "region";
        stringArray[11] = "capacity";
        stringArray[12] = "constraints";
        stringArray[13] = "updateStatus";
        stringArray[14] = "task";
        stringArray[15] = "updateStatus";
        stringArray[16] = "task";
        stringArray[17] = "min";
        stringArray[18] = "max";
        stringArray[19] = "desired";
        stringArray[20] = "updateStatus";
        stringArray[21] = "task";
        stringArray[22] = "min";
        stringArray[23] = "max";
        stringArray[24] = "desired";
        stringArray[25] = "updateStatus";
        stringArray[26] = "task";
        stringArray[27] = "getAutoScaling";
        stringArray[28] = "credentials";
        stringArray[29] = "describeAutoScalingGroups";
        stringArray[30] = "withAutoScalingGroupNames";
        stringArray[31] = "<$constructor$>";
        stringArray[32] = "isEmpty";
        stringArray[33] = "autoScalingGroups";
        stringArray[34] = "status";
        stringArray[35] = "get";
        stringArray[36] = "autoScalingGroups";
        stringArray[37] = "updateStatus";
        stringArray[38] = "task";
        stringArray[39] = "validateConstraints";
        stringArray[40] = "get";
        stringArray[41] = "getAutoScalingGroups";
        stringArray[42] = "withDesiredCapacity";
        stringArray[43] = "withMaxSize";
        stringArray[44] = "withMinSize";
        stringArray[45] = "withAutoScalingGroupName";
        stringArray[46] = "<$constructor$>";
        stringArray[47] = "min";
        stringArray[48] = "max";
        stringArray[49] = "desired";
        stringArray[50] = "updateAutoScalingGroup";
        stringArray[51] = "<$constructor$>";
        stringArray[52] = "task";
        stringArray[53] = "getAmazonEC2";
        stringArray[54] = "credentials";
        stringArray[55] = "get";
        stringArray[56] = "getAutoScalingGroups";
        stringArray[57] = "each";
        stringArray[58] = "updateStatus";
        stringArray[59] = "task";
        stringArray[60] = "capacity";
        stringArray[61] = "minSize";
        stringArray[62] = "desiredCapacity";
        stringArray[63] = "maxSize";
        stringArray[64] = "min";
        stringArray[65] = "capacity";
        stringArray[66] = "desired";
        stringArray[67] = "capacity";
        stringArray[68] = "max";
        stringArray[69] = "capacity";
        stringArray[70] = "find";
        stringArray[71] = "<$constructor$>";
        stringArray[72] = "format";
        stringArray[73] = "autoScalingGroupName";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[74];
        ResizeAsgAtomicOperation.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(ResizeAsgAtomicOperation.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = ResizeAsgAtomicOperation.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

