/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.aws.deploy.validators;

import com.google.common.annotations.VisibleForTesting;
import com.netflix.spinnaker.clouddriver.aws.AmazonOperation;
import com.netflix.spinnaker.clouddriver.aws.deploy.InstanceTypeUtils;
import com.netflix.spinnaker.clouddriver.aws.deploy.description.AbstractAmazonCredentialsDescription;
import com.netflix.spinnaker.clouddriver.aws.deploy.description.BasicAmazonDeployDescription;
import com.netflix.spinnaker.clouddriver.aws.deploy.validators.AmazonDescriptionValidationSupport;
import com.netflix.spinnaker.clouddriver.aws.model.AmazonBlockDevice;
import com.netflix.spinnaker.clouddriver.aws.security.AmazonCredentials;
import com.netflix.spinnaker.clouddriver.aws.security.NetflixAmazonCredentials;
import com.netflix.spinnaker.clouddriver.deploy.ValidationErrors;
import com.netflix.spinnaker.credentials.CredentialsRepository;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import groovy.transform.stc.ClosureParams;
import groovy.transform.stc.SimpleType;
import java.lang.ref.SoftReference;
import java.util.Iterator;
import java.util.List;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="basicAmazonDeployDescriptionValidator")
@AmazonOperation(value="createServerGroup")
public class BasicAmazonDeployDescriptionValidator
extends AmazonDescriptionValidationSupport<BasicAmazonDeployDescription> {
    @Autowired
    private CredentialsRepository<NetflixAmazonCredentials> credentialsRepository;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo$;
    private static /* synthetic */ SoftReference $callSiteArray;

    @Generated
    public BasicAmazonDeployDescriptionValidator() {
        MetaClass metaClass;
        CallSite[] callSiteArray = BasicAmazonDeployDescriptionValidator.$getCallSiteArray();
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    @Override
    public void validate(List priorDescriptions, BasicAmazonDeployDescription description, ValidationErrors errors) {
        CallSite[] callSiteArray = BasicAmazonDeployDescriptionValidator.$getCallSiteArray();
        Object credentials = null;
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[0].callGroovyObjectGetProperty((Object)description))) {
            callSiteArray[1].call((Object)errors, (Object)"credentials", (Object)"basicAmazonDeployDescription.credentials.empty");
        } else {
            Object object;
            credentials = object = callSiteArray[2].call(this.credentialsRepository, callSiteArray[3].callGetPropertySafe(callSiteArray[4].callGroovyObjectGetPropertySafe((Object)description)));
            if (ScriptBytecodeAdapter.compareEqual((Object)credentials, null)) {
                callSiteArray[5].call((Object)errors, (Object)"credentials", (Object)"basicAmazonDeployDescription.credentials.invalid");
            }
        }
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[6].callGroovyObjectGetProperty((Object)description))) {
            callSiteArray[7].call((Object)errors, (Object)"application", (Object)"basicAmazonDeployDescription.application.empty");
        }
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[8].callGroovyObjectGetProperty((Object)description))) {
            callSiteArray[9].call((Object)errors, (Object)"amiName", (Object)"basicAmazonDeployDescription.amiName.empty");
        }
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[10].callGroovyObjectGetProperty((Object)description))) {
            callSiteArray[11].call((Object)errors, (Object)"instanceType", (Object)"basicAmazonDeployDescription.instanceType.empty");
        }
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[12].callGroovyObjectGetProperty((Object)description))) {
            callSiteArray[13].call((Object)errors, (Object)"availabilityZones", (Object)"basicAmazonDeployDescription.availabilityZones.empty");
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[14].callGroovyObjectGetProperty((Object)description)) && !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[15].callGroovyObjectGetProperty((Object)description))) {
            callSiteArray[16].call((Object)errors, (Object)"associatePublicIpAddress", (Object)"basicAmazonDeployDescription.associatePublicIpAddress.subnetType.not.supplied");
        }
        if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[17].callSafe(callSiteArray[18].call(callSiteArray[19].callGroovyObjectGetProperty((Object)description)))) && !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[20].callGroovyObjectGetProperty((Object)description))) {
                callSiteArray[21].call((Object)errors, (Object)"availabilityZones", (Object)"basicAmazonDeployDescription.availabilityZones.or.subnetType.not.supplied");
            }
        } else if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[22].callSafe(callSiteArray[23].call(callSiteArray[24].callGroovyObjectGetProperty((Object)description)))) && !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[25].callGroovyObjectGetProperty((Object)description))) {
            callSiteArray[26].call((Object)errors, (Object)"availabilityZones", (Object)"basicAmazonDeployDescription.availabilityZones.or.subnetType.not.supplied");
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)credentials) && !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[27].call(callSiteArray[28].callGetProperty(callSiteArray[29].callGetProperty((Object)((AmazonCredentials)((Object)ScriptBytecodeAdapter.castToType((Object)credentials, AmazonCredentials.class))))), callSiteArray[30].call(callSiteArray[31].callGroovyObjectGetProperty((Object)description))))) {
            callSiteArray[32].call((Object)errors, (Object)"availabilityZones", (Object)"basicAmazonDeployDescription.region.not.configured", (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((String[])ScriptBytecodeAdapter.asType((Object)callSiteArray[33].call(callSiteArray[34].callGroovyObjectGetProperty((Object)description)), String[].class)), String[].class), (Object)"Region not configured");
        }
        AmazonBlockDevice device = null;
        Iterator iterator = (Iterator)ScriptBytecodeAdapter.castToType((Object)callSiteArray[35].call(callSiteArray[36].callGroovyObjectGetProperty((Object)description)), Iterator.class);
        while (iterator.hasNext()) {
            device = (AmazonBlockDevice)ScriptBytecodeAdapter.castToType(iterator.next(), AmazonBlockDevice.class);
            callSiteArray[37].call(BlockDeviceRules.class, (Object)device, (Object)errors);
        }
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[38].callGetPropertySafe(callSiteArray[39].callGroovyObjectGetProperty((Object)description)))) {
            callSiteArray[40].callStatic(BasicAmazonDeployDescriptionValidator.class, (Object)description, (Object)errors);
        }
        if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[41].callGroovyObjectGetProperty((Object)description), null) && !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[42].call(InstanceTypeUtils.class, callSiteArray[43].call((Object)description)))) {
                callSiteArray[44].call((Object)errors, (Object)"unlimitedCpuCredits", (Object)"basicAmazonDeployDescription.bursting.not.supported.by.instanceType");
            }
        } else if (ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[45].callGroovyObjectGetProperty((Object)description), null) && !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[46].call(InstanceTypeUtils.class, callSiteArray[47].call((Object)description)))) {
            callSiteArray[48].call((Object)errors, (Object)"unlimitedCpuCredits", (Object)"basicAmazonDeployDescription.bursting.not.supported.by.instanceType");
        }
        if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[49].callGroovyObjectGetProperty((Object)description)) && ScriptBytecodeAdapter.compareGreaterThan((Object)callSiteArray[50].callGroovyObjectGetProperty((Object)description), (Object)0) && ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[51].callGroovyObjectGetProperty((Object)description), (Object)"lowest-price")) {
                callSiteArray[52].call((Object)errors, (Object)"spotInstancePools", (Object)"basicAmazonDeployDescription.spotInstancePools.not.supported.for.spotAllocationStrategy");
            }
        } else if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[53].callGroovyObjectGetProperty((Object)description)) && ScriptBytecodeAdapter.compareGreaterThan((Object)callSiteArray[54].callGroovyObjectGetProperty((Object)description), (Object)0) && ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[55].callGroovyObjectGetProperty((Object)description), (Object)"lowest-price")) {
            callSiteArray[56].call((Object)errors, (Object)"spotInstancePools", (Object)"basicAmazonDeployDescription.spotInstancePools.not.supported.for.spotAllocationStrategy");
        }
        String warnings = ShortTypeHandling.castToString((Object)callSiteArray[57].callCurrent((GroovyObject)this, (Object)description));
        callSiteArray[58].call((Object)log, (Object)warnings);
    }

    @VisibleForTesting
    private String getWarnings(BasicAmazonDeployDescription description) {
        CallSite[] callSiteArray = BasicAmazonDeployDescriptionValidator.$getCallSiteArray();
        List warnings = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[59].callGroovyObjectGetProperty((Object)description))) {
            Object ltFeaturesEnabled = callSiteArray[60].callCurrent((GroovyObject)this, (Object)description);
            if (DefaultTypeTransformation.booleanUnbox((Object)ltFeaturesEnabled)) {
                callSiteArray[61].call((Object)warnings, callSiteArray[62].call(callSiteArray[63].call((Object)new GStringImpl(new Object[]{ltFeaturesEnabled}, new String[]{"WARNING: The following fields ", " work as expected only with AWS EC2 Launch Template, "}), (Object)new GStringImpl(new Object[]{callSiteArray[64].callGroovyObjectGetProperty((Object)description)}, new String[]{"but 'setLaunchTemplate' is set to false in request with account: ", ", "})), (Object)new GStringImpl(new Object[]{callSiteArray[65].callGroovyObjectGetProperty((Object)description), callSiteArray[66].callGroovyObjectGetProperty((Object)description)}, new String[]{"application: ", ", stack: ", ")"})));
            }
        }
        return ShortTypeHandling.castToString((Object)callSiteArray[67].call((Object)warnings, (Object)"\n"));
    }

    private List<String> getLtFeaturesEnabled(BasicAmazonDeployDescription descToValidate) {
        Reference descToValidate2 = new Reference((Object)descToValidate);
        CallSite[] callSiteArray = BasicAmazonDeployDescriptionValidator.$getCallSiteArray();
        Object allLtFeatures = callSiteArray[68].call(BasicAmazonDeployDescription.class);
        Reference descWithDefaults = new Reference(callSiteArray[69].callConstructor(BasicAmazonDeployDescription.class));
        Reference ltFeaturesEnabled = new Reference((Object)ScriptBytecodeAdapter.createList((Object[])new Object[0]));
        public final class _getLtFeaturesEnabled_closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference descToValidate;
            private /* synthetic */ Reference descWithDefaults;
            private /* synthetic */ Reference ltFeaturesEnabled;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _getLtFeaturesEnabled_closure1(Object _outerInstance, Object _thisObject, Reference descToValidate, Reference descWithDefaults, Reference ltFeaturesEnabled) {
                Reference reference;
                Reference reference2;
                Reference reference3;
                CallSite[] callSiteArray = _getLtFeaturesEnabled_closure1.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.descToValidate = reference3 = descToValidate;
                this.descWithDefaults = reference2 = descWithDefaults;
                this.ltFeaturesEnabled = reference = ltFeaturesEnabled;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _getLtFeaturesEnabled_closure1.$getCallSiteArray();
                if (ScriptBytecodeAdapter.compareNotEqual((Object)ScriptBytecodeAdapter.getGroovyObjectProperty(_getLtFeaturesEnabled_closure1.class, (GroovyObject)this.descToValidate.get(), (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{it}, new String[]{"", ""}))), (Object)ScriptBytecodeAdapter.getProperty(_getLtFeaturesEnabled_closure1.class, (Object)this.descWithDefaults.get(), (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{it}, new String[]{"", ""}))))) {
                    return callSiteArray[0].call(this.ltFeaturesEnabled.get(), it);
                }
                return null;
            }

            @Generated
            public BasicAmazonDeployDescription getDescToValidate() {
                CallSite[] callSiteArray = _getLtFeaturesEnabled_closure1.$getCallSiteArray();
                return (BasicAmazonDeployDescription)ScriptBytecodeAdapter.castToType((Object)this.descToValidate.get(), BasicAmazonDeployDescription.class);
            }

            @Generated
            public Object getDescWithDefaults() {
                CallSite[] callSiteArray = _getLtFeaturesEnabled_closure1.$getCallSiteArray();
                return this.descWithDefaults.get();
            }

            @Generated
            public Object getLtFeaturesEnabled() {
                CallSite[] callSiteArray = _getLtFeaturesEnabled_closure1.$getCallSiteArray();
                return this.ltFeaturesEnabled.get();
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _getLtFeaturesEnabled_closure1.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getLtFeaturesEnabled_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "add";
                return new CallSiteArray(_getLtFeaturesEnabled_closure1.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _getLtFeaturesEnabled_closure1.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[70].call(allLtFeatures, (Object)new _getLtFeaturesEnabled_closure1((Object)this, (Object)this, descToValidate2, descWithDefaults, ltFeaturesEnabled));
        return (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[71].call(ltFeaturesEnabled.get()), List.class);
    }

    @Override
    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (((Object)((Object)this)).getClass() != BasicAmazonDeployDescriptionValidator.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ Object this$dist$invoke$3(String name, Object args) {
        CallSite[] callSiteArray = BasicAmazonDeployDescriptionValidator.$getCallSiteArray();
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(BasicAmazonDeployDescriptionValidator.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$3(String name, Object value) {
        CallSite[] callSiteArray = BasicAmazonDeployDescriptionValidator.$getCallSiteArray();
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, BasicAmazonDeployDescriptionValidator.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public /* synthetic */ Object this$dist$get$3(String name) {
        CallSite[] callSiteArray = BasicAmazonDeployDescriptionValidator.$getCallSiteArray();
        return ScriptBytecodeAdapter.getGroovyObjectProperty(BasicAmazonDeployDescriptionValidator.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    static {
        Object object = BasicAmazonDeployDescriptionValidator.$getCallSiteArray()[72].call(LoggerFactory.class, (Object)"com.netflix.spinnaker.clouddriver.aws.deploy.validators.BasicAmazonDeployDescriptionValidator");
        log = (Logger)ScriptBytecodeAdapter.castToType((Object)object, Logger.class);
    }

    @Generated
    public CredentialsRepository<NetflixAmazonCredentials> getCredentialsRepository() {
        return this.credentialsRepository;
    }

    @Generated
    public void setCredentialsRepository(CredentialsRepository<NetflixAmazonCredentials> credentialsRepository) {
        this.credentialsRepository = credentialsRepository;
    }

    public /* synthetic */ MetaClass super$3$$getStaticMetaClass() {
        return super.$getStaticMetaClass();
    }

    public /* synthetic */ void super$3$validate(List list, AbstractAmazonCredentialsDescription abstractAmazonCredentialsDescription, ValidationErrors validationErrors) {
        super.validate(list, abstractAmazonCredentialsDescription, validationErrors);
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "credentials";
        stringArray[1] = "rejectValue";
        stringArray[2] = "getOne";
        stringArray[3] = "name";
        stringArray[4] = "credentials";
        stringArray[5] = "rejectValue";
        stringArray[6] = "application";
        stringArray[7] = "rejectValue";
        stringArray[8] = "amiName";
        stringArray[9] = "rejectValue";
        stringArray[10] = "instanceType";
        stringArray[11] = "rejectValue";
        stringArray[12] = "availabilityZones";
        stringArray[13] = "rejectValue";
        stringArray[14] = "associatePublicIpAddress";
        stringArray[15] = "subnetType";
        stringArray[16] = "rejectValue";
        stringArray[17] = "flatten";
        stringArray[18] = "values";
        stringArray[19] = "availabilityZones";
        stringArray[20] = "subnetType";
        stringArray[21] = "rejectValue";
        stringArray[22] = "flatten";
        stringArray[23] = "values";
        stringArray[24] = "availabilityZones";
        stringArray[25] = "subnetType";
        stringArray[26] = "rejectValue";
        stringArray[27] = "containsAll";
        stringArray[28] = "name";
        stringArray[29] = "regions";
        stringArray[30] = "keySet";
        stringArray[31] = "availabilityZones";
        stringArray[32] = "rejectValue";
        stringArray[33] = "keySet";
        stringArray[34] = "availabilityZones";
        stringArray[35] = "iterator";
        stringArray[36] = "blockDevices";
        stringArray[37] = "validate";
        stringArray[38] = "useSourceCapacity";
        stringArray[39] = "source";
        stringArray[40] = "validateCapacity";
        stringArray[41] = "unlimitedCpuCredits";
        stringArray[42] = "isBurstingSupportedByAllTypes";
        stringArray[43] = "getAllInstanceTypes";
        stringArray[44] = "rejectValue";
        stringArray[45] = "unlimitedCpuCredits";
        stringArray[46] = "isBurstingSupportedByAllTypes";
        stringArray[47] = "getAllInstanceTypes";
        stringArray[48] = "rejectValue";
        stringArray[49] = "spotInstancePools";
        stringArray[50] = "spotInstancePools";
        stringArray[51] = "spotAllocationStrategy";
        stringArray[52] = "rejectValue";
        stringArray[53] = "spotInstancePools";
        stringArray[54] = "spotInstancePools";
        stringArray[55] = "spotAllocationStrategy";
        stringArray[56] = "rejectValue";
        stringArray[57] = "getWarnings";
        stringArray[58] = "warn";
        stringArray[59] = "setLaunchTemplate";
        stringArray[60] = "getLtFeaturesEnabled";
        stringArray[61] = "add";
        stringArray[62] = "plus";
        stringArray[63] = "plus";
        stringArray[64] = "account";
        stringArray[65] = "application";
        stringArray[66] = "stack";
        stringArray[67] = "join";
        stringArray[68] = "getLaunchTemplateOnlyFieldNames";
        stringArray[69] = "<$constructor$>";
        stringArray[70] = "each";
        stringArray[71] = "sort";
        stringArray[72] = "getLogger";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[73];
        BasicAmazonDeployDescriptionValidator.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(BasicAmazonDeployDescriptionValidator.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = BasicAmazonDeployDescriptionValidator.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }

    public static final class BlockDeviceRules
    extends Enum<BlockDeviceRules>
    implements GroovyObject {
        public static final /* enum */ BlockDeviceRules deviceNameNotNull;
        public static final /* enum */ BlockDeviceRules ephemeralConfigWrong;
        public static final /* enum */ BlockDeviceRules ebsConfigWrong;
        private final Closure<Void> validationRule;
        public static final BlockDeviceRules MIN_VALUE;
        public static final BlockDeviceRules MAX_VALUE;
        private static final /* synthetic */ BlockDeviceRules[] $VALUES;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;
        private static /* synthetic */ SoftReference $callSiteArray;

        public BlockDeviceRules(@ClosureParams(value=SimpleType.class, options={"AmazonBlockDevice", "org.springframework.validation.Errors"}) String validationRule, int n, Closure<Void> metaClass) {
            CallSite[] callSiteArray = BlockDeviceRules.$getCallSiteArray();
            this.metaClass = metaClass = this.$getStaticMetaClass();
            String string = validationRule;
            this.validationRule = (Closure)ScriptBytecodeAdapter.castToType((Object)string, Closure.class);
        }

        public void validateDevice(AmazonBlockDevice device, ValidationErrors errors) {
            CallSite[] callSiteArray = BlockDeviceRules.$getCallSiteArray();
            ScriptBytecodeAdapter.invokeClosure(this.validationRule, (Object[])new Object[]{device, errors});
        }

        public static void validate(AmazonBlockDevice device, ValidationErrors errors) {
            CallSite[] callSiteArray = BlockDeviceRules.$getCallSiteArray();
            if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                Object rule = null;
                Iterator iterator = (Iterator)ScriptBytecodeAdapter.castToType((Object)callSiteArray[0].call(callSiteArray[1].callStatic(BlockDeviceRules.class)), Iterator.class);
                while (iterator.hasNext()) {
                    rule = iterator.next();
                    callSiteArray[2].call(rule, (Object)device, (Object)errors);
                }
            } else {
                Object rule = null;
                Iterator iterator = (Iterator)ScriptBytecodeAdapter.castToType((Object)callSiteArray[3].call((Object)BlockDeviceRules.values()), Iterator.class);
                while (iterator.hasNext()) {
                    rule = iterator.next();
                    callSiteArray[4].call(rule, (Object)device, (Object)errors);
                }
            }
        }

        public static final BlockDeviceRules[] values() {
            CallSite[] callSiteArray = BlockDeviceRules.$getCallSiteArray();
            return (BlockDeviceRules[])ScriptBytecodeAdapter.castToType((Object)$VALUES.clone(), BlockDeviceRules[].class);
        }

        public /* synthetic */ BlockDeviceRules next() {
            CallSite[] callSiteArray = BlockDeviceRules.$getCallSiteArray();
            Object ordinal = callSiteArray[5].call(callSiteArray[6].callCurrent((GroovyObject)this));
            if (ScriptBytecodeAdapter.compareGreaterThanEqual((Object)ordinal, (Object)callSiteArray[7].call((Object)$VALUES))) {
                Integer n = 0;
                ordinal = n;
            }
            return (BlockDeviceRules)ShortTypeHandling.castToEnum((Object)callSiteArray[8].call((Object)$VALUES, ordinal), BlockDeviceRules.class);
        }

        public /* synthetic */ BlockDeviceRules previous() {
            CallSite[] callSiteArray = BlockDeviceRules.$getCallSiteArray();
            Object ordinal = callSiteArray[9].call(callSiteArray[10].callCurrent((GroovyObject)this));
            if (ScriptBytecodeAdapter.compareLessThan((Object)ordinal, (Object)0)) {
                Object object;
                ordinal = object = callSiteArray[11].call(callSiteArray[12].call((Object)$VALUES), (Object)1);
            }
            return (BlockDeviceRules)ShortTypeHandling.castToEnum((Object)callSiteArray[13].call((Object)$VALUES, ordinal), BlockDeviceRules.class);
        }

        public static BlockDeviceRules valueOf(String name) {
            CallSite[] callSiteArray = BlockDeviceRules.$getCallSiteArray();
            return (BlockDeviceRules)ShortTypeHandling.castToEnum((Object)callSiteArray[14].callStatic(BlockDeviceRules.class, BlockDeviceRules.class, (Object)name), BlockDeviceRules.class);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static final /* synthetic */ BlockDeviceRules $INIT(Object ... para) {
            CallSite[] callSiteArray = BlockDeviceRules.$getCallSiteArray();
            Object[] objectArray = ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{para}, (int[])new int[]{0});
            switch (ScriptBytecodeAdapter.selectConstructorAndTransformArguments((Object[])objectArray, (int)-1, BlockDeviceRules.class)) {
                case 1159348642: {
                    return new BlockDeviceRules(ShortTypeHandling.castToString((Object)objectArray[0]), DefaultTypeTransformation.intUnbox((Object)objectArray[1]), (Closure)ScriptBytecodeAdapter.castToType((Object)objectArray[2], Closure.class));
                }
                default: {
                    throw new IllegalArgumentException("This class has been compiled with a super class which is binary incompatible with the current super class found on classpath. You should recompile this class with the new version.");
                }
            }
        }

        static {
            BlockDeviceRules blockDeviceRules;
            BlockDeviceRules blockDeviceRules2;
            public final class __clinit__closure1
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;

                public __clinit__closure1(Object _outerInstance, Object _thisObject) {
                    CallSite[] callSiteArray = __clinit__closure1.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(AmazonBlockDevice device, ValidationErrors errors) {
                    CallSite[] callSiteArray = __clinit__closure1.$getCallSiteArray();
                    if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[0].callGroovyObjectGetProperty((Object)device))) {
                        return callSiteArray[1].call((Object)errors, (Object)"blockDevices", (Object)"basicAmazonDeployDescription.block.device.not.named", (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((String[])ScriptBytecodeAdapter.asType((Object)ScriptBytecodeAdapter.createList((Object[])new Object[0]), String[].class)), String[].class), (Object)"Device name is required for block device");
                    }
                    return null;
                }

                public Object call(AmazonBlockDevice device, ValidationErrors errors) {
                    CallSite[] callSiteArray = __clinit__closure1.$getCallSiteArray();
                    return callSiteArray[2].callCurrent((GroovyObject)this, (Object)device, (Object)errors);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != __clinit__closure1.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                    stringArray[0] = "deviceName";
                    stringArray[1] = "rejectValue";
                    stringArray[2] = "doCall";
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[3];
                    __clinit__closure1.$createCallSiteArray_1(stringArray);
                    return new CallSiteArray(__clinit__closure1.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = __clinit__closure1.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            }
            Object object = BlockDeviceRules.$getCallSiteArray()[15].callStatic(BlockDeviceRules.class, (Object)"deviceNameNotNull", (Object)0, (Object)new __clinit__closure1(BlockDeviceRules.class, BasicAmazonDeployDescriptionValidator.class));
            deviceNameNotNull = (BlockDeviceRules)ShortTypeHandling.castToEnum((Object)object, BlockDeviceRules.class);
            public final class __clinit__closure2
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;

                public __clinit__closure2(Object _outerInstance, Object _thisObject) {
                    CallSite[] callSiteArray = __clinit__closure2.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(AmazonBlockDevice device, ValidationErrors errors) {
                    CallSite[] callSiteArray = __clinit__closure2.$getCallSiteArray();
                    if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[0].callGroovyObjectGetProperty((Object)device)) && (ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[1].callGroovyObjectGetProperty((Object)device), null) || DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[2].callGroovyObjectGetProperty((Object)device)) || DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[3].callGroovyObjectGetProperty((Object)device)) || DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[4].callGroovyObjectGetProperty((Object)device)) || DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[5].callGroovyObjectGetProperty((Object)device)))) {
                        return callSiteArray[6].call((Object)errors, (Object)"blockDevices", (Object)"basicAmazonDeployDescription.block.device.ephemeral.config", (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((String[])ScriptBytecodeAdapter.asType((Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{callSiteArray[7].callGroovyObjectGetProperty((Object)device)}), String[].class)), String[].class), (Object)new GStringImpl(new Object[]{callSiteArray[8].callGroovyObjectGetProperty((Object)device)}, new String[]{"Ephemeral block device ", " with EBS configuration parameters"}));
                    }
                    return null;
                }

                public Object call(AmazonBlockDevice device, ValidationErrors errors) {
                    CallSite[] callSiteArray = __clinit__closure2.$getCallSiteArray();
                    return callSiteArray[9].callCurrent((GroovyObject)this, (Object)device, (Object)errors);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != __clinit__closure2.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                    stringArray[0] = "virtualName";
                    stringArray[1] = "deleteOnTermination";
                    stringArray[2] = "iops";
                    stringArray[3] = "size";
                    stringArray[4] = "snapshotId";
                    stringArray[5] = "volumeType";
                    stringArray[6] = "rejectValue";
                    stringArray[7] = "virtualName";
                    stringArray[8] = "deviceName";
                    stringArray[9] = "doCall";
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[10];
                    __clinit__closure2.$createCallSiteArray_1(stringArray);
                    return new CallSiteArray(__clinit__closure2.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = __clinit__closure2.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            }
            Object object2 = BlockDeviceRules.$getCallSiteArray()[16].callStatic(BlockDeviceRules.class, (Object)"ephemeralConfigWrong", (Object)1, (Object)new __clinit__closure2(BlockDeviceRules.class, BasicAmazonDeployDescriptionValidator.class));
            ephemeralConfigWrong = (BlockDeviceRules)ShortTypeHandling.castToEnum((Object)object2, BlockDeviceRules.class);
            public final class __clinit__closure3
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;

                public __clinit__closure3(Object _outerInstance, Object _thisObject) {
                    CallSite[] callSiteArray = __clinit__closure3.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(AmazonBlockDevice device, ValidationErrors errors) {
                    CallSite[] callSiteArray = __clinit__closure3.$getCallSiteArray();
                    if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[0].callGroovyObjectGetProperty((Object)device)) && !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[1].callGroovyObjectGetProperty((Object)device))) {
                            return callSiteArray[2].call((Object)errors, (Object)"blockDevices", (Object)"basicAmazonDeployDescription.block.device.ebs.config", (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((String[])ScriptBytecodeAdapter.asType((Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{callSiteArray[3].callGroovyObjectGetProperty((Object)device)}), String[].class)), String[].class), (Object)new GStringImpl(new Object[]{callSiteArray[4].callGroovyObjectGetProperty((Object)device)}, new String[]{"EBS device ", " missing required value size"}));
                        }
                        return null;
                    }
                    if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[5].callGroovyObjectGetProperty((Object)device)) && !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[6].callGroovyObjectGetProperty((Object)device))) {
                        return callSiteArray[7].call((Object)errors, (Object)"blockDevices", (Object)"basicAmazonDeployDescription.block.device.ebs.config", (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((String[])ScriptBytecodeAdapter.asType((Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{callSiteArray[8].callGroovyObjectGetProperty((Object)device)}), String[].class)), String[].class), (Object)new GStringImpl(new Object[]{callSiteArray[9].callGroovyObjectGetProperty((Object)device)}, new String[]{"EBS device ", " missing required value size"}));
                    }
                    return null;
                }

                public Object call(AmazonBlockDevice device, ValidationErrors errors) {
                    CallSite[] callSiteArray = __clinit__closure3.$getCallSiteArray();
                    return callSiteArray[10].callCurrent((GroovyObject)this, (Object)device, (Object)errors);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != __clinit__closure3.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                    stringArray[0] = "virtualName";
                    stringArray[1] = "size";
                    stringArray[2] = "rejectValue";
                    stringArray[3] = "deviceName";
                    stringArray[4] = "deviceName";
                    stringArray[5] = "virtualName";
                    stringArray[6] = "size";
                    stringArray[7] = "rejectValue";
                    stringArray[8] = "deviceName";
                    stringArray[9] = "deviceName";
                    stringArray[10] = "doCall";
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[11];
                    __clinit__closure3.$createCallSiteArray_1(stringArray);
                    return new CallSiteArray(__clinit__closure3.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = __clinit__closure3.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            }
            Object object3 = BlockDeviceRules.$getCallSiteArray()[17].callStatic(BlockDeviceRules.class, (Object)"ebsConfigWrong", (Object)2, (Object)new __clinit__closure3(BlockDeviceRules.class, BasicAmazonDeployDescriptionValidator.class));
            ebsConfigWrong = (BlockDeviceRules)ShortTypeHandling.castToEnum((Object)object3, BlockDeviceRules.class);
            MIN_VALUE = blockDeviceRules2 = deviceNameNotNull;
            MAX_VALUE = blockDeviceRules = ebsConfigWrong;
            BlockDeviceRules[] blockDeviceRulesArray = new BlockDeviceRules[]{deviceNameNotNull, ephemeralConfigWrong, ebsConfigWrong};
            $VALUES = blockDeviceRulesArray;
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (((Object)((Object)this)).getClass() != BlockDeviceRules.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
            }
            return classInfo.getMetaClass();
        }

        @Generated
        @Internal
        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        @Generated
        @Internal
        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        @Generated
        @Internal
        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }

        private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
            stringArray[0] = "iterator";
            stringArray[1] = "values";
            stringArray[2] = "validateDevice";
            stringArray[3] = "iterator";
            stringArray[4] = "validateDevice";
            stringArray[5] = "next";
            stringArray[6] = "ordinal";
            stringArray[7] = "size";
            stringArray[8] = "getAt";
            stringArray[9] = "previous";
            stringArray[10] = "ordinal";
            stringArray[11] = "minus";
            stringArray[12] = "size";
            stringArray[13] = "getAt";
            stringArray[14] = "valueOf";
            stringArray[15] = "$INIT";
            stringArray[16] = "$INIT";
            stringArray[17] = "$INIT";
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[18];
            BlockDeviceRules.$createCallSiteArray_1(stringArray);
            return new CallSiteArray(BlockDeviceRules.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = BlockDeviceRules.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }
    }
}

