/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.aws.security;

import com.amazonaws.regions.Regions;
import com.amazonaws.util.CollectionUtils;
import com.netflix.spinnaker.clouddriver.aws.security.DefaultAccountConfigurationProperties;
import com.netflix.spinnaker.clouddriver.aws.security.NetflixAmazonCredentials;
import com.netflix.spinnaker.clouddriver.aws.security.config.CredentialsConfig;
import com.netflix.spinnaker.credentials.CredentialsRepository;
import com.netflix.spinnaker.credentials.definition.BasicCredentialsLoader;
import com.netflix.spinnaker.credentials.definition.CredentialsDefinitionSource;
import com.netflix.spinnaker.credentials.definition.CredentialsParser;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class AmazonBasicCredentialsLoader<T extends CredentialsConfig.Account, U extends NetflixAmazonCredentials>
extends BasicCredentialsLoader<T, U> {
    protected final CredentialsConfig credentialsConfig;
    protected final DefaultAccountConfigurationProperties defaultAccountConfigurationProperties;
    protected String defaultEnvironment;
    protected String defaultAccountType;

    public AmazonBasicCredentialsLoader(CredentialsDefinitionSource<T> definitionSource, CredentialsParser<T, U> parser, CredentialsRepository<U> credentialsRepository, CredentialsConfig credentialsConfig, DefaultAccountConfigurationProperties defaultAccountConfigurationProperties) {
        super(definitionSource, parser, credentialsRepository);
        this.credentialsConfig = credentialsConfig;
        this.defaultAccountConfigurationProperties = defaultAccountConfigurationProperties;
        this.defaultEnvironment = defaultAccountConfigurationProperties.getEnvironment() != null ? defaultAccountConfigurationProperties.getEnvironment() : defaultAccountConfigurationProperties.getEnv();
        String string = this.defaultAccountType = defaultAccountConfigurationProperties.getAccountType() != null ? defaultAccountConfigurationProperties.getAccountType() : defaultAccountConfigurationProperties.getEnv();
        if (!StringUtils.isEmpty((CharSequence)credentialsConfig.getAccessKeyId())) {
            System.setProperty("aws.accessKeyId", credentialsConfig.getAccessKeyId());
        }
        if (!StringUtils.isEmpty((CharSequence)credentialsConfig.getSecretAccessKey())) {
            System.setProperty("aws.secretKey", credentialsConfig.getSecretAccessKey());
        }
    }

    public void load() {
        if (CollectionUtils.isNullOrEmpty(this.credentialsConfig.getAccounts()) && StringUtils.isEmpty((CharSequence)this.credentialsConfig.getDefaultAssumeRole())) {
            this.credentialsConfig.setAccounts(Collections.singletonList(new CredentialsConfig.Account(){
                {
                    this.setName(AmazonBasicCredentialsLoader.this.defaultAccountConfigurationProperties.getEnv());
                    this.setEnvironment(AmazonBasicCredentialsLoader.this.defaultEnvironment);
                    this.setAccountType(AmazonBasicCredentialsLoader.this.defaultAccountType);
                }
            }));
            if (CollectionUtils.isNullOrEmpty(this.credentialsConfig.getDefaultRegions())) {
                ArrayList<Regions> regions = new ArrayList<Regions>(Arrays.asList(Regions.US_EAST_1, Regions.US_WEST_1, Regions.US_WEST_2, Regions.EU_WEST_1));
                this.credentialsConfig.setDefaultRegions(regions.stream().map(it -> new CredentialsConfig.Region((Regions)it){
                    final /* synthetic */ Regions val$it;
                    {
                        this.val$it = regions;
                        this.setName(this.val$it.getName());
                    }
                }).collect(Collectors.toList()));
            }
        }
        this.parse(this.definitionSource.getCredentialsDefinitions());
    }
}

