/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.aws.security.config;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.spinnaker.clouddriver.aws.security.AWSAccountInfoLookup;
import com.netflix.spinnaker.clouddriver.aws.security.AmazonClientProvider;
import com.netflix.spinnaker.clouddriver.aws.security.AmazonCredentials;
import com.netflix.spinnaker.clouddriver.aws.security.DefaultAWSAccountInfoLookup;
import com.netflix.spinnaker.clouddriver.aws.security.NetflixAmazonCredentials;
import com.netflix.spinnaker.clouddriver.aws.security.config.CredentialsConfig;
import com.netflix.spinnaker.credentials.definition.CredentialsParser;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AmazonCredentialsParser<U extends CredentialsConfig.Account, V extends NetflixAmazonCredentials>
implements CredentialsParser<U, V> {
    private final AWSCredentialsProvider credentialsProvider;
    private final AWSAccountInfoLookup awsAccountInfoLookup;
    private final Map<String, String> templateValues;
    private final CredentialTranslator<V> credentialTranslator;
    private final ObjectMapper objectMapper;
    private final CredentialsConfig credentialsConfig;
    private Lazy<List<CredentialsConfig.Region>> defaultRegions;

    public AmazonCredentialsParser(AWSCredentialsProvider credentialsProvider, AmazonClientProvider amazonClientProvider, Class<V> credentialsType, CredentialsConfig credentialsConfig) {
        this.credentialsProvider = Objects.requireNonNull(credentialsProvider, "credentialsProvider");
        this.awsAccountInfoLookup = new DefaultAWSAccountInfoLookup(credentialsProvider, amazonClientProvider);
        this.templateValues = Collections.emptyMap();
        this.objectMapper = new ObjectMapper();
        this.credentialTranslator = AmazonCredentialsParser.findTranslator(credentialsType, this.objectMapper);
        this.credentialsConfig = credentialsConfig;
        this.defaultRegions = this.createDefaults(credentialsConfig.getDefaultRegions());
    }

    public AmazonCredentialsParser(AWSCredentialsProvider credentialsProvider, AWSAccountInfoLookup awsAccountInfoLookup, Class<V> credentialsType, CredentialsConfig credentialsConfig) {
        this.credentialsProvider = Objects.requireNonNull(credentialsProvider, "credentialsProvider");
        this.awsAccountInfoLookup = awsAccountInfoLookup;
        this.templateValues = Collections.emptyMap();
        this.objectMapper = new ObjectMapper();
        this.credentialTranslator = AmazonCredentialsParser.findTranslator(credentialsType, this.objectMapper);
        this.credentialsConfig = credentialsConfig;
        this.defaultRegions = this.createDefaults(credentialsConfig.getDefaultRegions());
    }

    private Lazy<List<CredentialsConfig.Region>> createDefaults(final List<CredentialsConfig.Region> defaults) {
        return new Lazy<List<CredentialsConfig.Region>>(new Lazy.Loader<List<CredentialsConfig.Region>>(){

            @Override
            public List<CredentialsConfig.Region> get() {
                if (defaults == null) {
                    return AmazonCredentialsParser.toRegion(AmazonCredentialsParser.this.awsAccountInfoLookup.listRegions(new String[0]));
                }
                ArrayList<CredentialsConfig.Region> result = new ArrayList<CredentialsConfig.Region>(defaults.size());
                ArrayList<String> toLookup = new ArrayList<String>();
                for (CredentialsConfig.Region def : defaults) {
                    if (def.getAvailabilityZones() == null || def.getAvailabilityZones().isEmpty()) {
                        toLookup.add(def.getName());
                        continue;
                    }
                    result.add(def);
                }
                if (!toLookup.isEmpty()) {
                    List<CredentialsConfig.Region> resolved = AmazonCredentialsParser.toRegion(AmazonCredentialsParser.this.awsAccountInfoLookup.listRegions(toLookup));
                    for (CredentialsConfig.Region region : resolved) {
                        CredentialsConfig.Region fromDefault = AmazonCredentialsParser.find(defaults, region.getName());
                        if (fromDefault == null) continue;
                        region.setPreferredZones(fromDefault.getPreferredZones());
                        region.setDeprecated(fromDefault.getDeprecated());
                    }
                    result.addAll(resolved);
                }
                return result;
            }
        });
    }

    private List<CredentialsConfig.Region> initRegions(Lazy<List<CredentialsConfig.Region>> defaults, List<CredentialsConfig.Region> toInit) {
        if (toInit == null) {
            return defaults.get();
        }
        Map toInitByName = toInit.stream().collect(Collectors.toMap(CredentialsConfig.Region::getName, Function.identity()));
        List<Object> result = new ArrayList<CredentialsConfig.Region>(toInit.size());
        ArrayList<String> toLookup = new ArrayList<String>();
        for (CredentialsConfig.Region region : toInit) {
            if (region.getAvailabilityZones() == null || region.getAvailabilityZones().isEmpty()) {
                toLookup.add(region.getName());
                continue;
            }
            result.add(region);
        }
        Iterator lookups = toLookup.iterator();
        while (lookups.hasNext()) {
            String a;
            List<CredentialsConfig.Region> list = defaults.get();
            CredentialsConfig.Region fromDefault = AmazonCredentialsParser.find(list, a = (String)lookups.next());
            if (fromDefault == null) continue;
            lookups.remove();
            result.add(fromDefault);
        }
        if (!toLookup.isEmpty()) {
            List<CredentialsConfig.Region> resolved = AmazonCredentialsParser.toRegion(this.awsAccountInfoLookup.listRegions(toLookup));
            for (CredentialsConfig.Region region : resolved) {
                CredentialsConfig.Region src = AmazonCredentialsParser.find(toInit, region.getName());
                if (src == null || src.getPreferredZones() == null) {
                    src = AmazonCredentialsParser.find(defaults.get(), region.getName());
                }
                if (src == null) continue;
                region.setPreferredZones(src.getPreferredZones());
            }
            result.addAll(resolved);
        }
        result = result.stream().map(CredentialsConfig.Region::copyOf).collect(Collectors.toList());
        for (CredentialsConfig.Region region : result) {
            CredentialsConfig.Region toInitRegion = (CredentialsConfig.Region)toInitByName.get(region.getName());
            if (toInitRegion == null || toInitRegion.getDeprecated() == null) continue;
            region.setDeprecated(toInitRegion.getDeprecated());
        }
        return result;
    }

    private static CredentialsConfig.Region find(List<CredentialsConfig.Region> src, String name) {
        if (src != null) {
            for (CredentialsConfig.Region r : src) {
                if (!r.getName().equals(name)) continue;
                return r;
            }
        }
        return null;
    }

    private static List<CredentialsConfig.Region> toRegion(List<AmazonCredentials.AWSRegion> src) {
        ArrayList<CredentialsConfig.Region> result = new ArrayList<CredentialsConfig.Region>(src.size());
        for (AmazonCredentials.AWSRegion r : src) {
            CredentialsConfig.Region region = new CredentialsConfig.Region();
            region.setName(r.getName());
            region.setAvailabilityZones(new ArrayList<String>(r.getAvailabilityZones()));
            region.setPreferredZones(new ArrayList<String>(r.getPreferredZones()));
            result.add(region);
        }
        return result;
    }

    public List<V> load(CredentialsConfig source) throws Throwable {
        CredentialsConfig config = (CredentialsConfig)this.objectMapper.convertValue((Object)source, CredentialsConfig.class);
        if (config.getAccounts() == null || config.getAccounts().isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<V> initializedAccounts = new ArrayList<V>(config.getAccounts().size());
        for (CredentialsConfig.Account account : config.getAccounts()) {
            initializedAccounts.add(this.parseAccount(config, account));
        }
        return initializedAccounts.stream().filter(AmazonCredentials::isEnabled).collect(Collectors.toList());
    }

    @Nullable
    public V parse(@NotNull U account) {
        try {
            V a = this.parseAccount(this.credentialsConfig, (CredentialsConfig.Account)account);
            if (((AmazonCredentials)((Object)a)).isEnabled()) {
                return a;
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
        return null;
    }

    private V parseAccount(CredentialsConfig config, CredentialsConfig.Account account) throws Throwable {
        if (account.getAccountId() == null) {
            if (!this.credentialTranslator.resolveAccountId()) {
                throw new IllegalArgumentException("accountId is required and not resolvable for this credentials type");
            }
            account.setAccountId(this.awsAccountInfoLookup.findAccountId());
        }
        if (account.getEnvironment() == null) {
            account.setEnvironment(account.getName());
        }
        if (account.getAccountType() == null) {
            account.setAccountType(account.getName());
        }
        account.setRegions(this.initRegions(this.defaultRegions, account.getRegions()));
        account.setDefaultSecurityGroups(account.getDefaultSecurityGroups() != null ? account.getDefaultSecurityGroups() : config.getDefaultSecurityGroups());
        account.setLifecycleHooks(account.getLifecycleHooks() != null ? account.getLifecycleHooks() : config.getDefaultLifecycleHooks());
        account.setEnabled(Optional.ofNullable(account.getEnabled()).orElse(true));
        HashMap<String, String> templateContext = new HashMap<String, String>(this.templateValues);
        templateContext.put("name", account.getName());
        templateContext.put("accountId", account.getAccountId());
        templateContext.put("environment", account.getEnvironment());
        templateContext.put("accountType", account.getAccountType());
        account.setDefaultKeyPair(AmazonCredentialsParser.templateFirstNonNull(templateContext, account.getDefaultKeyPair(), config.getDefaultKeyPairTemplate()));
        account.setEdda(AmazonCredentialsParser.templateFirstNonNull(templateContext, account.getEdda(), config.getDefaultEddaTemplate()));
        account.setFront50(AmazonCredentialsParser.templateFirstNonNull(templateContext, account.getFront50(), config.getDefaultFront50Template()));
        account.setDiscovery(AmazonCredentialsParser.templateFirstNonNull(templateContext, account.getDiscovery(), config.getDefaultDiscoveryTemplate()));
        account.setAssumeRole(AmazonCredentialsParser.templateFirstNonNull(templateContext, account.getAssumeRole(), config.getDefaultAssumeRole()));
        account.setSessionName(AmazonCredentialsParser.templateFirstNonNull(templateContext, account.getSessionName(), config.getDefaultSessionName()));
        account.setBastionHost(AmazonCredentialsParser.templateFirstNonNull(templateContext, account.getBastionHost(), config.getDefaultBastionHostTemplate()));
        if (account.getLifecycleHooks() != null) {
            for (CredentialsConfig.LifecycleHook lifecycleHook : account.getLifecycleHooks()) {
                lifecycleHook.setRoleARN(AmazonCredentialsParser.templateFirstNonNull(templateContext, lifecycleHook.getRoleARN(), config.getDefaultLifecycleHookRoleARNTemplate()));
                lifecycleHook.setNotificationTargetARN(AmazonCredentialsParser.templateFirstNonNull(templateContext, lifecycleHook.getNotificationTargetARN(), config.getDefaultLifecycleHookNotificationTargetARNTemplate()));
            }
        }
        return (V)((Object)((NetflixAmazonCredentials)((Object)this.credentialTranslator.translate(this.credentialsProvider, account))));
    }

    private static String templateFirstNonNull(Map<String, String> substitutions, String ... values) {
        for (String value : values) {
            if (value == null) continue;
            return StringTemplater.render(value, substitutions);
        }
        return null;
    }

    static <T extends AmazonCredentials> CredentialTranslator<T> findTranslator(Class<T> credentialsType, ObjectMapper objectMapper) {
        return new CopyConstructorTranslator<T>(objectMapper, credentialsType);
    }

    static class StringTemplater {
        StringTemplater() {
        }

        public static String render(String template, Map<String, String> substitutions) {
            String base = template;
            int iterations = 0;
            boolean changed = true;
            while (changed && iterations < 10) {
                ++iterations;
                String previous = base;
                for (Map.Entry<String, String> substitution : substitutions.entrySet()) {
                    base = base.replaceAll(Pattern.quote("{{" + substitution.getKey() + "}}"), substitution.getValue());
                }
                changed = !previous.equals(base);
            }
            if (changed) {
                throw new RuntimeException("too many levels of templatery");
            }
            return base;
        }
    }

    static class CopyConstructorTranslator<T extends AmazonCredentials>
    implements CredentialTranslator<T> {
        private final ObjectMapper objectMapper;
        private final Class<T> credentialType;
        private final Constructor<T> copyConstructor;

        public CopyConstructorTranslator(ObjectMapper objectMapper, Class<T> credentialType) {
            this.objectMapper = objectMapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
            this.credentialType = credentialType;
            try {
                this.copyConstructor = credentialType.getConstructor(credentialType, AWSCredentialsProvider.class);
            }
            catch (NoSuchMethodException nsme) {
                throw new IllegalArgumentException("Class " + credentialType + " must supply a constructor with " + credentialType + ", " + AWSCredentialsProvider.class + " args.");
            }
        }

        @Override
        public Class<T> getCredentialType() {
            return this.credentialType;
        }

        @Override
        public boolean resolveAccountId() {
            try {
                this.credentialType.getMethod("getAssumeRole", new Class[0]);
                return false;
            }
            catch (NoSuchMethodException nsme) {
                return true;
            }
        }

        @Override
        public T translate(AWSCredentialsProvider credentialsProvider, CredentialsConfig.Account account) throws Throwable {
            AmazonCredentials immutableInstance = (AmazonCredentials)((Object)this.objectMapper.convertValue((Object)account, this.credentialType));
            try {
                return (T)((Object)((AmazonCredentials)((Object)this.copyConstructor.newInstance(new Object[]{immutableInstance, credentialsProvider}))));
            }
            catch (InvocationTargetException ite) {
                throw ite.getTargetException();
            }
        }
    }

    static interface CredentialTranslator<T extends AmazonCredentials> {
        public Class<T> getCredentialType();

        public boolean resolveAccountId();

        public T translate(AWSCredentialsProvider var1, CredentialsConfig.Account var2) throws Throwable;
    }

    private static class Lazy<T> {
        private final Loader<T> loader;
        private final AtomicReference<T> ref = new AtomicReference();

        public Lazy(Loader<T> loader) {
            this.loader = loader;
        }

        public T get() {
            if (this.ref.get() == null) {
                this.ref.set(this.loader.get());
            }
            return this.ref.get();
        }

        public static interface Loader<T> {
            public T get();
        }
    }
}

