/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.aws.security.sdkclient;

import com.amazonaws.SdkClientException;
import com.amazonaws.regions.AwsRegionProvider;
import com.amazonaws.regions.AwsRegionProviderChain;
import com.amazonaws.regions.DefaultAwsRegionProviderChain;
import com.amazonaws.regions.Regions;

public class SpinnakerAwsRegionProvider
extends AwsRegionProviderChain {
    public SpinnakerAwsRegionProvider() {
        super(new AwsRegionProvider[]{new Ec2RegionEnvVarRegionProvider(), new DefaultAwsRegionProviderChain(), new RegionsCurrentRegionProvider(), new DefaultRegionProvider()});
    }

    private static class DefaultRegionProvider
    extends AwsRegionProvider {
        private DefaultRegionProvider() {
        }

        public String getRegion() throws SdkClientException {
            return Regions.DEFAULT_REGION.getName();
        }
    }

    private static class RegionsCurrentRegionProvider
    extends AwsRegionProvider {
        private RegionsCurrentRegionProvider() {
        }

        public String getRegion() throws SdkClientException {
            return Regions.getCurrentRegion().getName();
        }
    }

    private static class Ec2RegionEnvVarRegionProvider
    extends AwsRegionProvider {
        private Ec2RegionEnvVarRegionProvider() {
        }

        public String getRegion() throws SdkClientException {
            return System.getenv("EC2_REGION");
        }
    }
}

