/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.aws.deploy.asg;

import com.netflix.frigga.NameConstants;
import com.netflix.frigga.NameValidation;
import com.netflix.frigga.Names;
import com.netflix.spinnaker.clouddriver.aws.services.AsgService;
import com.netflix.spinnaker.clouddriver.helpers.AbstractServerGroupNameResolver;
import com.netflix.spinnaker.clouddriver.model.Cluster;
import com.netflix.spinnaker.clouddriver.model.ClusterProvider;
import com.netflix.spinnaker.clouddriver.model.ServerGroup;
import groovy.lang.Closure;
import groovy.lang.GString;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;

public class AWSServerGroupNameResolver
extends AbstractServerGroupNameResolver {
    private static final String AWS_PHASE = "AWS_DEPLOY";
    private static final int DEFAULT_NEXT_SERVER_GROUP_ATTEMPTS = 5;
    private final String accountName;
    private final String region;
    private final AsgService asgService;
    private final Collection<ClusterProvider> clusterProviders;
    private final int maxNextServerGroupAttempts;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    public AWSServerGroupNameResolver(String accountName, String region, AsgService asgService, Collection<ClusterProvider> clusterProviders, int maxNextServerGroupAttempts) {
        int n;
        AsgService asgService2;
        String string;
        String string2;
        this.accountName = string2 = accountName;
        this.region = string = region;
        this.asgService = asgService2 = asgService;
        Collection<ClusterProvider> collection = clusterProviders;
        this.clusterProviders = collection;
        this.maxNextServerGroupAttempts = n = maxNextServerGroupAttempts;
    }

    @Generated
    public AWSServerGroupNameResolver(String accountName, String region, AsgService asgService, Collection<ClusterProvider> clusterProviders) {
        this(accountName, region, asgService, clusterProviders, DEFAULT_NEXT_SERVER_GROUP_ATTEMPTS);
    }

    public String getPhase() {
        return AWS_PHASE;
    }

    public String getRegion() {
        return this.region;
    }

    public List<AbstractServerGroupNameResolver.TakenSlot> getTakenSlots(String clusterName) {
        Cluster cluster = AWSServerGroupNameResolver.awsCluster(this.clusterProviders, this.accountName, clusterName);
        if (!DefaultTypeTransformation.booleanUnbox((Object)cluster)) {
            return ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        }
        public final class _getTakenSlots_closure1
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _getTakenSlots_closure1(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return ScriptBytecodeAdapter.compareEqual((Object)((ServerGroup)it).getRegion(), (Object)((AWSServerGroupNameResolver)((Object)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), AWSServerGroupNameResolver.class))).getRegion()) && DefaultTypeTransformation.booleanUnbox((Object)((AWSServerGroupNameResolver)((Object)this.getThisObject())).asgService.getAutoScalingGroup(((ServerGroup)it).getName()));
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getTakenSlots_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        Set serverGroupsInRegion = DefaultGroovyMethods.findAll((Set)cluster.getServerGroups(), (Closure)new _getTakenSlots_closure1((Object)this, (Object)this));
        public final class _getTakenSlots_closure2
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _getTakenSlots_closure2(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                AbstractServerGroupNameResolver.TakenSlot takenSlot = new AbstractServerGroupNameResolver.TakenSlot();
                String string = ((ServerGroup)it).getName();
                takenSlot.setServerGroupName(string);
                Integer n = Names.parseName((String)((ServerGroup)it).getName()).getSequence();
                takenSlot.setSequence(n);
                Date date = new Date(((ServerGroup)it).getCreatedTime());
                takenSlot.setCreatedTime(date);
                return takenSlot;
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getTakenSlots_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        return DefaultGroovyMethods.collect((Iterable)serverGroupsInRegion, (Closure)new _getTakenSlots_closure2((Object)this, (Object)this));
    }

    /*
     * Unable to fully structure code
     */
    public String resolveNextServerGroupName(String application, String stack, String details, Boolean ignoreSequence) {
        block6: {
            clusterName = this.combineAppStackDetail(application, stack, details);
            if (NameValidation.checkNameWithHyphen((String)clusterName) == false) {
                throw (Throwable)new IllegalArgumentException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{clusterName}, new String[]{"Invalid cluster name: '", "'. Cluster names can only contain "}).plus((GString)new GStringImpl(new Object[]{NameConstants.NAME_HYPHEN_CHARS}, new String[]{"characters in the following range: ", ""}))));
            }
            originalNextServerGroupName = super.resolveNextServerGroupName(application, stack, details, ignoreSequence);
            nextServerGroupName = originalNextServerGroupName;
            if (!DefaultTypeTransformation.booleanUnbox((Object)nextServerGroupName)) break block6;
            hasNextServerGroup = false;
            attempts = 0;
            while (true) {
                if (!(hasNextServerGroup == false)) ** GOTO lbl-1000
                var10_10 = attempts;
                var10_10 + 1;
                if (var10_10 <= AWSServerGroupNameResolver.DEFAULT_NEXT_SERVER_GROUP_ATTEMPTS) {
                    v0 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v0 = false;
                }
                if (!v0) break;
                nextServerGroup = this.asgService.getAutoScalingGroup(nextServerGroupName);
                if (DefaultTypeTransformation.booleanUnbox((Object)nextServerGroup) == false) {
                    hasNextServerGroup = var12_14 = true;
                    break;
                }
                nextSequence = this.generateNextSequence(nextServerGroupName);
                nextServerGroupName = var14_13 = AbstractServerGroupNameResolver.generateServerGroupName((String)application, (String)stack, (String)details, (Integer)nextSequence, (Boolean)false);
            }
            if (hasNextServerGroup == false) {
                throw (Throwable)new IllegalArgumentException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{clusterName, this.region}, new String[]{"All server group names for cluster ", " in ", " are taken."})));
            }
        }
        return nextServerGroupName;
    }

    /*
     * WARNING - void declaration
     */
    private static Cluster awsCluster(Collection<ClusterProvider> clusterProviders, String accountName, String clusterName) {
        void var2_2;
        Reference accountName2 = new Reference((Object)accountName);
        Reference clusterName2 = new Reference((Object)var2_2);
        public final class _awsCluster_closure3
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference clusterName;
            private /* synthetic */ Reference accountName;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _awsCluster_closure3(Object _outerInstance, Object _thisObject, Reference clusterName, Reference accountName) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                this.clusterName = reference2 = clusterName;
                this.accountName = reference = accountName;
            }

            public Object doCall(Object it) {
                String application = Names.parseName((String)ShortTypeHandling.castToString((Object)this.clusterName.get())).getApp();
                return ((ClusterProvider)it).getCluster(application, ShortTypeHandling.castToString((Object)this.accountName.get()), ShortTypeHandling.castToString((Object)this.clusterName.get()));
            }

            @Generated
            public String getClusterName() {
                return ShortTypeHandling.castToString((Object)this.clusterName.get());
            }

            @Generated
            public String getAccountName() {
                return ShortTypeHandling.castToString((Object)this.accountName.get());
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _awsCluster_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        List clusters = DefaultGroovyMethods.collect(clusterProviders, (Closure)new _awsCluster_closure3(AWSServerGroupNameResolver.class, AWSServerGroupNameResolver.class, clusterName2, accountName2));
        clusters.removeAll(ScriptBytecodeAdapter.createList((Object[])new Object[]{null}));
        public final class _awsCluster_closure4
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _awsCluster_closure4(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return ((Cluster)it).getType().equalsIgnoreCase("aws");
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _awsCluster_closure4.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        return (Cluster)ScriptBytecodeAdapter.castToType((Object)DefaultGroovyMethods.find((Collection)clusters, (Closure)new _awsCluster_closure4(AWSServerGroupNameResolver.class, AWSServerGroupNameResolver.class)), Cluster.class);
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (((Object)((Object)this)).getClass() != AWSServerGroupNameResolver.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
        }
        return classInfo.getMetaClass();
    }

    public static /* synthetic */ String pfaccess$0(AWSServerGroupNameResolver $that) {
        return $that.getRegion();
    }
}

