/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.aws.deploy.asg.asgbuilders;

import com.amazonaws.services.autoscaling.AmazonAutoScaling;
import com.amazonaws.services.autoscaling.model.CreateAutoScalingGroupRequest;
import com.amazonaws.services.autoscaling.model.InstancesDistribution;
import com.amazonaws.services.autoscaling.model.LaunchTemplateSpecification;
import com.amazonaws.services.autoscaling.model.MixedInstancesPolicy;
import com.amazonaws.services.ec2.AmazonEC2;
import com.amazonaws.services.ec2.model.LaunchTemplate;
import com.netflix.spinnaker.clouddriver.aws.deploy.asg.AsgConfigHelper;
import com.netflix.spinnaker.clouddriver.aws.deploy.asg.AsgLifecycleHookWorker;
import com.netflix.spinnaker.clouddriver.aws.deploy.asg.AutoScalingWorker;
import com.netflix.spinnaker.clouddriver.aws.deploy.asg.asgbuilders.AsgBuilder;
import com.netflix.spinnaker.clouddriver.aws.services.LaunchTemplateService;
import com.netflix.spinnaker.clouddriver.aws.services.SecurityGroupService;
import com.netflix.spinnaker.clouddriver.data.task.Task;
import com.netflix.spinnaker.config.AwsConfiguration;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsgWithMixedInstancesPolicyBuilder
extends AsgBuilder {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AsgWithMixedInstancesPolicyBuilder.class);
    private LaunchTemplateService ec2LtService;
    private SecurityGroupService securityGroupService;
    private AwsConfiguration.DeployDefaults deployDefaults;

    public AsgWithMixedInstancesPolicyBuilder(LaunchTemplateService ec2LtService, SecurityGroupService securityGroupService, AwsConfiguration.DeployDefaults deployDefaults, AmazonAutoScaling autoScaling, AmazonEC2 ec2, AsgLifecycleHookWorker asgLifecycleHookWorker) {
        super(autoScaling, ec2, asgLifecycleHookWorker);
        this.securityGroupService = securityGroupService;
        this.deployDefaults = deployDefaults;
        this.ec2LtService = ec2LtService;
    }

    @Override
    public CreateAutoScalingGroupRequest buildRequest(Task task, String taskPhase, String asgName, AutoScalingWorker.AsgConfiguration config) {
        config = AsgConfigHelper.setAppSecurityGroups(config, this.securityGroupService, this.deployDefaults);
        LaunchTemplate ec2Lt = this.ec2LtService.createLaunchTemplate(config, asgName, AsgConfigHelper.createName(asgName, null));
        LaunchTemplateSpecification asgLtSpec = new LaunchTemplateSpecification().withLaunchTemplateId(ec2Lt.getLaunchTemplateId()).withVersion("$Latest");
        com.amazonaws.services.autoscaling.model.LaunchTemplate asgLt = new com.amazonaws.services.autoscaling.model.LaunchTemplate().withLaunchTemplateSpecification(asgLtSpec);
        asgLt.withOverrides(AsgConfigHelper.getLaunchTemplateOverrides(config.getLaunchTemplateOverridesForInstanceType()));
        InstancesDistribution dist = new InstancesDistribution().withOnDemandBaseCapacity(config.getOnDemandBaseCapacity()).withOnDemandPercentageAboveBaseCapacity(config.getOnDemandPercentageAboveBaseCapacity()).withSpotInstancePools(config.getSpotInstancePools()).withSpotMaxPrice(config.getSpotMaxPrice()).withSpotAllocationStrategy(config.getSpotAllocationStrategy());
        MixedInstancesPolicy mixedInsPolicy = new MixedInstancesPolicy().withLaunchTemplate(asgLt).withInstancesDistribution(dist);
        task.updateStatus(taskPhase, "Deploying ASG " + asgName + " with mixed instances policy " + mixedInsPolicy.toString());
        CreateAutoScalingGroupRequest request = this.buildPartialRequest(task, taskPhase, asgName, config);
        return request.withMixedInstancesPolicy(mixedInsPolicy);
    }
}

