/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.aws.deploy.converters;

import com.netflix.spinnaker.clouddriver.aws.AmazonOperation;
import com.netflix.spinnaker.clouddriver.aws.deploy.description.AbstractRegionAsgInstanceIdsDescription;
import com.netflix.spinnaker.clouddriver.aws.deploy.description.InstanceLoadBalancerRegistrationDescription;
import com.netflix.spinnaker.clouddriver.aws.deploy.description.InstanceTargetGroupRegistrationDescription;
import com.netflix.spinnaker.clouddriver.aws.deploy.ops.RegisterInstancesWithLoadBalancerAtomicOperation;
import com.netflix.spinnaker.clouddriver.aws.deploy.ops.RegisterInstancesWithTargetGroupAtomicOperation;
import com.netflix.spinnaker.clouddriver.aws.security.NetflixAmazonCredentials;
import com.netflix.spinnaker.clouddriver.orchestration.AtomicOperation;
import com.netflix.spinnaker.clouddriver.security.AbstractAtomicOperationsCredentialsSupport;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Component;

@AmazonOperation(value="registerInstancesWithLoadBalancer")
@Component(value="registerInstancesFromLoadBalancerDescription")
class RegisterInstancesWithLoadBalancerAtomicOperationConverter
extends AbstractAtomicOperationsCredentialsSupport {
    RegisterInstancesWithLoadBalancerAtomicOperationConverter() {
    }

    private Boolean isClassic(Map input) {
        return !input.containsKey("targetGroupNames") || ((List)this.getObjectMapper().convertValue(input.get("targetGroupNames"), List.class)).isEmpty();
    }

    public AtomicOperation convertOperation(Map input) {
        if (this.isClassic(input).booleanValue()) {
            return new RegisterInstancesWithLoadBalancerAtomicOperation(this.convertDescription(input));
        }
        return new RegisterInstancesWithTargetGroupAtomicOperation(this.convertDescription(input));
    }

    public AbstractRegionAsgInstanceIdsDescription convertDescription(Map input) {
        AbstractRegionAsgInstanceIdsDescription converted = this.isClassic(input) != false ? (AbstractRegionAsgInstanceIdsDescription)this.getObjectMapper().convertValue((Object)input, InstanceLoadBalancerRegistrationDescription.class) : (AbstractRegionAsgInstanceIdsDescription)this.getObjectMapper().convertValue((Object)input, InstanceTargetGroupRegistrationDescription.class);
        converted.setCredentials((NetflixAmazonCredentials)this.getCredentialsObject((String)input.get("credentials")));
        return converted;
    }
}

