/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.aws.deploy.ops;

import com.amazonaws.services.cloudformation.AmazonCloudFormation;
import com.amazonaws.services.cloudformation.model.AmazonCloudFormationException;
import com.amazonaws.services.cloudformation.model.ChangeSetType;
import com.amazonaws.services.cloudformation.model.CreateChangeSetRequest;
import com.amazonaws.services.cloudformation.model.CreateChangeSetResult;
import com.amazonaws.services.cloudformation.model.CreateStackRequest;
import com.amazonaws.services.cloudformation.model.CreateStackResult;
import com.amazonaws.services.cloudformation.model.DescribeStacksRequest;
import com.amazonaws.services.cloudformation.model.Parameter;
import com.amazonaws.services.cloudformation.model.Stack;
import com.amazonaws.services.cloudformation.model.Tag;
import com.amazonaws.services.cloudformation.model.UpdateStackRequest;
import com.amazonaws.services.cloudformation.model.UpdateStackResult;
import com.amazonaws.services.cloudformation.model.ValidateTemplateRequest;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.spinnaker.clouddriver.aws.AwsConfigurationProperties;
import com.netflix.spinnaker.clouddriver.aws.deploy.description.DeployCloudFormationDescription;
import com.netflix.spinnaker.clouddriver.aws.security.AmazonClientProvider;
import com.netflix.spinnaker.clouddriver.data.task.Task;
import com.netflix.spinnaker.clouddriver.data.task.TaskRepository;
import com.netflix.spinnaker.clouddriver.orchestration.AtomicOperation;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.util.StringUtils;

public class DeployCloudFormationAtomicOperation
implements AtomicOperation<Map> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DeployCloudFormationAtomicOperation.class);
    private static final String BASE_PHASE = "DEPLOY_CLOUDFORMATION_STACK";
    private static final String NO_CHANGE_STACK_ERROR_MESSAGE = "No updates";
    @Autowired
    AmazonClientProvider amazonClientProvider;
    @Autowired
    AwsConfigurationProperties awsConfigurationProperties;
    @Autowired
    @Qualifier(value="amazonObjectMapper")
    private ObjectMapper objectMapper;
    private DeployCloudFormationDescription description;

    public DeployCloudFormationAtomicOperation(DeployCloudFormationDescription deployCloudFormationDescription) {
        this.description = deployCloudFormationDescription;
    }

    public Map operate(List priorOutputs) {
        String stackId;
        Task task = (Task)TaskRepository.threadLocalTask.get();
        task.updateStatus(BASE_PHASE, "Configuring CloudFormation Stack");
        AmazonCloudFormation amazonCloudFormation = this.amazonClientProvider.getAmazonCloudFormation(this.description.getCredentials(), this.description.getRegion());
        String templateURL = this.description.getTemplateURL();
        String templateBody = this.description.getTemplateBody();
        this.validateTemplate(amazonCloudFormation, templateURL, templateBody);
        String roleARN = this.description.getRoleARN();
        List<Parameter> parameters = this.description.getParameters().entrySet().stream().map(entry -> new Parameter().withParameterKey((String)entry.getKey()).withParameterValue((String)entry.getValue())).collect(Collectors.toList());
        List<Tag> tags = this.description.getTags().entrySet().stream().map(entry -> new Tag().withKey((String)entry.getKey()).withValue((String)entry.getValue())).collect(Collectors.toList());
        boolean stackExists = this.stackExists(amazonCloudFormation);
        if (this.description.isChangeSet()) {
            ChangeSetType changeSetType = stackExists ? ChangeSetType.UPDATE : ChangeSetType.CREATE;
            log.info("{} change set for stack: {}", (Object)changeSetType, (Object)this.description);
            stackId = this.createChangeSet(amazonCloudFormation, templateURL, templateBody, roleARN, parameters, tags, this.description.getCapabilities(), changeSetType);
        } else if (stackExists) {
            log.info("Updating existing stack {}", (Object)this.description);
            stackId = this.updateStack(amazonCloudFormation, templateURL, templateBody, roleARN, parameters, tags, this.description.getCapabilities());
        } else {
            log.info("Creating new stack: {}", (Object)this.description);
            stackId = this.createStack(amazonCloudFormation, templateURL, templateBody, roleARN, parameters, tags, this.description.getCapabilities());
        }
        return Collections.singletonMap("stackId", stackId);
    }

    private String createStack(AmazonCloudFormation amazonCloudFormation, String templateURL, String templateBody, String roleARN, List<Parameter> parameters, List<Tag> tags, List<String> capabilities) {
        Task task = (Task)TaskRepository.threadLocalTask.get();
        task.updateStatus(BASE_PHASE, "Preparing CloudFormation Stack");
        CreateStackRequest createStackRequest = new CreateStackRequest().withStackName(this.description.getStackName()).withParameters(parameters).withTags(tags).withCapabilities(capabilities);
        if (StringUtils.hasText((String)templateURL)) {
            createStackRequest.setTemplateURL(templateURL);
        } else {
            createStackRequest.setTemplateBody(templateBody);
        }
        if (StringUtils.hasText((String)roleARN)) {
            createStackRequest.setRoleARN(roleARN);
        }
        task.updateStatus(BASE_PHASE, "Uploading CloudFormation Stack");
        CreateStackResult createStackResult = amazonCloudFormation.createStack(createStackRequest);
        return createStackResult.getStackId();
    }

    private String updateStack(AmazonCloudFormation amazonCloudFormation, String templateURL, String templateBody, String roleARN, List<Parameter> parameters, List<Tag> tags, List<String> capabilities) {
        Task task = (Task)TaskRepository.threadLocalTask.get();
        task.updateStatus(BASE_PHASE, "CloudFormation Stack exists. Updating it");
        UpdateStackRequest updateStackRequest = new UpdateStackRequest().withStackName(this.description.getStackName()).withParameters(parameters).withTags(tags).withCapabilities(capabilities);
        if (StringUtils.hasText((String)templateURL)) {
            updateStackRequest.setTemplateURL(templateURL);
        } else {
            updateStackRequest.setTemplateBody(templateBody);
        }
        if (StringUtils.hasText((String)roleARN)) {
            updateStackRequest.setRoleARN(roleARN);
        }
        task.updateStatus(BASE_PHASE, "Uploading CloudFormation Stack");
        try {
            UpdateStackResult updateStackResult = amazonCloudFormation.updateStack(updateStackRequest);
            return updateStackResult.getStackId();
        }
        catch (AmazonCloudFormationException e) {
            if (e.getMessage().contains(NO_CHANGE_STACK_ERROR_MESSAGE)) {
                return this.getStackId(amazonCloudFormation);
            }
            log.error("Error updating stack", (Throwable)e);
            throw e;
        }
    }

    private String createChangeSet(AmazonCloudFormation amazonCloudFormation, String templateURL, String templateBody, String roleARN, List<Parameter> parameters, List<Tag> tags, List<String> capabilities, ChangeSetType changeSetType) {
        Task task = (Task)TaskRepository.threadLocalTask.get();
        task.updateStatus(BASE_PHASE, "CloudFormation Stack exists. Creating a change set");
        CreateChangeSetRequest createChangeSetRequest = new CreateChangeSetRequest().withStackName(this.description.getStackName()).withChangeSetName(this.description.getChangeSetName()).withParameters(parameters).withTags(tags).withCapabilities(capabilities).withChangeSetType(changeSetType).withIncludeNestedStacks(Boolean.valueOf(this.awsConfigurationProperties.getCloudformation().getChangeSetsIncludeNestedStacks()));
        if (StringUtils.hasText((String)templateURL)) {
            createChangeSetRequest.setTemplateURL(templateURL);
        } else {
            createChangeSetRequest.setTemplateBody(templateBody);
        }
        if (StringUtils.hasText((String)roleARN)) {
            createChangeSetRequest.setRoleARN(roleARN);
        }
        task.updateStatus(BASE_PHASE, "Uploading CloudFormation ChangeSet");
        try {
            CreateChangeSetResult createChangeSetResult = amazonCloudFormation.createChangeSet(createChangeSetRequest);
            return createChangeSetResult.getStackId();
        }
        catch (AmazonCloudFormationException e) {
            log.error("Error creating change set", (Throwable)e);
            throw e;
        }
    }

    private boolean stackExists(AmazonCloudFormation amazonCloudFormation) {
        try {
            this.getStackId(amazonCloudFormation);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private String getStackId(AmazonCloudFormation amazonCloudFormation) {
        return ((Stack)amazonCloudFormation.describeStacks(new DescribeStacksRequest().withStackName(this.description.getStackName())).getStacks().stream().findFirst().orElseThrow(() -> new IllegalArgumentException("No CloudFormation Stack found with stack name " + this.description.getStackName()))).getStackId();
    }

    private void validateTemplate(AmazonCloudFormation amazonCloudFormation, String templateURL, String templateBody) {
        try {
            ValidateTemplateRequest validateTemplateRequest = new ValidateTemplateRequest();
            if (StringUtils.hasText((String)templateURL)) {
                validateTemplateRequest.setTemplateURL(templateURL);
            } else {
                validateTemplateRequest.setTemplateBody(templateBody);
            }
            amazonCloudFormation.validateTemplate(validateTemplateRequest);
        }
        catch (AmazonCloudFormationException e) {
            log.error("Error validating cloudformation template", (Throwable)e);
            throw e;
        }
    }
}

