/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.aws.deploy.ops;

import com.amazonaws.services.cloudformation.AmazonCloudFormation;
import com.amazonaws.services.cloudformation.model.AmazonCloudFormationException;
import com.amazonaws.services.cloudformation.model.DescribeStacksRequest;
import com.amazonaws.services.cloudformation.model.ExecuteChangeSetRequest;
import com.amazonaws.services.cloudformation.model.ExecuteChangeSetResult;
import com.amazonaws.services.cloudformation.model.Stack;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.spinnaker.clouddriver.aws.deploy.description.ExecuteCloudFormationChangeSetDescription;
import com.netflix.spinnaker.clouddriver.aws.security.AmazonClientProvider;
import com.netflix.spinnaker.clouddriver.data.task.Task;
import com.netflix.spinnaker.clouddriver.data.task.TaskRepository;
import com.netflix.spinnaker.clouddriver.orchestration.AtomicOperation;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class ExecuteCloudFormationChangeSetAtomicOperation
implements AtomicOperation<Map> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ExecuteCloudFormationChangeSetAtomicOperation.class);
    private static final String BASE_PHASE = "EXECUTE_CLOUDFORMATION_CHANGESET";
    @Autowired
    AmazonClientProvider amazonClientProvider;
    @Autowired
    @Qualifier(value="amazonObjectMapper")
    private ObjectMapper objectMapper;
    private ExecuteCloudFormationChangeSetDescription description;

    public ExecuteCloudFormationChangeSetAtomicOperation(ExecuteCloudFormationChangeSetDescription executeCloudFormationChangeSetDescription) {
        this.description = executeCloudFormationChangeSetDescription;
    }

    public Map operate(List priorOutputs) {
        Task task = (Task)TaskRepository.threadLocalTask.get();
        task.updateStatus(BASE_PHASE, "Configuring CloudFormation Stack");
        AmazonCloudFormation amazonCloudFormation = this.amazonClientProvider.getAmazonCloudFormation(this.description.getCredentials(), this.description.getRegion());
        String stackName = this.description.getStackName();
        String changeSetName = this.description.getChangeSetName();
        ExecuteChangeSetRequest executeChangeSetRequest = new ExecuteChangeSetRequest().withStackName(this.description.getStackName()).withChangeSetName(this.description.getChangeSetName());
        task.updateStatus(BASE_PHASE, "Executing CloudFormation ChangeSet");
        try {
            ExecuteChangeSetResult executeChangeSetResult = amazonCloudFormation.executeChangeSet(executeChangeSetRequest);
            return Collections.singletonMap("stackId", this.getStackId(amazonCloudFormation));
        }
        catch (AmazonCloudFormationException e) {
            log.error("Error executing change set", (Throwable)e);
            throw e;
        }
    }

    private String getStackId(AmazonCloudFormation amazonCloudFormation) {
        return ((Stack)amazonCloudFormation.describeStacks(new DescribeStacksRequest().withStackName(this.description.getStackName())).getStacks().stream().findFirst().orElseThrow(() -> new IllegalArgumentException("No CloudFormation Stack found with stack name " + this.description.getStackName()))).getStackId();
    }
}

