/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.aws.provider.agent;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.spinnaker.cats.agent.AgentDataType;
import com.netflix.spinnaker.cats.agent.CacheResult;
import com.netflix.spinnaker.cats.agent.CachingAgent;
import com.netflix.spinnaker.cats.agent.DefaultCacheResult;
import com.netflix.spinnaker.cats.cache.CacheData;
import com.netflix.spinnaker.cats.cache.CacheFilter;
import com.netflix.spinnaker.cats.cache.DefaultCacheData;
import com.netflix.spinnaker.cats.cache.RelationshipCacheFilter;
import com.netflix.spinnaker.cats.provider.ProviderCache;
import com.netflix.spinnaker.clouddriver.aws.cache.Keys;
import com.netflix.spinnaker.clouddriver.aws.provider.AwsInfrastructureProvider;
import com.netflix.spinnaker.clouddriver.aws.security.NetflixAmazonCredentials;
import com.netflix.spinnaker.clouddriver.security.AccountCredentials;
import com.netflix.spinnaker.credentials.CredentialsRepository;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;

public class AmazonInstanceTypeCachingAgent
implements CachingAgent {
    private static final TypeReference<Map<String, Object>> ATTRIBUTES = new TypeReference<Map<String, Object>>(){};
    private final String region;
    private final CredentialsRepository<NetflixAmazonCredentials> credentialsRepository;
    private final URI pricingUri;
    private final HttpHost pricingHost;
    private final HttpClient httpClient;
    private final ObjectMapper objectMapper = new ObjectMapper().disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);

    public AmazonInstanceTypeCachingAgent(String region, CredentialsRepository<NetflixAmazonCredentials> credentialsRepository) {
        this(region, credentialsRepository, (HttpClient)HttpClients.createDefault());
    }

    AmazonInstanceTypeCachingAgent(String region, CredentialsRepository<NetflixAmazonCredentials> credentialsRepository, HttpClient httpClient) {
        this.region = region;
        this.credentialsRepository = credentialsRepository;
        this.pricingHost = region.startsWith("cn-") ? HttpHost.create((String)"https://pricing.cn-north-1.amazonaws.com.cn") : HttpHost.create((String)"https://pricing.us-east-1.amazonaws.com");
        this.pricingUri = URI.create("/offers/v1.0/aws/AmazonEC2/current/" + region + "/index.json");
        this.httpClient = httpClient;
    }

    public Collection<AgentDataType> getProvidedDataTypes() {
        return Collections.unmodifiableList(Arrays.asList(AgentDataType.Authority.AUTHORITATIVE.forType(Keys.Namespace.INSTANCE_TYPES.getNs()), AgentDataType.Authority.AUTHORITATIVE.forType(this.getAgentType())));
    }

    public CacheResult loadData(ProviderCache providerCache) {
        try {
            Optional<String> etag;
            Set matchingAccounts = this.credentialsRepository.getAll().stream().filter(ac -> ac.getRegions().stream().anyMatch(r -> this.region.equals(r.getName()))).map(AccountCredentials::getName).collect(Collectors.toSet());
            if (matchingAccounts.isEmpty()) {
                return new DefaultCacheResult(Collections.emptyMap());
            }
            CacheData metadata = providerCache.get(this.getAgentType(), "metadata", (CacheFilter)RelationshipCacheFilter.none());
            MetadataAttributes metadataAttributes = null;
            if (metadata != null) {
                metadataAttributes = (MetadataAttributes)this.objectMapper.convertValue((Object)metadata.getAttributes(), MetadataAttributes.class);
            }
            Set<String> instanceTypes = null;
            if (metadataAttributes != null && metadataAttributes.etag != null && metadataAttributes.cachedInstanceTypes != null) {
                HttpResponse headResponse = this.httpClient.execute(this.pricingHost, (HttpRequest)new HttpHead(this.pricingUri));
                EntityUtils.consumeQuietly((HttpEntity)headResponse.getEntity());
                if (headResponse.getStatusLine().getStatusCode() != 200) {
                    throw new Exception("failed to read instance type metadata for " + this.region + ": " + headResponse.getStatusLine().toString());
                }
                etag = this.getEtagHeader(headResponse);
                if (etag.filter(metadataAttributes.etag::equals).isPresent()) {
                    instanceTypes = metadataAttributes.cachedInstanceTypes;
                }
            }
            if (instanceTypes == null) {
                HttpResponse getResponse = this.httpClient.execute(this.pricingHost, (HttpRequest)new HttpGet(this.pricingUri));
                if (getResponse.getStatusLine().getStatusCode() != 200) {
                    EntityUtils.consumeQuietly((HttpEntity)getResponse.getEntity());
                    throw new Exception("failed to read instance type data for " + this.region + ": " + getResponse.getStatusLine().toString());
                }
                etag = this.getEtagHeader(getResponse);
                HttpEntity entity = getResponse.getEntity();
                instanceTypes = this.fromStream(entity.getContent());
                EntityUtils.consumeQuietly((HttpEntity)entity);
                if (etag.isPresent()) {
                    metadataAttributes = new MetadataAttributes();
                    metadataAttributes.etag = etag.get();
                    metadataAttributes.cachedInstanceTypes = new HashSet<String>(instanceTypes);
                    metadata = new DefaultCacheData("metadata", (Map)this.objectMapper.convertValue((Object)metadataAttributes, ATTRIBUTES), Collections.emptyMap());
                } else {
                    metadata = null;
                }
            }
            HashMap<String, Set<String>> evictions = new HashMap<String, Set<String>>();
            HashMap<String, Collection<Object>> cacheResults = new HashMap<String, Collection<Object>>();
            ArrayList<DefaultCacheData> instanceTypeData = new ArrayList<DefaultCacheData>();
            cacheResults.put(Keys.Namespace.INSTANCE_TYPES.getNs(), instanceTypeData);
            if (metadata != null) {
                cacheResults.put(this.getAgentType(), Collections.singleton(metadata));
            } else {
                evictions.put(this.getAgentType(), Collections.singleton("metadata"));
            }
            for (String instanceType : instanceTypes) {
                for (String account : matchingAccounts) {
                    HashMap<String, String> instanceTypeAttributes = new HashMap<String, String>();
                    instanceTypeAttributes.put("account", account);
                    instanceTypeAttributes.put("region", this.region);
                    instanceTypeAttributes.put("name", instanceType);
                    instanceTypeData.add(new DefaultCacheData(Keys.getInstanceTypeKey(instanceType, this.region, account), instanceTypeAttributes, Collections.emptyMap()));
                }
            }
            return new DefaultCacheResult(cacheResults, evictions);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    Optional<String> getEtagHeader(HttpResponse response) {
        return Optional.ofNullable(response).map(r -> r.getFirstHeader("ETag")).map(Header::getElements).filter(e -> ((HeaderElement[])e).length > 0).map(e -> e[0].getName());
    }

    public String getAgentType() {
        return this.getClass().getSimpleName() + "/" + this.region;
    }

    public String getProviderName() {
        return AwsInfrastructureProvider.PROVIDER_NAME;
    }

    Set<String> fromStream(InputStream is) throws IOException {
        Offerings offerings = (Offerings)this.objectMapper.readValue(is, Offerings.class);
        Set<String> instanceTypes = offerings.products.values().stream().filter(o -> o.productFamily != null && o.productFamily.startsWith("Compute Instance")).map(o -> o.attributes.instanceType).filter(it -> it != null && !it.isEmpty()).collect(Collectors.toSet());
        return instanceTypes;
    }

    static class MetadataAttributes {
        public String etag;
        public Set<String> cachedInstanceTypes;

        MetadataAttributes() {
        }
    }

    static class Offerings {
        public Map<String, Offering> products;

        Offerings() {
        }
    }

    static class ComputeInstanceAttributes {
        public String instanceType;

        ComputeInstanceAttributes() {
        }

        public String toString() {
            return this.instanceType;
        }
    }

    static class Offering {
        public String productFamily;
        public ComputeInstanceAttributes attributes;

        Offering() {
        }
    }
}

