/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.aws.security;

import com.github.wnameless.json.unflattener.JsonUnflattener;
import com.netflix.spinnaker.clouddriver.aws.security.config.AccountsConfiguration;
import com.netflix.spinnaker.clouddriver.config.AbstractBootstrapCredentialsConfigurationProvider;
import com.netflix.spinnaker.kork.configserver.CloudConfigResourceService;
import com.netflix.spinnaker.kork.secrets.SecretManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.bind.BindResult;
import org.springframework.context.ConfigurableApplicationContext;

public class CustomAccountsConfigurationProvider
extends AbstractBootstrapCredentialsConfigurationProvider {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CustomAccountsConfigurationProvider.class);
    private final String FIRST_ACCOUNT_NAME_KEY = "aws.accounts[0].name";

    public CustomAccountsConfigurationProvider(ConfigurableApplicationContext applicationContext, CloudConfigResourceService configResourceService, SecretManager secretManager) {
        super(applicationContext, configResourceService, secretManager);
    }

    public AccountsConfiguration getConfigurationProperties() {
        return this.getAccounts(this.getPropertiesMap("aws.accounts[0].name"));
    }

    private AccountsConfiguration getAccounts(Map<String, Object> credentialsPropertiesMap) {
        log.info("Started loading aws accounts from the configuration file");
        AccountsConfiguration accountConfig = new AccountsConfiguration();
        Map propertiesMap = (Map)JsonUnflattener.unflattenAsMap(credentialsPropertiesMap).get("aws");
        ArrayList<AccountsConfiguration.Account> accounts = new ArrayList<AccountsConfiguration.Account>();
        for (Map unflattendAcc : (List)propertiesMap.get("accounts")) {
            BindResult result = this.bind(this.getFlatMap(unflattendAcc), AccountsConfiguration.Account.class);
            accounts.add((AccountsConfiguration.Account)result.get());
        }
        accountConfig.setAccounts(accounts);
        log.info("Finished loading aws accounts");
        return accountConfig;
    }
}

