/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.aws.security;

import com.netflix.spinnaker.clouddriver.aws.security.AWSAccountInfoLookup;
import com.netflix.spinnaker.clouddriver.aws.security.AmazonCredentials;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

public class StaticAWSAccountInfoLookup
implements AWSAccountInfoLookup {
    private final String accountId;
    private final List<AmazonCredentials.AWSRegion> knownRegions;

    public StaticAWSAccountInfoLookup(String accountId, List<AmazonCredentials.AWSRegion> knownRegions) {
        this.accountId = accountId;
        this.knownRegions = knownRegions;
    }

    @Override
    public String findAccountId() {
        return this.accountId;
    }

    @Override
    public List<AmazonCredentials.AWSRegion> listRegions(String ... regionNames) {
        return this.listRegions(Arrays.asList(regionNames));
    }

    @Override
    public List<AmazonCredentials.AWSRegion> listRegions(Collection<String> regionNames) {
        HashSet<String> nameSet = new HashSet<String>(regionNames);
        ArrayList<AmazonCredentials.AWSRegion> result = new ArrayList<AmazonCredentials.AWSRegion>(nameSet.size());
        for (AmazonCredentials.AWSRegion region : this.knownRegions) {
            if (!nameSet.isEmpty() && !nameSet.contains(region.getName())) continue;
            result.add(region);
        }
        return result;
    }

    @Override
    public List<String> listAvailabilityZones(String regionName) {
        for (AmazonCredentials.AWSRegion region : this.knownRegions) {
            if (!region.getName().equals(regionName)) continue;
            return new ArrayList<String>(region.getAvailabilityZones());
        }
        return null;
    }
}

