/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.aws.security.sdkclient;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.RateLimiter;
import com.netflix.spectator.api.Registry;
import com.netflix.spinnaker.clouddriver.aws.security.sdkclient.LoadingCacheMetrics;
import com.netflix.spinnaker.clouddriver.core.limits.ServiceLimitConfiguration;
import java.util.Objects;
import java.util.concurrent.ExecutionException;

public class RateLimiterSupplier {
    private final LoadingCache<RateLimitKey, RateLimiter> rateLimiters;

    public RateLimiterSupplier(ServiceLimitConfiguration serviceLimitConfiguration, Registry registry) {
        this.rateLimiters = CacheBuilder.newBuilder().recordStats().build((CacheLoader)new RateLimitCacheLoader(serviceLimitConfiguration));
        LoadingCacheMetrics.instrument("rateLimiterSupplier", registry, this.rateLimiters);
    }

    public RateLimiter getRateLimiter(Class<?> implementation, String account, String region) {
        try {
            return (RateLimiter)this.rateLimiters.get((Object)new RateLimitKey(implementation, account, region));
        }
        catch (ExecutionException executionException) {
            if (executionException.getCause() instanceof RuntimeException) {
                throw (RuntimeException)executionException.getCause();
            }
            throw new RuntimeException("Failed creating rate limiter", executionException.getCause());
        }
    }

    private static class RateLimitKey {
        private final Class<?> implementationClass;
        private final String account;
        private final String region;

        public RateLimitKey(Class<?> implementationClass, String account, String region) {
            this.implementationClass = Objects.requireNonNull(implementationClass);
            this.account = Objects.requireNonNull(account);
            this.region = region;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RateLimitKey that = (RateLimitKey)o;
            if (!this.implementationClass.equals(that.implementationClass)) {
                return false;
            }
            if (!this.account.equals(that.account)) {
                return false;
            }
            return this.region != null ? this.region.equals(that.region) : that.region == null;
        }

        public int hashCode() {
            int result = this.implementationClass.hashCode();
            result = 31 * result + this.account.hashCode();
            result = 31 * result + (this.region != null ? this.region.hashCode() : 0);
            return result;
        }
    }

    private static class RateLimitCacheLoader
    extends CacheLoader<RateLimitKey, RateLimiter> {
        private static final double DEFAULT_LIMIT = 10.0;
        private final ServiceLimitConfiguration serviceLimitConfiguration;
        private final double defaultLimit;

        public RateLimitCacheLoader(ServiceLimitConfiguration serviceLimitConfiguration) {
            this(serviceLimitConfiguration, 10.0);
        }

        public RateLimitCacheLoader(ServiceLimitConfiguration serviceLimitConfiguration, double defaultLimit) {
            this.serviceLimitConfiguration = Objects.requireNonNull(serviceLimitConfiguration);
            this.defaultLimit = defaultLimit;
        }

        public RateLimiter load(RateLimitKey key) throws Exception {
            double rateLimit = this.serviceLimitConfiguration.getLimit("rateLimit", key.implementationClass.getSimpleName(), key.account, "aws", Double.valueOf(this.defaultLimit));
            return RateLimiter.create((double)rateLimit);
        }
    }
}

