/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.aws.deploy.converters;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.netflix.spinnaker.clouddriver.aws.AmazonOperation;
import com.netflix.spinnaker.clouddriver.aws.deploy.description.DeployCloudFormationDescription;
import com.netflix.spinnaker.clouddriver.aws.deploy.ops.DeployCloudFormationAtomicOperation;
import com.netflix.spinnaker.clouddriver.aws.security.NetflixAmazonCredentials;
import com.netflix.spinnaker.clouddriver.orchestration.AtomicOperation;
import com.netflix.spinnaker.clouddriver.security.AbstractAtomicOperationsCredentialsSupport;
import java.util.Map;
import org.springframework.stereotype.Component;

@AmazonOperation(value="deployCloudFormation")
@Component(value="deployCloudFormationDescription")
public class DeployCloudFormationAtomicOperationConverter
extends AbstractAtomicOperationsCredentialsSupport {
    public AtomicOperation convertOperation(Map input) {
        return new DeployCloudFormationAtomicOperation(this.convertDescription(input));
    }

    public DeployCloudFormationDescription convertDescription(Map input) {
        input = this.fixTemplateBody(input);
        DeployCloudFormationDescription converted = (DeployCloudFormationDescription)this.getObjectMapper().convertValue((Object)input, DeployCloudFormationDescription.class);
        converted.setCredentials((NetflixAmazonCredentials)this.getCredentialsObject((String)input.get("credentials")));
        return converted;
    }

    private Map fixTemplateBody(Map input) {
        if (input.get("templateBody") != null && !(input.get("templateBody") instanceof String)) {
            String template;
            try {
                template = this.getObjectMapper().writeValueAsString(input.get("templateBody"));
            }
            catch (JsonProcessingException e) {
                throw new IllegalArgumentException("Could not serialize CloudFormation Stack template body", e);
            }
            input.put("templateBody", template);
        }
        return input;
    }
}

