/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.aws.deploy.handlers;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.elasticloadbalancingv2.AmazonElasticLoadBalancing;
import com.amazonaws.services.elasticloadbalancingv2.model.Action;
import com.amazonaws.services.elasticloadbalancingv2.model.CreateListenerRequest;
import com.amazonaws.services.elasticloadbalancingv2.model.CreateListenerResult;
import com.amazonaws.services.elasticloadbalancingv2.model.CreateLoadBalancerRequest;
import com.amazonaws.services.elasticloadbalancingv2.model.CreateRuleRequest;
import com.amazonaws.services.elasticloadbalancingv2.model.CreateTargetGroupRequest;
import com.amazonaws.services.elasticloadbalancingv2.model.CreateTargetGroupResult;
import com.amazonaws.services.elasticloadbalancingv2.model.DeleteListenerRequest;
import com.amazonaws.services.elasticloadbalancingv2.model.DeleteRuleRequest;
import com.amazonaws.services.elasticloadbalancingv2.model.DeleteTargetGroupRequest;
import com.amazonaws.services.elasticloadbalancingv2.model.DescribeListenersRequest;
import com.amazonaws.services.elasticloadbalancingv2.model.DescribeLoadBalancerAttributesRequest;
import com.amazonaws.services.elasticloadbalancingv2.model.DescribeRulesRequest;
import com.amazonaws.services.elasticloadbalancingv2.model.DescribeTargetGroupsRequest;
import com.amazonaws.services.elasticloadbalancingv2.model.HttpRequestMethodConditionConfig;
import com.amazonaws.services.elasticloadbalancingv2.model.Listener;
import com.amazonaws.services.elasticloadbalancingv2.model.ListenerNotFoundException;
import com.amazonaws.services.elasticloadbalancingv2.model.LoadBalancer;
import com.amazonaws.services.elasticloadbalancingv2.model.LoadBalancerAttribute;
import com.amazonaws.services.elasticloadbalancingv2.model.LoadBalancerTypeEnum;
import com.amazonaws.services.elasticloadbalancingv2.model.Matcher;
import com.amazonaws.services.elasticloadbalancingv2.model.ModifyListenerRequest;
import com.amazonaws.services.elasticloadbalancingv2.model.ModifyLoadBalancerAttributesRequest;
import com.amazonaws.services.elasticloadbalancingv2.model.ModifyTargetGroupAttributesRequest;
import com.amazonaws.services.elasticloadbalancingv2.model.ModifyTargetGroupRequest;
import com.amazonaws.services.elasticloadbalancingv2.model.ProtocolEnum;
import com.amazonaws.services.elasticloadbalancingv2.model.ResourceInUseException;
import com.amazonaws.services.elasticloadbalancingv2.model.Rule;
import com.amazonaws.services.elasticloadbalancingv2.model.RuleCondition;
import com.amazonaws.services.elasticloadbalancingv2.model.SetIpAddressTypeRequest;
import com.amazonaws.services.elasticloadbalancingv2.model.SetSecurityGroupsRequest;
import com.amazonaws.services.elasticloadbalancingv2.model.TargetGroup;
import com.amazonaws.services.elasticloadbalancingv2.model.TargetGroupAttribute;
import com.amazonaws.services.elasticloadbalancingv2.model.TargetTypeEnum;
import com.netflix.spinnaker.clouddriver.aws.deploy.description.UpsertAmazonLoadBalancerV2Description;
import com.netflix.spinnaker.clouddriver.data.task.Task;
import com.netflix.spinnaker.clouddriver.data.task.TaskRepository;
import com.netflix.spinnaker.clouddriver.orchestration.AtomicOperationException;
import com.netflix.spinnaker.config.AwsConfiguration;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.ArrayUtil;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadBalancerV2UpsertHandler
implements GroovyObject {
    private static final String BASE_PHASE = "UPSERT_ELB_V2";
    private static final String ATTRIBUTE_IDLE_TIMEOUT = "idle_timeout.timeout_seconds";
    private static final String ATTRIBUTE_DELETION_PROTECTION = "deletion_protection.enabled";
    private static final String ATTRIBUTE_LOAD_BALANCING_CROSS_ZONE = "load_balancing.cross_zone.enabled";
    private static final String DEREGISTRATION_DELAY = "300";
    private static final Boolean STICKINESS_ENABLED;
    private static final String STICKINESS_TYPE = "lb_cookie";
    private static final String STICKINESS_DURATION = "86400";
    private static final Boolean PROXY_PROTOCOL_V2;
    private static final Boolean CONNECTION_TERMINATION;
    private static final Boolean MULTI_VALUE_HEADERS_ENABLED;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo$;
    private static /* synthetic */ SoftReference $callSiteArray;

    @Generated
    public LoadBalancerV2UpsertHandler() {
        MetaClass metaClass;
        CallSite[] callSiteArray = LoadBalancerV2UpsertHandler.$getCallSiteArray();
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    private static Task getTask() {
        CallSite[] callSiteArray = LoadBalancerV2UpsertHandler.$getCallSiteArray();
        return (Task)ScriptBytecodeAdapter.castToType((Object)callSiteArray[0].call(callSiteArray[1].callGetProperty(TaskRepository.class)), Task.class);
    }

    public static String createTargetGroupAttributes(AmazonElasticLoadBalancing loadBalancing, LoadBalancer loadBalancer, TargetGroup targetGroup, UpsertAmazonLoadBalancerV2Description.Attributes attributes, AwsConfiguration.DeployDefaults deployDefaults) {
        CallSite[] callSiteArray = LoadBalancerV2UpsertHandler.$getCallSiteArray();
        List targetGroupAttributes = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        Object object = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[2].call((Object)log)) ? callSiteArray[3].call((Object)log, (Object)"Creating target group attributes for targetGroup {}", callSiteArray[4].callGetProperty((Object)targetGroup)) : null;
        if (DefaultTypeTransformation.booleanUnbox((Object)attributes)) {
            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[5].call(callSiteArray[6].call(callSiteArray[7].callGetProperty(TargetTypeEnum.class)), callSiteArray[8].call((Object)targetGroup)))) {
                Object object2 = callSiteArray[9].callGetProperty((Object)attributes);
                Object multiValueHeaderAttribute = DefaultTypeTransformation.booleanUnbox((Object)object2) ? object2 : MULTI_VALUE_HEADERS_ENABLED;
                callSiteArray[10].call((Object)targetGroupAttributes, callSiteArray[11].callConstructor(TargetGroupAttribute.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"key", "lambda.multi_value_headers.enabled", "value", multiValueHeaderAttribute})));
            } else {
                Integer deregistrationDelay = (Integer)ScriptBytecodeAdapter.castToType((Object)callSiteArray[12].call((Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{callSiteArray[13].callGetProperty((Object)attributes), callSiteArray[14].callGetPropertySafe(callSiteArray[15].callGroovyObjectGetPropertySafe((Object)deployDefaults))}), callSiteArray[16].callGetProperty(Closure.class)), Integer.class);
                Object object3 = callSiteArray[17].callSafe((Object)deregistrationDelay);
                Object deregistrationDealyAttribute = DefaultTypeTransformation.booleanUnbox((Object)object3) ? object3 : DEREGISTRATION_DELAY;
                callSiteArray[18].call((Object)targetGroupAttributes, callSiteArray[19].callConstructor(TargetGroupAttribute.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"key", "deregistration_delay.timeout_seconds", "value", deregistrationDealyAttribute})));
            }
            if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[20].callGetProperty((Object)loadBalancer), (Object)"application")) {
                Object object4 = callSiteArray[21].callSafe(callSiteArray[22].callGetProperty((Object)attributes));
                Object stickinessEnabledAttribute = DefaultTypeTransformation.booleanUnbox((Object)object4) ? object4 : STICKINESS_ENABLED;
                callSiteArray[23].call((Object)targetGroupAttributes, callSiteArray[24].callConstructor(TargetGroupAttribute.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"key", "stickiness.enabled", "value", stickinessEnabledAttribute})));
                Object object5 = callSiteArray[25].callGetProperty((Object)attributes);
                Object stickinessTypeAttribute = DefaultTypeTransformation.booleanUnbox((Object)object5) ? object5 : STICKINESS_TYPE;
                callSiteArray[26].call((Object)targetGroupAttributes, callSiteArray[27].callConstructor(TargetGroupAttribute.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"key", "stickiness.type", "value", stickinessTypeAttribute})));
                Object object6 = callSiteArray[28].callSafe(callSiteArray[29].callGetProperty((Object)attributes));
                Object stickinessDurationAttribute = DefaultTypeTransformation.booleanUnbox((Object)object6) ? object6 : STICKINESS_DURATION;
                callSiteArray[30].call((Object)targetGroupAttributes, callSiteArray[31].callConstructor(TargetGroupAttribute.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"key", "stickiness.lb_cookie.duration_seconds", "value", stickinessDurationAttribute})));
            }
            if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[32].callGetProperty((Object)loadBalancer), (Object)"network")) {
                Object object7 = callSiteArray[33].callGetProperty((Object)attributes);
                Object proxyProtocolV2Attribute = DefaultTypeTransformation.booleanUnbox((Object)object7) ? object7 : PROXY_PROTOCOL_V2;
                callSiteArray[34].call((Object)targetGroupAttributes, callSiteArray[35].callConstructor(TargetGroupAttribute.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"key", "proxy_protocol_v2.enabled", "value", proxyProtocolV2Attribute})));
                Object object8 = callSiteArray[36].callGetProperty((Object)attributes);
                Object enableConnectionTermination = DefaultTypeTransformation.booleanUnbox((Object)object8) ? object8 : CONNECTION_TERMINATION;
                callSiteArray[37].call((Object)targetGroupAttributes, callSiteArray[38].callConstructor(TargetGroupAttribute.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"key", "deregistration_delay.connection_termination.enabled", "value", enableConnectionTermination})));
            }
        }
        return ShortTypeHandling.castToString((Object)callSiteArray[39].callStatic(LoadBalancerV2UpsertHandler.class, (Object)loadBalancing, (Object)targetGroup, (Object)targetGroupAttributes));
    }

    private static String modifyTargetGroupAttributes(AmazonElasticLoadBalancing loadBalancing, LoadBalancer loadBalancer, TargetGroup targetGroup, UpsertAmazonLoadBalancerV2Description.Attributes attributes, AwsConfiguration.DeployDefaults deployDefaults) {
        CallSite[] callSiteArray = LoadBalancerV2UpsertHandler.$getCallSiteArray();
        Object object = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[40].call((Object)log)) ? callSiteArray[41].call((Object)log, (Object)"Update target group attributes for targetGroup {}", callSiteArray[42].callGetProperty((Object)targetGroup)) : null;
        List targetGroupAttributes = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        if (DefaultTypeTransformation.booleanUnbox((Object)attributes)) {
            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[43].call(callSiteArray[44].call(callSiteArray[45].callGetProperty(TargetTypeEnum.class)), callSiteArray[46].call((Object)targetGroup)))) {
                if (ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[47].callGetProperty((Object)attributes), null)) {
                    callSiteArray[48].call((Object)targetGroupAttributes, callSiteArray[49].callConstructor(TargetGroupAttribute.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"key", "lambda.multi_value_headers.enabled", "value", callSiteArray[50].callGetProperty((Object)attributes)})));
                }
            } else {
                Integer deregistrationDelay = (Integer)ScriptBytecodeAdapter.castToType((Object)callSiteArray[51].call((Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{callSiteArray[52].callGetProperty((Object)attributes), callSiteArray[53].callGetPropertySafe(callSiteArray[54].callGroovyObjectGetPropertySafe((Object)deployDefaults))}), callSiteArray[55].callGetProperty(Closure.class)), Integer.class);
                if (ScriptBytecodeAdapter.compareNotEqual((Object)deregistrationDelay, null)) {
                    callSiteArray[56].call((Object)targetGroupAttributes, callSiteArray[57].callConstructor(TargetGroupAttribute.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"key", "deregistration_delay.timeout_seconds", "value", callSiteArray[58].call((Object)deregistrationDelay)})));
                }
                if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[59].callGetProperty((Object)loadBalancer), (Object)"application")) {
                    if (ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[60].callGetProperty((Object)attributes), null)) {
                        callSiteArray[61].call((Object)targetGroupAttributes, callSiteArray[62].callConstructor(TargetGroupAttribute.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"key", "stickiness.enabled", "value", callSiteArray[63].call(callSiteArray[64].callGetProperty((Object)attributes))})));
                    }
                    if (ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[65].callGetProperty((Object)attributes), null)) {
                        callSiteArray[66].call((Object)targetGroupAttributes, callSiteArray[67].callConstructor(TargetGroupAttribute.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"key", "stickiness.type", "value", callSiteArray[68].callGetProperty((Object)attributes)})));
                    }
                    if (ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[69].callGetProperty((Object)attributes), null)) {
                        callSiteArray[70].call((Object)targetGroupAttributes, callSiteArray[71].callConstructor(TargetGroupAttribute.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"key", "stickiness.lb_cookie.duration_seconds", "value", callSiteArray[72].call(callSiteArray[73].callGetProperty((Object)attributes))})));
                    }
                }
                if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[74].callGetProperty((Object)loadBalancer), (Object)"network")) {
                    if (ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[75].callGetProperty((Object)attributes), null)) {
                        callSiteArray[76].call((Object)targetGroupAttributes, callSiteArray[77].callConstructor(TargetGroupAttribute.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"key", "proxy_protocol_v2.enabled", "value", callSiteArray[78].callGetProperty((Object)attributes)})));
                    }
                    if (ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[79].callGetProperty((Object)attributes), null)) {
                        callSiteArray[80].call((Object)targetGroupAttributes, callSiteArray[81].callConstructor(TargetGroupAttribute.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"key", "deregistration_delay.connection_termination.enabled", "value", callSiteArray[82].callGetProperty((Object)attributes)})));
                    }
                }
            }
        }
        return ShortTypeHandling.castToString((Object)callSiteArray[83].callStatic(LoadBalancerV2UpsertHandler.class, (Object)loadBalancing, (Object)targetGroup, (Object)targetGroupAttributes));
    }

    public static String updateTargetGroupAttributes(AmazonElasticLoadBalancing loadBalancing, TargetGroup targetGroup, List<TargetGroupAttribute> targetGroupAttributes) {
        CallSite[] callSiteArray = LoadBalancerV2UpsertHandler.$getCallSiteArray();
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[84].call(targetGroupAttributes))) {
            try {
                callSiteArray[85].call((Object)loadBalancing, callSiteArray[86].call(callSiteArray[87].call(callSiteArray[88].callConstructor(ModifyTargetGroupAttributesRequest.class), callSiteArray[89].callGetProperty((Object)targetGroup)), targetGroupAttributes));
                callSiteArray[90].call(callSiteArray[91].callGetProperty(LoadBalancerV2UpsertHandler.class), (Object)BASE_PHASE, (Object)new GStringImpl(new Object[]{callSiteArray[92].callGetProperty((Object)targetGroup)}, new String[]{"Modified target group ", " attributes."}));
            }
            catch (AmazonServiceException e) {
                String string = ShortTypeHandling.castToString((Object)callSiteArray[93].callStatic(LoadBalancerV2UpsertHandler.class, (Object)new GStringImpl(new Object[]{callSiteArray[94].callGetProperty((Object)targetGroup), callSiteArray[95].call((Object)e)}, new String[]{"Failed to modify attributes for target group ", " - reason: ", "."}), (Object)e));
                return string;
            }
        }
        return ShortTypeHandling.castToString(null);
    }

    /*
     * WARNING - void declaration
     */
    public static List<TargetGroup> createTargetGroups(List<UpsertAmazonLoadBalancerV2Description.TargetGroup> targetGroupsToCreate, AmazonElasticLoadBalancing loadBalancing, LoadBalancer loadBalancer, List<String> amazonErrors, AwsConfiguration.DeployDefaults deployDefaults) {
        void var3_3;
        void var2_2;
        Reference loadBalancing2 = new Reference((Object)loadBalancing);
        Reference loadBalancer2 = new Reference((Object)var2_2);
        Reference amazonErrors2 = new Reference((Object)var3_3);
        Reference deployDefaults2 = new Reference((Object)deployDefaults);
        CallSite[] callSiteArray = LoadBalancerV2UpsertHandler.$getCallSiteArray();
        Reference loadBalancerName = new Reference((Object)ShortTypeHandling.castToString((Object)callSiteArray[96].callGetProperty((Object)((LoadBalancer)loadBalancer2.get()))));
        Reference createdTargetGroups = new Reference((Object)((List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[97].callConstructor(ArrayList.class), List.class)));
        public final class _createTargetGroups_closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference loadBalancerName;
            private /* synthetic */ Reference loadBalancer;
            private /* synthetic */ Reference loadBalancing;
            private /* synthetic */ Reference amazonErrors;
            private /* synthetic */ Reference createdTargetGroups;
            private /* synthetic */ Reference deployDefaults;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _createTargetGroups_closure1(Object _outerInstance, Object _thisObject, Reference loadBalancerName, Reference loadBalancer, Reference loadBalancing, Reference amazonErrors, Reference createdTargetGroups, Reference deployDefaults) {
                Reference reference;
                Reference reference2;
                Reference reference3;
                Reference reference4;
                Reference reference5;
                Reference reference6;
                CallSite[] callSiteArray = _createTargetGroups_closure1.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.loadBalancerName = reference6 = loadBalancerName;
                this.loadBalancer = reference5 = loadBalancer;
                this.loadBalancing = reference4 = loadBalancing;
                this.amazonErrors = reference3 = amazonErrors;
                this.createdTargetGroups = reference2 = createdTargetGroups;
                this.deployDefaults = reference = deployDefaults;
            }

            public Object doCall(Object targetGroup) {
                CallSite[] callSiteArray = _createTargetGroups_closure1.$getCallSiteArray();
                TargetGroup createdTargetGroup = null;
                try {
                    String status = ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.loadBalancerName.get(), callSiteArray[0].callGetProperty(targetGroup), callSiteArray[1].callGetProperty(targetGroup), callSiteArray[2].callGetProperty(targetGroup)}, new String[]{"Target group created in ", " (", ":", ":", ")."}));
                    CreateTargetGroupRequest createTargetGroupRequest = (CreateTargetGroupRequest)ScriptBytecodeAdapter.castToType((Object)callSiteArray[3].callConstructor(CreateTargetGroupRequest.class), CreateTargetGroupRequest.class);
                    if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[4].call(callSiteArray[5].call(callSiteArray[6].callGetProperty(TargetTypeEnum.class)), callSiteArray[7].callGetProperty(targetGroup)))) {
                        callSiteArray[8].call(callSiteArray[9].call(callSiteArray[10].call(callSiteArray[11].call(callSiteArray[12].call(callSiteArray[13].call(callSiteArray[14].call(callSiteArray[15].call((Object)createTargetGroupRequest, callSiteArray[16].callGetProperty(targetGroup)), callSiteArray[17].callGetProperty(targetGroup)), callSiteArray[18].callGetProperty(targetGroup)), callSiteArray[19].callGetProperty(targetGroup)), callSiteArray[20].callGetProperty(targetGroup)), callSiteArray[21].callGetProperty(targetGroup)), callSiteArray[22].call(callSiteArray[23].callConstructor(Matcher.class), callSiteArray[24].callGetProperty(targetGroup))), callSiteArray[25].callGetProperty(targetGroup));
                        GStringImpl gStringImpl = new GStringImpl(new Object[]{this.loadBalancerName.get(), callSiteArray[26].callGetProperty(targetGroup)}, new String[]{"Lambda Target group created in ", " (", ")."});
                        status = ShortTypeHandling.castToString((Object)gStringImpl);
                    } else {
                        callSiteArray[27].call(callSiteArray[28].call(callSiteArray[29].call(callSiteArray[30].call(callSiteArray[31].call(callSiteArray[32].call(callSiteArray[33].call(callSiteArray[34].call(callSiteArray[35].call(callSiteArray[36].call((Object)createTargetGroupRequest, callSiteArray[37].callGetProperty(targetGroup)), callSiteArray[38].callGetProperty(targetGroup)), callSiteArray[39].callGetProperty(targetGroup)), callSiteArray[40].callGetProperty(this.loadBalancer.get())), callSiteArray[41].callGetProperty(targetGroup)), callSiteArray[42].callGetProperty(targetGroup)), callSiteArray[43].callGetProperty(targetGroup)), callSiteArray[44].callGetProperty(targetGroup)), callSiteArray[45].callGetProperty(targetGroup)), callSiteArray[46].callGetProperty(targetGroup));
                        if (ScriptBytecodeAdapter.isCase((Object)callSiteArray[47].callGetProperty(targetGroup), (Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{callSiteArray[48].callGetProperty(ProtocolEnum.class), callSiteArray[49].callGetProperty(ProtocolEnum.class)}))) {
                            callSiteArray[50].call((Object)createTargetGroupRequest, callSiteArray[51].callGetProperty(targetGroup));
                            if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[52].callGetProperty(targetGroup), (Object)callSiteArray[53].callGetProperty(ProtocolEnum.class))) {
                                callSiteArray[54].call((Object)createTargetGroupRequest, callSiteArray[55].call((Object)createTargetGroupRequest));
                            } else {
                                callSiteArray[56].call(callSiteArray[57].call((Object)createTargetGroupRequest, callSiteArray[58].call(callSiteArray[59].callConstructor(Matcher.class), callSiteArray[60].callGetProperty(targetGroup))), callSiteArray[61].callGetProperty(targetGroup));
                            }
                        }
                    }
                    CreateTargetGroupResult createTargetGroupResult = (CreateTargetGroupResult)ScriptBytecodeAdapter.castToType((Object)callSiteArray[62].call(this.loadBalancing.get(), (Object)createTargetGroupRequest), CreateTargetGroupResult.class);
                    callSiteArray[63].call(callSiteArray[64].callGroovyObjectGetProperty((Object)this), ScriptBytecodeAdapter.getField(_createTargetGroups_closure1.class, LoadBalancerV2UpsertHandler.class, (String)"BASE_PHASE"), (Object)status);
                    Object object = callSiteArray[65].call(callSiteArray[66].call((Object)createTargetGroupResult), (Object)0);
                    createdTargetGroup = (TargetGroup)ScriptBytecodeAdapter.castToType((Object)object, TargetGroup.class);
                }
                catch (AmazonServiceException e) {
                    callSiteArray[67].call(this.amazonErrors.get(), callSiteArray[68].callStatic(LoadBalancerV2UpsertHandler.class, (Object)new GStringImpl(new Object[]{callSiteArray[69].callGetProperty(targetGroup), this.loadBalancerName.get(), callSiteArray[70].call((Object)e)}, new String[]{"Failed to create target group ", " for ", " - reason: ", "."}), (Object)e));
                }
                if (ScriptBytecodeAdapter.compareNotEqual(createdTargetGroup, null)) {
                    callSiteArray[71].call(this.createdTargetGroups.get(), createdTargetGroup);
                    String exceptionMessage = ShortTypeHandling.castToString((Object)callSiteArray[72].callStatic(LoadBalancerV2UpsertHandler.class, ArrayUtil.createArray((Object)this.loadBalancing.get(), (Object)this.loadBalancer.get(), createdTargetGroup, (Object)callSiteArray[73].callGetProperty(targetGroup), (Object)this.deployDefaults.get())));
                    if (DefaultTypeTransformation.booleanUnbox((Object)exceptionMessage)) {
                        return callSiteArray[74].call(this.amazonErrors.get(), (Object)exceptionMessage);
                    }
                    return null;
                }
                return null;
            }

            @Generated
            public String getLoadBalancerName() {
                CallSite[] callSiteArray = _createTargetGroups_closure1.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.loadBalancerName.get());
            }

            @Generated
            public LoadBalancer getLoadBalancer() {
                CallSite[] callSiteArray = _createTargetGroups_closure1.$getCallSiteArray();
                return (LoadBalancer)ScriptBytecodeAdapter.castToType((Object)this.loadBalancer.get(), LoadBalancer.class);
            }

            @Generated
            public AmazonElasticLoadBalancing getLoadBalancing() {
                CallSite[] callSiteArray = _createTargetGroups_closure1.$getCallSiteArray();
                return (AmazonElasticLoadBalancing)ScriptBytecodeAdapter.castToType((Object)this.loadBalancing.get(), AmazonElasticLoadBalancing.class);
            }

            @Generated
            public List getAmazonErrors() {
                CallSite[] callSiteArray = _createTargetGroups_closure1.$getCallSiteArray();
                return (List)ScriptBytecodeAdapter.castToType((Object)this.amazonErrors.get(), List.class);
            }

            @Generated
            public List getCreatedTargetGroups() {
                CallSite[] callSiteArray = _createTargetGroups_closure1.$getCallSiteArray();
                return (List)ScriptBytecodeAdapter.castToType((Object)this.createdTargetGroups.get(), List.class);
            }

            @Generated
            public AwsConfiguration.DeployDefaults getDeployDefaults() {
                CallSite[] callSiteArray = _createTargetGroups_closure1.$getCallSiteArray();
                return (AwsConfiguration.DeployDefaults)ScriptBytecodeAdapter.castToType((Object)this.deployDefaults.get(), AwsConfiguration.DeployDefaults.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _createTargetGroups_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "name";
                stringArray[1] = "port";
                stringArray[2] = "protocol";
                stringArray[3] = "<$constructor$>";
                stringArray[4] = "equalsIgnoreCase";
                stringArray[5] = "toString";
                stringArray[6] = "Lambda";
                stringArray[7] = "targetType";
                stringArray[8] = "withHealthCheckPath";
                stringArray[9] = "withMatcher";
                stringArray[10] = "withTargetType";
                stringArray[11] = "withUnhealthyThresholdCount";
                stringArray[12] = "withHealthyThresholdCount";
                stringArray[13] = "withHealthCheckTimeoutSeconds";
                stringArray[14] = "withHealthCheckIntervalSeconds";
                stringArray[15] = "withName";
                stringArray[16] = "name";
                stringArray[17] = "healthCheckInterval";
                stringArray[18] = "healthCheckTimeout";
                stringArray[19] = "healthyThreshold";
                stringArray[20] = "unhealthyThreshold";
                stringArray[21] = "targetType";
                stringArray[22] = "withHttpCode";
                stringArray[23] = "<$constructor$>";
                stringArray[24] = "healthCheckMatcher";
                stringArray[25] = "healthCheckPath";
                stringArray[26] = "name";
                stringArray[27] = "withTargetType";
                stringArray[28] = "withUnhealthyThresholdCount";
                stringArray[29] = "withHealthyThresholdCount";
                stringArray[30] = "withHealthCheckProtocol";
                stringArray[31] = "withHealthCheckPort";
                stringArray[32] = "withHealthCheckIntervalSeconds";
                stringArray[33] = "withVpcId";
                stringArray[34] = "withName";
                stringArray[35] = "withPort";
                stringArray[36] = "withProtocol";
                stringArray[37] = "protocol";
                stringArray[38] = "port";
                stringArray[39] = "name";
                stringArray[40] = "vpcId";
                stringArray[41] = "healthCheckInterval";
                stringArray[42] = "healthCheckPort";
                stringArray[43] = "healthCheckProtocol";
                stringArray[44] = "healthyThreshold";
                stringArray[45] = "unhealthyThreshold";
                stringArray[46] = "targetType";
                stringArray[47] = "healthCheckProtocol";
                stringArray[48] = "HTTP";
                stringArray[49] = "HTTPS";
                stringArray[50] = "withHealthCheckPath";
                stringArray[51] = "healthCheckPath";
                stringArray[52] = "protocol";
                stringArray[53] = "TCP";
                stringArray[54] = "withUnhealthyThresholdCount";
                stringArray[55] = "getHealthyThresholdCount";
                stringArray[56] = "withHealthCheckTimeoutSeconds";
                stringArray[57] = "withMatcher";
                stringArray[58] = "withHttpCode";
                stringArray[59] = "<$constructor$>";
                stringArray[60] = "healthCheckMatcher";
                stringArray[61] = "healthCheckTimeout";
                stringArray[62] = "createTargetGroup";
                stringArray[63] = "updateStatus";
                stringArray[64] = "task";
                stringArray[65] = "get";
                stringArray[66] = "getTargetGroups";
                stringArray[67] = "leftShift";
                stringArray[68] = "handleError";
                stringArray[69] = "name";
                stringArray[70] = "toString";
                stringArray[71] = "add";
                stringArray[72] = "createTargetGroupAttributes";
                stringArray[73] = "attributes";
                stringArray[74] = "leftShift";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[75];
                _createTargetGroups_closure1.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_createTargetGroups_closure1.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _createTargetGroups_closure1.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[98].call(targetGroupsToCreate, (Object)new _createTargetGroups_closure1(LoadBalancerV2UpsertHandler.class, LoadBalancerV2UpsertHandler.class, loadBalancerName, loadBalancer2, loadBalancing2, amazonErrors2, createdTargetGroups, deployDefaults2));
        return (List)createdTargetGroups.get();
    }

    /*
     * WARNING - void declaration
     */
    public static List<TargetGroup> removeTargetGroups(List<TargetGroup> targetGroupsToRemove, AmazonElasticLoadBalancing loadBalancing, LoadBalancer loadBalancer, List<String> amazonErrors) {
        void var3_3;
        void var2_2;
        Reference loadBalancing2 = new Reference((Object)loadBalancing);
        Reference loadBalancer2 = new Reference((Object)var2_2);
        Reference amazonErrors2 = new Reference((Object)var3_3);
        CallSite[] callSiteArray = LoadBalancerV2UpsertHandler.$getCallSiteArray();
        Reference removedTargetGroups = new Reference((Object)((List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[99].callConstructor(ArrayList.class), List.class)));
        public final class _removeTargetGroups_closure2
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference loadBalancing;
            private /* synthetic */ Reference removedTargetGroups;
            private /* synthetic */ Reference loadBalancer;
            private /* synthetic */ Reference amazonErrors;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _removeTargetGroups_closure2(Object _outerInstance, Object _thisObject, Reference loadBalancing, Reference removedTargetGroups, Reference loadBalancer, Reference amazonErrors) {
                Reference reference;
                Reference reference2;
                Reference reference3;
                Reference reference4;
                CallSite[] callSiteArray = _removeTargetGroups_closure2.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.loadBalancing = reference4 = loadBalancing;
                this.removedTargetGroups = reference3 = removedTargetGroups;
                this.loadBalancer = reference2 = loadBalancer;
                this.amazonErrors = reference = amazonErrors;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _removeTargetGroups_closure2.$getCallSiteArray();
                callSiteArray[0].call(this.loadBalancing.get(), callSiteArray[1].call(callSiteArray[2].callConstructor(DeleteTargetGroupRequest.class), callSiteArray[3].callGetProperty(it)));
                callSiteArray[4].call(this.removedTargetGroups.get(), it);
                Object object = callSiteArray[5].call(callSiteArray[6].callGroovyObjectGetProperty((Object)this), ScriptBytecodeAdapter.getField(_removeTargetGroups_closure2.class, LoadBalancerV2UpsertHandler.class, (String)"BASE_PHASE"), (Object)new GStringImpl(new Object[]{callSiteArray[7].callGetProperty(this.loadBalancer.get()), callSiteArray[8].callGetProperty(it), callSiteArray[9].callGetProperty(it), callSiteArray[10].callGetProperty(it)}, new String[]{"Target group removed from ", " (", ":", ":", ")."}));
                try {
                    return object;
                }
                catch (ResourceInUseException e) {
                    Object object2 = callSiteArray[11].call(this.amazonErrors.get(), callSiteArray[12].callStatic(LoadBalancerV2UpsertHandler.class, (Object)new GStringImpl(new Object[]{callSiteArray[13].callGetProperty(it), callSiteArray[14].callGetProperty(this.loadBalancer.get()), callSiteArray[15].call((Object)e)}, new String[]{"Failed to delete target group ", " from ", " - reason: ", "."}), (Object)e));
                    return object2;
                }
            }

            @Generated
            public AmazonElasticLoadBalancing getLoadBalancing() {
                CallSite[] callSiteArray = _removeTargetGroups_closure2.$getCallSiteArray();
                return (AmazonElasticLoadBalancing)ScriptBytecodeAdapter.castToType((Object)this.loadBalancing.get(), AmazonElasticLoadBalancing.class);
            }

            @Generated
            public List getRemovedTargetGroups() {
                CallSite[] callSiteArray = _removeTargetGroups_closure2.$getCallSiteArray();
                return (List)ScriptBytecodeAdapter.castToType((Object)this.removedTargetGroups.get(), List.class);
            }

            @Generated
            public LoadBalancer getLoadBalancer() {
                CallSite[] callSiteArray = _removeTargetGroups_closure2.$getCallSiteArray();
                return (LoadBalancer)ScriptBytecodeAdapter.castToType((Object)this.loadBalancer.get(), LoadBalancer.class);
            }

            @Generated
            public List getAmazonErrors() {
                CallSite[] callSiteArray = _removeTargetGroups_closure2.$getCallSiteArray();
                return (List)ScriptBytecodeAdapter.castToType((Object)this.amazonErrors.get(), List.class);
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _removeTargetGroups_closure2.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _removeTargetGroups_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "deleteTargetGroup";
                stringArray[1] = "withTargetGroupArn";
                stringArray[2] = "<$constructor$>";
                stringArray[3] = "targetGroupArn";
                stringArray[4] = "push";
                stringArray[5] = "updateStatus";
                stringArray[6] = "task";
                stringArray[7] = "loadBalancerName";
                stringArray[8] = "targetGroupName";
                stringArray[9] = "port";
                stringArray[10] = "protocol";
                stringArray[11] = "leftShift";
                stringArray[12] = "handleError";
                stringArray[13] = "targetGroupName";
                stringArray[14] = "loadBalancerName";
                stringArray[15] = "toString";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[16];
                _removeTargetGroups_closure2.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_removeTargetGroups_closure2.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _removeTargetGroups_closure2.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[100].call(targetGroupsToRemove, (Object)new _removeTargetGroups_closure2(LoadBalancerV2UpsertHandler.class, LoadBalancerV2UpsertHandler.class, loadBalancing2, removedTargetGroups, loadBalancer2, amazonErrors2));
        return (List)removedTargetGroups.get();
    }

    /*
     * WARNING - void declaration
     */
    public static void updateTargetGroups(List<TargetGroup> targetGroupsToUpdate, List<UpsertAmazonLoadBalancerV2Description.TargetGroup> updatedTargetGroups, AmazonElasticLoadBalancing loadBalancing, LoadBalancer loadBalancer, List<String> amazonErrors) {
        void var3_3;
        void var2_2;
        Reference updatedTargetGroups2 = new Reference(updatedTargetGroups);
        Reference loadBalancing2 = new Reference((Object)var2_2);
        Reference loadBalancer2 = new Reference((Object)var3_3);
        Reference amazonErrors2 = new Reference(amazonErrors);
        CallSite[] callSiteArray = LoadBalancerV2UpsertHandler.$getCallSiteArray();
        public final class _updateTargetGroups_closure3
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference updatedTargetGroups;
            private /* synthetic */ Reference loadBalancing;
            private /* synthetic */ Reference loadBalancer;
            private /* synthetic */ Reference amazonErrors;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _updateTargetGroups_closure3(Object _outerInstance, Object _thisObject, Reference updatedTargetGroups, Reference loadBalancing, Reference loadBalancer, Reference amazonErrors) {
                Reference reference;
                Reference reference2;
                Reference reference3;
                Reference reference4;
                CallSite[] callSiteArray = _updateTargetGroups_closure3.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.updatedTargetGroups = reference4 = updatedTargetGroups;
                this.loadBalancing = reference3 = loadBalancing;
                this.loadBalancer = reference2 = loadBalancer;
                this.amazonErrors = reference = amazonErrors;
            }

            public Object doCall(Object awsTargetGroup) {
                Reference awsTargetGroup2 = new Reference(awsTargetGroup);
                CallSite[] callSiteArray = _updateTargetGroups_closure3.$getCallSiteArray();
                public final class _closure23
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference awsTargetGroup;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;
                    private static /* synthetic */ SoftReference $callSiteArray;

                    public _closure23(Object _outerInstance, Object _thisObject, Reference awsTargetGroup) {
                        Reference reference;
                        CallSite[] callSiteArray = _closure23.$getCallSiteArray();
                        super(_outerInstance, _thisObject);
                        this.awsTargetGroup = reference = awsTargetGroup;
                    }

                    public Object doCall(Object it) {
                        CallSite[] callSiteArray = _closure23.$getCallSiteArray();
                        return ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[0].callGetProperty(it), (Object)callSiteArray[1].call(this.awsTargetGroup.get()));
                    }

                    @Generated
                    public Object getAwsTargetGroup() {
                        CallSite[] callSiteArray = _closure23.$getCallSiteArray();
                        return this.awsTargetGroup.get();
                    }

                    @Generated
                    public Object doCall() {
                        CallSite[] callSiteArray = _closure23.$getCallSiteArray();
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure23.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                        stringArray[0] = "name";
                        stringArray[1] = "getTargetGroupName";
                    }

                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                        String[] stringArray = new String[2];
                        _closure23.$createCallSiteArray_1(stringArray);
                        return new CallSiteArray(_closure23.class, stringArray);
                    }

                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                        CallSiteArray callSiteArray;
                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                            callSiteArray = _closure23.$createCallSiteArray();
                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                        }
                        return callSiteArray.array;
                    }
                }
                UpsertAmazonLoadBalancerV2Description.TargetGroup targetGroup = (UpsertAmazonLoadBalancerV2Description.TargetGroup)ScriptBytecodeAdapter.castToType((Object)callSiteArray[0].call(this.updatedTargetGroups.get(), (Object)new _closure23((Object)this, this.getThisObject(), awsTargetGroup2)), UpsertAmazonLoadBalancerV2Description.TargetGroup.class);
                ModifyTargetGroupRequest modifyTargetGroupRequest = (ModifyTargetGroupRequest)ScriptBytecodeAdapter.castToType((Object)callSiteArray[1].call(callSiteArray[2].call(callSiteArray[3].call(callSiteArray[4].call(callSiteArray[5].call(callSiteArray[6].call(callSiteArray[7].callConstructor(ModifyTargetGroupRequest.class), callSiteArray[8].callGetProperty(awsTargetGroup2.get())), callSiteArray[9].callGetProperty((Object)targetGroup)), callSiteArray[10].callGetProperty((Object)targetGroup)), callSiteArray[11].callGetProperty((Object)targetGroup)), callSiteArray[12].callGetProperty((Object)targetGroup)), callSiteArray[13].callGetProperty((Object)targetGroup)), ModifyTargetGroupRequest.class);
                if (ScriptBytecodeAdapter.isCase((Object)callSiteArray[14].callGetProperty((Object)targetGroup), (Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{callSiteArray[15].callGetProperty(ProtocolEnum.class), callSiteArray[16].callGetProperty(ProtocolEnum.class)}))) {
                    callSiteArray[17].call((Object)modifyTargetGroupRequest, callSiteArray[18].callGetProperty((Object)targetGroup));
                    if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[19].callGetProperty((Object)targetGroup), (Object)callSiteArray[20].callGetProperty(ProtocolEnum.class))) {
                        callSiteArray[21].call((Object)modifyTargetGroupRequest, callSiteArray[22].call((Object)modifyTargetGroupRequest));
                    } else {
                        callSiteArray[23].call(callSiteArray[24].call((Object)modifyTargetGroupRequest, callSiteArray[25].call(callSiteArray[26].callConstructor(Matcher.class), callSiteArray[27].callGetProperty((Object)targetGroup))), callSiteArray[28].callGetProperty((Object)targetGroup));
                    }
                }
                callSiteArray[29].call(this.loadBalancing.get(), (Object)modifyTargetGroupRequest);
                callSiteArray[30].call(callSiteArray[31].callGroovyObjectGetProperty((Object)this), ScriptBytecodeAdapter.getField(_updateTargetGroups_closure3.class, LoadBalancerV2UpsertHandler.class, (String)"BASE_PHASE"), (Object)new GStringImpl(new Object[]{callSiteArray[32].callGetProperty(this.loadBalancer.get()), callSiteArray[33].callGetProperty(awsTargetGroup2.get()), callSiteArray[34].callGetProperty(awsTargetGroup2.get()), callSiteArray[35].callGetProperty(awsTargetGroup2.get())}, new String[]{"Target group updated in ", " (", ":", ":", ")."}));
                String exceptionMessage = ShortTypeHandling.castToString((Object)callSiteArray[36].callStatic(LoadBalancerV2UpsertHandler.class, ArrayUtil.createArray((Object)this.loadBalancing.get(), (Object)this.loadBalancer.get(), (Object)awsTargetGroup2.get(), (Object)callSiteArray[37].callGetProperty((Object)targetGroup), null)));
                if (DefaultTypeTransformation.booleanUnbox((Object)exceptionMessage)) {
                    return callSiteArray[38].call(this.amazonErrors.get(), (Object)exceptionMessage);
                }
                return null;
            }

            @Generated
            public List getUpdatedTargetGroups() {
                CallSite[] callSiteArray = _updateTargetGroups_closure3.$getCallSiteArray();
                return (List)ScriptBytecodeAdapter.castToType((Object)this.updatedTargetGroups.get(), List.class);
            }

            @Generated
            public AmazonElasticLoadBalancing getLoadBalancing() {
                CallSite[] callSiteArray = _updateTargetGroups_closure3.$getCallSiteArray();
                return (AmazonElasticLoadBalancing)ScriptBytecodeAdapter.castToType((Object)this.loadBalancing.get(), AmazonElasticLoadBalancing.class);
            }

            @Generated
            public LoadBalancer getLoadBalancer() {
                CallSite[] callSiteArray = _updateTargetGroups_closure3.$getCallSiteArray();
                return (LoadBalancer)ScriptBytecodeAdapter.castToType((Object)this.loadBalancer.get(), LoadBalancer.class);
            }

            @Generated
            public List getAmazonErrors() {
                CallSite[] callSiteArray = _updateTargetGroups_closure3.$getCallSiteArray();
                return (List)ScriptBytecodeAdapter.castToType((Object)this.amazonErrors.get(), List.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _updateTargetGroups_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "find";
                stringArray[1] = "withUnhealthyThresholdCount";
                stringArray[2] = "withHealthyThresholdCount";
                stringArray[3] = "withHealthCheckProtocol";
                stringArray[4] = "withHealthCheckPort";
                stringArray[5] = "withHealthCheckIntervalSeconds";
                stringArray[6] = "withTargetGroupArn";
                stringArray[7] = "<$constructor$>";
                stringArray[8] = "targetGroupArn";
                stringArray[9] = "healthCheckInterval";
                stringArray[10] = "healthCheckPort";
                stringArray[11] = "healthCheckProtocol";
                stringArray[12] = "healthyThreshold";
                stringArray[13] = "unhealthyThreshold";
                stringArray[14] = "healthCheckProtocol";
                stringArray[15] = "HTTP";
                stringArray[16] = "HTTPS";
                stringArray[17] = "withHealthCheckPath";
                stringArray[18] = "healthCheckPath";
                stringArray[19] = "protocol";
                stringArray[20] = "TCP";
                stringArray[21] = "withUnhealthyThresholdCount";
                stringArray[22] = "getHealthyThresholdCount";
                stringArray[23] = "withHealthCheckTimeoutSeconds";
                stringArray[24] = "withMatcher";
                stringArray[25] = "withHttpCode";
                stringArray[26] = "<$constructor$>";
                stringArray[27] = "healthCheckMatcher";
                stringArray[28] = "healthCheckTimeout";
                stringArray[29] = "modifyTargetGroup";
                stringArray[30] = "updateStatus";
                stringArray[31] = "task";
                stringArray[32] = "loadBalancerName";
                stringArray[33] = "targetGroupName";
                stringArray[34] = "port";
                stringArray[35] = "protocol";
                stringArray[36] = "modifyTargetGroupAttributes";
                stringArray[37] = "attributes";
                stringArray[38] = "leftShift";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[39];
                _updateTargetGroups_closure3.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_updateTargetGroups_closure3.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _updateTargetGroups_closure3.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[101].call(targetGroupsToUpdate, (Object)new _updateTargetGroups_closure3(LoadBalancerV2UpsertHandler.class, LoadBalancerV2UpsertHandler.class, updatedTargetGroups2, loadBalancing2, loadBalancer2, amazonErrors2));
    }

    public static boolean createListener(UpsertAmazonLoadBalancerV2Description.Listener listener, List<Action> defaultActions, List<Rule> rules, AmazonElasticLoadBalancing loadBalancing, LoadBalancer loadBalancer, List<String> amazonErrors) {
        block16: {
            public final class _createListener_closure4
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference loadBalancing;
                private /* synthetic */ Reference listenerArn;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;

                public _createListener_closure4(Object _outerInstance, Object _thisObject, Reference loadBalancing, Reference listenerArn) {
                    Reference reference;
                    Reference reference2;
                    CallSite[] callSiteArray = _createListener_closure4.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                    this.loadBalancing = reference2 = loadBalancing;
                    this.listenerArn = reference = listenerArn;
                }

                public Object doCall(Object rule) {
                    CallSite[] callSiteArray = _createListener_closure4.$getCallSiteArray();
                    return callSiteArray[0].call(this.loadBalancing.get(), callSiteArray[1].callConstructor(CreateRuleRequest.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"listenerArn", this.listenerArn.get(), "conditions", callSiteArray[2].callGetProperty(rule), "actions", callSiteArray[3].callGetProperty(rule), "priority", callSiteArray[4].call(Integer.class, callSiteArray[5].callGetProperty(rule))})));
                }

                @Generated
                public AmazonElasticLoadBalancing getLoadBalancing() {
                    CallSite[] callSiteArray = _createListener_closure4.$getCallSiteArray();
                    return (AmazonElasticLoadBalancing)ScriptBytecodeAdapter.castToType((Object)this.loadBalancing.get(), AmazonElasticLoadBalancing.class);
                }

                @Generated
                public String getListenerArn() {
                    CallSite[] callSiteArray = _createListener_closure4.$getCallSiteArray();
                    return ShortTypeHandling.castToString((Object)this.listenerArn.get());
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _createListener_closure4.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                    stringArray[0] = "createRule";
                    stringArray[1] = "<$constructor$>";
                    stringArray[2] = "conditions";
                    stringArray[3] = "actions";
                    stringArray[4] = "valueOf";
                    stringArray[5] = "priority";
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[6];
                    _createListener_closure4.$createCallSiteArray_1(stringArray);
                    return new CallSiteArray(_createListener_closure4.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _createListener_closure4.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            }
            CreateListenerResult result;
            CallSite[] callSiteArray;
            Reference loadBalancing2;
            block17: {
                loadBalancing2 = new Reference((Object)loadBalancing);
                callSiteArray = LoadBalancerV2UpsertHandler.$getCallSiteArray();
                result = null;
                try {
                    Object object = callSiteArray[102].call((Object)((AmazonElasticLoadBalancing)loadBalancing2.get()), callSiteArray[103].call(callSiteArray[104].call(callSiteArray[105].call(callSiteArray[106].call(callSiteArray[107].call(callSiteArray[108].call(callSiteArray[109].callConstructor(CreateListenerRequest.class), callSiteArray[110].callGetProperty((Object)loadBalancer)), callSiteArray[111].callGetProperty((Object)listener)), callSiteArray[112].callGetProperty((Object)listener)), callSiteArray[113].callGetProperty((Object)listener)), callSiteArray[114].callGetProperty((Object)listener)), defaultActions));
                    result = (CreateListenerResult)ScriptBytecodeAdapter.castToType((Object)object, CreateListenerResult.class);
                    callSiteArray[115].call(callSiteArray[116].callGetProperty(LoadBalancerV2UpsertHandler.class), (Object)BASE_PHASE, (Object)new GStringImpl(new Object[]{callSiteArray[117].callGetProperty((Object)loadBalancer), callSiteArray[118].callGetProperty((Object)listener), callSiteArray[119].callGetProperty((Object)listener)}, new String[]{"Listener added to ", " (", ":", ")."}));
                }
                catch (AmazonServiceException e) {
                    callSiteArray[120].call(amazonErrors, callSiteArray[121].callStatic(LoadBalancerV2UpsertHandler.class, (Object)new GStringImpl(new Object[]{callSiteArray[122].callGetProperty((Object)loadBalancer), callSiteArray[123].callGetProperty((Object)listener), callSiteArray[124].callGetProperty((Object)listener), callSiteArray[125].call((Object)e)}, new String[]{"Failed to add listener to ", " (", ":", ") - reason: ", "."}), (Object)e));
                    boolean bl = false;
                    return bl;
                }
                if (BytecodeInterface8.isOrigInt() && BytecodeInterface8.isOrigZ() && !__$stMC && !BytecodeInterface8.disabledStandardMetaClass()) break block17;
                if (!(ScriptBytecodeAdapter.compareNotEqual((Object)result, null) && ScriptBytecodeAdapter.compareGreaterThan((Object)callSiteArray[126].call(callSiteArray[127].callGetProperty((Object)result)), (Object)0))) break block16;
                Reference listenerArn = new Reference((Object)ShortTypeHandling.castToString((Object)callSiteArray[128].callGetProperty(callSiteArray[129].call(callSiteArray[130].callGetProperty((Object)result), (Object)0))));
                try {
                    callSiteArray[131].call(rules, (Object)new _createListener_closure4(LoadBalancerV2UpsertHandler.class, LoadBalancerV2UpsertHandler.class, loadBalancing2, listenerArn));
                    break block16;
                }
                catch (AmazonServiceException e) {
                    callSiteArray[132].call(amazonErrors, callSiteArray[133].callStatic(LoadBalancerV2UpsertHandler.class, (Object)new GStringImpl(new Object[]{callSiteArray[134].callGetProperty((Object)loadBalancer), callSiteArray[135].callGetProperty((Object)listener), callSiteArray[136].callGetProperty((Object)listener), callSiteArray[137].call((Object)e)}, new String[]{"Failed to add rule to listener ", " (", ":", ") reason: ", "."}), (Object)e));
                    boolean bl = false;
                    return bl;
                }
            }
            if (ScriptBytecodeAdapter.compareNotEqual((Object)result, null) && ScriptBytecodeAdapter.compareGreaterThan((Object)callSiteArray[138].call(callSiteArray[139].callGetProperty((Object)result)), (Object)0)) {
                Reference listenerArn = new Reference((Object)ShortTypeHandling.castToString((Object)callSiteArray[140].callGetProperty(callSiteArray[141].call(callSiteArray[142].callGetProperty((Object)result), (Object)0))));
                try {
                    callSiteArray[143].call(rules, (Object)new _createListener_closure4(LoadBalancerV2UpsertHandler.class, LoadBalancerV2UpsertHandler.class, loadBalancing2, listenerArn));
                }
                catch (AmazonServiceException e) {
                    callSiteArray[144].call(amazonErrors, callSiteArray[145].callStatic(LoadBalancerV2UpsertHandler.class, (Object)new GStringImpl(new Object[]{callSiteArray[146].callGetProperty((Object)loadBalancer), callSiteArray[147].callGetProperty((Object)listener), callSiteArray[148].callGetProperty((Object)listener), callSiteArray[149].call((Object)e)}, new String[]{"Failed to add rule to listener ", " (", ":", ") reason: ", "."}), (Object)e));
                    boolean bl = false;
                    return bl;
                }
            }
        }
        return true;
    }

    public static boolean containsAllRules(List<Rule> aRules, List<Rule> bRules) {
        Reference bRules2 = new Reference(bRules);
        CallSite[] callSiteArray = LoadBalancerV2UpsertHandler.$getCallSiteArray();
        public final class _containsAllRules_closure5
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference bRules;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _containsAllRules_closure5(Object _outerInstance, Object _thisObject, Reference bRules) {
                Reference reference;
                CallSite[] callSiteArray = _containsAllRules_closure5.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.bRules = reference = bRules;
            }

            public Object doCall(Object aRule) {
                Reference aRule2 = new Reference(aRule);
                CallSite[] callSiteArray = _containsAllRules_closure5.$getCallSiteArray();
                public final class _closure24
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference aRule;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;
                    private static /* synthetic */ SoftReference $callSiteArray;

                    public _closure24(Object _outerInstance, Object _thisObject, Reference aRule) {
                        Reference reference;
                        CallSite[] callSiteArray = _closure24.$getCallSiteArray();
                        super(_outerInstance, _thisObject);
                        this.aRule = reference = aRule;
                    }

                    public Object doCall(Object bRule) {
                        CallSite[] callSiteArray = _closure24.$getCallSiteArray();
                        if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                            return DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[0].call(callSiteArray[1].callGetProperty(bRule), callSiteArray[2].callGetProperty(this.aRule.get()))) && DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[3].call(callSiteArray[4].callGetProperty(this.aRule.get()), callSiteArray[5].callGetProperty(bRule))) && DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[6].call(callSiteArray[7].callGetProperty(bRule), callSiteArray[8].callGetProperty(this.aRule.get()))) && DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[9].call(callSiteArray[10].callGetProperty(this.aRule.get()), callSiteArray[11].callGetProperty(bRule))) && ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[12].callGetProperty(bRule), (Object)callSiteArray[13].callGetProperty(this.aRule.get()));
                        }
                        return DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[14].call(callSiteArray[15].callGetProperty(bRule), callSiteArray[16].callGetProperty(this.aRule.get()))) && DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[17].call(callSiteArray[18].callGetProperty(this.aRule.get()), callSiteArray[19].callGetProperty(bRule))) && DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[20].call(callSiteArray[21].callGetProperty(bRule), callSiteArray[22].callGetProperty(this.aRule.get()))) && DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[23].call(callSiteArray[24].callGetProperty(this.aRule.get()), callSiteArray[25].callGetProperty(bRule))) && ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[26].callGetProperty(bRule), (Object)callSiteArray[27].callGetProperty(this.aRule.get()));
                    }

                    @Generated
                    public Object getaRule() {
                        CallSite[] callSiteArray = _closure24.$getCallSiteArray();
                        return this.aRule.get();
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure24.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                        stringArray[0] = "containsAll";
                        stringArray[1] = "actions";
                        stringArray[2] = "actions";
                        stringArray[3] = "containsAll";
                        stringArray[4] = "actions";
                        stringArray[5] = "actions";
                        stringArray[6] = "containsAll";
                        stringArray[7] = "conditions";
                        stringArray[8] = "conditions";
                        stringArray[9] = "containsAll";
                        stringArray[10] = "conditions";
                        stringArray[11] = "conditions";
                        stringArray[12] = "priority";
                        stringArray[13] = "priority";
                        stringArray[14] = "containsAll";
                        stringArray[15] = "actions";
                        stringArray[16] = "actions";
                        stringArray[17] = "containsAll";
                        stringArray[18] = "actions";
                        stringArray[19] = "actions";
                        stringArray[20] = "containsAll";
                        stringArray[21] = "conditions";
                        stringArray[22] = "conditions";
                        stringArray[23] = "containsAll";
                        stringArray[24] = "conditions";
                        stringArray[25] = "conditions";
                        stringArray[26] = "priority";
                        stringArray[27] = "priority";
                    }

                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                        String[] stringArray = new String[28];
                        _closure24.$createCallSiteArray_1(stringArray);
                        return new CallSiteArray(_closure24.class, stringArray);
                    }

                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                        CallSiteArray callSiteArray;
                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                            callSiteArray = _closure24.$createCallSiteArray();
                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                        }
                        return callSiteArray.array;
                    }
                }
                boolean foundMatchingRule = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[0].call(this.bRules.get(), (Object)new _closure24((Object)this, this.getThisObject(), aRule2)));
                return !foundMatchingRule;
            }

            @Generated
            public List getbRules() {
                CallSite[] callSiteArray = _containsAllRules_closure5.$getCallSiteArray();
                return (List)ScriptBytecodeAdapter.castToType((Object)this.bRules.get(), List.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _containsAllRules_closure5.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "any";
                return new CallSiteArray(_containsAllRules_closure5.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _containsAllRules_closure5.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        return !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[150].call(aRules, (Object)new _containsAllRules_closure5(LoadBalancerV2UpsertHandler.class, LoadBalancerV2UpsertHandler.class, bRules2)));
    }

    /*
     * WARNING - void declaration
     */
    public static void updateListener(String listenerArn, UpsertAmazonLoadBalancerV2Description.Listener listener, List<Action> defaultActions, List<Rule> existingRules, List<Rule> newRules, AmazonElasticLoadBalancing loadBalancing, List<String> amazonErrors) {
        int n;
        int n2;
        void var1_1;
        Reference listenerArn2 = new Reference((Object)listenerArn);
        Reference listener2 = new Reference((Object)var1_1);
        Reference loadBalancing2 = new Reference((Object)loadBalancing);
        Reference amazonErrors2 = new Reference(amazonErrors);
        CallSite[] callSiteArray = LoadBalancerV2UpsertHandler.$getCallSiteArray();
        try {
            callSiteArray[151].call((Object)((AmazonElasticLoadBalancing)loadBalancing2.get()), callSiteArray[152].call(callSiteArray[153].call(callSiteArray[154].call(callSiteArray[155].call(callSiteArray[156].call(callSiteArray[157].callConstructor(ModifyListenerRequest.class), (Object)((String)listenerArn2.get())), callSiteArray[158].callGetProperty((Object)((UpsertAmazonLoadBalancerV2Description.Listener)listener2.get()))), callSiteArray[159].callGetProperty((Object)((UpsertAmazonLoadBalancerV2Description.Listener)listener2.get()))), callSiteArray[160].callGetProperty((Object)((UpsertAmazonLoadBalancerV2Description.Listener)listener2.get()))), defaultActions));
            callSiteArray[161].call(callSiteArray[162].callGetProperty(LoadBalancerV2UpsertHandler.class), (Object)BASE_PHASE, (Object)new GStringImpl(new Object[]{(String)listenerArn2.get(), callSiteArray[163].callGetProperty((Object)((UpsertAmazonLoadBalancerV2Description.Listener)listener2.get())), callSiteArray[164].callGetProperty((Object)((UpsertAmazonLoadBalancerV2Description.Listener)listener2.get()))}, new String[]{"Listener ", " updated (", ":", ")."}));
        }
        catch (AmazonServiceException e) {
            callSiteArray[165].call((Object)((List)amazonErrors2.get()), callSiteArray[166].callStatic(LoadBalancerV2UpsertHandler.class, (Object)new GStringImpl(new Object[]{(String)listenerArn2.get(), callSiteArray[167].callGetProperty((Object)((UpsertAmazonLoadBalancerV2Description.Listener)listener2.get())), callSiteArray[168].callGetProperty((Object)((UpsertAmazonLoadBalancerV2Description.Listener)listener2.get())), callSiteArray[169].call((Object)e)}, new String[]{"Failed to modify listener ", " (", ":", ") - reason: ", "."}), (Object)e));
        }
        int rulesSame = 0;
        rulesSame = !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass() ? (n2 = ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[170].call(existingRules), (Object)callSiteArray[171].call(newRules)) && DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[172].callStatic(LoadBalancerV2UpsertHandler.class, existingRules, newRules)) && DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[173].callStatic(LoadBalancerV2UpsertHandler.class, newRules, existingRules)) ? 1 : 0) : (n = ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[174].call(existingRules), (Object)callSiteArray[175].call(newRules)) && DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[176].callStatic(LoadBalancerV2UpsertHandler.class, existingRules, newRules)) && DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[177].callStatic(LoadBalancerV2UpsertHandler.class, newRules, existingRules)) ? 1 : 0);
        if (rulesSame == 0) {
            public final class _updateListener_closure6
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference loadBalancing;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;

                public _updateListener_closure6(Object _outerInstance, Object _thisObject, Reference loadBalancing) {
                    Reference reference;
                    CallSite[] callSiteArray = _updateListener_closure6.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                    this.loadBalancing = reference = loadBalancing;
                }

                public Object doCall(Object rule) {
                    CallSite[] callSiteArray = _updateListener_closure6.$getCallSiteArray();
                    Object object = callSiteArray[0].call(this.loadBalancing.get(), callSiteArray[1].callConstructor(DeleteRuleRequest.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"ruleArn", callSiteArray[2].callGetProperty(rule)})));
                    try {
                        return object;
                    }
                    catch (AmazonServiceException ignore) {
                        Object var5_5 = null;
                        return var5_5;
                    }
                }

                @Generated
                public AmazonElasticLoadBalancing getLoadBalancing() {
                    CallSite[] callSiteArray = _updateListener_closure6.$getCallSiteArray();
                    return (AmazonElasticLoadBalancing)ScriptBytecodeAdapter.castToType((Object)this.loadBalancing.get(), AmazonElasticLoadBalancing.class);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _updateListener_closure6.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                    stringArray[0] = "deleteRule";
                    stringArray[1] = "<$constructor$>";
                    stringArray[2] = "ruleArn";
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[3];
                    _updateListener_closure6.$createCallSiteArray_1(stringArray);
                    return new CallSiteArray(_updateListener_closure6.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _updateListener_closure6.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            }
            callSiteArray[178].call(existingRules, (Object)new _updateListener_closure6(LoadBalancerV2UpsertHandler.class, LoadBalancerV2UpsertHandler.class, loadBalancing2));
            public final class _updateListener_closure7
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference loadBalancing;
                private /* synthetic */ Reference listenerArn;
                private /* synthetic */ Reference amazonErrors;
                private /* synthetic */ Reference listener;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;

                public _updateListener_closure7(Object _outerInstance, Object _thisObject, Reference loadBalancing, Reference listenerArn, Reference amazonErrors, Reference listener) {
                    Reference reference;
                    Reference reference2;
                    Reference reference3;
                    Reference reference4;
                    CallSite[] callSiteArray = _updateListener_closure7.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                    this.loadBalancing = reference4 = loadBalancing;
                    this.listenerArn = reference3 = listenerArn;
                    this.amazonErrors = reference2 = amazonErrors;
                    this.listener = reference = listener;
                }

                public Object doCall(Object rule) {
                    CallSite[] callSiteArray = _updateListener_closure7.$getCallSiteArray();
                    Object object = callSiteArray[0].call(this.loadBalancing.get(), callSiteArray[1].callConstructor(CreateRuleRequest.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"listenerArn", this.listenerArn.get(), "conditions", callSiteArray[2].callGetProperty(rule), "actions", callSiteArray[3].callGetProperty(rule), "priority", callSiteArray[4].call(Integer.class, callSiteArray[5].callGetProperty(rule))})));
                    try {
                        return object;
                    }
                    catch (AmazonServiceException e) {
                        Object object2 = callSiteArray[6].call(this.amazonErrors.get(), callSiteArray[7].callStatic(LoadBalancerV2UpsertHandler.class, (Object)new GStringImpl(new Object[]{this.listenerArn.get(), callSiteArray[8].callGetProperty(this.listener.get()), callSiteArray[9].callGetProperty(this.listener.get()), callSiteArray[10].call((Object)e)}, new String[]{"Failed to add rule to listener ", " (", ":", ") reason: ", "."}), (Object)e));
                        return object2;
                    }
                }

                @Generated
                public AmazonElasticLoadBalancing getLoadBalancing() {
                    CallSite[] callSiteArray = _updateListener_closure7.$getCallSiteArray();
                    return (AmazonElasticLoadBalancing)ScriptBytecodeAdapter.castToType((Object)this.loadBalancing.get(), AmazonElasticLoadBalancing.class);
                }

                @Generated
                public String getListenerArn() {
                    CallSite[] callSiteArray = _updateListener_closure7.$getCallSiteArray();
                    return ShortTypeHandling.castToString((Object)this.listenerArn.get());
                }

                @Generated
                public List getAmazonErrors() {
                    CallSite[] callSiteArray = _updateListener_closure7.$getCallSiteArray();
                    return (List)ScriptBytecodeAdapter.castToType((Object)this.amazonErrors.get(), List.class);
                }

                @Generated
                public UpsertAmazonLoadBalancerV2Description.Listener getListener() {
                    CallSite[] callSiteArray = _updateListener_closure7.$getCallSiteArray();
                    return (UpsertAmazonLoadBalancerV2Description.Listener)ScriptBytecodeAdapter.castToType((Object)this.listener.get(), UpsertAmazonLoadBalancerV2Description.Listener.class);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _updateListener_closure7.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                    stringArray[0] = "createRule";
                    stringArray[1] = "<$constructor$>";
                    stringArray[2] = "conditions";
                    stringArray[3] = "actions";
                    stringArray[4] = "valueOf";
                    stringArray[5] = "priority";
                    stringArray[6] = "leftShift";
                    stringArray[7] = "handleError";
                    stringArray[8] = "port";
                    stringArray[9] = "protocol";
                    stringArray[10] = "toString";
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[11];
                    _updateListener_closure7.$createCallSiteArray_1(stringArray);
                    return new CallSiteArray(_updateListener_closure7.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _updateListener_closure7.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            }
            callSiteArray[179].call(newRules, (Object)new _updateListener_closure7(LoadBalancerV2UpsertHandler.class, LoadBalancerV2UpsertHandler.class, loadBalancing2, listenerArn2, amazonErrors2, listener2));
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void removeListeners(List<Listener> listenersToRemove, List<Listener> existingListeners, AmazonElasticLoadBalancing loadBalancing, LoadBalancer loadBalancer) {
        void var3_3;
        void var2_2;
        Reference existingListeners2 = new Reference(existingListeners);
        Reference loadBalancing2 = new Reference((Object)var2_2);
        Reference loadBalancer2 = new Reference((Object)var3_3);
        CallSite[] callSiteArray = LoadBalancerV2UpsertHandler.$getCallSiteArray();
        public final class _removeListeners_closure8
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference loadBalancing;
            private /* synthetic */ Reference loadBalancer;
            private /* synthetic */ Reference existingListeners;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _removeListeners_closure8(Object _outerInstance, Object _thisObject, Reference loadBalancing, Reference loadBalancer, Reference existingListeners) {
                Reference reference;
                Reference reference2;
                Reference reference3;
                CallSite[] callSiteArray = _removeListeners_closure8.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.loadBalancing = reference3 = loadBalancing;
                this.loadBalancer = reference2 = loadBalancer;
                this.existingListeners = reference = existingListeners;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _removeListeners_closure8.$getCallSiteArray();
                callSiteArray[0].call(this.loadBalancing.get(), callSiteArray[1].call(callSiteArray[2].callConstructor(DeleteListenerRequest.class), callSiteArray[3].callGetProperty(it)));
                callSiteArray[4].call(callSiteArray[5].callGroovyObjectGetProperty((Object)this), ScriptBytecodeAdapter.getField(_removeListeners_closure8.class, LoadBalancerV2UpsertHandler.class, (String)"BASE_PHASE"), (Object)new GStringImpl(new Object[]{callSiteArray[6].callGetProperty(this.loadBalancer.get()), callSiteArray[7].callGetProperty(it), callSiteArray[8].callGetProperty(it)}, new String[]{"Listener removed from ", " (", ":", ")."}));
                Object object = callSiteArray[9].call(this.existingListeners.get(), it);
                try {
                    return object;
                }
                catch (ListenerNotFoundException e) {
                    Object object2 = callSiteArray[10].callStatic(LoadBalancerV2UpsertHandler.class, (Object)new GStringImpl(new Object[]{callSiteArray[11].callGetProperty(it), callSiteArray[12].call((Object)e)}, new String[]{"Failed to delete listener ", ". Listener could not be found. ", ""}), (Object)e);
                    return object2;
                }
            }

            @Generated
            public AmazonElasticLoadBalancing getLoadBalancing() {
                CallSite[] callSiteArray = _removeListeners_closure8.$getCallSiteArray();
                return (AmazonElasticLoadBalancing)ScriptBytecodeAdapter.castToType((Object)this.loadBalancing.get(), AmazonElasticLoadBalancing.class);
            }

            @Generated
            public LoadBalancer getLoadBalancer() {
                CallSite[] callSiteArray = _removeListeners_closure8.$getCallSiteArray();
                return (LoadBalancer)ScriptBytecodeAdapter.castToType((Object)this.loadBalancer.get(), LoadBalancer.class);
            }

            @Generated
            public List getExistingListeners() {
                CallSite[] callSiteArray = _removeListeners_closure8.$getCallSiteArray();
                return (List)ScriptBytecodeAdapter.castToType((Object)this.existingListeners.get(), List.class);
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _removeListeners_closure8.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _removeListeners_closure8.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "deleteListener";
                stringArray[1] = "withListenerArn";
                stringArray[2] = "<$constructor$>";
                stringArray[3] = "listenerArn";
                stringArray[4] = "updateStatus";
                stringArray[5] = "task";
                stringArray[6] = "loadBalancerName";
                stringArray[7] = "port";
                stringArray[8] = "protocol";
                stringArray[9] = "remove";
                stringArray[10] = "handleError";
                stringArray[11] = "listenerArn";
                stringArray[12] = "toString";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[13];
                _removeListeners_closure8.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_removeListeners_closure8.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _removeListeners_closure8.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[180].call(listenersToRemove, (Object)new _removeListeners_closure8(LoadBalancerV2UpsertHandler.class, LoadBalancerV2UpsertHandler.class, loadBalancing2, loadBalancer2, existingListeners2));
    }

    /*
     * WARNING - void declaration
     */
    public static List<Action> getAmazonActionsFromDescription(List<UpsertAmazonLoadBalancerV2Description.Action> actions, List<TargetGroup> existingTargetGroups, List<String> amazonErrors) {
        void var2_2;
        Reference existingTargetGroups2 = new Reference(existingTargetGroups);
        Reference amazonErrors2 = new Reference((Object)var2_2);
        CallSite[] callSiteArray = LoadBalancerV2UpsertHandler.$getCallSiteArray();
        Reference awsActions = new Reference((Object)ScriptBytecodeAdapter.createList((Object[])new Object[0]));
        public final class _getAmazonActionsFromDescription_closure9
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference existingTargetGroups;
            private /* synthetic */ Reference awsActions;
            private /* synthetic */ Reference amazonErrors;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _getAmazonActionsFromDescription_closure9(Object _outerInstance, Object _thisObject, Reference existingTargetGroups, Reference awsActions, Reference amazonErrors) {
                Reference reference;
                Reference reference2;
                Reference reference3;
                CallSite[] callSiteArray = _getAmazonActionsFromDescription_closure9.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.existingTargetGroups = reference3 = existingTargetGroups;
                this.awsActions = reference2 = awsActions;
                this.amazonErrors = reference = amazonErrors;
            }

            public Object doCall(Object action, Object index) {
                Reference action2 = new Reference(action);
                CallSite[] callSiteArray = _getAmazonActionsFromDescription_closure9.$getCallSiteArray();
                if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[0].callGetProperty(action2.get()), (Object)"forward")) {
                    public final class _closure25
                    extends Closure
                    implements GeneratedClosure {
                        private /* synthetic */ Reference action;
                        private static /* synthetic */ ClassInfo $staticClassInfo;
                        public static transient /* synthetic */ boolean __$stMC;
                        private static /* synthetic */ SoftReference $callSiteArray;

                        public _closure25(Object _outerInstance, Object _thisObject, Reference action) {
                            Reference reference;
                            CallSite[] callSiteArray = _closure25.$getCallSiteArray();
                            super(_outerInstance, _thisObject);
                            this.action = reference = action;
                        }

                        public Object doCall(Object it) {
                            CallSite[] callSiteArray = _closure25.$getCallSiteArray();
                            return ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[0].callGetProperty(it), (Object)callSiteArray[1].callGetProperty(this.action.get()));
                        }

                        @Generated
                        public Object getAction() {
                            CallSite[] callSiteArray = _closure25.$getCallSiteArray();
                            return this.action.get();
                        }

                        @Generated
                        public Object doCall() {
                            CallSite[] callSiteArray = _closure25.$getCallSiteArray();
                            return this.doCall(null);
                        }

                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                            if (((Object)((Object)this)).getClass() != _closure25.class) {
                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                            }
                            ClassInfo classInfo = $staticClassInfo;
                            if (classInfo == null) {
                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                            }
                            return classInfo.getMetaClass();
                        }

                        private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                            stringArray[0] = "targetGroupName";
                            stringArray[1] = "targetGroupName";
                        }

                        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                            String[] stringArray = new String[2];
                            _closure25.$createCallSiteArray_1(stringArray);
                            return new CallSiteArray(_closure25.class, stringArray);
                        }

                        private static /* synthetic */ CallSite[] $getCallSiteArray() {
                            CallSiteArray callSiteArray;
                            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                                callSiteArray = _closure25.$createCallSiteArray();
                                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                            }
                            return callSiteArray.array;
                        }
                    }
                    TargetGroup targetGroup = (TargetGroup)ScriptBytecodeAdapter.castToType((Object)callSiteArray[1].call(this.existingTargetGroups.get(), (Object)new _closure25((Object)this, this.getThisObject(), action2)), TargetGroup.class);
                    if (ScriptBytecodeAdapter.compareNotEqual((Object)targetGroup, null)) {
                        Action awsAction = (Action)ScriptBytecodeAdapter.castToType((Object)callSiteArray[2].call(callSiteArray[3].call(callSiteArray[4].call(callSiteArray[5].callConstructor(Action.class), callSiteArray[6].callGetProperty(action2.get())), callSiteArray[7].callGetProperty((Object)targetGroup)), callSiteArray[8].call(index, (Object)1)), Action.class);
                        return callSiteArray[9].call(this.awsActions.get(), (Object)awsAction);
                    }
                    String exceptionMessage = ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{callSiteArray[10].callGetProperty(action2.get())}, new String[]{"Target group name ", " not found when trying to create action"}));
                    callSiteArray[11].call(callSiteArray[12].callGroovyObjectGetProperty((Object)this), ScriptBytecodeAdapter.getField(_getAmazonActionsFromDescription_closure9.class, LoadBalancerV2UpsertHandler.class, (String)"BASE_PHASE"), (Object)exceptionMessage);
                    return callSiteArray[13].call(this.amazonErrors.get(), (Object)exceptionMessage);
                }
                if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[14].callGetProperty(action2.get()), (Object)"authenticate-oidc")) {
                    Action awsAction = (Action)ScriptBytecodeAdapter.castToType((Object)callSiteArray[15].call(callSiteArray[16].call(callSiteArray[17].call(callSiteArray[18].callConstructor(Action.class), callSiteArray[19].callGetProperty(action2.get())), callSiteArray[20].callGetProperty(action2.get())), callSiteArray[21].call(index, (Object)1)), Action.class);
                    return callSiteArray[22].call(this.awsActions.get(), (Object)awsAction);
                }
                if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[23].callGetProperty(action2.get()), (Object)"redirect")) {
                    Action awsAction = (Action)ScriptBytecodeAdapter.castToType((Object)callSiteArray[24].call(callSiteArray[25].call(callSiteArray[26].call(callSiteArray[27].callConstructor(Action.class), callSiteArray[28].callGetProperty(action2.get())), callSiteArray[29].callGetProperty(action2.get())), callSiteArray[30].call(index, (Object)1)), Action.class);
                    return callSiteArray[31].call(this.awsActions.get(), (Object)awsAction);
                }
                return null;
            }

            public Object call(Object action, Object index) {
                Reference action2 = new Reference(action);
                CallSite[] callSiteArray = _getAmazonActionsFromDescription_closure9.$getCallSiteArray();
                return callSiteArray[32].callCurrent((GroovyObject)this, action2.get(), index);
            }

            @Generated
            public List getExistingTargetGroups() {
                CallSite[] callSiteArray = _getAmazonActionsFromDescription_closure9.$getCallSiteArray();
                return (List)ScriptBytecodeAdapter.castToType((Object)this.existingTargetGroups.get(), List.class);
            }

            @Generated
            public List getAwsActions() {
                CallSite[] callSiteArray = _getAmazonActionsFromDescription_closure9.$getCallSiteArray();
                return (List)ScriptBytecodeAdapter.castToType((Object)this.awsActions.get(), List.class);
            }

            @Generated
            public List getAmazonErrors() {
                CallSite[] callSiteArray = _getAmazonActionsFromDescription_closure9.$getCallSiteArray();
                return (List)ScriptBytecodeAdapter.castToType((Object)this.amazonErrors.get(), List.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getAmazonActionsFromDescription_closure9.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "type";
                stringArray[1] = "find";
                stringArray[2] = "withOrder";
                stringArray[3] = "withTargetGroupArn";
                stringArray[4] = "withType";
                stringArray[5] = "<$constructor$>";
                stringArray[6] = "type";
                stringArray[7] = "targetGroupArn";
                stringArray[8] = "plus";
                stringArray[9] = "add";
                stringArray[10] = "targetGroupName";
                stringArray[11] = "updateStatus";
                stringArray[12] = "task";
                stringArray[13] = "leftShift";
                stringArray[14] = "type";
                stringArray[15] = "withOrder";
                stringArray[16] = "withAuthenticateOidcConfig";
                stringArray[17] = "withType";
                stringArray[18] = "<$constructor$>";
                stringArray[19] = "type";
                stringArray[20] = "authenticateOidcActionConfig";
                stringArray[21] = "plus";
                stringArray[22] = "add";
                stringArray[23] = "type";
                stringArray[24] = "withOrder";
                stringArray[25] = "withRedirectConfig";
                stringArray[26] = "withType";
                stringArray[27] = "<$constructor$>";
                stringArray[28] = "type";
                stringArray[29] = "redirectActionConfig";
                stringArray[30] = "plus";
                stringArray[31] = "add";
                stringArray[32] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[33];
                _getAmazonActionsFromDescription_closure9.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_getAmazonActionsFromDescription_closure9.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _getAmazonActionsFromDescription_closure9.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[181].call(actions, (Object)new _getAmazonActionsFromDescription_closure9(LoadBalancerV2UpsertHandler.class, LoadBalancerV2UpsertHandler.class, existingTargetGroups2, awsActions, amazonErrors2));
        return (List)awsActions.get();
    }

    /*
     * WARNING - void declaration
     */
    public static void updateLoadBalancer(AmazonElasticLoadBalancing loadBalancing, LoadBalancer loadBalancer, Collection<String> securityGroups, List<UpsertAmazonLoadBalancerV2Description.TargetGroup> targetGroups, List<UpsertAmazonLoadBalancerV2Description.Listener> listeners, AwsConfiguration.DeployDefaults deployDefaults, Integer idleTimeout, Boolean deletionProtection, Boolean loadBalancingCrossZone, String ipAddressType) {
        public final class _updateLoadBalancer_closure12
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _updateLoadBalancer_closure12(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _updateLoadBalancer_closure12.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _updateLoadBalancer_closure12.$getCallSiteArray();
                return ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[0].callGetProperty(it), (Object)ScriptBytecodeAdapter.getField(_updateLoadBalancer_closure12.class, LoadBalancerV2UpsertHandler.class, (String)"ATTRIBUTE_LOAD_BALANCING_CROSS_ZONE"));
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _updateLoadBalancer_closure12.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _updateLoadBalancer_closure12.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "key";
                return new CallSiteArray(_updateLoadBalancer_closure12.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _updateLoadBalancer_closure12.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        void var3_3;
        void var1_1;
        Reference loadBalancing2 = new Reference((Object)loadBalancing);
        Reference loadBalancer2 = new Reference((Object)var1_1);
        Reference targetGroups2 = new Reference((Object)var3_3);
        Reference listeners2 = new Reference(listeners);
        CallSite[] callSiteArray = LoadBalancerV2UpsertHandler.$getCallSiteArray();
        Reference amazonErrors = new Reference((Object)ScriptBytecodeAdapter.createList((Object[])new Object[0]));
        Object loadBalancerName = callSiteArray[182].callGetProperty((Object)((LoadBalancer)loadBalancer2.get()));
        Object loadBalancerArn = callSiteArray[183].callGetProperty((Object)((LoadBalancer)loadBalancer2.get()));
        if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[184].call((Object)((LoadBalancer)loadBalancer2.get())), (Object)"application")) {
            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[185].callGetProperty((Object)((LoadBalancer)loadBalancer2.get()))) && !DefaultTypeTransformation.booleanUnbox(securityGroups)) {
                throw (Throwable)callSiteArray[186].callConstructor(IllegalArgumentException.class, (Object)new GStringImpl(new Object[]{loadBalancerName}, new String[]{"Load balancer ", " must have at least one security group"}));
            }
            if (DefaultTypeTransformation.booleanUnbox(securityGroups)) {
                callSiteArray[187].call((Object)((AmazonElasticLoadBalancing)loadBalancing2.get()), callSiteArray[188].callConstructor(SetSecurityGroupsRequest.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"loadBalancerArn", loadBalancerArn, "securityGroups", securityGroups})));
                callSiteArray[189].call(callSiteArray[190].callGetProperty(LoadBalancerV2UpsertHandler.class), (Object)BASE_PHASE, (Object)new GStringImpl(new Object[]{loadBalancerName}, new String[]{"Security groups updated on ", "."}));
            }
        }
        Object currentIpAddressType = callSiteArray[191].callGetProperty((Object)((LoadBalancer)loadBalancer2.get()));
        if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (DefaultTypeTransformation.booleanUnbox((Object)ipAddressType) && ScriptBytecodeAdapter.compareNotEqual((Object)ipAddressType, (Object)currentIpAddressType) && (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[192].callGetProperty((Object)((LoadBalancer)loadBalancer2.get())), (Object)"application") || ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[193].callGetProperty((Object)((LoadBalancer)loadBalancer2.get())), (Object)"network"))) {
                String newIpAddressType = ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[194].callGetProperty((Object)((LoadBalancer)loadBalancer2.get())), (Object)"internal") ? "ipv4" : ipAddressType;
                callSiteArray[195].call((Object)((AmazonElasticLoadBalancing)loadBalancing2.get()), callSiteArray[196].callConstructor(SetIpAddressTypeRequest.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"loadBalancerArn", loadBalancerArn, "ipAddressType", newIpAddressType})));
                callSiteArray[197].call(callSiteArray[198].callGetProperty(LoadBalancerV2UpsertHandler.class), (Object)BASE_PHASE, (Object)new GStringImpl(new Object[]{loadBalancerName}, new String[]{"IP Address type updated ", "."}));
            }
        } else if (DefaultTypeTransformation.booleanUnbox((Object)ipAddressType) && ScriptBytecodeAdapter.compareNotEqual((Object)ipAddressType, (Object)currentIpAddressType) && (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[199].callGetProperty((Object)((LoadBalancer)loadBalancer2.get())), (Object)"application") || ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[200].callGetProperty((Object)((LoadBalancer)loadBalancer2.get())), (Object)"network"))) {
            String newIpAddressType = ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[201].callGetProperty((Object)((LoadBalancer)loadBalancer2.get())), (Object)"internal") ? "ipv4" : ipAddressType;
            callSiteArray[202].call((Object)((AmazonElasticLoadBalancing)loadBalancing2.get()), callSiteArray[203].callConstructor(SetIpAddressTypeRequest.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"loadBalancerArn", loadBalancerArn, "ipAddressType", newIpAddressType})));
            callSiteArray[204].call(callSiteArray[205].callGetProperty(LoadBalancerV2UpsertHandler.class), (Object)BASE_PHASE, (Object)new GStringImpl(new Object[]{loadBalancerName}, new String[]{"IP Address type updated ", "."}));
        }
        Object currentAttributes = callSiteArray[206].callGetProperty(callSiteArray[207].call((Object)((AmazonElasticLoadBalancing)loadBalancing2.get()), callSiteArray[208].call(callSiteArray[209].callConstructor(DescribeLoadBalancerAttributesRequest.class), loadBalancerArn)));
        List attributes = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[210].callGetProperty((Object)((LoadBalancer)loadBalancer2.get())), (Object)"application")) {
            public final class _updateLoadBalancer_closure10
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;

                public _updateLoadBalancer_closure10(Object _outerInstance, Object _thisObject) {
                    CallSite[] callSiteArray = _updateLoadBalancer_closure10.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(Object it) {
                    CallSite[] callSiteArray = _updateLoadBalancer_closure10.$getCallSiteArray();
                    return ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[0].callGetProperty(it), (Object)ScriptBytecodeAdapter.getField(_updateLoadBalancer_closure10.class, LoadBalancerV2UpsertHandler.class, (String)"ATTRIBUTE_IDLE_TIMEOUT"));
                }

                @Generated
                public Object doCall() {
                    CallSite[] callSiteArray = _updateLoadBalancer_closure10.$getCallSiteArray();
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _updateLoadBalancer_closure10.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[1];
                    stringArray[0] = "key";
                    return new CallSiteArray(_updateLoadBalancer_closure10.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _updateLoadBalancer_closure10.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            }
            String currentIdleTimeout = ShortTypeHandling.castToString((Object)callSiteArray[211].callSafe(callSiteArray[212].call(currentAttributes, (Object)new _updateLoadBalancer_closure10(LoadBalancerV2UpsertHandler.class, LoadBalancerV2UpsertHandler.class))));
            String newIdleTimeout = ShortTypeHandling.castToString((Object)callSiteArray[213].call(callSiteArray[214].call((Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{idleTimeout, callSiteArray[215].callGetProperty(callSiteArray[216].callGroovyObjectGetProperty((Object)deployDefaults))}), callSiteArray[217].callGetProperty(Closure.class))));
            if (ScriptBytecodeAdapter.compareNotEqual((Object)currentIdleTimeout, (Object)newIdleTimeout)) {
                callSiteArray[218].call(callSiteArray[219].callGetProperty(LoadBalancerV2UpsertHandler.class), (Object)BASE_PHASE, (Object)new GStringImpl(new Object[]{loadBalancerName, newIdleTimeout}, new String[]{"Setting idle timeout on ", " to ", "."}));
                callSiteArray[220].call((Object)attributes, callSiteArray[221].call(callSiteArray[222].call(callSiteArray[223].callConstructor(LoadBalancerAttribute.class), (Object)ATTRIBUTE_IDLE_TIMEOUT), (Object)newIdleTimeout));
            }
        }
        public final class _updateLoadBalancer_closure11
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _updateLoadBalancer_closure11(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _updateLoadBalancer_closure11.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _updateLoadBalancer_closure11.$getCallSiteArray();
                return ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[0].callGetProperty(it), (Object)ScriptBytecodeAdapter.getField(_updateLoadBalancer_closure11.class, LoadBalancerV2UpsertHandler.class, (String)"ATTRIBUTE_DELETION_PROTECTION"));
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _updateLoadBalancer_closure11.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _updateLoadBalancer_closure11.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "key";
                return new CallSiteArray(_updateLoadBalancer_closure11.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _updateLoadBalancer_closure11.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        String currentDeletionProtections = ShortTypeHandling.castToString((Object)callSiteArray[224].callSafe(callSiteArray[225].call(currentAttributes, (Object)new _updateLoadBalancer_closure11(LoadBalancerV2UpsertHandler.class, LoadBalancerV2UpsertHandler.class))));
        String newDeletionProtection = ShortTypeHandling.castToString((Object)callSiteArray[226].call(callSiteArray[227].call((Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{deletionProtection, callSiteArray[228].callGetProperty(callSiteArray[229].callGroovyObjectGetProperty((Object)deployDefaults))}), callSiteArray[230].callGetProperty(Boolean.class), callSiteArray[231].callGetProperty(Closure.class))));
        if (ScriptBytecodeAdapter.compareNotEqual((Object)currentDeletionProtections, (Object)newDeletionProtection)) {
            callSiteArray[232].call(callSiteArray[233].callGetProperty(LoadBalancerV2UpsertHandler.class), (Object)BASE_PHASE, (Object)new GStringImpl(new Object[]{loadBalancerName, newDeletionProtection}, new String[]{"Setting deletion protection on ", " to ", "."}));
            callSiteArray[234].call((Object)attributes, callSiteArray[235].call(callSiteArray[236].call(callSiteArray[237].callConstructor(LoadBalancerAttribute.class), (Object)ATTRIBUTE_DELETION_PROTECTION), (Object)newDeletionProtection));
        }
        if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[238].callGetProperty((Object)((LoadBalancer)loadBalancer2.get())), (Object)"network") && ScriptBytecodeAdapter.compareNotEqual((Object)loadBalancingCrossZone, null)) {
                String currentLoadBalancingCrossZone = ShortTypeHandling.castToString((Object)callSiteArray[239].callSafe(callSiteArray[240].call(currentAttributes, (Object)new _updateLoadBalancer_closure12(LoadBalancerV2UpsertHandler.class, LoadBalancerV2UpsertHandler.class))));
                String newLoadBalancingCrossZone = ShortTypeHandling.castToString((Object)callSiteArray[241].call(callSiteArray[242].call((Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{loadBalancingCrossZone, callSiteArray[243].callGetProperty(callSiteArray[244].callGroovyObjectGetProperty((Object)deployDefaults))}), callSiteArray[245].callGetProperty(Boolean.class), callSiteArray[246].callGetProperty(Closure.class))));
                if (ScriptBytecodeAdapter.compareNotEqual((Object)currentLoadBalancingCrossZone, (Object)newLoadBalancingCrossZone)) {
                    callSiteArray[247].call(callSiteArray[248].callGetProperty(LoadBalancerV2UpsertHandler.class), (Object)BASE_PHASE, (Object)new GStringImpl(new Object[]{loadBalancerName, newLoadBalancingCrossZone}, new String[]{"Setting Cross-Zone Load Balancing on ", " to ", "."}));
                    callSiteArray[249].call((Object)attributes, callSiteArray[250].call(callSiteArray[251].call(callSiteArray[252].callConstructor(LoadBalancerAttribute.class), (Object)ATTRIBUTE_LOAD_BALANCING_CROSS_ZONE), (Object)newLoadBalancingCrossZone));
                }
            }
        } else if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[253].callGetProperty((Object)((LoadBalancer)loadBalancer2.get())), (Object)"network") && ScriptBytecodeAdapter.compareNotEqual((Object)loadBalancingCrossZone, null)) {
            String currentLoadBalancingCrossZone = ShortTypeHandling.castToString((Object)callSiteArray[254].callSafe(callSiteArray[255].call(currentAttributes, (Object)new _updateLoadBalancer_closure12(LoadBalancerV2UpsertHandler.class, LoadBalancerV2UpsertHandler.class))));
            String newLoadBalancingCrossZone = ShortTypeHandling.castToString((Object)callSiteArray[256].call(callSiteArray[257].call((Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{loadBalancingCrossZone, callSiteArray[258].callGetProperty(callSiteArray[259].callGroovyObjectGetProperty((Object)deployDefaults))}), callSiteArray[260].callGetProperty(Boolean.class), callSiteArray[261].callGetProperty(Closure.class))));
            if (ScriptBytecodeAdapter.compareNotEqual((Object)currentLoadBalancingCrossZone, (Object)newLoadBalancingCrossZone)) {
                callSiteArray[262].call(callSiteArray[263].callGetProperty(LoadBalancerV2UpsertHandler.class), (Object)BASE_PHASE, (Object)new GStringImpl(new Object[]{loadBalancerName, newLoadBalancingCrossZone}, new String[]{"Setting Cross-Zone Load Balancing on ", " to ", "."}));
                callSiteArray[264].call((Object)attributes, callSiteArray[265].call(callSiteArray[266].call(callSiteArray[267].callConstructor(LoadBalancerAttribute.class), (Object)ATTRIBUTE_LOAD_BALANCING_CROSS_ZONE), (Object)newLoadBalancingCrossZone));
            }
        }
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[268].call((Object)attributes))) {
            callSiteArray[269].call((Object)((AmazonElasticLoadBalancing)loadBalancing2.get()), callSiteArray[270].call(callSiteArray[271].call(callSiteArray[272].callConstructor(ModifyLoadBalancerAttributesRequest.class), loadBalancerArn), (Object)attributes));
        }
        Reference existingTargetGroups = new Reference((Object)ScriptBytecodeAdapter.createList((Object[])new Object[0]));
        Object object = callSiteArray[273].callGetPropertySafe(callSiteArray[274].call((Object)((AmazonElasticLoadBalancing)loadBalancing2.get()), callSiteArray[275].call(callSiteArray[276].callConstructor(DescribeTargetGroupsRequest.class), callSiteArray[277].callGetProperty((Object)((LoadBalancer)loadBalancer2.get())))));
        existingTargetGroups.set((Object)((List)ScriptBytecodeAdapter.castToType((Object)object, List.class)));
        Reference existingListeners = new Reference((Object)((List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[278].callGetPropertySafe(callSiteArray[279].call((Object)((AmazonElasticLoadBalancing)loadBalancing2.get()), callSiteArray[280].call(callSiteArray[281].callConstructor(DescribeListenersRequest.class), loadBalancerArn))), List.class)));
        public final class _updateLoadBalancer_closure13
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference loadBalancing;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _updateLoadBalancer_closure13(Object _outerInstance, Object _thisObject, Reference loadBalancing) {
                Reference reference;
                CallSite[] callSiteArray = _updateLoadBalancer_closure13.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.loadBalancing = reference = loadBalancing;
            }

            public Object doCall(Object listener) {
                CallSite[] callSiteArray = _updateLoadBalancer_closure13.$getCallSiteArray();
                List rules = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[0].callGetPropertySafe(callSiteArray[1].call(this.loadBalancing.get(), callSiteArray[2].callConstructor(DescribeRulesRequest.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"listenerArn", callSiteArray[3].callGetProperty(listener)})))), List.class);
                return ScriptBytecodeAdapter.createMap((Object[])new Object[]{listener, rules});
            }

            @Generated
            public AmazonElasticLoadBalancing getLoadBalancing() {
                CallSite[] callSiteArray = _updateLoadBalancer_closure13.$getCallSiteArray();
                return (AmazonElasticLoadBalancing)ScriptBytecodeAdapter.castToType((Object)this.loadBalancing.get(), AmazonElasticLoadBalancing.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _updateLoadBalancer_closure13.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "rules";
                stringArray[1] = "describeRules";
                stringArray[2] = "<$constructor$>";
                stringArray[3] = "listenerArn";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[4];
                _updateLoadBalancer_closure13.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_updateLoadBalancer_closure13.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _updateLoadBalancer_closure13.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        Reference existingListenerToRules = new Reference((Object)((Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[282].call((Object)((List)existingListeners.get()), (Object)new _updateLoadBalancer_closure13(LoadBalancerV2UpsertHandler.class, LoadBalancerV2UpsertHandler.class, loadBalancing2)), Map.class)));
        public final class _updateLoadBalancer_closure14
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference targetGroups;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _updateLoadBalancer_closure14(Object _outerInstance, Object _thisObject, Reference targetGroups) {
                Reference reference;
                CallSite[] callSiteArray = _updateLoadBalancer_closure14.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.targetGroups = reference = targetGroups;
            }

            public Object doCall(Object awsTargetGroup) {
                Reference awsTargetGroup2 = new Reference(awsTargetGroup);
                CallSite[] callSiteArray = _updateLoadBalancer_closure14.$getCallSiteArray();
                public final class _closure26
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference awsTargetGroup;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;
                    private static /* synthetic */ SoftReference $callSiteArray;

                    public _closure26(Object _outerInstance, Object _thisObject, Reference awsTargetGroup) {
                        Reference reference;
                        CallSite[] callSiteArray = _closure26.$getCallSiteArray();
                        super(_outerInstance, _thisObject);
                        this.awsTargetGroup = reference = awsTargetGroup;
                    }

                    public Object doCall(Object it) {
                        CallSite[] callSiteArray = _closure26.$getCallSiteArray();
                        if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                            return ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[0].callGetProperty(it), (Object)callSiteArray[1].callGetProperty(this.awsTargetGroup.get())) && ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[2].callGetProperty(it), (Object)callSiteArray[3].callGetProperty(this.awsTargetGroup.get())) && ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[4].call(callSiteArray[5].callGetProperty(it)), (Object)callSiteArray[6].callGetProperty(this.awsTargetGroup.get()));
                        }
                        return ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[7].callGetProperty(it), (Object)callSiteArray[8].callGetProperty(this.awsTargetGroup.get())) && ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[9].callGetProperty(it), (Object)callSiteArray[10].callGetProperty(this.awsTargetGroup.get())) && ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[11].call(callSiteArray[12].callGetProperty(it)), (Object)callSiteArray[13].callGetProperty(this.awsTargetGroup.get()));
                    }

                    @Generated
                    public Object getAwsTargetGroup() {
                        CallSite[] callSiteArray = _closure26.$getCallSiteArray();
                        return this.awsTargetGroup.get();
                    }

                    @Generated
                    public Object doCall() {
                        CallSite[] callSiteArray = _closure26.$getCallSiteArray();
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure26.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                        stringArray[0] = "name";
                        stringArray[1] = "targetGroupName";
                        stringArray[2] = "port";
                        stringArray[3] = "port";
                        stringArray[4] = "toString";
                        stringArray[5] = "protocol";
                        stringArray[6] = "protocol";
                        stringArray[7] = "name";
                        stringArray[8] = "targetGroupName";
                        stringArray[9] = "port";
                        stringArray[10] = "port";
                        stringArray[11] = "toString";
                        stringArray[12] = "protocol";
                        stringArray[13] = "protocol";
                    }

                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                        String[] stringArray = new String[14];
                        _closure26.$createCallSiteArray_1(stringArray);
                        return new CallSiteArray(_closure26.class, stringArray);
                    }

                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                        CallSiteArray callSiteArray;
                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                            callSiteArray = _closure26.$createCallSiteArray();
                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                        }
                        return callSiteArray.array;
                    }
                }
                return ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[0].call(this.targetGroups.get(), (Object)new _closure26((Object)this, this.getThisObject(), awsTargetGroup2)), null);
            }

            @Generated
            public List getTargetGroups() {
                CallSite[] callSiteArray = _updateLoadBalancer_closure14.$getCallSiteArray();
                return (List)ScriptBytecodeAdapter.castToType((Object)this.targetGroups.get(), List.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _updateLoadBalancer_closure14.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "find";
                return new CallSiteArray(_updateLoadBalancer_closure14.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _updateLoadBalancer_closure14.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        List targetGroupsSplit = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[283].call((Object)((List)existingTargetGroups.get()), (Object)new _updateLoadBalancer_closure14(LoadBalancerV2UpsertHandler.class, LoadBalancerV2UpsertHandler.class, targetGroups2)), List.class);
        List targetGroupsToRemove = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[284].call((Object)targetGroupsSplit, (Object)0), List.class);
        List targetGroupsToUpdate = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[285].call((Object)targetGroupsSplit, (Object)1), List.class);
        public final class _updateLoadBalancer_closure15
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _updateLoadBalancer_closure15(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _updateLoadBalancer_closure15.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _updateLoadBalancer_closure15.$getCallSiteArray();
                return callSiteArray[0].callGetProperty(it);
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _updateLoadBalancer_closure15.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _updateLoadBalancer_closure15.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "targetGroupArn";
                return new CallSiteArray(_updateLoadBalancer_closure15.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _updateLoadBalancer_closure15.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        Reference targetGroupArnsToRemove = new Reference((Object)((List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[286].call((Object)targetGroupsToRemove, (Object)new _updateLoadBalancer_closure15(LoadBalancerV2UpsertHandler.class, LoadBalancerV2UpsertHandler.class)), List.class)));
        public final class _updateLoadBalancer_closure16
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference existingTargetGroups;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _updateLoadBalancer_closure16(Object _outerInstance, Object _thisObject, Reference existingTargetGroups) {
                Reference reference;
                CallSite[] callSiteArray = _updateLoadBalancer_closure16.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.existingTargetGroups = reference = existingTargetGroups;
            }

            public Object doCall(Object targetGroup) {
                Reference targetGroup2 = new Reference(targetGroup);
                CallSite[] callSiteArray = _updateLoadBalancer_closure16.$getCallSiteArray();
                public final class _closure27
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference targetGroup;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;
                    private static /* synthetic */ SoftReference $callSiteArray;

                    public _closure27(Object _outerInstance, Object _thisObject, Reference targetGroup) {
                        Reference reference;
                        CallSite[] callSiteArray = _closure27.$getCallSiteArray();
                        super(_outerInstance, _thisObject);
                        this.targetGroup = reference = targetGroup;
                    }

                    public Object doCall(Object it) {
                        CallSite[] callSiteArray = _closure27.$getCallSiteArray();
                        if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                            return ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[0].callGetProperty(this.targetGroup.get()), (Object)callSiteArray[1].callGetProperty(it)) && ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[2].callGetProperty(this.targetGroup.get()), (Object)callSiteArray[3].callGetProperty(it)) && ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[4].call(callSiteArray[5].callGetProperty(this.targetGroup.get())), (Object)callSiteArray[6].callGetProperty(it));
                        }
                        return ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[7].callGetProperty(this.targetGroup.get()), (Object)callSiteArray[8].callGetProperty(it)) && ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[9].callGetProperty(this.targetGroup.get()), (Object)callSiteArray[10].callGetProperty(it)) && ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[11].call(callSiteArray[12].callGetProperty(this.targetGroup.get())), (Object)callSiteArray[13].callGetProperty(it));
                    }

                    @Generated
                    public Object getTargetGroup() {
                        CallSite[] callSiteArray = _closure27.$getCallSiteArray();
                        return this.targetGroup.get();
                    }

                    @Generated
                    public Object doCall() {
                        CallSite[] callSiteArray = _closure27.$getCallSiteArray();
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure27.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                        stringArray[0] = "name";
                        stringArray[1] = "targetGroupName";
                        stringArray[2] = "port";
                        stringArray[3] = "port";
                        stringArray[4] = "toString";
                        stringArray[5] = "protocol";
                        stringArray[6] = "protocol";
                        stringArray[7] = "name";
                        stringArray[8] = "targetGroupName";
                        stringArray[9] = "port";
                        stringArray[10] = "port";
                        stringArray[11] = "toString";
                        stringArray[12] = "protocol";
                        stringArray[13] = "protocol";
                    }

                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                        String[] stringArray = new String[14];
                        _closure27.$createCallSiteArray_1(stringArray);
                        return new CallSiteArray(_closure27.class, stringArray);
                    }

                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                        CallSiteArray callSiteArray;
                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                            callSiteArray = _closure27.$createCallSiteArray();
                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                        }
                        return callSiteArray.array;
                    }
                }
                return ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[0].call(this.existingTargetGroups.get(), (Object)new _closure27((Object)this, this.getThisObject(), targetGroup2)), null);
            }

            @Generated
            public List getExistingTargetGroups() {
                CallSite[] callSiteArray = _updateLoadBalancer_closure16.$getCallSiteArray();
                return (List)ScriptBytecodeAdapter.castToType((Object)this.existingTargetGroups.get(), List.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _updateLoadBalancer_closure16.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "find";
                return new CallSiteArray(_updateLoadBalancer_closure16.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _updateLoadBalancer_closure16.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        List targetGroupsToCreate = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[287].call((Object)((List)targetGroups2.get()), (Object)new _updateLoadBalancer_closure16(LoadBalancerV2UpsertHandler.class, LoadBalancerV2UpsertHandler.class, existingTargetGroups)), List.class);
        public final class _updateLoadBalancer_closure17
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference existingListenerToRules;
            private /* synthetic */ Reference targetGroupArnsToRemove;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _updateLoadBalancer_closure17(Object _outerInstance, Object _thisObject, Reference existingListenerToRules, Reference targetGroupArnsToRemove) {
                Reference reference;
                Reference reference2;
                CallSite[] callSiteArray = _updateLoadBalancer_closure17.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.existingListenerToRules = reference2 = existingListenerToRules;
                this.targetGroupArnsToRemove = reference = targetGroupArnsToRemove;
            }

            public Object doCall(Object listener) {
                CallSite[] callSiteArray = _updateLoadBalancer_closure17.$getCallSiteArray();
                public final class _closure28
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference targetGroupArnsToRemove;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;
                    private static /* synthetic */ SoftReference $callSiteArray;

                    public _closure28(Object _outerInstance, Object _thisObject, Reference targetGroupArnsToRemove) {
                        Reference reference;
                        CallSite[] callSiteArray = _closure28.$getCallSiteArray();
                        super(_outerInstance, _thisObject);
                        this.targetGroupArnsToRemove = reference = targetGroupArnsToRemove;
                    }

                    public Object doCall(Object rule) {
                        CallSite[] callSiteArray = _closure28.$getCallSiteArray();
                        public final class _closure29
                        extends Closure
                        implements GeneratedClosure {
                            private /* synthetic */ Reference targetGroupArnsToRemove;
                            private static /* synthetic */ ClassInfo $staticClassInfo;
                            public static transient /* synthetic */ boolean __$stMC;
                            private static /* synthetic */ SoftReference $callSiteArray;

                            public _closure29(Object _outerInstance, Object _thisObject, Reference targetGroupArnsToRemove) {
                                Reference reference;
                                CallSite[] callSiteArray = _closure29.$getCallSiteArray();
                                super(_outerInstance, _thisObject);
                                this.targetGroupArnsToRemove = reference = targetGroupArnsToRemove;
                            }

                            public Object doCall(Object it) {
                                CallSite[] callSiteArray = _closure29.$getCallSiteArray();
                                return callSiteArray[0].call(this.targetGroupArnsToRemove.get(), callSiteArray[1].callGetProperty(it));
                            }

                            @Generated
                            public List getTargetGroupArnsToRemove() {
                                CallSite[] callSiteArray = _closure29.$getCallSiteArray();
                                return (List)ScriptBytecodeAdapter.castToType((Object)this.targetGroupArnsToRemove.get(), List.class);
                            }

                            @Generated
                            public Object doCall() {
                                CallSite[] callSiteArray = _closure29.$getCallSiteArray();
                                return this.doCall(null);
                            }

                            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                if (((Object)((Object)this)).getClass() != _closure29.class) {
                                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                }
                                ClassInfo classInfo = $staticClassInfo;
                                if (classInfo == null) {
                                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                }
                                return classInfo.getMetaClass();
                            }

                            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                                stringArray[0] = "contains";
                                stringArray[1] = "targetGroupArn";
                            }

                            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                                String[] stringArray = new String[2];
                                _closure29.$createCallSiteArray_1(stringArray);
                                return new CallSiteArray(_closure29.class, stringArray);
                            }

                            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                                CallSiteArray callSiteArray;
                                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                                    callSiteArray = _closure29.$createCallSiteArray();
                                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                                }
                                return callSiteArray.array;
                            }
                        }
                        return callSiteArray[0].call(callSiteArray[1].callGetProperty(rule), (Object)new _closure29((Object)this, this.getThisObject(), this.targetGroupArnsToRemove));
                    }

                    @Generated
                    public List getTargetGroupArnsToRemove() {
                        CallSite[] callSiteArray = _closure28.$getCallSiteArray();
                        return (List)ScriptBytecodeAdapter.castToType((Object)this.targetGroupArnsToRemove.get(), List.class);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure28.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                        stringArray[0] = "any";
                        stringArray[1] = "actions";
                    }

                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                        String[] stringArray = new String[2];
                        _closure28.$createCallSiteArray_1(stringArray);
                        return new CallSiteArray(_closure28.class, stringArray);
                    }

                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                        CallSiteArray callSiteArray;
                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                            callSiteArray = _closure28.$createCallSiteArray();
                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                        }
                        return callSiteArray.array;
                    }
                }
                return callSiteArray[0].call(callSiteArray[1].call(this.existingListenerToRules.get(), listener), (Object)new _closure28((Object)this, this.getThisObject(), this.targetGroupArnsToRemove));
            }

            @Generated
            public Map getExistingListenerToRules() {
                CallSite[] callSiteArray = _updateLoadBalancer_closure17.$getCallSiteArray();
                return (Map)ScriptBytecodeAdapter.castToType((Object)this.existingListenerToRules.get(), Map.class);
            }

            @Generated
            public List getTargetGroupArnsToRemove() {
                CallSite[] callSiteArray = _updateLoadBalancer_closure17.$getCallSiteArray();
                return (List)ScriptBytecodeAdapter.castToType((Object)this.targetGroupArnsToRemove.get(), List.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _updateLoadBalancer_closure17.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "any";
                stringArray[1] = "get";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[2];
                _updateLoadBalancer_closure17.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_updateLoadBalancer_closure17.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _updateLoadBalancer_closure17.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        List listenersToRemove = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[288].call((Object)((List)existingListeners.get()), (Object)new _updateLoadBalancer_closure17(LoadBalancerV2UpsertHandler.class, LoadBalancerV2UpsertHandler.class, existingListenerToRules, targetGroupArnsToRemove)), List.class);
        callSiteArray[289].callStatic(LoadBalancerV2UpsertHandler.class, (Object)listenersToRemove, (Object)((List)existingListeners.get()), (Object)((AmazonElasticLoadBalancing)loadBalancing2.get()), (Object)((LoadBalancer)loadBalancer2.get()));
        List removedTargetGroups = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[290].callStatic(LoadBalancerV2UpsertHandler.class, (Object)targetGroupsToRemove, (Object)((AmazonElasticLoadBalancing)loadBalancing2.get()), (Object)((LoadBalancer)loadBalancer2.get()), amazonErrors.get()), List.class);
        callSiteArray[291].call((Object)((List)existingTargetGroups.get()), (Object)removedTargetGroups);
        List createdTargetGroups = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[292].callStatic(LoadBalancerV2UpsertHandler.class, ArrayUtil.createArray((Object)targetGroupsToCreate, (Object)((AmazonElasticLoadBalancing)loadBalancing2.get()), (Object)((LoadBalancer)loadBalancer2.get()), (Object)amazonErrors.get(), (Object)deployDefaults)), List.class);
        callSiteArray[293].call((Object)((List)existingTargetGroups.get()), (Object)createdTargetGroups);
        callSiteArray[294].callStatic(LoadBalancerV2UpsertHandler.class, ArrayUtil.createArray((Object)targetGroupsToUpdate, (Object)((List)targetGroups2.get()), (Object)((AmazonElasticLoadBalancing)loadBalancing2.get()), (Object)((LoadBalancer)loadBalancer2.get()), (Object)amazonErrors.get()));
        Reference listenerToDefaultActions = new Reference((Object)((Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[295].callConstructor(HashMap.class), Map.class)));
        Reference listenerToRules = new Reference((Object)((Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[296].callConstructor(HashMap.class), Map.class)));
        public final class _updateLoadBalancer_closure18
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference existingTargetGroups;
            private /* synthetic */ Reference amazonErrors;
            private /* synthetic */ Reference listenerToDefaultActions;
            private /* synthetic */ Reference listenerToRules;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _updateLoadBalancer_closure18(Object _outerInstance, Object _thisObject, Reference existingTargetGroups, Reference amazonErrors, Reference listenerToDefaultActions, Reference listenerToRules) {
                Reference reference;
                Reference reference2;
                Reference reference3;
                Reference reference4;
                CallSite[] callSiteArray = _updateLoadBalancer_closure18.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.existingTargetGroups = reference4 = existingTargetGroups;
                this.amazonErrors = reference3 = amazonErrors;
                this.listenerToDefaultActions = reference2 = listenerToDefaultActions;
                this.listenerToRules = reference = listenerToRules;
            }

            public Object doCall(Object listener) {
                CallSite[] callSiteArray = _updateLoadBalancer_closure18.$getCallSiteArray();
                List defaultActions = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[0].callStatic(LoadBalancerV2UpsertHandler.class, callSiteArray[1].callGetProperty(listener), this.existingTargetGroups.get(), this.amazonErrors.get()), List.class);
                callSiteArray[2].call(this.listenerToDefaultActions.get(), listener, (Object)defaultActions);
                Reference rules = new Reference((Object)ScriptBytecodeAdapter.createList((Object[])new Object[0]));
                public final class _closure30
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference existingTargetGroups;
                    private /* synthetic */ Reference amazonErrors;
                    private /* synthetic */ Reference rules;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;
                    private static /* synthetic */ SoftReference $callSiteArray;

                    public _closure30(Object _outerInstance, Object _thisObject, Reference existingTargetGroups, Reference amazonErrors, Reference rules) {
                        Reference reference;
                        Reference reference2;
                        Reference reference3;
                        CallSite[] callSiteArray = _closure30.$getCallSiteArray();
                        super(_outerInstance, _thisObject);
                        this.existingTargetGroups = reference3 = existingTargetGroups;
                        this.amazonErrors = reference2 = amazonErrors;
                        this.rules = reference = rules;
                    }

                    public Object doCall(Object rule) {
                        CallSite[] callSiteArray = _closure30.$getCallSiteArray();
                        List actions = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[0].callStatic(LoadBalancerV2UpsertHandler.class, callSiteArray[1].callGetProperty(rule), this.existingTargetGroups.get(), this.amazonErrors.get()), List.class);
                        public final class _closure31
                        extends Closure
                        implements GeneratedClosure {
                            private static /* synthetic */ ClassInfo $staticClassInfo;
                            public static transient /* synthetic */ boolean __$stMC;
                            private static /* synthetic */ SoftReference $callSiteArray;

                            public _closure31(Object _outerInstance, Object _thisObject) {
                                CallSite[] callSiteArray = _closure31.$getCallSiteArray();
                                super(_outerInstance, _thisObject);
                            }

                            public Object doCall(Object condition) {
                                CallSite[] callSiteArray = _closure31.$getCallSiteArray();
                                if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[0].callGetProperty(condition), (Object)"http-request-method")) {
                                    HttpRequestMethodConditionConfig httpRequestMethodConditionConfig = (HttpRequestMethodConditionConfig)ScriptBytecodeAdapter.castToType((Object)callSiteArray[1].call(callSiteArray[2].callConstructor(HttpRequestMethodConditionConfig.class), callSiteArray[3].callGetProperty(condition)), HttpRequestMethodConditionConfig.class);
                                    return callSiteArray[4].call(callSiteArray[5].call(callSiteArray[6].callConstructor(RuleCondition.class), callSiteArray[7].callGetProperty(condition)), (Object)httpRequestMethodConditionConfig);
                                }
                                return callSiteArray[8].call(callSiteArray[9].call(callSiteArray[10].callConstructor(RuleCondition.class), callSiteArray[11].callGetProperty(condition)), callSiteArray[12].callGetProperty(condition));
                            }

                            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                if (((Object)((Object)this)).getClass() != _closure31.class) {
                                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                }
                                ClassInfo classInfo = $staticClassInfo;
                                if (classInfo == null) {
                                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                }
                                return classInfo.getMetaClass();
                            }

                            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                                stringArray[0] = "field";
                                stringArray[1] = "withValues";
                                stringArray[2] = "<$constructor$>";
                                stringArray[3] = "values";
                                stringArray[4] = "withHttpRequestMethodConfig";
                                stringArray[5] = "withField";
                                stringArray[6] = "<$constructor$>";
                                stringArray[7] = "field";
                                stringArray[8] = "withValues";
                                stringArray[9] = "withField";
                                stringArray[10] = "<$constructor$>";
                                stringArray[11] = "field";
                                stringArray[12] = "values";
                            }

                            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                                String[] stringArray = new String[13];
                                _closure31.$createCallSiteArray_1(stringArray);
                                return new CallSiteArray(_closure31.class, stringArray);
                            }

                            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                                CallSiteArray callSiteArray;
                                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                                    callSiteArray = _closure31.$createCallSiteArray();
                                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                                }
                                return callSiteArray.array;
                            }
                        }
                        List conditions = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[2].call(callSiteArray[3].callGetProperty(rule), (Object)new _closure31((Object)this, this.getThisObject())), List.class);
                        return callSiteArray[4].call(this.rules.get(), callSiteArray[5].call(callSiteArray[6].call(callSiteArray[7].call(callSiteArray[8].callConstructor(Rule.class), (Object)actions), (Object)conditions), callSiteArray[9].callGetProperty(rule)));
                    }

                    @Generated
                    public List getExistingTargetGroups() {
                        CallSite[] callSiteArray = _closure30.$getCallSiteArray();
                        return (List)ScriptBytecodeAdapter.castToType((Object)this.existingTargetGroups.get(), List.class);
                    }

                    @Generated
                    public Object getAmazonErrors() {
                        CallSite[] callSiteArray = _closure30.$getCallSiteArray();
                        return this.amazonErrors.get();
                    }

                    @Generated
                    public List getRules() {
                        CallSite[] callSiteArray = _closure30.$getCallSiteArray();
                        return (List)ScriptBytecodeAdapter.castToType((Object)this.rules.get(), List.class);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure30.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                        stringArray[0] = "getAmazonActionsFromDescription";
                        stringArray[1] = "actions";
                        stringArray[2] = "collect";
                        stringArray[3] = "conditions";
                        stringArray[4] = "add";
                        stringArray[5] = "withPriority";
                        stringArray[6] = "withConditions";
                        stringArray[7] = "withActions";
                        stringArray[8] = "<$constructor$>";
                        stringArray[9] = "priority";
                    }

                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                        String[] stringArray = new String[10];
                        _closure30.$createCallSiteArray_1(stringArray);
                        return new CallSiteArray(_closure30.class, stringArray);
                    }

                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                        CallSiteArray callSiteArray;
                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                            callSiteArray = _closure30.$createCallSiteArray();
                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                        }
                        return callSiteArray.array;
                    }
                }
                callSiteArray[3].call(callSiteArray[4].callGetProperty(listener), (Object)new _closure30((Object)this, this.getThisObject(), this.existingTargetGroups, this.amazonErrors, rules));
                return callSiteArray[5].call(this.listenerToRules.get(), listener, (Object)((List)rules.get()));
            }

            @Generated
            public List getExistingTargetGroups() {
                CallSite[] callSiteArray = _updateLoadBalancer_closure18.$getCallSiteArray();
                return (List)ScriptBytecodeAdapter.castToType((Object)this.existingTargetGroups.get(), List.class);
            }

            @Generated
            public Object getAmazonErrors() {
                CallSite[] callSiteArray = _updateLoadBalancer_closure18.$getCallSiteArray();
                return this.amazonErrors.get();
            }

            @Generated
            public Map getListenerToDefaultActions() {
                CallSite[] callSiteArray = _updateLoadBalancer_closure18.$getCallSiteArray();
                return (Map)ScriptBytecodeAdapter.castToType((Object)this.listenerToDefaultActions.get(), Map.class);
            }

            @Generated
            public Map getListenerToRules() {
                CallSite[] callSiteArray = _updateLoadBalancer_closure18.$getCallSiteArray();
                return (Map)ScriptBytecodeAdapter.castToType((Object)this.listenerToRules.get(), Map.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _updateLoadBalancer_closure18.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "getAmazonActionsFromDescription";
                stringArray[1] = "defaultActions";
                stringArray[2] = "put";
                stringArray[3] = "each";
                stringArray[4] = "rules";
                stringArray[5] = "put";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[6];
                _updateLoadBalancer_closure18.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_updateLoadBalancer_closure18.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _updateLoadBalancer_closure18.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[297].call((Object)((List)listeners2.get()), (Object)new _updateLoadBalancer_closure18(LoadBalancerV2UpsertHandler.class, LoadBalancerV2UpsertHandler.class, existingTargetGroups, amazonErrors, listenerToDefaultActions, listenerToRules));
        public final class _updateLoadBalancer_closure19
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference listeners;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _updateLoadBalancer_closure19(Object _outerInstance, Object _thisObject, Reference listeners) {
                Reference reference;
                CallSite[] callSiteArray = _updateLoadBalancer_closure19.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.listeners = reference = listeners;
            }

            public Object doCall(Object awsListener) {
                Reference awsListener2 = new Reference(awsListener);
                CallSite[] callSiteArray = _updateLoadBalancer_closure19.$getCallSiteArray();
                public final class _closure32
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference awsListener;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;
                    private static /* synthetic */ SoftReference $callSiteArray;

                    public _closure32(Object _outerInstance, Object _thisObject, Reference awsListener) {
                        Reference reference;
                        CallSite[] callSiteArray = _closure32.$getCallSiteArray();
                        super(_outerInstance, _thisObject);
                        this.awsListener = reference = awsListener;
                    }

                    public Object doCall(Object it) {
                        CallSite[] callSiteArray = _closure32.$getCallSiteArray();
                        return ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[0].callGetProperty(it), (Object)callSiteArray[1].callGetProperty(this.awsListener.get()));
                    }

                    @Generated
                    public Object getAwsListener() {
                        CallSite[] callSiteArray = _closure32.$getCallSiteArray();
                        return this.awsListener.get();
                    }

                    @Generated
                    public Object doCall() {
                        CallSite[] callSiteArray = _closure32.$getCallSiteArray();
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure32.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                        stringArray[0] = "port";
                        stringArray[1] = "port";
                    }

                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                        String[] stringArray = new String[2];
                        _closure32.$createCallSiteArray_1(stringArray);
                        return new CallSiteArray(_closure32.class, stringArray);
                    }

                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                        CallSiteArray callSiteArray;
                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                            callSiteArray = _closure32.$createCallSiteArray();
                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                        }
                        return callSiteArray.array;
                    }
                }
                return ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[0].call(this.listeners.get(), (Object)new _closure32((Object)this, this.getThisObject(), awsListener2)), null);
            }

            @Generated
            public List getListeners() {
                CallSite[] callSiteArray = _updateLoadBalancer_closure19.$getCallSiteArray();
                return (List)ScriptBytecodeAdapter.castToType((Object)this.listeners.get(), List.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _updateLoadBalancer_closure19.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "find";
                return new CallSiteArray(_updateLoadBalancer_closure19.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _updateLoadBalancer_closure19.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        List listenersSplit = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[298].call((Object)((List)existingListeners.get()), (Object)new _updateLoadBalancer_closure19(LoadBalancerV2UpsertHandler.class, LoadBalancerV2UpsertHandler.class, listeners2)), List.class);
        Object object2 = callSiteArray[299].call((Object)listenersSplit, (Object)0);
        listenersToRemove = (List)ScriptBytecodeAdapter.castToType((Object)object2, List.class);
        List listenersToUpdate = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[300].call((Object)listenersSplit, (Object)1), List.class);
        public final class _updateLoadBalancer_closure20
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference existingListeners;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _updateLoadBalancer_closure20(Object _outerInstance, Object _thisObject, Reference existingListeners) {
                Reference reference;
                CallSite[] callSiteArray = _updateLoadBalancer_closure20.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.existingListeners = reference = existingListeners;
            }

            public Object doCall(Object listener) {
                Reference listener2 = new Reference(listener);
                CallSite[] callSiteArray = _updateLoadBalancer_closure20.$getCallSiteArray();
                public final class _closure33
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference listener;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;
                    private static /* synthetic */ SoftReference $callSiteArray;

                    public _closure33(Object _outerInstance, Object _thisObject, Reference listener) {
                        Reference reference;
                        CallSite[] callSiteArray = _closure33.$getCallSiteArray();
                        super(_outerInstance, _thisObject);
                        this.listener = reference = listener;
                    }

                    public Object doCall(Object it) {
                        CallSite[] callSiteArray = _closure33.$getCallSiteArray();
                        return ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[0].callGetProperty(it), (Object)callSiteArray[1].callGetProperty(this.listener.get()));
                    }

                    @Generated
                    public Object getListener() {
                        CallSite[] callSiteArray = _closure33.$getCallSiteArray();
                        return this.listener.get();
                    }

                    @Generated
                    public Object doCall() {
                        CallSite[] callSiteArray = _closure33.$getCallSiteArray();
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure33.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                        stringArray[0] = "port";
                        stringArray[1] = "port";
                    }

                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                        String[] stringArray = new String[2];
                        _closure33.$createCallSiteArray_1(stringArray);
                        return new CallSiteArray(_closure33.class, stringArray);
                    }

                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                        CallSiteArray callSiteArray;
                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                            callSiteArray = _closure33.$createCallSiteArray();
                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                        }
                        return callSiteArray.array;
                    }
                }
                return ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[0].call(this.existingListeners.get(), (Object)new _closure33((Object)this, this.getThisObject(), listener2)), null);
            }

            @Generated
            public List getExistingListeners() {
                CallSite[] callSiteArray = _updateLoadBalancer_closure20.$getCallSiteArray();
                return (List)ScriptBytecodeAdapter.castToType((Object)this.existingListeners.get(), List.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _updateLoadBalancer_closure20.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "find";
                return new CallSiteArray(_updateLoadBalancer_closure20.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _updateLoadBalancer_closure20.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        List listenersToCreate = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[301].call((Object)((List)listeners2.get()), (Object)new _updateLoadBalancer_closure20(LoadBalancerV2UpsertHandler.class, LoadBalancerV2UpsertHandler.class, existingListeners)), List.class);
        public final class _updateLoadBalancer_closure21
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference listenerToDefaultActions;
            private /* synthetic */ Reference listenerToRules;
            private /* synthetic */ Reference loadBalancing;
            private /* synthetic */ Reference loadBalancer;
            private /* synthetic */ Reference amazonErrors;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _updateLoadBalancer_closure21(Object _outerInstance, Object _thisObject, Reference listenerToDefaultActions, Reference listenerToRules, Reference loadBalancing, Reference loadBalancer, Reference amazonErrors) {
                Reference reference;
                Reference reference2;
                Reference reference3;
                Reference reference4;
                Reference reference5;
                CallSite[] callSiteArray = _updateLoadBalancer_closure21.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.listenerToDefaultActions = reference5 = listenerToDefaultActions;
                this.listenerToRules = reference4 = listenerToRules;
                this.loadBalancing = reference3 = loadBalancing;
                this.loadBalancer = reference2 = loadBalancer;
                this.amazonErrors = reference = amazonErrors;
            }

            public Object doCall(UpsertAmazonLoadBalancerV2Description.Listener listener) {
                CallSite[] callSiteArray = _updateLoadBalancer_closure21.$getCallSiteArray();
                return callSiteArray[0].callStatic(LoadBalancerV2UpsertHandler.class, ArrayUtil.createArray((Object)listener, (Object)callSiteArray[1].call(this.listenerToDefaultActions.get(), (Object)listener), (Object)callSiteArray[2].call(this.listenerToRules.get(), (Object)listener), (Object)this.loadBalancing.get(), (Object)this.loadBalancer.get(), (Object)this.amazonErrors.get()));
            }

            public Object call(UpsertAmazonLoadBalancerV2Description.Listener listener) {
                CallSite[] callSiteArray = _updateLoadBalancer_closure21.$getCallSiteArray();
                return callSiteArray[3].callCurrent((GroovyObject)this, (Object)listener);
            }

            @Generated
            public Map getListenerToDefaultActions() {
                CallSite[] callSiteArray = _updateLoadBalancer_closure21.$getCallSiteArray();
                return (Map)ScriptBytecodeAdapter.castToType((Object)this.listenerToDefaultActions.get(), Map.class);
            }

            @Generated
            public Map getListenerToRules() {
                CallSite[] callSiteArray = _updateLoadBalancer_closure21.$getCallSiteArray();
                return (Map)ScriptBytecodeAdapter.castToType((Object)this.listenerToRules.get(), Map.class);
            }

            @Generated
            public AmazonElasticLoadBalancing getLoadBalancing() {
                CallSite[] callSiteArray = _updateLoadBalancer_closure21.$getCallSiteArray();
                return (AmazonElasticLoadBalancing)ScriptBytecodeAdapter.castToType((Object)this.loadBalancing.get(), AmazonElasticLoadBalancing.class);
            }

            @Generated
            public LoadBalancer getLoadBalancer() {
                CallSite[] callSiteArray = _updateLoadBalancer_closure21.$getCallSiteArray();
                return (LoadBalancer)ScriptBytecodeAdapter.castToType((Object)this.loadBalancer.get(), LoadBalancer.class);
            }

            @Generated
            public Object getAmazonErrors() {
                CallSite[] callSiteArray = _updateLoadBalancer_closure21.$getCallSiteArray();
                return this.amazonErrors.get();
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _updateLoadBalancer_closure21.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "createListener";
                stringArray[1] = "get";
                stringArray[2] = "get";
                stringArray[3] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[4];
                _updateLoadBalancer_closure21.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_updateLoadBalancer_closure21.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _updateLoadBalancer_closure21.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[302].call((Object)listenersToCreate, (Object)new _updateLoadBalancer_closure21(LoadBalancerV2UpsertHandler.class, LoadBalancerV2UpsertHandler.class, listenerToDefaultActions, listenerToRules, loadBalancing2, loadBalancer2, amazonErrors));
        public final class _updateLoadBalancer_closure22
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference listeners;
            private /* synthetic */ Reference listenerToDefaultActions;
            private /* synthetic */ Reference existingListenerToRules;
            private /* synthetic */ Reference listenerToRules;
            private /* synthetic */ Reference loadBalancing;
            private /* synthetic */ Reference amazonErrors;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _updateLoadBalancer_closure22(Object _outerInstance, Object _thisObject, Reference listeners, Reference listenerToDefaultActions, Reference existingListenerToRules, Reference listenerToRules, Reference loadBalancing, Reference amazonErrors) {
                Reference reference;
                Reference reference2;
                Reference reference3;
                Reference reference4;
                Reference reference5;
                Reference reference6;
                CallSite[] callSiteArray = _updateLoadBalancer_closure22.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.listeners = reference6 = listeners;
                this.listenerToDefaultActions = reference5 = listenerToDefaultActions;
                this.existingListenerToRules = reference4 = existingListenerToRules;
                this.listenerToRules = reference3 = listenerToRules;
                this.loadBalancing = reference2 = loadBalancing;
                this.amazonErrors = reference = amazonErrors;
            }

            public Object doCall(Object listener) {
                Reference listener2 = new Reference(listener);
                CallSite[] callSiteArray = _updateLoadBalancer_closure22.$getCallSiteArray();
                public final class _closure34
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference listener;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;
                    private static /* synthetic */ SoftReference $callSiteArray;

                    public _closure34(Object _outerInstance, Object _thisObject, Reference listener) {
                        Reference reference;
                        CallSite[] callSiteArray = _closure34.$getCallSiteArray();
                        super(_outerInstance, _thisObject);
                        this.listener = reference = listener;
                    }

                    public Object doCall(Object it) {
                        CallSite[] callSiteArray = _closure34.$getCallSiteArray();
                        return ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[0].callGetProperty(it), (Object)callSiteArray[1].callGetProperty(this.listener.get()));
                    }

                    @Generated
                    public Object getListener() {
                        CallSite[] callSiteArray = _closure34.$getCallSiteArray();
                        return this.listener.get();
                    }

                    @Generated
                    public Object doCall() {
                        CallSite[] callSiteArray = _closure34.$getCallSiteArray();
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure34.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                        stringArray[0] = "port";
                        stringArray[1] = "port";
                    }

                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                        String[] stringArray = new String[2];
                        _closure34.$createCallSiteArray_1(stringArray);
                        return new CallSiteArray(_closure34.class, stringArray);
                    }

                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                        CallSiteArray callSiteArray;
                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                            callSiteArray = _closure34.$createCallSiteArray();
                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                        }
                        return callSiteArray.array;
                    }
                }
                UpsertAmazonLoadBalancerV2Description.Listener updatedListener = (UpsertAmazonLoadBalancerV2Description.Listener)ScriptBytecodeAdapter.castToType((Object)callSiteArray[0].call(this.listeners.get(), (Object)new _closure34((Object)this, this.getThisObject(), listener2)), UpsertAmazonLoadBalancerV2Description.Listener.class);
                public final class _closure35
                extends Closure
                implements GeneratedClosure {
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;
                    private static /* synthetic */ SoftReference $callSiteArray;

                    public _closure35(Object _outerInstance, Object _thisObject) {
                        CallSite[] callSiteArray = _closure35.$getCallSiteArray();
                        super(_outerInstance, _thisObject);
                    }

                    public Object doCall(Object it) {
                        CallSite[] callSiteArray = _closure35.$getCallSiteArray();
                        return !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[0].callGetProperty(it));
                    }

                    @Generated
                    public Object doCall() {
                        CallSite[] callSiteArray = _closure35.$getCallSiteArray();
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure35.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                        String[] stringArray = new String[1];
                        stringArray[0] = "isDefault";
                        return new CallSiteArray(_closure35.class, stringArray);
                    }

                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                        CallSiteArray callSiteArray;
                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                            callSiteArray = _closure35.$createCallSiteArray();
                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                        }
                        return callSiteArray.array;
                    }
                }
                return callSiteArray[1].callStatic(LoadBalancerV2UpsertHandler.class, ArrayUtil.createArray((Object)callSiteArray[2].callGetProperty(listener2.get()), (Object)updatedListener, (Object)callSiteArray[3].call(this.listenerToDefaultActions.get(), (Object)updatedListener), (Object)callSiteArray[4].call(callSiteArray[5].call(this.existingListenerToRules.get(), listener2.get()), (Object)new _closure35((Object)this, this.getThisObject())), (Object)callSiteArray[6].call(this.listenerToRules.get(), (Object)updatedListener), (Object)this.loadBalancing.get(), (Object)this.amazonErrors.get()));
            }

            @Generated
            public List getListeners() {
                CallSite[] callSiteArray = _updateLoadBalancer_closure22.$getCallSiteArray();
                return (List)ScriptBytecodeAdapter.castToType((Object)this.listeners.get(), List.class);
            }

            @Generated
            public Map getListenerToDefaultActions() {
                CallSite[] callSiteArray = _updateLoadBalancer_closure22.$getCallSiteArray();
                return (Map)ScriptBytecodeAdapter.castToType((Object)this.listenerToDefaultActions.get(), Map.class);
            }

            @Generated
            public Map getExistingListenerToRules() {
                CallSite[] callSiteArray = _updateLoadBalancer_closure22.$getCallSiteArray();
                return (Map)ScriptBytecodeAdapter.castToType((Object)this.existingListenerToRules.get(), Map.class);
            }

            @Generated
            public Map getListenerToRules() {
                CallSite[] callSiteArray = _updateLoadBalancer_closure22.$getCallSiteArray();
                return (Map)ScriptBytecodeAdapter.castToType((Object)this.listenerToRules.get(), Map.class);
            }

            @Generated
            public AmazonElasticLoadBalancing getLoadBalancing() {
                CallSite[] callSiteArray = _updateLoadBalancer_closure22.$getCallSiteArray();
                return (AmazonElasticLoadBalancing)ScriptBytecodeAdapter.castToType((Object)this.loadBalancing.get(), AmazonElasticLoadBalancing.class);
            }

            @Generated
            public Object getAmazonErrors() {
                CallSite[] callSiteArray = _updateLoadBalancer_closure22.$getCallSiteArray();
                return this.amazonErrors.get();
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _updateLoadBalancer_closure22.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "find";
                stringArray[1] = "updateListener";
                stringArray[2] = "listenerArn";
                stringArray[3] = "get";
                stringArray[4] = "findAll";
                stringArray[5] = "get";
                stringArray[6] = "get";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[7];
                _updateLoadBalancer_closure22.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_updateLoadBalancer_closure22.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _updateLoadBalancer_closure22.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[303].call((Object)listenersToUpdate, (Object)new _updateLoadBalancer_closure22(LoadBalancerV2UpsertHandler.class, LoadBalancerV2UpsertHandler.class, listeners2, listenerToDefaultActions, existingListenerToRules, listenerToRules, loadBalancing2, amazonErrors));
        if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[304].call(amazonErrors.get()), (Object)0)) {
            callSiteArray[305].callStatic(LoadBalancerV2UpsertHandler.class, (Object)listenersToRemove, (Object)((List)existingListeners.get()), (Object)((AmazonElasticLoadBalancing)loadBalancing2.get()), (Object)((LoadBalancer)loadBalancer2.get()));
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)amazonErrors.get()) && ScriptBytecodeAdapter.compareGreaterThan((Object)callSiteArray[306].call(amazonErrors.get()), (Object)0)) {
            throw (Throwable)callSiteArray[307].callConstructor(AtomicOperationException.class, (Object)"Failed to apply all load balancer updates", amazonErrors.get());
        }
    }

    public static LoadBalancer createLoadBalancer(AmazonElasticLoadBalancing loadBalancing, String loadBalancerName, boolean isInternal, Collection<String> subnetIds, Collection<String> securityGroups, List<UpsertAmazonLoadBalancerV2Description.TargetGroup> targetGroups, List<UpsertAmazonLoadBalancerV2Description.Listener> listeners, AwsConfiguration.DeployDefaults deployDefaults, String type, Integer idleTimeout, boolean deletionProtection, boolean loadBalancingCrossZone, String ipAddressType) {
        CallSite[] callSiteArray = LoadBalancerV2UpsertHandler.$getCallSiteArray();
        Object request = callSiteArray[308].call(callSiteArray[309].callConstructor(CreateLoadBalancerRequest.class), (Object)loadBalancerName);
        if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (DefaultTypeTransformation.booleanUnbox((Object)ipAddressType) && (ScriptBytecodeAdapter.compareEqual((Object)type, (Object)"application") || ScriptBytecodeAdapter.compareEqual((Object)type, (Object)"network"))) {
                String addressType = isInternal ? "ipv4" : ipAddressType;
                callSiteArray[310].call(request, (Object)addressType);
            }
        } else if (DefaultTypeTransformation.booleanUnbox((Object)ipAddressType) && (ScriptBytecodeAdapter.compareEqual((Object)type, (Object)"application") || ScriptBytecodeAdapter.compareEqual((Object)type, (Object)"network"))) {
            String addressType = isInternal ? "ipv4" : ipAddressType;
            callSiteArray[311].call(request, (Object)addressType);
        }
        if (DefaultTypeTransformation.booleanUnbox(subnetIds)) {
            callSiteArray[312].call(callSiteArray[313].callGetProperty(LoadBalancerV2UpsertHandler.class), (Object)BASE_PHASE, (Object)new GStringImpl(new Object[]{subnetIds}, new String[]{"Subnets: [", "]"}));
            callSiteArray[314].call(request, subnetIds);
            if (isInternal) {
                String string = "internal";
                ScriptBytecodeAdapter.setProperty((Object)string, null, (Object)request, (String)"scheme");
            }
            if (ScriptBytecodeAdapter.compareEqual((Object)type, (Object)"application")) {
                callSiteArray[315].call(request, securityGroups);
            }
        }
        if (ScriptBytecodeAdapter.compareEqual((Object)type, (Object)"network")) {
            callSiteArray[316].call(request, callSiteArray[317].callGetProperty(LoadBalancerTypeEnum.class));
        } else {
            callSiteArray[318].call(request, callSiteArray[319].callGetProperty(LoadBalancerTypeEnum.class));
        }
        callSiteArray[320].call(callSiteArray[321].callGetProperty(LoadBalancerV2UpsertHandler.class), (Object)BASE_PHASE, (Object)"Creating load balancer.");
        Object result = null;
        try {
            Object object;
            result = object = callSiteArray[322].call((Object)loadBalancing, request);
        }
        catch (AmazonServiceException e) {
            callSiteArray[323].call((Object)log, (Object)"Failed to create load balancer", (Object)e);
            throw (Throwable)callSiteArray[324].callConstructor(AtomicOperationException.class, (Object)"Failed to create load balancer.", (Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{callSiteArray[325].call((Object)e)}));
        }
        LoadBalancer createdLoadBalancer = null;
        List loadBalancers = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[326].call(result), List.class);
        if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (ScriptBytecodeAdapter.compareNotEqual((Object)loadBalancers, null) && ScriptBytecodeAdapter.compareGreaterThan((Object)callSiteArray[327].call((Object)loadBalancers), (Object)0)) {
                Object object = callSiteArray[328].call((Object)loadBalancers, (Object)0);
                createdLoadBalancer = (LoadBalancer)ScriptBytecodeAdapter.castToType((Object)object, LoadBalancer.class);
                callSiteArray[329].callStatic(LoadBalancerV2UpsertHandler.class, ArrayUtil.createArray((Object)loadBalancing, (Object)createdLoadBalancer, securityGroups, targetGroups, listeners, (Object)deployDefaults, (Object)idleTimeout, (Object)deletionProtection, (Object)loadBalancingCrossZone, (Object)ipAddressType));
            }
        } else if (ScriptBytecodeAdapter.compareNotEqual((Object)loadBalancers, null) && ScriptBytecodeAdapter.compareGreaterThan((Object)callSiteArray[330].call((Object)loadBalancers), (Object)0)) {
            Object object = callSiteArray[331].call((Object)loadBalancers, (Object)0);
            createdLoadBalancer = (LoadBalancer)ScriptBytecodeAdapter.castToType((Object)object, LoadBalancer.class);
            callSiteArray[332].callStatic(LoadBalancerV2UpsertHandler.class, ArrayUtil.createArray((Object)loadBalancing, (Object)createdLoadBalancer, securityGroups, targetGroups, listeners, (Object)deployDefaults, (Object)idleTimeout, (Object)deletionProtection, (Object)loadBalancingCrossZone, (Object)ipAddressType));
        }
        return createdLoadBalancer;
    }

    private static String handleError(String message, Exception e) {
        CallSite[] callSiteArray = LoadBalancerV2UpsertHandler.$getCallSiteArray();
        callSiteArray[333].call((Object)log, (Object)message, (Object)e);
        callSiteArray[334].call(callSiteArray[335].callGetProperty(LoadBalancerV2UpsertHandler.class), (Object)BASE_PHASE, (Object)message);
        return message;
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != LoadBalancerV2UpsertHandler.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Generated
    @Internal
    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    @Generated
    @Internal
    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    static {
        boolean bl = false;
        MULTI_VALUE_HEADERS_ENABLED = bl;
        boolean bl2 = false;
        CONNECTION_TERMINATION = bl2;
        boolean bl3 = false;
        PROXY_PROTOCOL_V2 = bl3;
        boolean bl4 = false;
        STICKINESS_ENABLED = bl4;
        Object object = LoadBalancerV2UpsertHandler.$getCallSiteArray()[336].call(LoggerFactory.class, (Object)"com.netflix.spinnaker.clouddriver.aws.deploy.handlers.LoadBalancerV2UpsertHandler");
        log = (Logger)ScriptBytecodeAdapter.castToType((Object)object, Logger.class);
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "get";
        stringArray[1] = "threadLocalTask";
        stringArray[2] = "isInfoEnabled";
        stringArray[3] = "info";
        stringArray[4] = "targetGroupName";
        stringArray[5] = "equalsIgnoreCase";
        stringArray[6] = "toString";
        stringArray[7] = "Lambda";
        stringArray[8] = "getTargetType";
        stringArray[9] = "multiValueHeadersEnabled";
        stringArray[10] = "add";
        stringArray[11] = "<$constructor$>";
        stringArray[12] = "findResult";
        stringArray[13] = "deregistrationDelay";
        stringArray[14] = "deregistrationDelayDefault";
        stringArray[15] = "loadBalancing";
        stringArray[16] = "IDENTITY";
        stringArray[17] = "toString";
        stringArray[18] = "add";
        stringArray[19] = "<$constructor$>";
        stringArray[20] = "type";
        stringArray[21] = "toString";
        stringArray[22] = "stickinessEnabled";
        stringArray[23] = "add";
        stringArray[24] = "<$constructor$>";
        stringArray[25] = "stickinessType";
        stringArray[26] = "add";
        stringArray[27] = "<$constructor$>";
        stringArray[28] = "toString";
        stringArray[29] = "stickinessDuration";
        stringArray[30] = "add";
        stringArray[31] = "<$constructor$>";
        stringArray[32] = "type";
        stringArray[33] = "proxyProtocolV2";
        stringArray[34] = "add";
        stringArray[35] = "<$constructor$>";
        stringArray[36] = "deregistrationDelayConnectionTermination";
        stringArray[37] = "add";
        stringArray[38] = "<$constructor$>";
        stringArray[39] = "updateTargetGroupAttributes";
        stringArray[40] = "isInfoEnabled";
        stringArray[41] = "info";
        stringArray[42] = "targetGroupName";
        stringArray[43] = "equalsIgnoreCase";
        stringArray[44] = "toString";
        stringArray[45] = "Lambda";
        stringArray[46] = "getTargetType";
        stringArray[47] = "multiValueHeadersEnabled";
        stringArray[48] = "add";
        stringArray[49] = "<$constructor$>";
        stringArray[50] = "multiValueHeadersEnabled";
        stringArray[51] = "findResult";
        stringArray[52] = "deregistrationDelay";
        stringArray[53] = "deregistrationDelayDefault";
        stringArray[54] = "loadBalancing";
        stringArray[55] = "IDENTITY";
        stringArray[56] = "add";
        stringArray[57] = "<$constructor$>";
        stringArray[58] = "toString";
        stringArray[59] = "type";
        stringArray[60] = "stickinessEnabled";
        stringArray[61] = "add";
        stringArray[62] = "<$constructor$>";
        stringArray[63] = "toString";
        stringArray[64] = "stickinessEnabled";
        stringArray[65] = "stickinessType";
        stringArray[66] = "add";
        stringArray[67] = "<$constructor$>";
        stringArray[68] = "stickinessType";
        stringArray[69] = "stickinessDuration";
        stringArray[70] = "add";
        stringArray[71] = "<$constructor$>";
        stringArray[72] = "toString";
        stringArray[73] = "stickinessDuration";
        stringArray[74] = "type";
        stringArray[75] = "proxyProtocolV2";
        stringArray[76] = "add";
        stringArray[77] = "<$constructor$>";
        stringArray[78] = "proxyProtocolV2";
        stringArray[79] = "deregistrationDelayConnectionTermination";
        stringArray[80] = "add";
        stringArray[81] = "<$constructor$>";
        stringArray[82] = "deregistrationDelayConnectionTermination";
        stringArray[83] = "updateTargetGroupAttributes";
        stringArray[84] = "isEmpty";
        stringArray[85] = "modifyTargetGroupAttributes";
        stringArray[86] = "withAttributes";
        stringArray[87] = "withTargetGroupArn";
        stringArray[88] = "<$constructor$>";
        stringArray[89] = "targetGroupArn";
        stringArray[90] = "updateStatus";
        stringArray[91] = "task";
        stringArray[92] = "targetGroupName";
        stringArray[93] = "handleError";
        stringArray[94] = "targetGroupName";
        stringArray[95] = "toString";
        stringArray[96] = "loadBalancerName";
        stringArray[97] = "<$constructor$>";
        stringArray[98] = "each";
        stringArray[99] = "<$constructor$>";
        stringArray[100] = "each";
        stringArray[101] = "each";
        stringArray[102] = "createListener";
        stringArray[103] = "withDefaultActions";
        stringArray[104] = "withSslPolicy";
        stringArray[105] = "withCertificates";
        stringArray[106] = "withProtocol";
        stringArray[107] = "withPort";
        stringArray[108] = "withLoadBalancerArn";
        stringArray[109] = "<$constructor$>";
        stringArray[110] = "loadBalancerArn";
        stringArray[111] = "port";
        stringArray[112] = "protocol";
        stringArray[113] = "certificates";
        stringArray[114] = "sslPolicy";
        stringArray[115] = "updateStatus";
        stringArray[116] = "task";
        stringArray[117] = "loadBalancerName";
        stringArray[118] = "port";
        stringArray[119] = "protocol";
        stringArray[120] = "leftShift";
        stringArray[121] = "handleError";
        stringArray[122] = "loadBalancerName";
        stringArray[123] = "port";
        stringArray[124] = "protocol";
        stringArray[125] = "toString";
        stringArray[126] = "size";
        stringArray[127] = "listeners";
        stringArray[128] = "listenerArn";
        stringArray[129] = "get";
        stringArray[130] = "listeners";
        stringArray[131] = "each";
        stringArray[132] = "leftShift";
        stringArray[133] = "handleError";
        stringArray[134] = "loadBalancerName";
        stringArray[135] = "port";
        stringArray[136] = "protocol";
        stringArray[137] = "toString";
        stringArray[138] = "size";
        stringArray[139] = "listeners";
        stringArray[140] = "listenerArn";
        stringArray[141] = "get";
        stringArray[142] = "listeners";
        stringArray[143] = "each";
        stringArray[144] = "leftShift";
        stringArray[145] = "handleError";
        stringArray[146] = "loadBalancerName";
        stringArray[147] = "port";
        stringArray[148] = "protocol";
        stringArray[149] = "toString";
        stringArray[150] = "any";
        stringArray[151] = "modifyListener";
        stringArray[152] = "withDefaultActions";
        stringArray[153] = "withSslPolicy";
        stringArray[154] = "withCertificates";
        stringArray[155] = "withProtocol";
        stringArray[156] = "withListenerArn";
        stringArray[157] = "<$constructor$>";
        stringArray[158] = "protocol";
        stringArray[159] = "certificates";
        stringArray[160] = "sslPolicy";
        stringArray[161] = "updateStatus";
        stringArray[162] = "task";
        stringArray[163] = "port";
        stringArray[164] = "protocol";
        stringArray[165] = "leftShift";
        stringArray[166] = "handleError";
        stringArray[167] = "port";
        stringArray[168] = "protocol";
        stringArray[169] = "toString";
        stringArray[170] = "size";
        stringArray[171] = "size";
        stringArray[172] = "containsAllRules";
        stringArray[173] = "containsAllRules";
        stringArray[174] = "size";
        stringArray[175] = "size";
        stringArray[176] = "containsAllRules";
        stringArray[177] = "containsAllRules";
        stringArray[178] = "each";
        stringArray[179] = "each";
        stringArray[180] = "each";
        stringArray[181] = "eachWithIndex";
        stringArray[182] = "loadBalancerName";
        stringArray[183] = "loadBalancerArn";
        stringArray[184] = "getType";
        stringArray[185] = "vpcId";
        stringArray[186] = "<$constructor$>";
        stringArray[187] = "setSecurityGroups";
        stringArray[188] = "<$constructor$>";
        stringArray[189] = "updateStatus";
        stringArray[190] = "task";
        stringArray[191] = "ipAddressType";
        stringArray[192] = "type";
        stringArray[193] = "type";
        stringArray[194] = "scheme";
        stringArray[195] = "setIpAddressType";
        stringArray[196] = "<$constructor$>";
        stringArray[197] = "updateStatus";
        stringArray[198] = "task";
        stringArray[199] = "type";
        stringArray[200] = "type";
        stringArray[201] = "scheme";
        stringArray[202] = "setIpAddressType";
        stringArray[203] = "<$constructor$>";
        stringArray[204] = "updateStatus";
        stringArray[205] = "task";
        stringArray[206] = "attributes";
        stringArray[207] = "describeLoadBalancerAttributes";
        stringArray[208] = "withLoadBalancerArn";
        stringArray[209] = "<$constructor$>";
        stringArray[210] = "type";
        stringArray[211] = "getValue";
        stringArray[212] = "find";
        stringArray[213] = "toString";
        stringArray[214] = "findResult";
        stringArray[215] = "idleTimeout";
        stringArray[216] = "loadBalancing";
        stringArray[217] = "IDENTITY";
        stringArray[218] = "updateStatus";
        stringArray[219] = "task";
        stringArray[220] = "add";
        stringArray[221] = "withValue";
        stringArray[222] = "withKey";
        stringArray[223] = "<$constructor$>";
        stringArray[224] = "getValue";
        stringArray[225] = "find";
        stringArray[226] = "toString";
        stringArray[227] = "findResult";
        stringArray[228] = "deletionProtection";
        stringArray[229] = "loadBalancing";
        stringArray[230] = "FALSE";
        stringArray[231] = "IDENTITY";
        stringArray[232] = "updateStatus";
        stringArray[233] = "task";
        stringArray[234] = "add";
        stringArray[235] = "withValue";
        stringArray[236] = "withKey";
        stringArray[237] = "<$constructor$>";
        stringArray[238] = "type";
        stringArray[239] = "getValue";
        stringArray[240] = "find";
        stringArray[241] = "toString";
        stringArray[242] = "findResult";
        stringArray[243] = "crossZoneBalancingDefault";
        stringArray[244] = "loadBalancing";
        stringArray[245] = "TRUE";
        stringArray[246] = "IDENTITY";
        stringArray[247] = "updateStatus";
        stringArray[248] = "task";
        stringArray[249] = "add";
        stringArray[250] = "withValue";
        stringArray[251] = "withKey";
        stringArray[252] = "<$constructor$>";
        stringArray[253] = "type";
        stringArray[254] = "getValue";
        stringArray[255] = "find";
        stringArray[256] = "toString";
        stringArray[257] = "findResult";
        stringArray[258] = "crossZoneBalancingDefault";
        stringArray[259] = "loadBalancing";
        stringArray[260] = "TRUE";
        stringArray[261] = "IDENTITY";
        stringArray[262] = "updateStatus";
        stringArray[263] = "task";
        stringArray[264] = "add";
        stringArray[265] = "withValue";
        stringArray[266] = "withKey";
        stringArray[267] = "<$constructor$>";
        stringArray[268] = "isEmpty";
        stringArray[269] = "modifyLoadBalancerAttributes";
        stringArray[270] = "withAttributes";
        stringArray[271] = "withLoadBalancerArn";
        stringArray[272] = "<$constructor$>";
        stringArray[273] = "targetGroups";
        stringArray[274] = "describeTargetGroups";
        stringArray[275] = "withLoadBalancerArn";
        stringArray[276] = "<$constructor$>";
        stringArray[277] = "loadBalancerArn";
        stringArray[278] = "listeners";
        stringArray[279] = "describeListeners";
        stringArray[280] = "withLoadBalancerArn";
        stringArray[281] = "<$constructor$>";
        stringArray[282] = "collectEntries";
        stringArray[283] = "split";
        stringArray[284] = "getAt";
        stringArray[285] = "getAt";
        stringArray[286] = "collect";
        stringArray[287] = "findAll";
        stringArray[288] = "findAll";
        stringArray[289] = "removeListeners";
        stringArray[290] = "removeTargetGroups";
        stringArray[291] = "removeAll";
        stringArray[292] = "createTargetGroups";
        stringArray[293] = "addAll";
        stringArray[294] = "updateTargetGroups";
        stringArray[295] = "<$constructor$>";
        stringArray[296] = "<$constructor$>";
        stringArray[297] = "each";
        stringArray[298] = "split";
        stringArray[299] = "getAt";
        stringArray[300] = "getAt";
        stringArray[301] = "findAll";
        stringArray[302] = "each";
        stringArray[303] = "each";
        stringArray[304] = "size";
        stringArray[305] = "removeListeners";
        stringArray[306] = "size";
        stringArray[307] = "<$constructor$>";
        stringArray[308] = "withName";
        stringArray[309] = "<$constructor$>";
        stringArray[310] = "withIpAddressType";
        stringArray[311] = "withIpAddressType";
        stringArray[312] = "updateStatus";
        stringArray[313] = "task";
        stringArray[314] = "withSubnets";
        stringArray[315] = "withSecurityGroups";
        stringArray[316] = "setType";
        stringArray[317] = "Network";
        stringArray[318] = "setType";
        stringArray[319] = "Application";
        stringArray[320] = "updateStatus";
        stringArray[321] = "task";
        stringArray[322] = "createLoadBalancer";
        stringArray[323] = "error";
        stringArray[324] = "<$constructor$>";
        stringArray[325] = "toString";
        stringArray[326] = "getLoadBalancers";
        stringArray[327] = "size";
        stringArray[328] = "get";
        stringArray[329] = "updateLoadBalancer";
        stringArray[330] = "size";
        stringArray[331] = "get";
        stringArray[332] = "updateLoadBalancer";
        stringArray[333] = "error";
        stringArray[334] = "updateStatus";
        stringArray[335] = "task";
        stringArray[336] = "getLogger";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[337];
        LoadBalancerV2UpsertHandler.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(LoadBalancerV2UpsertHandler.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = LoadBalancerV2UpsertHandler.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

