/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.aws.model;

import com.amazonaws.services.ec2.model.LaunchTemplateInstanceNetworkInterfaceSpecificationRequest;
import com.amazonaws.services.ec2.model.RequestLaunchTemplateData;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.netflix.spinnaker.clouddriver.aws.AmazonCloudProvider;
import com.netflix.spinnaker.clouddriver.model.HealthState;
import com.netflix.spinnaker.clouddriver.model.Instance;
import com.netflix.spinnaker.clouddriver.model.ServerGroup;
import com.netflix.spinnaker.kork.annotations.Alpha;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;

public class AmazonServerGroup
implements ServerGroup,
Serializable,
GroovyObject {
    private String name;
    private String region;
    private Set<String> zones;
    private Set<Instance> instances;
    private Set health;
    private Map<String, Object> image;
    private Map<String, Object> launchConfig;
    private Map<String, Object> launchTemplate;
    @Alpha
    private MixedInstancesPolicySettings mixedInstancesPolicy;
    private Map<String, Object> asg;
    private List<Map> scalingPolicies;
    private List<Map> scheduledActions;
    private Map buildInfo;
    private String vpcId;
    private final String type;
    private final String cloudProvider;
    private Set<String> targetGroups;
    @JsonIgnore
    private Map<String, Object> extraAttributes;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    @Generated
    public AmazonServerGroup() {
        MetaClass metaClass;
        String string;
        String string2;
        this.type = string2 = AmazonCloudProvider.ID;
        this.cloudProvider = string = AmazonCloudProvider.ID;
        LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
        this.extraAttributes = linkedHashMap;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    @JsonAnyGetter
    public Map<String, Object> getExtraAttributes() {
        return this.extraAttributes;
    }

    @JsonAnySetter
    public void set(String name, Object value) {
        this.extraAttributes.put(name, value);
    }

    public Boolean isDisabled() {
        if (DefaultTypeTransformation.booleanUnbox(this.asg)) {
            List suspendedProcesses = (List)ScriptBytecodeAdapter.castToType((Object)this.asg.get("suspendedProcesses"), List.class);
            public final class _isDisabled_closure1
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _isDisabled_closure1(Object _outerInstance, Object _thisObject) {
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(Object it) {
                    return it.get("processName");
                }

                public Object call(Object args) {
                    return this.doCall(args);
                }

                public Object call() {
                    return this.doCall(null);
                }

                @Generated
                public Object doCall() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _isDisabled_closure1.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }
            }
            List processNames = DefaultGroovyMethods.collect((Iterable)suspendedProcesses, (Closure)new _isDisabled_closure1(this, this));
            return processNames.contains("AddToLoadBalancer");
        }
        return false;
    }

    public Long getCreatedTime() {
        if (!DefaultTypeTransformation.booleanUnbox(this.asg)) {
            return (Long)ScriptBytecodeAdapter.castToType(null, Long.class);
        }
        return (Long)ScriptBytecodeAdapter.castToType((Object)this.asg.get("createdTime"), Long.class);
    }

    public Set<String> getLoadBalancers() {
        Set loadBalancerNames = (Set)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.createList((Object[])new Object[0]), Set.class);
        Map<String, Object> asg = this.getAsg();
        if (DefaultTypeTransformation.booleanUnbox(asg) && asg.containsKey("loadBalancerNames")) {
            Set set;
            loadBalancerNames = set = (Set)ScriptBytecodeAdapter.castToType((Object)asg.get("loadBalancerNames"), Set.class);
        }
        return loadBalancerNames;
    }

    public void setTargetGroups() {
        Set set;
        Set targetGroupNames = (Set)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.createList((Object[])new Object[0]), Set.class);
        Map<String, Object> asg = this.getAsg();
        if (DefaultTypeTransformation.booleanUnbox(asg) && asg.containsKey("targetGroupNames")) {
            Set set2;
            targetGroupNames = set2 = (Set)ScriptBytecodeAdapter.castToType((Object)asg.get("targetGroupNames"), Set.class);
        }
        this.targetGroups = set = targetGroupNames;
    }

    public Set<String> getSecurityGroups() {
        Set securityGroups = (Set)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.createList((Object[])new Object[0]), Set.class);
        if (DefaultTypeTransformation.booleanUnbox(this.launchConfig) && this.launchConfig.containsKey("securityGroups")) {
            Set set;
            securityGroups = set = (Set)ScriptBytecodeAdapter.castToType((Object)this.launchConfig.get("securityGroups"), Set.class);
        }
        RequestLaunchTemplateData launchTemplateData = null;
        if (DefaultTypeTransformation.booleanUnbox(this.launchTemplate)) {
            RequestLaunchTemplateData requestLaunchTemplateData;
            launchTemplateData = requestLaunchTemplateData = (RequestLaunchTemplateData)ScriptBytecodeAdapter.castToType((Object)DefaultGroovyMethods.getAt(this.launchTemplate, (Object)"launchTemplateData"), RequestLaunchTemplateData.class);
        } else if (DefaultTypeTransformation.booleanUnbox((Object)this.mixedInstancesPolicy)) {
            RequestLaunchTemplateData requestLaunchTemplateData;
            launchTemplateData = requestLaunchTemplateData = (RequestLaunchTemplateData)ScriptBytecodeAdapter.castToType((Object)DefaultGroovyMethods.getAt((Map)((Map)ScriptBytecodeAdapter.castToType((Object)DefaultGroovyMethods.getAt(this.mixedInstancesPolicy.getLaunchTemplates(), (int)0), Map.class)), (Object)"launchTemplateData"), RequestLaunchTemplateData.class);
        }
        if (DefaultTypeTransformation.booleanUnbox(launchTemplateData)) {
            Set set;
            RequestLaunchTemplateData requestLaunchTemplateData = launchTemplateData;
            Set set2 = (Set)ScriptBytecodeAdapter.castToType((Object)(requestLaunchTemplateData != null ? requestLaunchTemplateData.getSecurityGroupIds() : null), Set.class);
            Set securityGroupIds = DefaultTypeTransformation.booleanUnbox((Object)set2) ? set2 : ScriptBytecodeAdapter.createList((Object[])new Object[0]);
            Set set3 = securityGroupIds;
            if (DefaultTypeTransformation.booleanUnbox(set3 != null ? Integer.valueOf(set3.size()) : null)) {
                Set set4;
                securityGroups = set4 = (Set)ScriptBytecodeAdapter.castToType((Object)securityGroupIds, Set.class);
            }
            if (!DefaultTypeTransformation.booleanUnbox((set = securityGroupIds) != null ? Integer.valueOf(set.size()) : null)) {
                Set set5;
                RequestLaunchTemplateData requestLaunchTemplateData2 = launchTemplateData;
                List list = requestLaunchTemplateData2 != null ? requestLaunchTemplateData2.getNetworkInterfaces() : null;
                public final class _getSecurityGroups_closure2
                extends Closure
                implements GeneratedClosure {
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _getSecurityGroups_closure2(Object _outerInstance, Object _thisObject) {
                        super(_outerInstance, _thisObject);
                    }

                    public Object doCall(Object it) {
                        return ScriptBytecodeAdapter.compareEqual((Object)DefaultGroovyMethods.getAt((Object)it, (String)"deviceIndex"), (Object)0);
                    }

                    public Object call(Object args) {
                        return this.doCall(args);
                    }

                    public Object call() {
                        return this.doCall(null);
                    }

                    @Generated
                    public Object doCall() {
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _getSecurityGroups_closure2.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }
                }
                LaunchTemplateInstanceNetworkInterfaceSpecificationRequest networkInterface = (LaunchTemplateInstanceNetworkInterfaceSpecificationRequest)ScriptBytecodeAdapter.castToType(list != null ? DefaultGroovyMethods.find((Collection)list, (Closure)new _getSecurityGroups_closure2(this, this)) : null, LaunchTemplateInstanceNetworkInterfaceSpecificationRequest.class);
                LaunchTemplateInstanceNetworkInterfaceSpecificationRequest launchTemplateInstanceNetworkInterfaceSpecificationRequest = networkInterface;
                List list2 = launchTemplateInstanceNetworkInterfaceSpecificationRequest != null ? launchTemplateInstanceNetworkInterfaceSpecificationRequest.getGroups() : null;
                List groups = DefaultTypeTransformation.booleanUnbox((Object)list2) ? list2 : ScriptBytecodeAdapter.createList((Object[])new Object[0]);
                securityGroups = set5 = (Set)ScriptBytecodeAdapter.castToType((Object)groups, Set.class);
            }
        }
        return securityGroups;
    }

    public String getInstanceType() {
        if (DefaultTypeTransformation.booleanUnbox(this.launchConfig)) {
            return ShortTypeHandling.castToString((Object)this.launchConfig.get("instanceType"));
        }
        if (DefaultTypeTransformation.booleanUnbox(this.launchTemplate)) {
            return ShortTypeHandling.castToString(((Map)ScriptBytecodeAdapter.castToType((Object)this.launchTemplate.get("launchTemplateData"), Map.class)).get("instanceType"));
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)this.mixedInstancesPolicy)) {
            if (!DefaultTypeTransformation.booleanUnbox(this.mixedInstancesPolicy.getLaunchTemplateOverridesForInstanceType())) {
                Map mipLt = this.mixedInstancesPolicy.getLaunchTemplates().get(0);
                return ShortTypeHandling.castToString((Object)DefaultGroovyMethods.getAt((Object)DefaultGroovyMethods.getAt((Map)mipLt, (Object)"launchTemplateData"), (String)"instanceType"));
            }
            return ShortTypeHandling.castToString(null);
        }
        return ShortTypeHandling.castToString(null);
    }

    public ServerGroup.InstanceCounts getInstanceCounts() {
        Set<Instance> instances = this.getInstances();
        ServerGroup.InstanceCounts instanceCounts = new ServerGroup.InstanceCounts();
        int n = instances.size();
        instanceCounts.setTotal(Integer.valueOf(n));
        Collection<Instance> collection = AmazonServerGroup.filterInstancesByHealthState(instances, HealthState.Up);
        Integer n2 = collection != null ? Integer.valueOf(collection.size()) : null;
        Integer n3 = DefaultTypeTransformation.booleanUnbox((Object)n2) ? n2 : Integer.valueOf(0);
        instanceCounts.setUp(n3);
        Collection<Instance> collection2 = AmazonServerGroup.filterInstancesByHealthState(instances, HealthState.Down);
        Integer n4 = collection2 != null ? Integer.valueOf(collection2.size()) : null;
        Integer n5 = DefaultTypeTransformation.booleanUnbox((Object)n4) ? n4 : Integer.valueOf(0);
        instanceCounts.setDown(n5);
        Collection<Instance> collection3 = AmazonServerGroup.filterInstancesByHealthState(instances, HealthState.Unknown);
        Integer n6 = collection3 != null ? Integer.valueOf(collection3.size()) : null;
        Integer n7 = DefaultTypeTransformation.booleanUnbox((Object)n6) ? n6 : Integer.valueOf(0);
        instanceCounts.setUnknown(n7);
        Collection<Instance> collection4 = AmazonServerGroup.filterInstancesByHealthState(instances, HealthState.Starting);
        Integer n8 = collection4 != null ? Integer.valueOf(collection4.size()) : null;
        Integer n9 = DefaultTypeTransformation.booleanUnbox((Object)n8) ? n8 : Integer.valueOf(0);
        instanceCounts.setStarting(n9);
        Collection<Instance> collection5 = AmazonServerGroup.filterInstancesByHealthState(instances, HealthState.OutOfService);
        Integer n10 = collection5 != null ? Integer.valueOf(collection5.size()) : null;
        Integer n11 = DefaultTypeTransformation.booleanUnbox((Object)n10) ? n10 : Integer.valueOf(0);
        instanceCounts.setOutOfService(n11);
        return instanceCounts;
    }

    public ServerGroup.Capacity getCapacity() {
        if (DefaultTypeTransformation.booleanUnbox(this.asg)) {
            ServerGroup.Capacity capacity = new ServerGroup.Capacity();
            Integer n = DefaultTypeTransformation.booleanUnbox((Object)this.asg.get("minSize")) ? (Integer)ScriptBytecodeAdapter.asType((Object)this.asg.get("minSize"), Integer.class) : Integer.valueOf(0);
            capacity.setMin(n);
            Integer n2 = DefaultTypeTransformation.booleanUnbox((Object)this.asg.get("maxSize")) ? (Integer)ScriptBytecodeAdapter.asType((Object)this.asg.get("maxSize"), Integer.class) : Integer.valueOf(0);
            capacity.setMax(n2);
            Integer n3 = DefaultTypeTransformation.booleanUnbox((Object)this.asg.get("desiredCapacity")) ? (Integer)ScriptBytecodeAdapter.asType((Object)this.asg.get("desiredCapacity"), Integer.class) : Integer.valueOf(0);
            capacity.setDesired(n3);
            return capacity;
        }
        return (ServerGroup.Capacity)ScriptBytecodeAdapter.castToType(null, ServerGroup.Capacity.class);
    }

    public ServerGroup.ImagesSummary getImagesSummary() {
        Reference i = new Reference(this.image);
        Reference bi = new Reference((Object)this.buildInfo);
        return new ServerGroup.ImagesSummary(this, bi, i){
            public /* synthetic */ Reference i;
            public /* synthetic */ Reference bi;
            final /* synthetic */ AmazonServerGroup this$0;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private transient /* synthetic */ MetaClass metaClass;
            {
                MetaClass metaClass;
                Reference reference;
                Reference reference2;
                AmazonServerGroup amazonServerGroup;
                this.this$0 = amazonServerGroup = p0;
                this.i = reference2 = p2;
                this.bi = reference = p1;
                this.metaClass = metaClass = this.$getStaticMetaClass();
            }

            public List<? extends ServerGroup.ImageSummary> getSummaries() {
                return ScriptBytecodeAdapter.createList((Object[])new Object[]{new ServerGroup.ImageSummary(this, this.bi, this.i){
                    public /* synthetic */ Reference i;
                    public /* synthetic */ Reference bi;
                    private String serverGroupName;
                    private String imageName;
                    private String imageId;
                    final /* synthetic */ 1 this$0;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;
                    private transient /* synthetic */ MetaClass metaClass;
                    {
                        MetaClass metaClass;
                        String string;
                        Reference reference;
                        Reference reference2;
                        1 var4_4;
                        this.this$0 = var4_4 = p0;
                        this.i = reference2 = p2;
                        this.bi = reference = p1;
                        this.serverGroupName = string = this.this$0.this$0.getName();
                        Object var8_8 = this.i.get() == null ? null : this.i.get().get("name");
                        this.imageName = ShortTypeHandling.castToString(var8_8);
                        Object var9_9 = this.i.get() == null ? null : this.i.get().get("imageId");
                        this.imageId = ShortTypeHandling.castToString(var9_9);
                        this.metaClass = metaClass = this.$getStaticMetaClass();
                    }

                    public Map<String, Object> getBuildInfo() {
                        return (Map)ScriptBytecodeAdapter.castToType((Object)this.bi.get(), Map.class);
                    }

                    public Map<String, Object> getImage() {
                        return (Map)ScriptBytecodeAdapter.castToType((Object)this.i.get(), Map.class);
                    }

                    public /* synthetic */ Object methodMissing(String name, Object args) {
                        return this.this$0.this$dist$invoke$1(name, args);
                    }

                    public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
                        return ScriptBytecodeAdapter.invokeMethodN(1.class, 1.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
                    }

                    public /* synthetic */ void propertyMissing(String name, Object val) {
                        this.this$0.this$dist$set$1(name, val);
                    }

                    public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
                        Object object = val;
                        ScriptBytecodeAdapter.setProperty((Object)object, null, 1.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
                    }

                    public /* synthetic */ Object propertyMissing(String name) {
                        return this.this$0.this$dist$get$1(name);
                    }

                    public static /* synthetic */ Object $static_propertyMissing(String name) {
                        return ScriptBytecodeAdapter.getProperty(1.class, 1.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (this.getClass() != 1.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)this);
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    @Generated
                    @Internal
                    public /* synthetic */ MetaClass getMetaClass() {
                        MetaClass metaClass = this.metaClass;
                        if (metaClass != null) {
                            return metaClass;
                        }
                        this.metaClass = this.$getStaticMetaClass();
                        return this.metaClass;
                    }

                    @Generated
                    @Internal
                    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
                        this.metaClass = metaClass;
                    }

                    @Generated
                    @Internal
                    public /* synthetic */ Object invokeMethod(String string, Object object) {
                        return this.getMetaClass().invokeMethod((Object)this, string, object);
                    }

                    @Generated
                    @Internal
                    public /* synthetic */ Object getProperty(String string) {
                        return this.getMetaClass().getProperty((Object)this, string);
                    }

                    @Generated
                    @Internal
                    public /* synthetic */ void setProperty(String string, Object object) {
                        this.getMetaClass().setProperty((Object)this, string, object);
                    }

                    @Generated
                    public String getServerGroupName() {
                        return this.serverGroupName;
                    }

                    @Generated
                    public void setServerGroupName(String string) {
                        this.serverGroupName = string;
                    }

                    @Generated
                    public String getImageName() {
                        return this.imageName;
                    }

                    @Generated
                    public void setImageName(String string) {
                        this.imageName = string;
                    }

                    @Generated
                    public String getImageId() {
                        return this.imageId;
                    }

                    @Generated
                    public void setImageId(String string) {
                        this.imageId = string;
                    }
                }});
            }

            public /* synthetic */ Object this$dist$invoke$1(String name, Object args) {
                return ScriptBytecodeAdapter.invokeMethodOnCurrentN(1.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            }

            public /* synthetic */ void this$dist$set$1(String name, Object value) {
                Object object = value;
                ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, 1.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
            }

            public /* synthetic */ Object this$dist$get$1(String name) {
                return ScriptBytecodeAdapter.getGroovyObjectProperty(1.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
            }

            public /* synthetic */ Object methodMissing(String name, Object args) {
                return this.this$0.this$dist$invoke$1(name, args);
            }

            public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
                return ScriptBytecodeAdapter.invokeMethodN(1.class, AmazonServerGroup.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            }

            public /* synthetic */ void propertyMissing(String name, Object val) {
                this.this$0.this$dist$set$1(name, val);
            }

            public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
                Object object = val;
                ScriptBytecodeAdapter.setProperty((Object)object, null, AmazonServerGroup.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
            }

            public /* synthetic */ Object propertyMissing(String name) {
                return this.this$0.this$dist$get$1(name);
            }

            public static /* synthetic */ Object $static_propertyMissing(String name) {
                return ScriptBytecodeAdapter.getProperty(1.class, AmazonServerGroup.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (this.getClass() != 1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)this);
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                }
                return classInfo.getMetaClass();
            }

            @Generated
            @Internal
            public /* synthetic */ MetaClass getMetaClass() {
                MetaClass metaClass = this.metaClass;
                if (metaClass != null) {
                    return metaClass;
                }
                this.metaClass = this.$getStaticMetaClass();
                return this.metaClass;
            }

            @Generated
            @Internal
            public /* synthetic */ void setMetaClass(MetaClass metaClass) {
                this.metaClass = metaClass;
            }

            @Generated
            @Internal
            public /* synthetic */ Object invokeMethod(String string, Object object) {
                return this.getMetaClass().invokeMethod((Object)this, string, object);
            }

            @Generated
            @Internal
            public /* synthetic */ Object getProperty(String string) {
                return this.getMetaClass().getProperty((Object)this, string);
            }

            @Generated
            @Internal
            public /* synthetic */ void setProperty(String string, Object object) {
                this.getMetaClass().setProperty((Object)this, string, object);
            }
        };
    }

    public ServerGroup.ImageSummary getImageSummary() {
        ServerGroup.ImagesSummary imagesSummary = this.getImagesSummary();
        List list = imagesSummary != null ? imagesSummary.getSummaries() : null;
        return (ServerGroup.ImageSummary)ScriptBytecodeAdapter.castToType(list != null ? list.get(0) : null, ServerGroup.ImageSummary.class);
    }

    @JsonIgnore
    @Alpha
    public Map getLaunchTemplateSpecification() {
        if (DefaultTypeTransformation.booleanUnbox(this.asg == null ? null : this.asg.get("launchTemplate"))) {
            return (Map)ScriptBytecodeAdapter.asType((Object)this.asg.get("launchTemplate"), Map.class);
        }
        if (DefaultTypeTransformation.booleanUnbox(this.asg == null ? null : this.asg.get("mixedInstancesPolicy"))) {
            return (Map)ScriptBytecodeAdapter.asType((Object)DefaultGroovyMethods.getAt((Object)DefaultGroovyMethods.getAt((Object)this.asg.get("mixedInstancesPolicy"), (String)"launchTemplate"), (String)"launchTemplateSpecification"), Map.class);
        }
        return (Map)ScriptBytecodeAdapter.castToType(null, Map.class);
    }

    public static Collection<Instance> filterInstancesByHealthState(Collection<Instance> instances, HealthState healthState) {
        Reference healthState2 = new Reference((Object)healthState);
        public final class _filterInstancesByHealthState_closure3
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference healthState;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _filterInstancesByHealthState_closure3(Object _outerInstance, Object _thisObject, Reference healthState) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.healthState = reference = healthState;
            }

            public Object doCall(Instance it) {
                return ScriptBytecodeAdapter.compareEqual((Object)it.getHealthState(), (Object)this.healthState.get());
            }

            public Object call(Instance it) {
                return this.doCall(it);
            }

            @Generated
            public HealthState getHealthState() {
                return (HealthState)ShortTypeHandling.castToEnum((Object)this.healthState.get(), HealthState.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _filterInstancesByHealthState_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        return DefaultGroovyMethods.findAll(instances, (Closure)new _filterInstancesByHealthState_closure3(AmazonServerGroup.class, AmazonServerGroup.class, healthState2));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != AmazonServerGroup.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ Object this$dist$invoke$1(String name, Object args) {
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(AmazonServerGroup.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$1(String name, Object value) {
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, AmazonServerGroup.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public /* synthetic */ Object this$dist$get$1(String name) {
        return ScriptBytecodeAdapter.getGroovyObjectProperty(AmazonServerGroup.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public static /* synthetic */ String pfaccess$0(AmazonServerGroup $that) {
        return $that.getName();
    }

    @Generated
    @Internal
    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Generated
    @Internal
    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    @Generated
    @Internal
    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public void setName(String string) {
        this.name = string;
    }

    @Generated
    public String getRegion() {
        return this.region;
    }

    @Generated
    public void setRegion(String string) {
        this.region = string;
    }

    @Generated
    public Set<String> getZones() {
        return this.zones;
    }

    @Generated
    public void setZones(Set<String> set) {
        this.zones = set;
    }

    @Generated
    public Set<Instance> getInstances() {
        return this.instances;
    }

    @Generated
    public void setInstances(Set<Instance> set) {
        this.instances = set;
    }

    @Generated
    public Set getHealth() {
        return this.health;
    }

    @Generated
    public void setHealth(Set set) {
        this.health = set;
    }

    @Generated
    public Map<String, Object> getImage() {
        return this.image;
    }

    @Generated
    public void setImage(Map<String, Object> map) {
        this.image = map;
    }

    @Generated
    public Map<String, Object> getLaunchConfig() {
        return this.launchConfig;
    }

    @Generated
    public void setLaunchConfig(Map<String, Object> map) {
        this.launchConfig = map;
    }

    @Generated
    public Map<String, Object> getLaunchTemplate() {
        return this.launchTemplate;
    }

    @Generated
    public void setLaunchTemplate(Map<String, Object> map) {
        this.launchTemplate = map;
    }

    @Generated
    public MixedInstancesPolicySettings getMixedInstancesPolicy() {
        return this.mixedInstancesPolicy;
    }

    @Generated
    public void setMixedInstancesPolicy(MixedInstancesPolicySettings mixedInstancesPolicySettings) {
        this.mixedInstancesPolicy = mixedInstancesPolicySettings;
    }

    @Generated
    public Map<String, Object> getAsg() {
        return this.asg;
    }

    @Generated
    public void setAsg(Map<String, Object> map) {
        this.asg = map;
    }

    @Generated
    public List<Map> getScalingPolicies() {
        return this.scalingPolicies;
    }

    @Generated
    public void setScalingPolicies(List<Map> list) {
        this.scalingPolicies = list;
    }

    @Generated
    public List<Map> getScheduledActions() {
        return this.scheduledActions;
    }

    @Generated
    public void setScheduledActions(List<Map> list) {
        this.scheduledActions = list;
    }

    @Generated
    public Map getBuildInfo() {
        return this.buildInfo;
    }

    @Generated
    public void setBuildInfo(Map map) {
        this.buildInfo = map;
    }

    @Generated
    public String getVpcId() {
        return this.vpcId;
    }

    @Generated
    public void setVpcId(String string) {
        this.vpcId = string;
    }

    @Generated
    public final String getType() {
        return this.type;
    }

    @Generated
    public final String getCloudProvider() {
        return this.cloudProvider;
    }

    @Generated
    public Set<String> getTargetGroups() {
        return this.targetGroups;
    }

    @Generated
    public void setTargetGroups(Set<String> set) {
        this.targetGroups = set;
    }

    public static class MixedInstancesPolicySettings
    implements GroovyObject {
        private List<String> allowedInstanceTypes;
        private Map instancesDistribution;
        private List<Map> launchTemplates;
        private List<Map> launchTemplateOverridesForInstanceType;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;

        @Generated
        public MixedInstancesPolicySettings() {
            MetaClass metaClass;
            this.metaClass = metaClass = this.$getStaticMetaClass();
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != MixedInstancesPolicySettings.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(MixedInstancesPolicySettings.class, AmazonServerGroup.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(MixedInstancesPolicySettings.class, AmazonServerGroup.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, AmazonServerGroup.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, AmazonServerGroup.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(MixedInstancesPolicySettings.class, AmazonServerGroup.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(MixedInstancesPolicySettings.class, AmazonServerGroup.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        @Generated
        @Internal
        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        @Generated
        @Internal
        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        @Generated
        @Internal
        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }

        @Generated
        public List<String> getAllowedInstanceTypes() {
            return this.allowedInstanceTypes;
        }

        @Generated
        public void setAllowedInstanceTypes(List<String> list) {
            this.allowedInstanceTypes = list;
        }

        @Generated
        public Map getInstancesDistribution() {
            return this.instancesDistribution;
        }

        @Generated
        public void setInstancesDistribution(Map map) {
            this.instancesDistribution = map;
        }

        @Generated
        public List<Map> getLaunchTemplates() {
            return this.launchTemplates;
        }

        @Generated
        public void setLaunchTemplates(List<Map> list) {
            this.launchTemplates = list;
        }

        @Generated
        public List<Map> getLaunchTemplateOverridesForInstanceType() {
            return this.launchTemplateOverridesForInstanceType;
        }

        @Generated
        public void setLaunchTemplateOverridesForInstanceType(List<Map> list) {
            this.launchTemplateOverridesForInstanceType = list;
        }
    }
}

