/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.aws.provider.view;

import com.amazonaws.services.autoscaling.model.LifecycleState;
import com.netflix.frigga.ami.AppVersion;
import com.netflix.spinnaker.cats.cache.Cache;
import com.netflix.spinnaker.cats.cache.CacheData;
import com.netflix.spinnaker.cats.cache.CacheFilter;
import com.netflix.spinnaker.cats.cache.RelationshipCacheFilter;
import com.netflix.spinnaker.clouddriver.aws.AmazonCloudProvider;
import com.netflix.spinnaker.clouddriver.aws.data.Keys;
import com.netflix.spinnaker.clouddriver.aws.model.AmazonCluster;
import com.netflix.spinnaker.clouddriver.aws.model.AmazonInstance;
import com.netflix.spinnaker.clouddriver.aws.model.AmazonLoadBalancer;
import com.netflix.spinnaker.clouddriver.aws.model.AmazonServerGroup;
import com.netflix.spinnaker.clouddriver.aws.model.AmazonTargetGroup;
import com.netflix.spinnaker.clouddriver.aws.provider.AwsProvider;
import com.netflix.spinnaker.clouddriver.core.provider.agent.ExternalHealthProvider;
import com.netflix.spinnaker.clouddriver.core.provider.agent.Namespace;
import com.netflix.spinnaker.clouddriver.model.ClusterProvider;
import com.netflix.spinnaker.clouddriver.model.ServerGroupProvider;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.ArrayUtil;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class AmazonClusterProvider
implements ClusterProvider<AmazonCluster>,
ServerGroupProvider,
GroovyObject {
    private final AmazonCloudProvider amazonCloudProvider;
    private final Cache cacheView;
    private final AwsProvider awsProvider;
    @Autowired(required=false)
    private List<ExternalHealthProvider> externalHealthProviders;
    @Value(value="${default.build.host:http://builds.netflix.com/}")
    private String defaultBuildHost;
    @Value(value="${sql.cache.enabled:false}")
    private Boolean sqlEnabled;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo$;
    private static /* synthetic */ SoftReference $callSiteArray;

    @Autowired
    public AmazonClusterProvider(AmazonCloudProvider amazonCloudProvider, Cache cacheView, AwsProvider awsProvider) {
        AwsProvider awsProvider2;
        Cache cache;
        AmazonCloudProvider amazonCloudProvider2;
        MetaClass metaClass;
        CallSite[] callSiteArray = AmazonClusterProvider.$getCallSiteArray();
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.amazonCloudProvider = amazonCloudProvider2 = amazonCloudProvider;
        this.cacheView = cache = cacheView;
        this.awsProvider = awsProvider2 = awsProvider;
    }

    public Map<String, Set<AmazonCluster>> getClusters() {
        CallSite[] callSiteArray = AmazonClusterProvider.$getCallSiteArray();
        Collection clusterData = (Collection)ScriptBytecodeAdapter.castToType((Object)callSiteArray[0].call((Object)this.cacheView, callSiteArray[1].callGetProperty(callSiteArray[2].callGetProperty(Namespace.class))), Collection.class);
        Collection clusters = (Collection)ScriptBytecodeAdapter.castToType((Object)callSiteArray[3].callCurrent((GroovyObject)this, (Object)clusterData, (Object)false), Collection.class);
        return (Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[4].callStatic(AmazonClusterProvider.class, (Object)clusters), Map.class);
    }

    public Map<String, Set<AmazonCluster>> getClusterSummaries(String applicationName) {
        CallSite[] callSiteArray = AmazonClusterProvider.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return (Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[5].callCurrent((GroovyObject)this, (Object)applicationName, (Object)false), Map.class);
        }
        return this.getClusters0(applicationName, false);
    }

    public Map<String, Set<AmazonCluster>> getClusterDetails(String applicationName) {
        CallSite[] callSiteArray = AmazonClusterProvider.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return (Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[6].callCurrent((GroovyObject)this, (Object)applicationName, (Object)true), Map.class);
        }
        return this.getClusters0(applicationName, true);
    }

    public AmazonServerGroup getServerGroup(String account, String region, String name, boolean includeDetails) {
        CallSite[] callSiteArray = AmazonClusterProvider.$getCallSiteArray();
        String serverGroupKey = ShortTypeHandling.castToString((Object)callSiteArray[7].call(Keys.class, (Object)name, (Object)account, (Object)region));
        CacheData serverGroupData = (CacheData)ScriptBytecodeAdapter.castToType((Object)callSiteArray[8].call((Object)this.cacheView, callSiteArray[9].callGetProperty(callSiteArray[10].callGetProperty(Namespace.class)), (Object)serverGroupKey), CacheData.class);
        if (ScriptBytecodeAdapter.compareEqual((Object)serverGroupData, null)) {
            return (AmazonServerGroup)ScriptBytecodeAdapter.castToType(null, AmazonServerGroup.class);
        }
        Object asg = callSiteArray[11].call(callSiteArray[12].callGetProperty((Object)serverGroupData), (Object)"asg");
        Map serverGroupById = ScriptBytecodeAdapter.createMap((Object[])new Object[]{callSiteArray[13].callGetProperty((Object)serverGroupData), callSiteArray[14].callConstructor(AmazonServerGroup.class, callSiteArray[15].callGetProperty((Object)serverGroupData))});
        Object serverGroup = callSiteArray[16].call(callSiteArray[17].call((Object)serverGroupById));
        String imageId = null;
        Map ltSpec = (Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[18].call(serverGroup), Map.class);
        if (DefaultTypeTransformation.booleanUnbox((Object)ltSpec)) {
            String launchTemplateName = ShortTypeHandling.castToString((Object)callSiteArray[19].call((Object)ltSpec, (Object)"launchTemplateName"));
            String launchTemplateKey = ShortTypeHandling.castToString((Object)callSiteArray[20].call(Keys.class, (Object)launchTemplateName, (Object)account, (Object)region));
            CacheData launchTemplate = (CacheData)ScriptBytecodeAdapter.castToType((Object)callSiteArray[21].call((Object)this.cacheView, callSiteArray[22].callGetProperty(callSiteArray[23].callGetProperty(Namespace.class)), (Object)launchTemplateKey), CacheData.class);
            callSiteArray[24].callStatic(AmazonClusterProvider.class, (Object)serverGroupById, (Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{launchTemplate}));
            Object launchTemplateData = callSiteArray[25].callSafe((Object)((Map)ScriptBytecodeAdapter.asType((Object)callSiteArray[26].callSafe(callSiteArray[27].callGetPropertySafe((Object)launchTemplate), (Object)"latestVersion"), Map.class)), (Object)"launchTemplateData");
            Object object = callSiteArray[28].callSafe((Object)((Map)ScriptBytecodeAdapter.asType((Object)launchTemplateData, Map.class)), (Object)"imageId");
            imageId = ShortTypeHandling.castToString((Object)object);
        } else {
            String launchConfigKey = ShortTypeHandling.castToString((Object)callSiteArray[29].call(Keys.class, (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((String)ScriptBytecodeAdapter.asType((Object)callSiteArray[30].call(callSiteArray[31].callGetPropertySafe((Object)serverGroupData), (Object)"launchConfigName"), String.class)), String.class), (Object)account, (Object)region));
            CacheData launchConfigs = (CacheData)ScriptBytecodeAdapter.castToType((Object)callSiteArray[32].call((Object)this.cacheView, callSiteArray[33].callGetProperty(callSiteArray[34].callGetProperty(Namespace.class)), (Object)launchConfigKey), CacheData.class);
            callSiteArray[35].callStatic(AmazonClusterProvider.class, (Object)serverGroupById, (Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{launchConfigs}));
            Object object = callSiteArray[36].callSafe(callSiteArray[37].callGetPropertySafe((Object)launchConfigs), (Object)"imageId");
            imageId = ShortTypeHandling.castToString((Object)object);
        }
        CacheData imageConfigs = (CacheData)ScriptBytecodeAdapter.castToType(DefaultTypeTransformation.booleanUnbox((Object)imageId) ? callSiteArray[38].call((Object)this.cacheView, callSiteArray[39].callGetProperty(callSiteArray[40].callGetProperty(Namespace.class)), callSiteArray[41].call(Keys.class, (Object)imageId, (Object)account, (Object)region)) : null, CacheData.class);
        Object object = DefaultTypeTransformation.booleanUnbox((Object)imageConfigs) ? callSiteArray[42].callGetProperty((Object)imageConfigs) : null;
        ScriptBytecodeAdapter.setProperty((Object)object, null, (Object)serverGroup, (String)"image");
        Object object2 = DefaultTypeTransformation.booleanUnbox((Object)imageConfigs) ? callSiteArray[43].callCurrent((GroovyObject)this, (Object)imageConfigs) : null;
        ScriptBytecodeAdapter.setProperty((Object)object2, null, (Object)serverGroup, (String)"buildInfo");
        String string = account;
        ScriptBytecodeAdapter.setProperty((Object)string, null, (Object)serverGroup, (String)"accountName");
        if (includeDetails) {
            Reference asgInstances = new Reference((Object)((Set)ScriptBytecodeAdapter.castToType((Object)callSiteArray[44].callStatic(AmazonClusterProvider.class, asg, (Object)account, (Object)region), Set.class)));
            public final class _getServerGroup_closure1
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference asgInstances;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;

                public _getServerGroup_closure1(Object _outerInstance, Object _thisObject, Reference asgInstances) {
                    Reference reference;
                    CallSite[] callSiteArray = _getServerGroup_closure1.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                    this.asgInstances = reference = asgInstances;
                }

                public Object doCall(Object rel) {
                    CallSite[] callSiteArray = _getServerGroup_closure1.$getCallSiteArray();
                    return ScriptBytecodeAdapter.compareEqual((Object)this.asgInstances.get(), null) || DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[0].call(this.asgInstances.get(), rel));
                }

                @Generated
                public Set getAsgInstances() {
                    CallSite[] callSiteArray = _getServerGroup_closure1.$getCallSiteArray();
                    return (Set)ScriptBytecodeAdapter.castToType((Object)this.asgInstances.get(), Set.class);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _getServerGroup_closure1.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[1];
                    stringArray[0] = "contains";
                    return new CallSiteArray(_getServerGroup_closure1.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _getServerGroup_closure1.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            }
            _getServerGroup_closure1 instanceFilter = new _getServerGroup_closure1(this, this, asgInstances);
            Object object3 = callSiteArray[45].call(callSiteArray[46].callCurrent((GroovyObject)this, callSiteArray[47].callCurrent((GroovyObject)this, (Object)serverGroupData, callSiteArray[48].callGetProperty(callSiteArray[49].callGetProperty(Namespace.class)), (Object)instanceFilter, callSiteArray[50].call(RelationshipCacheFilter.class))));
            ScriptBytecodeAdapter.setProperty((Object)object3, null, (Object)serverGroup, (String)"instances");
        } else {
            List list = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
            ScriptBytecodeAdapter.setProperty((Object)list, null, (Object)serverGroup, (String)"instances");
        }
        return (AmazonServerGroup)ScriptBytecodeAdapter.castToType((Object)serverGroup, AmazonServerGroup.class);
    }

    public AmazonServerGroup getServerGroup(String account, String region, String name) {
        CallSite[] callSiteArray = AmazonClusterProvider.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return (AmazonServerGroup)ScriptBytecodeAdapter.castToType((Object)callSiteArray[51].callCurrent((GroovyObject)this, (Object)account, (Object)region, (Object)name, (Object)true), AmazonServerGroup.class);
        }
        return this.getServerGroup(account, region, name, true);
    }

    public String getCloudProviderId() {
        CallSite[] callSiteArray = AmazonClusterProvider.$getCallSiteArray();
        return ShortTypeHandling.castToString((Object)callSiteArray[52].callGroovyObjectGetProperty((Object)this.amazonCloudProvider));
    }

    public boolean supportsMinimalClusters() {
        CallSite[] callSiteArray = AmazonClusterProvider.$getCallSiteArray();
        return true;
    }

    private static Map<String, Set<AmazonCluster>> mapResponse(Collection<AmazonCluster> clusters) {
        CallSite[] callSiteArray = AmazonClusterProvider.$getCallSiteArray();
        public final class _mapResponse_closure2
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _mapResponse_closure2(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _mapResponse_closure2.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _mapResponse_closure2.$getCallSiteArray();
                return callSiteArray[0].callGetProperty(it);
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _mapResponse_closure2.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _mapResponse_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "accountName";
                return new CallSiteArray(_mapResponse_closure2.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _mapResponse_closure2.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        public final class _mapResponse_closure3
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _mapResponse_closure3(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _mapResponse_closure3.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object k, Object v) {
                CallSite[] callSiteArray = _mapResponse_closure3.$getCallSiteArray();
                return ScriptBytecodeAdapter.createList((Object[])new Object[]{k, callSiteArray[0].callConstructor(HashSet.class, v)});
            }

            public Object call(Object k, Object v) {
                CallSite[] callSiteArray = _mapResponse_closure3.$getCallSiteArray();
                return callSiteArray[1].callCurrent((GroovyObject)this, k, v);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _mapResponse_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "<$constructor$>";
                stringArray[1] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[2];
                _mapResponse_closure3.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_mapResponse_closure3.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _mapResponse_closure3.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        return (Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[53].call(callSiteArray[54].call(clusters, (Object)new _mapResponse_closure2(AmazonClusterProvider.class, AmazonClusterProvider.class)), (Object)new _mapResponse_closure3(AmazonClusterProvider.class, AmazonClusterProvider.class)), Map.class);
    }

    /*
     * WARNING - void declaration
     */
    private static Set<String> getAsgInstanceKeys(Map asg, String account, String region) {
        void var2_2;
        Reference account2 = new Reference((Object)account);
        Reference region2 = new Reference((Object)var2_2);
        CallSite[] callSiteArray = AmazonClusterProvider.$getCallSiteArray();
        public final class _getAsgInstanceKeys_closure4
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference account;
            private /* synthetic */ Reference region;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _getAsgInstanceKeys_closure4(Object _outerInstance, Object _thisObject, Reference account, Reference region) {
                Reference reference;
                Reference reference2;
                CallSite[] callSiteArray = _getAsgInstanceKeys_closure4.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.account = reference2 = account;
                this.region = reference = region;
            }

            public Object doCall(Set instances, Map instance) {
                CallSite[] callSiteArray = _getAsgInstanceKeys_closure4.$getCallSiteArray();
                callSiteArray[0].call((Object)instances, callSiteArray[1].call(Keys.class, callSiteArray[2].callGetProperty((Object)instance), this.account.get(), this.region.get()));
                return instances;
            }

            public Object call(Set instances, Map instance) {
                CallSite[] callSiteArray = _getAsgInstanceKeys_closure4.$getCallSiteArray();
                return callSiteArray[3].callCurrent((GroovyObject)this, (Object)instances, (Object)instance);
            }

            @Generated
            public String getAccount() {
                CallSite[] callSiteArray = _getAsgInstanceKeys_closure4.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.account.get());
            }

            @Generated
            public String getRegion() {
                CallSite[] callSiteArray = _getAsgInstanceKeys_closure4.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.region.get());
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getAsgInstanceKeys_closure4.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "add";
                stringArray[1] = "getInstanceKey";
                stringArray[2] = "instanceId";
                stringArray[3] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[4];
                _getAsgInstanceKeys_closure4.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_getAsgInstanceKeys_closure4.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _getAsgInstanceKeys_closure4.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        Object object = callSiteArray[55].callSafe(callSiteArray[56].callGetPropertySafe((Object)asg), callSiteArray[57].callConstructor(HashSet.class), (Object)new _getAsgInstanceKeys_closure4(AmazonClusterProvider.class, AmazonClusterProvider.class, account2, region2));
        return (Set)ScriptBytecodeAdapter.castToType((Object)(DefaultTypeTransformation.booleanUnbox((Object)object) ? object : ScriptBytecodeAdapter.createList((Object[])new Object[0])), Set.class);
    }

    private static Map<String, AmazonLoadBalancer> translateLoadBalancers(Collection<CacheData> loadBalancerData) {
        CallSite[] callSiteArray = AmazonClusterProvider.$getCallSiteArray();
        public final class _translateLoadBalancers_closure5
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _translateLoadBalancers_closure5(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _translateLoadBalancers_closure5.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object loadBalancerEntry) {
                CallSite[] callSiteArray = _translateLoadBalancers_closure5.$getCallSiteArray();
                Map lbKey = (Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[0].call(Keys.class, callSiteArray[1].callGetProperty(loadBalancerEntry)), Map.class);
                return ScriptBytecodeAdapter.createMap((Object[])new Object[]{callSiteArray[2].callGetProperty(loadBalancerEntry), callSiteArray[3].callConstructor(AmazonLoadBalancer.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", callSiteArray[4].callGetProperty((Object)lbKey), "account", callSiteArray[5].callGetProperty((Object)lbKey), "region", callSiteArray[6].callGetProperty((Object)lbKey)}))});
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _translateLoadBalancers_closure5.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "parse";
                stringArray[1] = "id";
                stringArray[2] = "id";
                stringArray[3] = "<$constructor$>";
                stringArray[4] = "loadBalancer";
                stringArray[5] = "account";
                stringArray[6] = "region";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[7];
                _translateLoadBalancers_closure5.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_translateLoadBalancers_closure5.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _translateLoadBalancers_closure5.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        return (Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[58].call(loadBalancerData, (Object)new _translateLoadBalancers_closure5(AmazonClusterProvider.class, AmazonClusterProvider.class)), Map.class);
    }

    private static Map<String, AmazonTargetGroup> translateTargetGroups(Collection<CacheData> targetGroupData) {
        CallSite[] callSiteArray = AmazonClusterProvider.$getCallSiteArray();
        public final class _translateTargetGroups_closure6
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _translateTargetGroups_closure6(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _translateTargetGroups_closure6.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object targetGroupEntry) {
                CallSite[] callSiteArray = _translateTargetGroups_closure6.$getCallSiteArray();
                Map tgKey = (Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[0].call(Keys.class, callSiteArray[1].callGetProperty(targetGroupEntry)), Map.class);
                return ScriptBytecodeAdapter.createMap((Object[])new Object[]{callSiteArray[2].callGetProperty(targetGroupEntry), callSiteArray[3].callConstructor(AmazonTargetGroup.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", callSiteArray[4].callGetProperty((Object)tgKey), "account", callSiteArray[5].callGetProperty((Object)tgKey), "region", callSiteArray[6].callGetProperty((Object)tgKey)}))});
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _translateTargetGroups_closure6.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "parse";
                stringArray[1] = "id";
                stringArray[2] = "id";
                stringArray[3] = "<$constructor$>";
                stringArray[4] = "loadBalancer";
                stringArray[5] = "account";
                stringArray[6] = "region";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[7];
                _translateTargetGroups_closure6.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_translateTargetGroups_closure6.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _translateTargetGroups_closure6.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        return (Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[59].call(targetGroupData, (Object)new _translateTargetGroups_closure6(AmazonClusterProvider.class, AmazonClusterProvider.class)), Map.class);
    }

    private Collection<AmazonCluster> allClustersByApplication(String application) {
        CallSite[] callSiteArray = AmazonClusterProvider.$getCallSiteArray();
        List toFetch = ScriptBytecodeAdapter.createList((Object[])new Object[]{callSiteArray[60].callGetProperty(callSiteArray[61].callGetProperty(Namespace.class)), callSiteArray[62].callGetProperty(callSiteArray[63].callGetProperty(Namespace.class)), callSiteArray[64].callGetProperty(callSiteArray[65].callGetProperty(Namespace.class)), callSiteArray[66].callGetProperty(callSiteArray[67].callGetProperty(Namespace.class)), callSiteArray[68].callGetProperty(callSiteArray[69].callGetProperty(Namespace.class))});
        Map filters = ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
        Object object = callSiteArray[70].call(RelationshipCacheFilter.class, callSiteArray[71].callGetProperty(callSiteArray[72].callGetProperty(Namespace.class)), callSiteArray[73].callGetProperty(callSiteArray[74].callGetProperty(Namespace.class)), callSiteArray[75].callGetProperty(callSiteArray[76].callGetProperty(Namespace.class)));
        callSiteArray[77].call((Object)filters, callSiteArray[78].callGetProperty(callSiteArray[79].callGetProperty(Namespace.class)), object);
        Object object2 = callSiteArray[80].call(RelationshipCacheFilter.class, callSiteArray[81].callGetProperty(callSiteArray[82].callGetProperty(Namespace.class)), callSiteArray[83].callGetProperty(callSiteArray[84].callGetProperty(Namespace.class)));
        callSiteArray[85].call((Object)filters, callSiteArray[86].callGetProperty(callSiteArray[87].callGetProperty(Namespace.class)), object2);
        Object object3 = callSiteArray[88].call(RelationshipCacheFilter.class, callSiteArray[89].callGetProperty(callSiteArray[90].callGetProperty(Namespace.class)), callSiteArray[91].callGetProperty(callSiteArray[92].callGetProperty(Namespace.class)));
        callSiteArray[93].call((Object)filters, callSiteArray[94].callGetProperty(callSiteArray[95].callGetProperty(Namespace.class)), object3);
        Object object4 = callSiteArray[96].call(RelationshipCacheFilter.class, callSiteArray[97].callGetProperty(callSiteArray[98].callGetProperty(Namespace.class)));
        callSiteArray[99].call((Object)filters, callSiteArray[100].callGetProperty(callSiteArray[101].callGetProperty(Namespace.class)), object4);
        Object cacheResults = callSiteArray[102].call((Object)this.cacheView, (Object)toFetch, (Object)application, (Object)filters);
        Collection allLoadBalancers = (Collection)ScriptBytecodeAdapter.castToType((Object)callSiteArray[103].callCurrent((GroovyObject)this, callSiteArray[104].call(cacheResults, callSiteArray[105].callGetProperty(callSiteArray[106].callGetProperty(Namespace.class))), callSiteArray[107].callGetProperty(callSiteArray[108].callGetProperty(Namespace.class)), callSiteArray[109].call(RelationshipCacheFilter.class)), Collection.class);
        Collection allTargetGroups = (Collection)ScriptBytecodeAdapter.castToType((Object)callSiteArray[110].callCurrent((GroovyObject)this, callSiteArray[111].call(cacheResults, callSiteArray[112].callGetProperty(callSiteArray[113].callGetProperty(Namespace.class))), callSiteArray[114].callGetProperty(callSiteArray[115].callGetProperty(Namespace.class)), callSiteArray[116].call(RelationshipCacheFilter.class)), Collection.class);
        List allImages = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        callSiteArray[117].call((Object)allImages, callSiteArray[118].callCurrent((GroovyObject)this, callSiteArray[119].call(cacheResults, callSiteArray[120].callGetProperty(callSiteArray[121].callGetProperty(Namespace.class))), callSiteArray[122].callGetProperty(callSiteArray[123].callGetProperty(Namespace.class)), callSiteArray[124].call(RelationshipCacheFilter.class)));
        callSiteArray[125].call((Object)allImages, callSiteArray[126].callCurrent((GroovyObject)this, callSiteArray[127].call(cacheResults, callSiteArray[128].callGetProperty(callSiteArray[129].callGetProperty(Namespace.class))), callSiteArray[130].callGetProperty(callSiteArray[131].callGetProperty(Namespace.class)), callSiteArray[132].call(RelationshipCacheFilter.class)));
        Reference loadBalancers = new Reference((Object)((Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[133].callStatic(AmazonClusterProvider.class, (Object)allLoadBalancers), Map.class)));
        Reference targetGroups = new Reference((Object)((Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[134].callStatic(AmazonClusterProvider.class, (Object)allTargetGroups), Map.class)));
        Reference serverGroups = new Reference((Object)((Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[135].callCurrent((GroovyObject)this, ArrayUtil.createArray((Object)callSiteArray[136].call(cacheResults, callSiteArray[137].callGetProperty(callSiteArray[138].callGetProperty(Namespace.class))), (Object)callSiteArray[139].call(cacheResults, callSiteArray[140].callGetProperty(callSiteArray[141].callGetProperty(Namespace.class))), (Object)callSiteArray[142].call(cacheResults, callSiteArray[143].callGetProperty(callSiteArray[144].callGetProperty(Namespace.class))), (Object)callSiteArray[145].call(cacheResults, callSiteArray[146].callGetProperty(callSiteArray[147].callGetProperty(Namespace.class))), (Object)allImages)), Map.class)));
        public final class _allClustersByApplication_closure7
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference serverGroups;
            private /* synthetic */ Reference loadBalancers;
            private /* synthetic */ Reference targetGroups;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _allClustersByApplication_closure7(Object _outerInstance, Object _thisObject, Reference serverGroups, Reference loadBalancers, Reference targetGroups) {
                Reference reference;
                Reference reference2;
                Reference reference3;
                CallSite[] callSiteArray = _allClustersByApplication_closure7.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.serverGroups = reference3 = serverGroups;
                this.loadBalancers = reference2 = loadBalancers;
                this.targetGroups = reference = targetGroups;
            }

            public Object doCall(Object clusterData) {
                CallSite[] callSiteArray = _allClustersByApplication_closure7.$getCallSiteArray();
                Map clusterKey = (Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[0].call(Keys.class, callSiteArray[1].callGetProperty(clusterData)), Map.class);
                AmazonCluster cluster = (AmazonCluster)ScriptBytecodeAdapter.castToType((Object)callSiteArray[2].callConstructor(AmazonCluster.class), AmazonCluster.class);
                Object object = callSiteArray[3].callGetProperty((Object)clusterKey);
                ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, _allClustersByApplication_closure7.class, (GroovyObject)cluster, (String)"accountName");
                Object object2 = callSiteArray[4].callGetProperty((Object)clusterKey);
                ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object2, _allClustersByApplication_closure7.class, (GroovyObject)cluster, (String)"name");
                public final class _closure35
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference serverGroups;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;
                    private static /* synthetic */ SoftReference $callSiteArray;

                    public _closure35(Object _outerInstance, Object _thisObject, Reference serverGroups) {
                        Reference reference;
                        CallSite[] callSiteArray = _closure35.$getCallSiteArray();
                        super(_outerInstance, _thisObject);
                        this.serverGroups = reference = serverGroups;
                    }

                    public Object doCall(Object it) {
                        CallSite[] callSiteArray = _closure35.$getCallSiteArray();
                        return callSiteArray[0].call(this.serverGroups.get(), it);
                    }

                    @Generated
                    public Map getServerGroups() {
                        CallSite[] callSiteArray = _closure35.$getCallSiteArray();
                        return (Map)ScriptBytecodeAdapter.castToType((Object)this.serverGroups.get(), Map.class);
                    }

                    @Generated
                    public Object doCall() {
                        CallSite[] callSiteArray = _closure35.$getCallSiteArray();
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure35.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                        String[] stringArray = new String[1];
                        stringArray[0] = "get";
                        return new CallSiteArray(_closure35.class, stringArray);
                    }

                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                        CallSiteArray callSiteArray;
                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                            callSiteArray = _closure35.$createCallSiteArray();
                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                        }
                        return callSiteArray.array;
                    }
                }
                Object object3 = callSiteArray[5].callSafe(callSiteArray[6].call(callSiteArray[7].callGetProperty(clusterData), callSiteArray[8].callGetProperty(callSiteArray[9].callGetProperty(Namespace.class))), (Object)new _closure35((Object)this, this.getThisObject(), this.serverGroups));
                ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object3, _allClustersByApplication_closure7.class, (GroovyObject)cluster, (String)"serverGroups");
                public final class _closure36
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference loadBalancers;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;
                    private static /* synthetic */ SoftReference $callSiteArray;

                    public _closure36(Object _outerInstance, Object _thisObject, Reference loadBalancers) {
                        Reference reference;
                        CallSite[] callSiteArray = _closure36.$getCallSiteArray();
                        super(_outerInstance, _thisObject);
                        this.loadBalancers = reference = loadBalancers;
                    }

                    public Object doCall(Object it) {
                        CallSite[] callSiteArray = _closure36.$getCallSiteArray();
                        return callSiteArray[0].call(this.loadBalancers.get(), it);
                    }

                    @Generated
                    public Map getLoadBalancers() {
                        CallSite[] callSiteArray = _closure36.$getCallSiteArray();
                        return (Map)ScriptBytecodeAdapter.castToType((Object)this.loadBalancers.get(), Map.class);
                    }

                    @Generated
                    public Object doCall() {
                        CallSite[] callSiteArray = _closure36.$getCallSiteArray();
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure36.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                        String[] stringArray = new String[1];
                        stringArray[0] = "get";
                        return new CallSiteArray(_closure36.class, stringArray);
                    }

                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                        CallSiteArray callSiteArray;
                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                            callSiteArray = _closure36.$createCallSiteArray();
                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                        }
                        return callSiteArray.array;
                    }
                }
                Object object4 = callSiteArray[10].callSafe(callSiteArray[11].call(callSiteArray[12].callGetProperty(clusterData), callSiteArray[13].callGetProperty(callSiteArray[14].callGetProperty(Namespace.class))), (Object)new _closure36((Object)this, this.getThisObject(), this.loadBalancers));
                ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object4, _allClustersByApplication_closure7.class, (GroovyObject)cluster, (String)"loadBalancers");
                public final class _closure37
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference targetGroups;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;
                    private static /* synthetic */ SoftReference $callSiteArray;

                    public _closure37(Object _outerInstance, Object _thisObject, Reference targetGroups) {
                        Reference reference;
                        CallSite[] callSiteArray = _closure37.$getCallSiteArray();
                        super(_outerInstance, _thisObject);
                        this.targetGroups = reference = targetGroups;
                    }

                    public Object doCall(Object it) {
                        CallSite[] callSiteArray = _closure37.$getCallSiteArray();
                        return callSiteArray[0].call(this.targetGroups.get(), it);
                    }

                    @Generated
                    public Map getTargetGroups() {
                        CallSite[] callSiteArray = _closure37.$getCallSiteArray();
                        return (Map)ScriptBytecodeAdapter.castToType((Object)this.targetGroups.get(), Map.class);
                    }

                    @Generated
                    public Object doCall() {
                        CallSite[] callSiteArray = _closure37.$getCallSiteArray();
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure37.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                        String[] stringArray = new String[1];
                        stringArray[0] = "get";
                        return new CallSiteArray(_closure37.class, stringArray);
                    }

                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                        CallSiteArray callSiteArray;
                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                            callSiteArray = _closure37.$createCallSiteArray();
                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                        }
                        return callSiteArray.array;
                    }
                }
                Object object5 = callSiteArray[15].callSafe(callSiteArray[16].call(callSiteArray[17].callGetProperty(clusterData), callSiteArray[18].callGetProperty(callSiteArray[19].callGetProperty(Namespace.class))), (Object)new _closure37((Object)this, this.getThisObject(), this.targetGroups));
                ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object5, _allClustersByApplication_closure7.class, (GroovyObject)cluster, (String)"targetGroups");
                return cluster;
            }

            @Generated
            public Map getServerGroups() {
                CallSite[] callSiteArray = _allClustersByApplication_closure7.$getCallSiteArray();
                return (Map)ScriptBytecodeAdapter.castToType((Object)this.serverGroups.get(), Map.class);
            }

            @Generated
            public Map getLoadBalancers() {
                CallSite[] callSiteArray = _allClustersByApplication_closure7.$getCallSiteArray();
                return (Map)ScriptBytecodeAdapter.castToType((Object)this.loadBalancers.get(), Map.class);
            }

            @Generated
            public Map getTargetGroups() {
                CallSite[] callSiteArray = _allClustersByApplication_closure7.$getCallSiteArray();
                return (Map)ScriptBytecodeAdapter.castToType((Object)this.targetGroups.get(), Map.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _allClustersByApplication_closure7.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "parse";
                stringArray[1] = "id";
                stringArray[2] = "<$constructor$>";
                stringArray[3] = "account";
                stringArray[4] = "cluster";
                stringArray[5] = "findResults";
                stringArray[6] = "getAt";
                stringArray[7] = "relationships";
                stringArray[8] = "ns";
                stringArray[9] = "SERVER_GROUPS";
                stringArray[10] = "findResults";
                stringArray[11] = "getAt";
                stringArray[12] = "relationships";
                stringArray[13] = "ns";
                stringArray[14] = "LOAD_BALANCERS";
                stringArray[15] = "findResults";
                stringArray[16] = "getAt";
                stringArray[17] = "relationships";
                stringArray[18] = "ns";
                stringArray[19] = "TARGET_GROUPS";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[20];
                _allClustersByApplication_closure7.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_allClustersByApplication_closure7.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _allClustersByApplication_closure7.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        Collection clusters = (Collection)ScriptBytecodeAdapter.castToType((Object)callSiteArray[148].call(callSiteArray[149].call(cacheResults, callSiteArray[150].callGetProperty(callSiteArray[151].callGetProperty(Namespace.class))), (Object)new _allClustersByApplication_closure7(this, this, serverGroups, loadBalancers, targetGroups)), Collection.class);
        return clusters;
    }

    private Collection<AmazonCluster> translateClusters(Collection<CacheData> clusterData, boolean includeDetails) {
        Reference includeDetails2 = new Reference((Object)includeDetails);
        CallSite[] callSiteArray = AmazonClusterProvider.$getCallSiteArray();
        Reference loadBalancers = new Reference(null);
        Map cfr_ignored_0 = (Map)loadBalancers.get();
        Reference targetGroups = new Reference(null);
        Map cfr_ignored_1 = (Map)targetGroups.get();
        Reference serverGroups = new Reference(null);
        Map cfr_ignored_2 = (Map)serverGroups.get();
        if (DefaultTypeTransformation.booleanUnbox((Object)includeDetails2.get())) {
            Collection allLoadBalancers = (Collection)ScriptBytecodeAdapter.castToType((Object)callSiteArray[152].callCurrent((GroovyObject)this, clusterData, callSiteArray[153].callGetProperty(callSiteArray[154].callGetProperty(Namespace.class))), Collection.class);
            Collection allTargetGroups = (Collection)ScriptBytecodeAdapter.castToType((Object)callSiteArray[155].callCurrent((GroovyObject)this, clusterData, callSiteArray[156].callGetProperty(callSiteArray[157].callGetProperty(Namespace.class))), Collection.class);
            Collection allServerGroups = (Collection)ScriptBytecodeAdapter.castToType((Object)callSiteArray[158].callCurrent((GroovyObject)this, clusterData, callSiteArray[159].callGetProperty(callSiteArray[160].callGetProperty(Namespace.class)), callSiteArray[161].call(RelationshipCacheFilter.class, callSiteArray[162].callGetProperty(callSiteArray[163].callGetProperty(Namespace.class)), callSiteArray[164].callGetProperty(callSiteArray[165].callGetProperty(Namespace.class)), callSiteArray[166].callGetProperty(callSiteArray[167].callGetProperty(Namespace.class)))), Collection.class);
            Object object = callSiteArray[168].callStatic(AmazonClusterProvider.class, (Object)allLoadBalancers);
            loadBalancers.set((Object)((Map)ScriptBytecodeAdapter.castToType((Object)object, Map.class)));
            Object object2 = callSiteArray[169].callStatic(AmazonClusterProvider.class, (Object)allTargetGroups);
            targetGroups.set((Object)((Map)ScriptBytecodeAdapter.castToType((Object)object2, Map.class)));
            Object object3 = callSiteArray[170].callCurrent((GroovyObject)this, (Object)allServerGroups, (Object)false);
            serverGroups.set((Object)((Map)ScriptBytecodeAdapter.castToType((Object)object3, Map.class)));
        } else {
            Collection allServerGroups = (Collection)ScriptBytecodeAdapter.castToType((Object)callSiteArray[171].callCurrent((GroovyObject)this, clusterData, callSiteArray[172].callGetProperty(callSiteArray[173].callGetProperty(Namespace.class)), callSiteArray[174].call(RelationshipCacheFilter.class)), Collection.class);
            Object object = callSiteArray[175].callCurrent((GroovyObject)this, (Object)allServerGroups, (Object)true);
            serverGroups.set((Object)((Map)ScriptBytecodeAdapter.castToType((Object)object, Map.class)));
        }
        public final class _translateClusters_closure8
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference serverGroups;
            private /* synthetic */ Reference includeDetails;
            private /* synthetic */ Reference loadBalancers;
            private /* synthetic */ Reference targetGroups;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _translateClusters_closure8(Object _outerInstance, Object _thisObject, Reference serverGroups, Reference includeDetails, Reference loadBalancers, Reference targetGroups) {
                Reference reference;
                Reference reference2;
                Reference reference3;
                Reference reference4;
                CallSite[] callSiteArray = _translateClusters_closure8.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.serverGroups = reference4 = serverGroups;
                this.includeDetails = reference3 = includeDetails;
                this.loadBalancers = reference2 = loadBalancers;
                this.targetGroups = reference = targetGroups;
            }

            public Object doCall(CacheData clusterDataEntry) {
                CallSite[] callSiteArray = _translateClusters_closure8.$getCallSiteArray();
                Map clusterKey = (Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[0].call(Keys.class, callSiteArray[1].callGetProperty((Object)clusterDataEntry)), Map.class);
                AmazonCluster cluster = (AmazonCluster)ScriptBytecodeAdapter.castToType((Object)callSiteArray[2].callConstructor(AmazonCluster.class), AmazonCluster.class);
                Object object = callSiteArray[3].callGetProperty((Object)clusterKey);
                ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, _translateClusters_closure8.class, (GroovyObject)cluster, (String)"accountName");
                Object object2 = callSiteArray[4].callGetProperty((Object)clusterKey);
                ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object2, _translateClusters_closure8.class, (GroovyObject)cluster, (String)"name");
                public final class _closure38
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference serverGroups;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;
                    private static /* synthetic */ SoftReference $callSiteArray;

                    public _closure38(Object _outerInstance, Object _thisObject, Reference serverGroups) {
                        Reference reference;
                        CallSite[] callSiteArray = _closure38.$getCallSiteArray();
                        super(_outerInstance, _thisObject);
                        this.serverGroups = reference = serverGroups;
                    }

                    public Object doCall(Object it) {
                        CallSite[] callSiteArray = _closure38.$getCallSiteArray();
                        return callSiteArray[0].call(this.serverGroups.get(), it);
                    }

                    @Generated
                    public Map getServerGroups() {
                        CallSite[] callSiteArray = _closure38.$getCallSiteArray();
                        return (Map)ScriptBytecodeAdapter.castToType((Object)this.serverGroups.get(), Map.class);
                    }

                    @Generated
                    public Object doCall() {
                        CallSite[] callSiteArray = _closure38.$getCallSiteArray();
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure38.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                        String[] stringArray = new String[1];
                        stringArray[0] = "get";
                        return new CallSiteArray(_closure38.class, stringArray);
                    }

                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                        CallSiteArray callSiteArray;
                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                            callSiteArray = _closure38.$createCallSiteArray();
                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                        }
                        return callSiteArray.array;
                    }
                }
                Object object3 = callSiteArray[5].callSafe(callSiteArray[6].call(callSiteArray[7].callGetProperty((Object)clusterDataEntry), callSiteArray[8].callGetProperty(callSiteArray[9].callGetProperty(Namespace.class))), (Object)new _closure38((Object)this, this.getThisObject(), this.serverGroups));
                ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object3, _translateClusters_closure8.class, (GroovyObject)cluster, (String)"serverGroups");
                if (DefaultTypeTransformation.booleanUnbox((Object)this.includeDetails.get())) {
                    public final class _closure39
                    extends Closure
                    implements GeneratedClosure {
                        private /* synthetic */ Reference loadBalancers;
                        private static /* synthetic */ ClassInfo $staticClassInfo;
                        public static transient /* synthetic */ boolean __$stMC;
                        private static /* synthetic */ SoftReference $callSiteArray;

                        public _closure39(Object _outerInstance, Object _thisObject, Reference loadBalancers) {
                            Reference reference;
                            CallSite[] callSiteArray = _closure39.$getCallSiteArray();
                            super(_outerInstance, _thisObject);
                            this.loadBalancers = reference = loadBalancers;
                        }

                        public Object doCall(Object it) {
                            CallSite[] callSiteArray = _closure39.$getCallSiteArray();
                            return callSiteArray[0].call(this.loadBalancers.get(), it);
                        }

                        @Generated
                        public Map getLoadBalancers() {
                            CallSite[] callSiteArray = _closure39.$getCallSiteArray();
                            return (Map)ScriptBytecodeAdapter.castToType((Object)this.loadBalancers.get(), Map.class);
                        }

                        @Generated
                        public Object doCall() {
                            CallSite[] callSiteArray = _closure39.$getCallSiteArray();
                            return this.doCall(null);
                        }

                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                            if (((Object)((Object)this)).getClass() != _closure39.class) {
                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                            }
                            ClassInfo classInfo = $staticClassInfo;
                            if (classInfo == null) {
                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                            }
                            return classInfo.getMetaClass();
                        }

                        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                            String[] stringArray = new String[1];
                            stringArray[0] = "get";
                            return new CallSiteArray(_closure39.class, stringArray);
                        }

                        private static /* synthetic */ CallSite[] $getCallSiteArray() {
                            CallSiteArray callSiteArray;
                            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                                callSiteArray = _closure39.$createCallSiteArray();
                                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                            }
                            return callSiteArray.array;
                        }
                    }
                    Object object4 = callSiteArray[10].callSafe(callSiteArray[11].call(callSiteArray[12].callGetProperty((Object)clusterDataEntry), callSiteArray[13].callGetProperty(callSiteArray[14].callGetProperty(Namespace.class))), (Object)new _closure39((Object)this, this.getThisObject(), this.loadBalancers));
                    ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object4, _translateClusters_closure8.class, (GroovyObject)cluster, (String)"loadBalancers");
                    public final class _closure40
                    extends Closure
                    implements GeneratedClosure {
                        private /* synthetic */ Reference targetGroups;
                        private static /* synthetic */ ClassInfo $staticClassInfo;
                        public static transient /* synthetic */ boolean __$stMC;
                        private static /* synthetic */ SoftReference $callSiteArray;

                        public _closure40(Object _outerInstance, Object _thisObject, Reference targetGroups) {
                            Reference reference;
                            CallSite[] callSiteArray = _closure40.$getCallSiteArray();
                            super(_outerInstance, _thisObject);
                            this.targetGroups = reference = targetGroups;
                        }

                        public Object doCall(Object it) {
                            CallSite[] callSiteArray = _closure40.$getCallSiteArray();
                            return callSiteArray[0].call(this.targetGroups.get(), it);
                        }

                        @Generated
                        public Map getTargetGroups() {
                            CallSite[] callSiteArray = _closure40.$getCallSiteArray();
                            return (Map)ScriptBytecodeAdapter.castToType((Object)this.targetGroups.get(), Map.class);
                        }

                        @Generated
                        public Object doCall() {
                            CallSite[] callSiteArray = _closure40.$getCallSiteArray();
                            return this.doCall(null);
                        }

                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                            if (((Object)((Object)this)).getClass() != _closure40.class) {
                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                            }
                            ClassInfo classInfo = $staticClassInfo;
                            if (classInfo == null) {
                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                            }
                            return classInfo.getMetaClass();
                        }

                        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                            String[] stringArray = new String[1];
                            stringArray[0] = "get";
                            return new CallSiteArray(_closure40.class, stringArray);
                        }

                        private static /* synthetic */ CallSite[] $getCallSiteArray() {
                            CallSiteArray callSiteArray;
                            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                                callSiteArray = _closure40.$createCallSiteArray();
                                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                            }
                            return callSiteArray.array;
                        }
                    }
                    Object object5 = callSiteArray[15].callSafe(callSiteArray[16].call(callSiteArray[17].callGetProperty((Object)clusterDataEntry), callSiteArray[18].callGetProperty(callSiteArray[19].callGetProperty(Namespace.class))), (Object)new _closure40((Object)this, this.getThisObject(), this.targetGroups));
                    ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object5, _translateClusters_closure8.class, (GroovyObject)cluster, (String)"targetGroups");
                } else {
                    public final class _closure41
                    extends Closure
                    implements GeneratedClosure {
                        private static /* synthetic */ ClassInfo $staticClassInfo;
                        public static transient /* synthetic */ boolean __$stMC;
                        private static /* synthetic */ SoftReference $callSiteArray;

                        public _closure41(Object _outerInstance, Object _thisObject) {
                            CallSite[] callSiteArray = _closure41.$getCallSiteArray();
                            super(_outerInstance, _thisObject);
                        }

                        public Object doCall(Object loadBalancerKey) {
                            CallSite[] callSiteArray = _closure41.$getCallSiteArray();
                            Map parts = (Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[0].call(Keys.class, loadBalancerKey), Map.class);
                            return callSiteArray[1].callConstructor(AmazonLoadBalancer.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", callSiteArray[2].callGetProperty((Object)parts), "account", callSiteArray[3].callGetProperty((Object)parts), "region", callSiteArray[4].callGetProperty((Object)parts)}));
                        }

                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                            if (((Object)((Object)this)).getClass() != _closure41.class) {
                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                            }
                            ClassInfo classInfo = $staticClassInfo;
                            if (classInfo == null) {
                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                            }
                            return classInfo.getMetaClass();
                        }

                        private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                            stringArray[0] = "parse";
                            stringArray[1] = "<$constructor$>";
                            stringArray[2] = "loadBalancer";
                            stringArray[3] = "account";
                            stringArray[4] = "region";
                        }

                        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                            String[] stringArray = new String[5];
                            _closure41.$createCallSiteArray_1(stringArray);
                            return new CallSiteArray(_closure41.class, stringArray);
                        }

                        private static /* synthetic */ CallSite[] $getCallSiteArray() {
                            CallSiteArray callSiteArray;
                            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                                callSiteArray = _closure41.$createCallSiteArray();
                                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                            }
                            return callSiteArray.array;
                        }
                    }
                    Object object6 = callSiteArray[20].callSafe(callSiteArray[21].call(callSiteArray[22].callGetProperty((Object)clusterDataEntry), callSiteArray[23].callGetProperty(callSiteArray[24].callGetProperty(Namespace.class))), (Object)new _closure41((Object)this, this.getThisObject()));
                    ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object6, _translateClusters_closure8.class, (GroovyObject)cluster, (String)"loadBalancers");
                    public final class _closure42
                    extends Closure
                    implements GeneratedClosure {
                        private static /* synthetic */ ClassInfo $staticClassInfo;
                        public static transient /* synthetic */ boolean __$stMC;
                        private static /* synthetic */ SoftReference $callSiteArray;

                        public _closure42(Object _outerInstance, Object _thisObject) {
                            CallSite[] callSiteArray = _closure42.$getCallSiteArray();
                            super(_outerInstance, _thisObject);
                        }

                        public Object doCall(Object targetGroupKey) {
                            CallSite[] callSiteArray = _closure42.$getCallSiteArray();
                            Map parts = (Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[0].call(Keys.class, targetGroupKey), Map.class);
                            return callSiteArray[1].callConstructor(AmazonTargetGroup.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", callSiteArray[2].callGetProperty((Object)parts), "account", callSiteArray[3].callGetProperty((Object)parts), "region", callSiteArray[4].callGetProperty((Object)parts)}));
                        }

                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                            if (((Object)((Object)this)).getClass() != _closure42.class) {
                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                            }
                            ClassInfo classInfo = $staticClassInfo;
                            if (classInfo == null) {
                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                            }
                            return classInfo.getMetaClass();
                        }

                        private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                            stringArray[0] = "parse";
                            stringArray[1] = "<$constructor$>";
                            stringArray[2] = "loadBalancer";
                            stringArray[3] = "account";
                            stringArray[4] = "region";
                        }

                        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                            String[] stringArray = new String[5];
                            _closure42.$createCallSiteArray_1(stringArray);
                            return new CallSiteArray(_closure42.class, stringArray);
                        }

                        private static /* synthetic */ CallSite[] $getCallSiteArray() {
                            CallSiteArray callSiteArray;
                            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                                callSiteArray = _closure42.$createCallSiteArray();
                                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                            }
                            return callSiteArray.array;
                        }
                    }
                    Object object7 = callSiteArray[25].callSafe(callSiteArray[26].call(callSiteArray[27].callGetProperty((Object)clusterDataEntry), callSiteArray[28].callGetProperty(callSiteArray[29].callGetProperty(Namespace.class))), (Object)new _closure42((Object)this, this.getThisObject()));
                    ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object7, _translateClusters_closure8.class, (GroovyObject)cluster, (String)"targetGroups");
                }
                return cluster;
            }

            public Object call(CacheData clusterDataEntry) {
                CallSite[] callSiteArray = _translateClusters_closure8.$getCallSiteArray();
                return callSiteArray[30].callCurrent((GroovyObject)this, (Object)clusterDataEntry);
            }

            @Generated
            public Map getServerGroups() {
                CallSite[] callSiteArray = _translateClusters_closure8.$getCallSiteArray();
                return (Map)ScriptBytecodeAdapter.castToType((Object)this.serverGroups.get(), Map.class);
            }

            @Generated
            public boolean getIncludeDetails() {
                CallSite[] callSiteArray = _translateClusters_closure8.$getCallSiteArray();
                return DefaultTypeTransformation.booleanUnbox((Object)this.includeDetails.get());
            }

            @Generated
            public Map getLoadBalancers() {
                CallSite[] callSiteArray = _translateClusters_closure8.$getCallSiteArray();
                return (Map)ScriptBytecodeAdapter.castToType((Object)this.loadBalancers.get(), Map.class);
            }

            @Generated
            public Map getTargetGroups() {
                CallSite[] callSiteArray = _translateClusters_closure8.$getCallSiteArray();
                return (Map)ScriptBytecodeAdapter.castToType((Object)this.targetGroups.get(), Map.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _translateClusters_closure8.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "parse";
                stringArray[1] = "id";
                stringArray[2] = "<$constructor$>";
                stringArray[3] = "account";
                stringArray[4] = "cluster";
                stringArray[5] = "findResults";
                stringArray[6] = "getAt";
                stringArray[7] = "relationships";
                stringArray[8] = "ns";
                stringArray[9] = "SERVER_GROUPS";
                stringArray[10] = "findResults";
                stringArray[11] = "getAt";
                stringArray[12] = "relationships";
                stringArray[13] = "ns";
                stringArray[14] = "LOAD_BALANCERS";
                stringArray[15] = "findResults";
                stringArray[16] = "getAt";
                stringArray[17] = "relationships";
                stringArray[18] = "ns";
                stringArray[19] = "TARGET_GROUPS";
                stringArray[20] = "collect";
                stringArray[21] = "getAt";
                stringArray[22] = "relationships";
                stringArray[23] = "ns";
                stringArray[24] = "LOAD_BALANCERS";
                stringArray[25] = "collect";
                stringArray[26] = "getAt";
                stringArray[27] = "relationships";
                stringArray[28] = "ns";
                stringArray[29] = "TARGET_GROUPS";
                stringArray[30] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[31];
                _translateClusters_closure8.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_translateClusters_closure8.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _translateClusters_closure8.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        Collection clusters = (Collection)ScriptBytecodeAdapter.castToType((Object)callSiteArray[176].call(clusterData, (Object)new _translateClusters_closure8(this, this, serverGroups, includeDetails2, loadBalancers, targetGroups)), Collection.class);
        return clusters;
    }

    private Map<String, Set<AmazonCluster>> getClusters0(String applicationName, boolean includeDetails) {
        CallSite[] callSiteArray = AmazonClusterProvider.$getCallSiteArray();
        Collection clusters = null;
        if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (includeDetails && DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[177].call((Object)this.cacheView))) {
                Object object = callSiteArray[178].callCurrent((GroovyObject)this, (Object)applicationName);
                clusters = (Collection)ScriptBytecodeAdapter.castToType((Object)object, Collection.class);
            } else {
                Collection clusterKeys = (Collection)ScriptBytecodeAdapter.castToType((Object)callSiteArray[179].call((Object)this.cacheView, callSiteArray[180].callGetProperty(callSiteArray[181].callGetProperty(Namespace.class)), callSiteArray[182].call(Keys.class, (Object)"*", (Object)applicationName, (Object)"*")), Collection.class);
                Collection clusterData = (Collection)ScriptBytecodeAdapter.castToType((Object)callSiteArray[183].call((Object)this.cacheView, callSiteArray[184].callGetProperty(callSiteArray[185].callGetProperty(Namespace.class)), (Object)clusterKeys), Collection.class);
                Object object = callSiteArray[186].callCurrent((GroovyObject)this, (Object)clusterData, (Object)includeDetails);
                clusters = (Collection)ScriptBytecodeAdapter.castToType((Object)object, Collection.class);
            }
        } else if (includeDetails && DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[187].call((Object)this.cacheView))) {
            Collection collection;
            clusters = collection = this.allClustersByApplication(applicationName);
        } else {
            Collection clusterKeys = (Collection)ScriptBytecodeAdapter.castToType((Object)callSiteArray[188].call((Object)this.cacheView, callSiteArray[189].callGetProperty(callSiteArray[190].callGetProperty(Namespace.class)), callSiteArray[191].call(Keys.class, (Object)"*", (Object)applicationName, (Object)"*")), Collection.class);
            Collection clusterData = (Collection)ScriptBytecodeAdapter.castToType((Object)callSiteArray[192].call((Object)this.cacheView, callSiteArray[193].callGetProperty(callSiteArray[194].callGetProperty(Namespace.class)), (Object)clusterKeys), Collection.class);
            Object object = callSiteArray[195].callCurrent((GroovyObject)this, (Object)clusterData, (Object)includeDetails);
            clusters = (Collection)ScriptBytecodeAdapter.castToType((Object)object, Collection.class);
        }
        if (!DefaultTypeTransformation.booleanUnbox((Object)clusters)) {
            return (Map)ScriptBytecodeAdapter.castToType(null, Map.class);
        }
        return (Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[196].callStatic(AmazonClusterProvider.class, (Object)clusters), Map.class);
    }

    private Map<String, AmazonServerGroup> translateServerGroups(Collection<CacheData> serverGroupData, Collection<CacheData> instanceData, Collection<CacheData> launchConfigData, Collection<CacheData> launchTemplateData, Collection<CacheData> imageData) {
        CallSite[] callSiteArray = AmazonClusterProvider.$getCallSiteArray();
        Reference instances = new Reference((Object)((Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[197].callCurrent((GroovyObject)this, instanceData), Map.class)));
        public final class _translateServerGroups_closure9
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference instances;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _translateServerGroups_closure9(Object _outerInstance, Object _thisObject, Reference instances) {
                Reference reference;
                CallSite[] callSiteArray = _translateServerGroups_closure9.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.instances = reference = instances;
            }

            public Object doCall(Object sg) {
                CallSite[] callSiteArray = _translateServerGroups_closure9.$getCallSiteArray();
                Map parsed = (Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[0].call(Keys.class, callSiteArray[1].callGetProperty(sg)), Map.class);
                AmazonServerGroup serverGroup = (AmazonServerGroup)ScriptBytecodeAdapter.castToType((Object)callSiteArray[2].callConstructor(AmazonServerGroup.class, callSiteArray[3].callGetProperty(sg)), AmazonServerGroup.class);
                Set asgInstanceSet = (Set)ScriptBytecodeAdapter.castToType((Object)callSiteArray[4].callStatic(AmazonClusterProvider.class, callSiteArray[5].callGroovyObjectGetProperty((Object)serverGroup), callSiteArray[6].callGetProperty((Object)parsed), callSiteArray[7].callGetProperty((Object)parsed)), Set.class);
                public final class _closure43
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference instances;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;
                    private static /* synthetic */ SoftReference $callSiteArray;

                    public _closure43(Object _outerInstance, Object _thisObject, Reference instances) {
                        Reference reference;
                        CallSite[] callSiteArray = _closure43.$getCallSiteArray();
                        super(_outerInstance, _thisObject);
                        this.instances = reference = instances;
                    }

                    public Object doCall(Object it) {
                        CallSite[] callSiteArray = _closure43.$getCallSiteArray();
                        return callSiteArray[0].call(this.instances.get(), it);
                    }

                    @Generated
                    public Map getInstances() {
                        CallSite[] callSiteArray = _closure43.$getCallSiteArray();
                        return (Map)ScriptBytecodeAdapter.castToType((Object)this.instances.get(), Map.class);
                    }

                    @Generated
                    public Object doCall() {
                        CallSite[] callSiteArray = _closure43.$getCallSiteArray();
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure43.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                        String[] stringArray = new String[1];
                        stringArray[0] = "containsKey";
                        return new CallSiteArray(_closure43.class, stringArray);
                    }

                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                        CallSiteArray callSiteArray;
                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                            callSiteArray = _closure43.$createCallSiteArray();
                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                        }
                        return callSiteArray.array;
                    }
                }
                public final class _closure44
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference instances;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;
                    private static /* synthetic */ SoftReference $callSiteArray;

                    public _closure44(Object _outerInstance, Object _thisObject, Reference instances) {
                        Reference reference;
                        CallSite[] callSiteArray = _closure44.$getCallSiteArray();
                        super(_outerInstance, _thisObject);
                        this.instances = reference = instances;
                    }

                    public Object doCall(Object it) {
                        CallSite[] callSiteArray = _closure44.$getCallSiteArray();
                        return callSiteArray[0].call(this.instances.get(), it);
                    }

                    @Generated
                    public Map getInstances() {
                        CallSite[] callSiteArray = _closure44.$getCallSiteArray();
                        return (Map)ScriptBytecodeAdapter.castToType((Object)this.instances.get(), Map.class);
                    }

                    @Generated
                    public Object doCall() {
                        CallSite[] callSiteArray = _closure44.$getCallSiteArray();
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure44.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                        String[] stringArray = new String[1];
                        stringArray[0] = "get";
                        return new CallSiteArray(_closure44.class, stringArray);
                    }

                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                        CallSiteArray callSiteArray;
                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                            callSiteArray = _closure44.$createCallSiteArray();
                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                        }
                        return callSiteArray.array;
                    }
                }
                Object object = callSiteArray[8].call(callSiteArray[9].call((Object)asgInstanceSet, (Object)new _closure43((Object)this, this.getThisObject(), this.instances)), (Object)new _closure44((Object)this, this.getThisObject(), this.instances));
                ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, _translateServerGroups_closure9.class, (GroovyObject)serverGroup, (String)"instances");
                return ScriptBytecodeAdapter.createMap((Object[])new Object[]{callSiteArray[10].callGetProperty(sg), serverGroup});
            }

            @Generated
            public Map getInstances() {
                CallSite[] callSiteArray = _translateServerGroups_closure9.$getCallSiteArray();
                return (Map)ScriptBytecodeAdapter.castToType((Object)this.instances.get(), Map.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _translateServerGroups_closure9.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "parse";
                stringArray[1] = "id";
                stringArray[2] = "<$constructor$>";
                stringArray[3] = "attributes";
                stringArray[4] = "getAsgInstanceKeys";
                stringArray[5] = "asg";
                stringArray[6] = "account";
                stringArray[7] = "region";
                stringArray[8] = "collect";
                stringArray[9] = "findAll";
                stringArray[10] = "id";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[11];
                _translateServerGroups_closure9.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_translateServerGroups_closure9.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _translateServerGroups_closure9.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        Map serverGroups = (Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[198].callSafe(serverGroupData, (Object)new _translateServerGroups_closure9(this, this, instances)), Map.class);
        callSiteArray[199].callStatic(AmazonClusterProvider.class, (Object)serverGroups, launchTemplateData);
        callSiteArray[200].callStatic(AmazonClusterProvider.class, (Object)serverGroups, launchConfigData);
        callSiteArray[201].callCurrent((GroovyObject)this, (Object)serverGroups, launchTemplateData, imageData);
        callSiteArray[202].callCurrent((GroovyObject)this, (Object)serverGroups, launchConfigData, imageData);
        return serverGroups;
    }

    private Map<String, AmazonServerGroup> translateServerGroups(Collection<CacheData> serverGroupData, boolean includePartialInstances) {
        Reference includePartialInstances2 = new Reference((Object)includePartialInstances);
        CallSite[] callSiteArray = AmazonClusterProvider.$getCallSiteArray();
        Collection allInstances = (Collection)ScriptBytecodeAdapter.castToType((Object)callSiteArray[203].callCurrent((GroovyObject)this, serverGroupData, callSiteArray[204].callGetProperty(callSiteArray[205].callGetProperty(Namespace.class)), callSiteArray[206].call(RelationshipCacheFilter.class)), Collection.class);
        Reference instances = new Reference((Object)((Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[207].callCurrent((GroovyObject)this, (Object)allInstances), Map.class)));
        public final class _translateServerGroups_closure10
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference instances;
            private /* synthetic */ Reference includePartialInstances;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _translateServerGroups_closure10(Object _outerInstance, Object _thisObject, Reference instances, Reference includePartialInstances) {
                Reference reference;
                Reference reference2;
                CallSite[] callSiteArray = _translateServerGroups_closure10.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.instances = reference2 = instances;
                this.includePartialInstances = reference = includePartialInstances;
            }

            public Object doCall(Object serverGroupEntry) {
                CallSite[] callSiteArray = _translateServerGroups_closure10.$getCallSiteArray();
                Map serverGroupKey = (Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[0].call(Keys.class, callSiteArray[1].callGetProperty(serverGroupEntry)), Map.class);
                AmazonServerGroup serverGroup = (AmazonServerGroup)ScriptBytecodeAdapter.castToType((Object)callSiteArray[2].callConstructor(AmazonServerGroup.class, callSiteArray[3].callGetProperty(serverGroupEntry)), AmazonServerGroup.class);
                Object asg = callSiteArray[4].callGetProperty(callSiteArray[5].callGetProperty(serverGroupEntry));
                Reference asgInstanceSet = new Reference((Object)((Set)ScriptBytecodeAdapter.castToType((Object)callSiteArray[6].callStatic(AmazonClusterProvider.class, asg, callSiteArray[7].callGetProperty((Object)serverGroupKey), callSiteArray[8].callGetProperty((Object)serverGroupKey)), Set.class)));
                public final class _closure45
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference asgInstanceSet;
                    private /* synthetic */ Reference instances;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;
                    private static /* synthetic */ SoftReference $callSiteArray;

                    public _closure45(Object _outerInstance, Object _thisObject, Reference asgInstanceSet, Reference instances) {
                        Reference reference;
                        Reference reference2;
                        CallSite[] callSiteArray = _closure45.$getCallSiteArray();
                        super(_outerInstance, _thisObject);
                        this.asgInstanceSet = reference2 = asgInstanceSet;
                        this.instances = reference = instances;
                    }

                    public Object doCall(Object it) {
                        CallSite[] callSiteArray = _closure45.$getCallSiteArray();
                        if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass() ? ScriptBytecodeAdapter.compareNotEqual((Object)this.asgInstanceSet.get(), null) && !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[0].call(this.asgInstanceSet.get(), it)) : ScriptBytecodeAdapter.compareNotEqual((Object)this.asgInstanceSet.get(), null) && !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[1].call(this.asgInstanceSet.get(), it))) {
                            return null;
                        }
                        return callSiteArray[2].call(this.instances.get(), it);
                    }

                    @Generated
                    public Set getAsgInstanceSet() {
                        CallSite[] callSiteArray = _closure45.$getCallSiteArray();
                        return (Set)ScriptBytecodeAdapter.castToType((Object)this.asgInstanceSet.get(), Set.class);
                    }

                    @Generated
                    public Map getInstances() {
                        CallSite[] callSiteArray = _closure45.$getCallSiteArray();
                        return (Map)ScriptBytecodeAdapter.castToType((Object)this.instances.get(), Map.class);
                    }

                    @Generated
                    public Object doCall() {
                        CallSite[] callSiteArray = _closure45.$getCallSiteArray();
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure45.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                        stringArray[0] = "contains";
                        stringArray[1] = "contains";
                        stringArray[2] = "get";
                    }

                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                        String[] stringArray = new String[3];
                        _closure45.$createCallSiteArray_1(stringArray);
                        return new CallSiteArray(_closure45.class, stringArray);
                    }

                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                        CallSiteArray callSiteArray;
                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                            callSiteArray = _closure45.$createCallSiteArray();
                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                        }
                        return callSiteArray.array;
                    }
                }
                Object object = callSiteArray[9].callSafe(callSiteArray[10].call(callSiteArray[11].callGetProperty(serverGroupEntry), callSiteArray[12].callGetProperty(callSiteArray[13].callGetProperty(Namespace.class))), (Object)new _closure45((Object)this, this.getThisObject(), asgInstanceSet, this.instances));
                Object object2 = DefaultTypeTransformation.booleanUnbox((Object)object) ? object : ScriptBytecodeAdapter.createList((Object[])new Object[0]);
                ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object2, _translateServerGroups_closure10.class, (GroovyObject)serverGroup, (String)"instances");
                if (DefaultTypeTransformation.booleanUnbox((Object)this.includePartialInstances.get()) && !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[14].callGroovyObjectGetProperty((Object)serverGroup)) && DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[15].callGetProperty(callSiteArray[16].callGetProperty(serverGroupEntry)))) {
                    Reference validStates = new Reference((Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{callSiteArray[17].call(callSiteArray[18].callGetProperty(LifecycleState.class))}));
                    public final class _closure46
                    extends Closure
                    implements GeneratedClosure {
                        private /* synthetic */ Reference validStates;
                        private static /* synthetic */ ClassInfo $staticClassInfo;
                        public static transient /* synthetic */ boolean __$stMC;
                        private static /* synthetic */ SoftReference $callSiteArray;

                        public _closure46(Object _outerInstance, Object _thisObject, Reference validStates) {
                            Reference reference;
                            CallSite[] callSiteArray = _closure46.$getCallSiteArray();
                            super(_outerInstance, _thisObject);
                            this.validStates = reference = validStates;
                        }

                        public Object doCall(Object it) {
                            CallSite[] callSiteArray = _closure46.$getCallSiteArray();
                            return callSiteArray[0].call(this.validStates.get(), callSiteArray[1].callGetProperty(it));
                        }

                        @Generated
                        public Object getValidStates() {
                            CallSite[] callSiteArray = _closure46.$getCallSiteArray();
                            return this.validStates.get();
                        }

                        @Generated
                        public Object doCall() {
                            CallSite[] callSiteArray = _closure46.$getCallSiteArray();
                            return this.doCall(null);
                        }

                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                            if (((Object)((Object)this)).getClass() != _closure46.class) {
                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                            }
                            ClassInfo classInfo = $staticClassInfo;
                            if (classInfo == null) {
                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                            }
                            return classInfo.getMetaClass();
                        }

                        private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                            stringArray[0] = "contains";
                            stringArray[1] = "lifecycleState";
                        }

                        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                            String[] stringArray = new String[2];
                            _closure46.$createCallSiteArray_1(stringArray);
                            return new CallSiteArray(_closure46.class, stringArray);
                        }

                        private static /* synthetic */ CallSite[] $getCallSiteArray() {
                            CallSiteArray callSiteArray;
                            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                                callSiteArray = _closure46.$createCallSiteArray();
                                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                            }
                            return callSiteArray.array;
                        }
                    }
                    public final class _closure47
                    extends Closure
                    implements GeneratedClosure {
                        private static /* synthetic */ ClassInfo $staticClassInfo;
                        public static transient /* synthetic */ boolean __$stMC;
                        private static /* synthetic */ SoftReference $callSiteArray;

                        public _closure47(Object _outerInstance, Object _thisObject) {
                            CallSite[] callSiteArray = _closure47.$getCallSiteArray();
                            super(_outerInstance, _thisObject);
                        }

                        public Object doCall(Object it) {
                            CallSite[] callSiteArray = _closure47.$getCallSiteArray();
                            return callSiteArray[0].callConstructor(AmazonInstance.class, callSiteArray[1].call((Object)((Map)ScriptBytecodeAdapter.castToType((Object)it, Map.class)), (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", callSiteArray[2].callGetProperty(it)})));
                        }

                        @Generated
                        public Object doCall() {
                            CallSite[] callSiteArray = _closure47.$getCallSiteArray();
                            return this.doCall(null);
                        }

                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                            if (((Object)((Object)this)).getClass() != _closure47.class) {
                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                            }
                            ClassInfo classInfo = $staticClassInfo;
                            if (classInfo == null) {
                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                            }
                            return classInfo.getMetaClass();
                        }

                        private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                            stringArray[0] = "<$constructor$>";
                            stringArray[1] = "plus";
                            stringArray[2] = "instanceId";
                        }

                        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                            String[] stringArray = new String[3];
                            _closure47.$createCallSiteArray_1(stringArray);
                            return new CallSiteArray(_closure47.class, stringArray);
                        }

                        private static /* synthetic */ CallSite[] $getCallSiteArray() {
                            CallSiteArray callSiteArray;
                            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                                callSiteArray = _closure47.$createCallSiteArray();
                                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                            }
                            return callSiteArray.array;
                        }
                    }
                    Object object3 = callSiteArray[19].call(callSiteArray[20].call((Object)((List)ScriptBytecodeAdapter.asType((Object)callSiteArray[21].callGetProperty(callSiteArray[22].callGetProperty(serverGroupEntry)), List.class)), (Object)new _closure46((Object)this, this.getThisObject(), validStates)), (Object)new _closure47((Object)this, this.getThisObject()));
                    ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object3, _translateServerGroups_closure10.class, (GroovyObject)serverGroup, (String)"instances");
                }
                return ScriptBytecodeAdapter.createMap((Object[])new Object[]{callSiteArray[23].callGetProperty(serverGroupEntry), serverGroup});
            }

            @Generated
            public Map getInstances() {
                CallSite[] callSiteArray = _translateServerGroups_closure10.$getCallSiteArray();
                return (Map)ScriptBytecodeAdapter.castToType((Object)this.instances.get(), Map.class);
            }

            @Generated
            public boolean getIncludePartialInstances() {
                CallSite[] callSiteArray = _translateServerGroups_closure10.$getCallSiteArray();
                return DefaultTypeTransformation.booleanUnbox((Object)this.includePartialInstances.get());
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _translateServerGroups_closure10.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "parse";
                stringArray[1] = "id";
                stringArray[2] = "<$constructor$>";
                stringArray[3] = "attributes";
                stringArray[4] = "asg";
                stringArray[5] = "attributes";
                stringArray[6] = "getAsgInstanceKeys";
                stringArray[7] = "account";
                stringArray[8] = "region";
                stringArray[9] = "findResults";
                stringArray[10] = "getAt";
                stringArray[11] = "relationships";
                stringArray[12] = "ns";
                stringArray[13] = "INSTANCES";
                stringArray[14] = "instances";
                stringArray[15] = "instances";
                stringArray[16] = "attributes";
                stringArray[17] = "name";
                stringArray[18] = "InService";
                stringArray[19] = "collect";
                stringArray[20] = "findAll";
                stringArray[21] = "instances";
                stringArray[22] = "attributes";
                stringArray[23] = "id";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[24];
                _translateServerGroups_closure10.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_translateServerGroups_closure10.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _translateServerGroups_closure10.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        Reference serverGroups = new Reference((Object)((Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[208].call(serverGroupData, (Object)new _translateServerGroups_closure10(this, this, instances, includePartialInstances2)), Map.class)));
        public final class _translateServerGroups_closure11
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _translateServerGroups_closure11(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _translateServerGroups_closure11.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _translateServerGroups_closure11.$getCallSiteArray();
                return callSiteArray[0].call(callSiteArray[1].callGetProperty(it), callSiteArray[2].callGetProperty(callSiteArray[3].callGetProperty(Namespace.class)));
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _translateServerGroups_closure11.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _translateServerGroups_closure11.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "getAt";
                stringArray[1] = "relationships";
                stringArray[2] = "ns";
                stringArray[3] = "LAUNCH_CONFIGS";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[4];
                _translateServerGroups_closure11.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_translateServerGroups_closure11.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _translateServerGroups_closure11.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        public final class _translateServerGroups_closure12
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _translateServerGroups_closure12(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _translateServerGroups_closure12.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _translateServerGroups_closure12.$getCallSiteArray();
                return ScriptBytecodeAdapter.createMap((Object[])new Object[]{callSiteArray[0].call(callSiteArray[1].call(callSiteArray[2].callGetProperty(it), callSiteArray[3].callGetProperty(callSiteArray[4].callGetProperty(Namespace.class)))), callSiteArray[5].callGetProperty(it)});
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _translateServerGroups_closure12.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _translateServerGroups_closure12.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "first";
                stringArray[1] = "getAt";
                stringArray[2] = "relationships";
                stringArray[3] = "ns";
                stringArray[4] = "LAUNCH_CONFIGS";
                stringArray[5] = "id";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[6];
                _translateServerGroups_closure12.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_translateServerGroups_closure12.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _translateServerGroups_closure12.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        Reference launchConfigurations = new Reference((Object)((Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[209].call(callSiteArray[210].call(serverGroupData, (Object)new _translateServerGroups_closure11(this, this)), (Object)new _translateServerGroups_closure12(this, this)), Map.class)));
        public final class _translateServerGroups_closure13
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _translateServerGroups_closure13(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _translateServerGroups_closure13.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _translateServerGroups_closure13.$getCallSiteArray();
                return callSiteArray[0].call(callSiteArray[1].callGetProperty(it), callSiteArray[2].callGetProperty(callSiteArray[3].callGetProperty(Namespace.class)));
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _translateServerGroups_closure13.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _translateServerGroups_closure13.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "getAt";
                stringArray[1] = "relationships";
                stringArray[2] = "ns";
                stringArray[3] = "LAUNCH_TEMPLATES";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[4];
                _translateServerGroups_closure13.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_translateServerGroups_closure13.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _translateServerGroups_closure13.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        public final class _translateServerGroups_closure14
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _translateServerGroups_closure14(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _translateServerGroups_closure14.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _translateServerGroups_closure14.$getCallSiteArray();
                return ScriptBytecodeAdapter.createMap((Object[])new Object[]{callSiteArray[0].call(callSiteArray[1].call(callSiteArray[2].callGetProperty(it), callSiteArray[3].callGetProperty(callSiteArray[4].callGetProperty(Namespace.class)))), callSiteArray[5].callGetProperty(it)});
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _translateServerGroups_closure14.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _translateServerGroups_closure14.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "first";
                stringArray[1] = "getAt";
                stringArray[2] = "relationships";
                stringArray[3] = "ns";
                stringArray[4] = "LAUNCH_TEMPLATES";
                stringArray[5] = "id";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[6];
                _translateServerGroups_closure14.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_translateServerGroups_closure14.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _translateServerGroups_closure14.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        Reference templates = new Reference((Object)((Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[211].call(callSiteArray[212].call(serverGroupData, (Object)new _translateServerGroups_closure13(this, this)), (Object)new _translateServerGroups_closure14(this, this)), Map.class)));
        Collection launchConfigs = (Collection)ScriptBytecodeAdapter.castToType((Object)callSiteArray[213].call((Object)this.cacheView, callSiteArray[214].callGetProperty(callSiteArray[215].callGetProperty(Namespace.class)), callSiteArray[216].call((Object)((Map)launchConfigurations.get()))), Collection.class);
        Reference allImages = new Reference((Object)ScriptBytecodeAdapter.createMap((Object[])new Object[0]));
        public final class _translateServerGroups_closure15
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference launchConfigurations;
            private /* synthetic */ Reference serverGroups;
            private /* synthetic */ Reference allImages;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _translateServerGroups_closure15(Object _outerInstance, Object _thisObject, Reference launchConfigurations, Reference serverGroups, Reference allImages) {
                Reference reference;
                Reference reference2;
                Reference reference3;
                CallSite[] callSiteArray = _translateServerGroups_closure15.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.launchConfigurations = reference3 = launchConfigurations;
                this.serverGroups = reference2 = serverGroups;
                this.allImages = reference = allImages;
            }

            public Object doCall(Object launchConfig) {
                CallSite[] callSiteArray = _translateServerGroups_closure15.$getCallSiteArray();
                Object serverGroupId = callSiteArray[0].call(this.launchConfigurations.get(), callSiteArray[1].callGetProperty(launchConfig));
                Object imageId = callSiteArray[2].callSafe(callSiteArray[3].call(callSiteArray[4].callGetProperty(launchConfig), callSiteArray[5].callGetProperty(callSiteArray[6].callGetProperty(Namespace.class))));
                Object object = callSiteArray[7].callGetProperty(launchConfig);
                ScriptBytecodeAdapter.setProperty((Object)object, null, (Object)callSiteArray[8].call(this.serverGroups.get(), serverGroupId), (String)"launchConfig");
                if (DefaultTypeTransformation.booleanUnbox((Object)imageId)) {
                    if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[9].call(this.allImages.get(), imageId))) {
                        callSiteArray[10].call(this.allImages.get(), imageId, (Object)ScriptBytecodeAdapter.createList((Object[])new Object[0]));
                    }
                    return callSiteArray[11].call(callSiteArray[12].call(this.allImages.get(), imageId), serverGroupId);
                }
                return null;
            }

            @Generated
            public Map getLaunchConfigurations() {
                CallSite[] callSiteArray = _translateServerGroups_closure15.$getCallSiteArray();
                return (Map)ScriptBytecodeAdapter.castToType((Object)this.launchConfigurations.get(), Map.class);
            }

            @Generated
            public Map getServerGroups() {
                CallSite[] callSiteArray = _translateServerGroups_closure15.$getCallSiteArray();
                return (Map)ScriptBytecodeAdapter.castToType((Object)this.serverGroups.get(), Map.class);
            }

            @Generated
            public Map getAllImages() {
                CallSite[] callSiteArray = _translateServerGroups_closure15.$getCallSiteArray();
                return (Map)ScriptBytecodeAdapter.castToType((Object)this.allImages.get(), Map.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _translateServerGroups_closure15.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "getAt";
                stringArray[1] = "id";
                stringArray[2] = "first";
                stringArray[3] = "getAt";
                stringArray[4] = "relationships";
                stringArray[5] = "ns";
                stringArray[6] = "IMAGES";
                stringArray[7] = "attributes";
                stringArray[8] = "getAt";
                stringArray[9] = "containsKey";
                stringArray[10] = "put";
                stringArray[11] = "leftShift";
                stringArray[12] = "getAt";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[13];
                _translateServerGroups_closure15.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_translateServerGroups_closure15.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _translateServerGroups_closure15.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[217].call((Object)launchConfigs, (Object)new _translateServerGroups_closure15(this, this, launchConfigurations, serverGroups, allImages));
        Collection launchTemplates = (Collection)ScriptBytecodeAdapter.castToType((Object)callSiteArray[218].call((Object)this.cacheView, callSiteArray[219].callGetProperty(callSiteArray[220].callGetProperty(Namespace.class)), callSiteArray[221].call((Object)((Map)templates.get()))), Collection.class);
        public final class _translateServerGroups_closure16
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference templates;
            private /* synthetic */ Reference serverGroups;
            private /* synthetic */ Reference allImages;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _translateServerGroups_closure16(Object _outerInstance, Object _thisObject, Reference templates, Reference serverGroups, Reference allImages) {
                Reference reference;
                Reference reference2;
                Reference reference3;
                CallSite[] callSiteArray = _translateServerGroups_closure16.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.templates = reference3 = templates;
                this.serverGroups = reference2 = serverGroups;
                this.allImages = reference = allImages;
            }

            public Object doCall(Object launchTemplate) {
                CallSite[] callSiteArray = _translateServerGroups_closure16.$getCallSiteArray();
                Object serverGroupId = callSiteArray[0].call(this.templates.get(), callSiteArray[1].callGetProperty(launchTemplate));
                callSiteArray[2].callStatic(AmazonClusterProvider.class, callSiteArray[3].call(this.serverGroups.get(), serverGroupId), launchTemplate);
                String imageId = ShortTypeHandling.castToString((Object)callSiteArray[4].callSafe(callSiteArray[5].call(callSiteArray[6].callGetProperty(launchTemplate), callSiteArray[7].callGetProperty(callSiteArray[8].callGetProperty(Namespace.class)))));
                if (DefaultTypeTransformation.booleanUnbox((Object)imageId)) {
                    if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[9].call(this.allImages.get(), (Object)imageId))) {
                        callSiteArray[10].call(this.allImages.get(), (Object)imageId, (Object)ScriptBytecodeAdapter.createList((Object[])new Object[0]));
                    }
                    return callSiteArray[11].call(callSiteArray[12].call(this.allImages.get(), (Object)imageId), serverGroupId);
                }
                return null;
            }

            @Generated
            public Map getTemplates() {
                CallSite[] callSiteArray = _translateServerGroups_closure16.$getCallSiteArray();
                return (Map)ScriptBytecodeAdapter.castToType((Object)this.templates.get(), Map.class);
            }

            @Generated
            public Map getServerGroups() {
                CallSite[] callSiteArray = _translateServerGroups_closure16.$getCallSiteArray();
                return (Map)ScriptBytecodeAdapter.castToType((Object)this.serverGroups.get(), Map.class);
            }

            @Generated
            public Map getAllImages() {
                CallSite[] callSiteArray = _translateServerGroups_closure16.$getCallSiteArray();
                return (Map)ScriptBytecodeAdapter.castToType((Object)this.allImages.get(), Map.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _translateServerGroups_closure16.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "getAt";
                stringArray[1] = "id";
                stringArray[2] = "populateServerGroupWithLtOrMip";
                stringArray[3] = "getAt";
                stringArray[4] = "first";
                stringArray[5] = "getAt";
                stringArray[6] = "relationships";
                stringArray[7] = "ns";
                stringArray[8] = "IMAGES";
                stringArray[9] = "containsKey";
                stringArray[10] = "put";
                stringArray[11] = "leftShift";
                stringArray[12] = "getAt";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[13];
                _translateServerGroups_closure16.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_translateServerGroups_closure16.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _translateServerGroups_closure16.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[222].call((Object)launchTemplates, (Object)new _translateServerGroups_closure16(this, this, templates, serverGroups, allImages));
        Collection images = (Collection)ScriptBytecodeAdapter.castToType((Object)callSiteArray[223].call((Object)this.cacheView, callSiteArray[224].callGetProperty(callSiteArray[225].callGetProperty(Namespace.class)), callSiteArray[226].call((Object)((Map)allImages.get()))), Collection.class);
        public final class _translateServerGroups_closure17
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference allImages;
            private /* synthetic */ Reference serverGroups;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _translateServerGroups_closure17(Object _outerInstance, Object _thisObject, Reference allImages, Reference serverGroups) {
                Reference reference;
                Reference reference2;
                CallSite[] callSiteArray = _translateServerGroups_closure17.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.allImages = reference2 = allImages;
                this.serverGroups = reference = serverGroups;
            }

            public Object doCall(Object image) {
                Reference image2 = new Reference(image);
                CallSite[] callSiteArray = _translateServerGroups_closure17.$getCallSiteArray();
                Object serverGroupIds = callSiteArray[0].call(this.allImages.get(), callSiteArray[1].callGetProperty(image2.get()));
                public final class _closure48
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference serverGroups;
                    private /* synthetic */ Reference image;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;
                    private static /* synthetic */ SoftReference $callSiteArray;

                    public _closure48(Object _outerInstance, Object _thisObject, Reference serverGroups, Reference image) {
                        Reference reference;
                        Reference reference2;
                        CallSite[] callSiteArray = _closure48.$getCallSiteArray();
                        super(_outerInstance, _thisObject);
                        this.serverGroups = reference2 = serverGroups;
                        this.image = reference = image;
                    }

                    public Object doCall(Object serverGroupId) {
                        CallSite[] callSiteArray = _closure48.$getCallSiteArray();
                        Object serverGroup = callSiteArray[0].call(this.serverGroups.get(), serverGroupId);
                        Object object = callSiteArray[1].callGetProperty(this.image.get());
                        ScriptBytecodeAdapter.setProperty((Object)object, null, (Object)serverGroup, (String)"image");
                        Object object2 = callSiteArray[2].callCurrent((GroovyObject)this, this.image.get());
                        ScriptBytecodeAdapter.setProperty((Object)object2, null, (Object)serverGroup, (String)"buildInfo");
                        return object2;
                    }

                    @Generated
                    public Map getServerGroups() {
                        CallSite[] callSiteArray = _closure48.$getCallSiteArray();
                        return (Map)ScriptBytecodeAdapter.castToType((Object)this.serverGroups.get(), Map.class);
                    }

                    @Generated
                    public Object getImage() {
                        CallSite[] callSiteArray = _closure48.$getCallSiteArray();
                        return this.image.get();
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure48.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                        stringArray[0] = "getAt";
                        stringArray[1] = "attributes";
                        stringArray[2] = "getBuildInfoFromImage";
                    }

                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                        String[] stringArray = new String[3];
                        _closure48.$createCallSiteArray_1(stringArray);
                        return new CallSiteArray(_closure48.class, stringArray);
                    }

                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                        CallSiteArray callSiteArray;
                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                            callSiteArray = _closure48.$createCallSiteArray();
                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                        }
                        return callSiteArray.array;
                    }
                }
                return callSiteArray[2].call(serverGroupIds, (Object)new _closure48((Object)this, this.getThisObject(), this.serverGroups, image2));
            }

            @Generated
            public Map getAllImages() {
                CallSite[] callSiteArray = _translateServerGroups_closure17.$getCallSiteArray();
                return (Map)ScriptBytecodeAdapter.castToType((Object)this.allImages.get(), Map.class);
            }

            @Generated
            public Map getServerGroups() {
                CallSite[] callSiteArray = _translateServerGroups_closure17.$getCallSiteArray();
                return (Map)ScriptBytecodeAdapter.castToType((Object)this.serverGroups.get(), Map.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _translateServerGroups_closure17.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "getAt";
                stringArray[1] = "id";
                stringArray[2] = "each";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[3];
                _translateServerGroups_closure17.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_translateServerGroups_closure17.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _translateServerGroups_closure17.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[227].call((Object)images, (Object)new _translateServerGroups_closure17(this, this, allImages, serverGroups));
        return (Map)serverGroups.get();
    }

    private Map<String, AmazonInstance> translateInstances(Collection<CacheData> instanceData) {
        CallSite[] callSiteArray = AmazonClusterProvider.$getCallSiteArray();
        public final class _translateInstances_closure18
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _translateInstances_closure18(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _translateInstances_closure18.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object instanceEntry) {
                CallSite[] callSiteArray = _translateInstances_closure18.$getCallSiteArray();
                AmazonInstance instance = (AmazonInstance)ScriptBytecodeAdapter.castToType((Object)callSiteArray[0].callConstructor(AmazonInstance.class, callSiteArray[1].callGetProperty(instanceEntry)), AmazonInstance.class);
                Object object = callSiteArray[2].call(callSiteArray[3].callGetProperty(callSiteArray[4].callGetProperty(instanceEntry)));
                ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, _translateInstances_closure18.class, (GroovyObject)instance, (String)"name");
                return ScriptBytecodeAdapter.createMap((Object[])new Object[]{callSiteArray[5].callGetProperty(instanceEntry), instance});
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _translateInstances_closure18.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "<$constructor$>";
                stringArray[1] = "attributes";
                stringArray[2] = "toString";
                stringArray[3] = "instanceId";
                stringArray[4] = "attributes";
                stringArray[5] = "id";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[6];
                _translateInstances_closure18.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_translateInstances_closure18.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _translateInstances_closure18.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        Object object = callSiteArray[228].callSafe(instanceData, (Object)new _translateInstances_closure18(this, this));
        Map instances = (Map)ScriptBytecodeAdapter.castToType((Object)(DefaultTypeTransformation.booleanUnbox((Object)object) ? object : ScriptBytecodeAdapter.createMap((Object[])new Object[0])), Map.class);
        callSiteArray[229].callCurrent((GroovyObject)this, instanceData, (Object)instances);
        return instances;
    }

    private void addHealthToInstances(Collection<CacheData> instanceData, Map<String, AmazonInstance> instances) {
        Reference instances2 = new Reference(instances);
        CallSite[] callSiteArray = AmazonClusterProvider.$getCallSiteArray();
        Reference healthKeysToInstance = new Reference((Object)ScriptBytecodeAdapter.createMap((Object[])new Object[0]));
        public final class _addHealthToInstances_closure19
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference healthKeysToInstance;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _addHealthToInstances_closure19(Object _outerInstance, Object _thisObject, Reference healthKeysToInstance) {
                Reference reference;
                CallSite[] callSiteArray = _addHealthToInstances_closure19.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.healthKeysToInstance = reference = healthKeysToInstance;
            }

            public Object doCall(Object instanceEntry) {
                Reference instanceEntry2 = new Reference(instanceEntry);
                CallSite[] callSiteArray = _addHealthToInstances_closure19.$getCallSiteArray();
                Reference instanceKey = new Reference((Object)((Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[0].call(Keys.class, callSiteArray[1].callGetProperty(instanceEntry2.get())), Map.class)));
                public final class _closure49
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference instanceKey;
                    private /* synthetic */ Reference healthKeysToInstance;
                    private /* synthetic */ Reference instanceEntry;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;
                    private static /* synthetic */ SoftReference $callSiteArray;

                    public _closure49(Object _outerInstance, Object _thisObject, Reference instanceKey, Reference healthKeysToInstance, Reference instanceEntry) {
                        Reference reference;
                        Reference reference2;
                        Reference reference3;
                        CallSite[] callSiteArray = _closure49.$getCallSiteArray();
                        super(_outerInstance, _thisObject);
                        this.instanceKey = reference3 = instanceKey;
                        this.healthKeysToInstance = reference2 = healthKeysToInstance;
                        this.instanceEntry = reference = instanceEntry;
                    }

                    public Object doCall(Object it) {
                        CallSite[] callSiteArray = _closure49.$getCallSiteArray();
                        Object key = callSiteArray[0].call(Keys.class, callSiteArray[1].callGetProperty(this.instanceKey.get()), callSiteArray[2].callGetProperty(this.instanceKey.get()), callSiteArray[3].callGetProperty(this.instanceKey.get()), callSiteArray[4].callGetProperty(it));
                        return callSiteArray[5].call(this.healthKeysToInstance.get(), key, callSiteArray[6].callGetProperty(this.instanceEntry.get()));
                    }

                    @Generated
                    public Map getInstanceKey() {
                        CallSite[] callSiteArray = _closure49.$getCallSiteArray();
                        return (Map)ScriptBytecodeAdapter.castToType((Object)this.instanceKey.get(), Map.class);
                    }

                    @Generated
                    public Map getHealthKeysToInstance() {
                        CallSite[] callSiteArray = _closure49.$getCallSiteArray();
                        return (Map)ScriptBytecodeAdapter.castToType((Object)this.healthKeysToInstance.get(), Map.class);
                    }

                    @Generated
                    public Object getInstanceEntry() {
                        CallSite[] callSiteArray = _closure49.$getCallSiteArray();
                        return this.instanceEntry.get();
                    }

                    @Generated
                    public Object doCall() {
                        CallSite[] callSiteArray = _closure49.$getCallSiteArray();
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure49.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                        stringArray[0] = "getInstanceHealthKey";
                        stringArray[1] = "instanceId";
                        stringArray[2] = "account";
                        stringArray[3] = "region";
                        stringArray[4] = "healthId";
                        stringArray[5] = "put";
                        stringArray[6] = "id";
                    }

                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                        String[] stringArray = new String[7];
                        _closure49.$createCallSiteArray_1(stringArray);
                        return new CallSiteArray(_closure49.class, stringArray);
                    }

                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                        CallSiteArray callSiteArray;
                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                            callSiteArray = _closure49.$createCallSiteArray();
                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                        }
                        return callSiteArray.array;
                    }
                }
                callSiteArray[2].call(callSiteArray[3].callGroovyObjectGetProperty(callSiteArray[4].callGroovyObjectGetProperty((Object)this)), (Object)new _closure49((Object)this, this.getThisObject(), instanceKey, this.healthKeysToInstance, instanceEntry2));
                public final class _closure50
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference instanceKey;
                    private /* synthetic */ Reference healthKeysToInstance;
                    private /* synthetic */ Reference instanceEntry;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;
                    private static /* synthetic */ SoftReference $callSiteArray;

                    public _closure50(Object _outerInstance, Object _thisObject, Reference instanceKey, Reference healthKeysToInstance, Reference instanceEntry) {
                        Reference reference;
                        Reference reference2;
                        Reference reference3;
                        CallSite[] callSiteArray = _closure50.$getCallSiteArray();
                        super(_outerInstance, _thisObject);
                        this.instanceKey = reference3 = instanceKey;
                        this.healthKeysToInstance = reference2 = healthKeysToInstance;
                        this.instanceEntry = reference = instanceEntry;
                    }

                    public Object doCall(Object externalHealthProvider) {
                        CallSite[] callSiteArray = _closure50.$getCallSiteArray();
                        public final class _closure51
                        extends Closure
                        implements GeneratedClosure {
                            private /* synthetic */ Reference instanceKey;
                            private /* synthetic */ Reference healthKeysToInstance;
                            private /* synthetic */ Reference instanceEntry;
                            private static /* synthetic */ ClassInfo $staticClassInfo;
                            public static transient /* synthetic */ boolean __$stMC;
                            private static /* synthetic */ SoftReference $callSiteArray;

                            public _closure51(Object _outerInstance, Object _thisObject, Reference instanceKey, Reference healthKeysToInstance, Reference instanceEntry) {
                                Reference reference;
                                Reference reference2;
                                Reference reference3;
                                CallSite[] callSiteArray = _closure51.$getCallSiteArray();
                                super(_outerInstance, _thisObject);
                                this.instanceKey = reference3 = instanceKey;
                                this.healthKeysToInstance = reference2 = healthKeysToInstance;
                                this.instanceEntry = reference = instanceEntry;
                            }

                            public Object doCall(Object externalHealthAgent) {
                                CallSite[] callSiteArray = _closure51.$getCallSiteArray();
                                Object key = callSiteArray[0].call(Keys.class, callSiteArray[1].callGetProperty(this.instanceKey.get()), callSiteArray[2].callGetProperty(this.instanceKey.get()), callSiteArray[3].callGetProperty(this.instanceKey.get()), callSiteArray[4].callGetProperty(externalHealthAgent));
                                return callSiteArray[5].call(this.healthKeysToInstance.get(), key, callSiteArray[6].callGetProperty(this.instanceEntry.get()));
                            }

                            @Generated
                            public Map getInstanceKey() {
                                CallSite[] callSiteArray = _closure51.$getCallSiteArray();
                                return (Map)ScriptBytecodeAdapter.castToType((Object)this.instanceKey.get(), Map.class);
                            }

                            @Generated
                            public Map getHealthKeysToInstance() {
                                CallSite[] callSiteArray = _closure51.$getCallSiteArray();
                                return (Map)ScriptBytecodeAdapter.castToType((Object)this.healthKeysToInstance.get(), Map.class);
                            }

                            @Generated
                            public Object getInstanceEntry() {
                                CallSite[] callSiteArray = _closure51.$getCallSiteArray();
                                return this.instanceEntry.get();
                            }

                            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                if (((Object)((Object)this)).getClass() != _closure51.class) {
                                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                }
                                ClassInfo classInfo = $staticClassInfo;
                                if (classInfo == null) {
                                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                }
                                return classInfo.getMetaClass();
                            }

                            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                                stringArray[0] = "getInstanceHealthKey";
                                stringArray[1] = "instanceId";
                                stringArray[2] = "account";
                                stringArray[3] = "region";
                                stringArray[4] = "healthId";
                                stringArray[5] = "put";
                                stringArray[6] = "id";
                            }

                            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                                String[] stringArray = new String[7];
                                _closure51.$createCallSiteArray_1(stringArray);
                                return new CallSiteArray(_closure51.class, stringArray);
                            }

                            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                                CallSiteArray callSiteArray;
                                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                                    callSiteArray = _closure51.$createCallSiteArray();
                                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                                }
                                return callSiteArray.array;
                            }
                        }
                        return callSiteArray[0].call(callSiteArray[1].callGetProperty(externalHealthProvider), (Object)new _closure51((Object)this, this.getThisObject(), this.instanceKey, this.healthKeysToInstance, this.instanceEntry));
                    }

                    @Generated
                    public Map getInstanceKey() {
                        CallSite[] callSiteArray = _closure50.$getCallSiteArray();
                        return (Map)ScriptBytecodeAdapter.castToType((Object)this.instanceKey.get(), Map.class);
                    }

                    @Generated
                    public Map getHealthKeysToInstance() {
                        CallSite[] callSiteArray = _closure50.$getCallSiteArray();
                        return (Map)ScriptBytecodeAdapter.castToType((Object)this.healthKeysToInstance.get(), Map.class);
                    }

                    @Generated
                    public Object getInstanceEntry() {
                        CallSite[] callSiteArray = _closure50.$getCallSiteArray();
                        return this.instanceEntry.get();
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure50.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                        stringArray[0] = "each";
                        stringArray[1] = "agents";
                    }

                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                        String[] stringArray = new String[2];
                        _closure50.$createCallSiteArray_1(stringArray);
                        return new CallSiteArray(_closure50.class, stringArray);
                    }

                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                        CallSiteArray callSiteArray;
                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                            callSiteArray = _closure50.$createCallSiteArray();
                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                        }
                        return callSiteArray.array;
                    }
                }
                return callSiteArray[5].call(callSiteArray[6].callGroovyObjectGetProperty((Object)this), (Object)new _closure50((Object)this, this.getThisObject(), instanceKey, this.healthKeysToInstance, instanceEntry2));
            }

            @Generated
            public Map getHealthKeysToInstance() {
                CallSite[] callSiteArray = _addHealthToInstances_closure19.$getCallSiteArray();
                return (Map)ScriptBytecodeAdapter.castToType((Object)this.healthKeysToInstance.get(), Map.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _addHealthToInstances_closure19.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "parse";
                stringArray[1] = "id";
                stringArray[2] = "each";
                stringArray[3] = "healthAgents";
                stringArray[4] = "awsProvider";
                stringArray[5] = "each";
                stringArray[6] = "externalHealthProviders";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[7];
                _addHealthToInstances_closure19.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_addHealthToInstances_closure19.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _addHealthToInstances_closure19.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[230].call(instanceData, (Object)new _addHealthToInstances_closure19(this, this, healthKeysToInstance));
        Collection healths = (Collection)ScriptBytecodeAdapter.castToType((Object)callSiteArray[231].call((Object)this.cacheView, callSiteArray[232].callGetProperty(callSiteArray[233].callGetProperty(Namespace.class)), callSiteArray[234].call((Object)((Map)healthKeysToInstance.get())), callSiteArray[235].call(RelationshipCacheFilter.class)), Collection.class);
        public final class _addHealthToInstances_closure20
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference healthKeysToInstance;
            private /* synthetic */ Reference instances;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _addHealthToInstances_closure20(Object _outerInstance, Object _thisObject, Reference healthKeysToInstance, Reference instances) {
                Reference reference;
                Reference reference2;
                CallSite[] callSiteArray = _addHealthToInstances_closure20.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.healthKeysToInstance = reference2 = healthKeysToInstance;
                this.instances = reference = instances;
            }

            public Object doCall(Object healthEntry) {
                CallSite[] callSiteArray = _addHealthToInstances_closure20.$getCallSiteArray();
                Object instanceId = callSiteArray[0].call(this.healthKeysToInstance.get(), callSiteArray[1].callGetProperty(healthEntry));
                return callSiteArray[2].call(callSiteArray[3].callGetProperty(callSiteArray[4].call(this.instances.get(), instanceId)), callSiteArray[5].callGetProperty(healthEntry));
            }

            @Generated
            public Map getHealthKeysToInstance() {
                CallSite[] callSiteArray = _addHealthToInstances_closure20.$getCallSiteArray();
                return (Map)ScriptBytecodeAdapter.castToType((Object)this.healthKeysToInstance.get(), Map.class);
            }

            @Generated
            public Map getInstances() {
                CallSite[] callSiteArray = _addHealthToInstances_closure20.$getCallSiteArray();
                return (Map)ScriptBytecodeAdapter.castToType((Object)this.instances.get(), Map.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _addHealthToInstances_closure20.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "get";
                stringArray[1] = "id";
                stringArray[2] = "leftShift";
                stringArray[3] = "health";
                stringArray[4] = "getAt";
                stringArray[5] = "attributes";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[6];
                _addHealthToInstances_closure20.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_addHealthToInstances_closure20.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _addHealthToInstances_closure20.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[236].call((Object)healths, (Object)new _addHealthToInstances_closure20(this, this, healthKeysToInstance, instances2));
        public final class _addHealthToInstances_closure21
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _addHealthToInstances_closure21(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _addHealthToInstances_closure21.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object instance) {
                CallSite[] callSiteArray = _addHealthToInstances_closure21.$getCallSiteArray();
                public final class _closure52
                extends Closure
                implements GeneratedClosure {
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;
                    private static /* synthetic */ SoftReference $callSiteArray;

                    public _closure52(Object _outerInstance, Object _thisObject) {
                        CallSite[] callSiteArray = _closure52.$getCallSiteArray();
                        super(_outerInstance, _thisObject);
                    }

                    public Object doCall(Object it) {
                        CallSite[] callSiteArray = _closure52.$getCallSiteArray();
                        return ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[0].callGetProperty(it), (Object)"Up");
                    }

                    @Generated
                    public Object doCall() {
                        CallSite[] callSiteArray = _closure52.$getCallSiteArray();
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure52.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                        String[] stringArray = new String[1];
                        stringArray[0] = "state";
                        return new CallSiteArray(_closure52.class, stringArray);
                    }

                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                        CallSiteArray callSiteArray;
                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                            callSiteArray = _closure52.$createCallSiteArray();
                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                        }
                        return callSiteArray.array;
                    }
                }
                public final class _closure53
                extends Closure
                implements GeneratedClosure {
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;
                    private static /* synthetic */ SoftReference $callSiteArray;

                    public _closure53(Object _outerInstance, Object _thisObject) {
                        CallSite[] callSiteArray = _closure53.$getCallSiteArray();
                        super(_outerInstance, _thisObject);
                    }

                    public Object doCall(Object it) {
                        CallSite[] callSiteArray = _closure53.$getCallSiteArray();
                        if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                            return ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[0].callGetProperty(it), (Object)"Up") || ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[1].callGetProperty(it), (Object)"Unknown");
                        }
                        return ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[2].callGetProperty(it), (Object)"Up") || ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[3].callGetProperty(it), (Object)"Unknown");
                    }

                    @Generated
                    public Object doCall() {
                        CallSite[] callSiteArray = _closure53.$getCallSiteArray();
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure53.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                        stringArray[0] = "state";
                        stringArray[1] = "state";
                        stringArray[2] = "state";
                        stringArray[3] = "state";
                    }

                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                        String[] stringArray = new String[4];
                        _closure53.$createCallSiteArray_1(stringArray);
                        return new CallSiteArray(_closure53.class, stringArray);
                    }

                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                        CallSiteArray callSiteArray;
                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                            callSiteArray = _closure53.$createCallSiteArray();
                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                        }
                        return callSiteArray.array;
                    }
                }
                boolean bl = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[0].call(callSiteArray[1].callGetProperty(instance), (Object)new _closure52((Object)this, this.getThisObject()))) && DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[2].call(callSiteArray[3].callGetProperty(instance), (Object)new _closure53((Object)this, this.getThisObject())));
                ScriptBytecodeAdapter.setProperty((Object)bl, null, (Object)instance, (String)"isHealthy");
                return bl;
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _addHealthToInstances_closure21.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "any";
                stringArray[1] = "health";
                stringArray[2] = "every";
                stringArray[3] = "health";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[4];
                _addHealthToInstances_closure21.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_addHealthToInstances_closure21.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _addHealthToInstances_closure21.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[237].call(callSiteArray[238].call((Object)((Map)instances2.get())), (Object)new _addHealthToInstances_closure21(this, this));
    }

    private Collection<CacheData> resolveRelationshipDataForCollection(Collection<CacheData> sources, String relationship, CacheFilter cacheFilter) {
        Reference relationship2 = new Reference((Object)relationship);
        CallSite[] callSiteArray = AmazonClusterProvider.$getCallSiteArray();
        public final class _resolveRelationshipDataForCollection_closure22
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference relationship;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _resolveRelationshipDataForCollection_closure22(Object _outerInstance, Object _thisObject, Reference relationship) {
                Reference reference;
                CallSite[] callSiteArray = _resolveRelationshipDataForCollection_closure22.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.relationship = reference = relationship;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _resolveRelationshipDataForCollection_closure22.$getCallSiteArray();
                Object object = callSiteArray[0].call(callSiteArray[1].callGetProperty(it), this.relationship.get());
                return DefaultTypeTransformation.booleanUnbox((Object)object) ? object : ScriptBytecodeAdapter.createList((Object[])new Object[0]);
            }

            @Generated
            public String getRelationship() {
                CallSite[] callSiteArray = _resolveRelationshipDataForCollection_closure22.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.relationship.get());
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _resolveRelationshipDataForCollection_closure22.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _resolveRelationshipDataForCollection_closure22.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "getAt";
                stringArray[1] = "relationships";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[2];
                _resolveRelationshipDataForCollection_closure22.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_resolveRelationshipDataForCollection_closure22.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _resolveRelationshipDataForCollection_closure22.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        Object object = callSiteArray[239].callSafe(callSiteArray[240].callSafe(sources, (Object)new _resolveRelationshipDataForCollection_closure22(this, this, relationship2)));
        Collection relationships = (Collection)ScriptBytecodeAdapter.castToType((Object)(DefaultTypeTransformation.booleanUnbox((Object)object) ? object : ScriptBytecodeAdapter.createList((Object[])new Object[0])), Collection.class);
        return (Collection)ScriptBytecodeAdapter.castToType((Object)(DefaultTypeTransformation.booleanUnbox((Object)relationships) ? callSiteArray[241].call((Object)this.cacheView, (Object)((String)relationship2.get()), (Object)relationships, (Object)cacheFilter) : ScriptBytecodeAdapter.createList((Object[])new Object[0])), Collection.class);
    }

    private Collection<CacheData> resolveRelationshipData(CacheData source, String relationship, Closure<Boolean> relFilter, CacheFilter cacheFilter) {
        CallSite[] callSiteArray = AmazonClusterProvider.$getCallSiteArray();
        Collection filteredRelationships = (Collection)ScriptBytecodeAdapter.castToType((Object)callSiteArray[242].callSafe(callSiteArray[243].call(callSiteArray[244].callGetProperty((Object)source), (Object)relationship), relFilter), Collection.class);
        return (Collection)ScriptBytecodeAdapter.castToType((Object)(DefaultTypeTransformation.booleanUnbox((Object)filteredRelationships) ? callSiteArray[245].call((Object)this.cacheView, (Object)relationship, (Object)filteredRelationships, (Object)cacheFilter) : ScriptBytecodeAdapter.createList((Object[])new Object[0])), Collection.class);
    }

    private Map getBuildInfoFromImage(CacheData image) {
        CallSite[] callSiteArray = AmazonClusterProvider.$getCallSiteArray();
        Map buildInfo = null;
        public final class _getBuildInfoFromImage_closure23
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _getBuildInfoFromImage_closure23(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _getBuildInfoFromImage_closure23.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _getBuildInfoFromImage_closure23.$getCallSiteArray();
                return ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[0].callGetProperty(it), (Object)"appversion");
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _getBuildInfoFromImage_closure23.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getBuildInfoFromImage_closure23.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "key";
                return new CallSiteArray(_getBuildInfoFromImage_closure23.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _getBuildInfoFromImage_closure23.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        String appVersionTag = ShortTypeHandling.castToString((Object)callSiteArray[246].callGetPropertySafe(callSiteArray[247].callSafe(callSiteArray[248].callGetProperty(callSiteArray[249].callGetProperty((Object)image)), (Object)new _getBuildInfoFromImage_closure23(this, this))));
        if (DefaultTypeTransformation.booleanUnbox((Object)appVersionTag)) {
            Object appVersion = callSiteArray[250].call(AppVersion.class, (Object)appVersionTag);
            if (DefaultTypeTransformation.booleanUnbox((Object)appVersion)) {
                Object object;
                Object object2;
                Map map;
                buildInfo = map = ScriptBytecodeAdapter.createMap((Object[])new Object[]{"package_name", callSiteArray[251].callGetProperty(appVersion), "version", callSiteArray[252].callGetProperty(appVersion), "commit", callSiteArray[253].callGetProperty(appVersion)});
                if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[254].callGetProperty(appVersion))) {
                    Map map2 = ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", callSiteArray[255].callGetProperty(appVersion), "number", callSiteArray[256].callGetProperty(appVersion)});
                    ScriptBytecodeAdapter.setProperty((Object)map2, null, (Object)buildInfo, (String)"jenkins");
                }
                public final class _getBuildInfoFromImage_closure24
                extends Closure
                implements GeneratedClosure {
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;
                    private static /* synthetic */ SoftReference $callSiteArray;

                    public _getBuildInfoFromImage_closure24(Object _outerInstance, Object _thisObject) {
                        CallSite[] callSiteArray = _getBuildInfoFromImage_closure24.$getCallSiteArray();
                        super(_outerInstance, _thisObject);
                    }

                    public Object doCall(Object it) {
                        CallSite[] callSiteArray = _getBuildInfoFromImage_closure24.$getCallSiteArray();
                        return ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[0].callGetProperty(it), (Object)"build_host");
                    }

                    @Generated
                    public Object doCall() {
                        CallSite[] callSiteArray = _getBuildInfoFromImage_closure24.$getCallSiteArray();
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _getBuildInfoFromImage_closure24.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                        String[] stringArray = new String[1];
                        stringArray[0] = "key";
                        return new CallSiteArray(_getBuildInfoFromImage_closure24.class, stringArray);
                    }

                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                        CallSiteArray callSiteArray;
                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                            callSiteArray = _getBuildInfoFromImage_closure24.$createCallSiteArray();
                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                        }
                        return callSiteArray.array;
                    }
                }
                Object buildHost = DefaultTypeTransformation.booleanUnbox((Object)(object2 = callSiteArray[257].callGetPropertySafe(callSiteArray[258].call(callSiteArray[259].callGetProperty(callSiteArray[260].callGetProperty((Object)image)), (Object)new _getBuildInfoFromImage_closure24(this, this))))) ? object2 : this.defaultBuildHost;
                if (DefaultTypeTransformation.booleanUnbox((Object)buildHost) && DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[261].call((Object)buildInfo, (Object)"jenkins"))) {
                    Object object3 = buildHost;
                    ScriptBytecodeAdapter.setProperty((Object)object3, null, (Object)((Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[262].callGetProperty((Object)buildInfo), Map.class)), (String)"host");
                }
                public final class _getBuildInfoFromImage_closure25
                extends Closure
                implements GeneratedClosure {
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;
                    private static /* synthetic */ SoftReference $callSiteArray;

                    public _getBuildInfoFromImage_closure25(Object _outerInstance, Object _thisObject) {
                        CallSite[] callSiteArray = _getBuildInfoFromImage_closure25.$getCallSiteArray();
                        super(_outerInstance, _thisObject);
                    }

                    public Object doCall(Object it) {
                        CallSite[] callSiteArray = _getBuildInfoFromImage_closure25.$getCallSiteArray();
                        return ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[0].callGetProperty(it), (Object)"build_info_url");
                    }

                    @Generated
                    public Object doCall() {
                        CallSite[] callSiteArray = _getBuildInfoFromImage_closure25.$getCallSiteArray();
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _getBuildInfoFromImage_closure25.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                        String[] stringArray = new String[1];
                        stringArray[0] = "key";
                        return new CallSiteArray(_getBuildInfoFromImage_closure25.class, stringArray);
                    }

                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                        CallSiteArray callSiteArray;
                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                            callSiteArray = _getBuildInfoFromImage_closure25.$createCallSiteArray();
                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                        }
                        return callSiteArray.array;
                    }
                }
                Object buildInfoUrl = DefaultTypeTransformation.booleanUnbox((Object)(object = callSiteArray[263].callGetPropertySafe(callSiteArray[264].callSafe(callSiteArray[265].callGetProperty(callSiteArray[266].callGetProperty((Object)image)), (Object)new _getBuildInfoFromImage_closure25(this, this))))) ? object : null;
                if (DefaultTypeTransformation.booleanUnbox((Object)buildInfoUrl)) {
                    Object object4 = buildInfoUrl;
                    ScriptBytecodeAdapter.setProperty((Object)object4, null, (Object)buildInfo, (String)"buildInfoUrl");
                }
            }
        }
        return buildInfo;
    }

    public Set<AmazonCluster> getClusters(String applicationName, String account) {
        CallSite[] callSiteArray = AmazonClusterProvider.$getCallSiteArray();
        Collection clusterKeys = (Collection)ScriptBytecodeAdapter.castToType((Object)callSiteArray[267].call((Object)this.cacheView, callSiteArray[268].callGetProperty(callSiteArray[269].callGetProperty(Namespace.class)), callSiteArray[270].call(Keys.class, (Object)"*", (Object)applicationName, (Object)account)), Collection.class);
        Collection clusters = (Collection)ScriptBytecodeAdapter.castToType((Object)callSiteArray[271].call((Object)this.cacheView, callSiteArray[272].callGetProperty(callSiteArray[273].callGetProperty(Namespace.class)), (Object)clusterKeys), Collection.class);
        return (Set)ScriptBytecodeAdapter.asType((Object)callSiteArray[274].callCurrent((GroovyObject)this, (Object)clusters, (Object)true), Set.class);
    }

    public AmazonCluster getCluster(String application, String account, String name, boolean includeDetails) {
        CallSite[] callSiteArray = AmazonClusterProvider.$getCallSiteArray();
        CacheData cluster = (CacheData)ScriptBytecodeAdapter.castToType((Object)callSiteArray[275].call((Object)this.cacheView, callSiteArray[276].callGetProperty(callSiteArray[277].callGetProperty(Namespace.class)), callSiteArray[278].call(Keys.class, (Object)name, (Object)application, (Object)account)), CacheData.class);
        if (ScriptBytecodeAdapter.compareEqual((Object)cluster, null)) {
            return (AmazonCluster)ScriptBytecodeAdapter.castToType(null, AmazonCluster.class);
        }
        return (AmazonCluster)ScriptBytecodeAdapter.castToType((Object)callSiteArray[279].call(callSiteArray[280].callCurrent((GroovyObject)this, (Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{cluster}), (Object)includeDetails), (Object)0), AmazonCluster.class);
    }

    public AmazonCluster getCluster(String application, String account, String name) {
        CallSite[] callSiteArray = AmazonClusterProvider.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return (AmazonCluster)ScriptBytecodeAdapter.castToType((Object)callSiteArray[281].callCurrent((GroovyObject)this, (Object)application, (Object)account, (Object)name, (Object)true), AmazonCluster.class);
        }
        return this.getCluster(application, account, name, true);
    }

    public Collection<String> getServerGroupIdentifiers(String account, String region) {
        CallSite[] callSiteArray = AmazonClusterProvider.$getCallSiteArray();
        Object object = callSiteArray[282].call(callSiteArray[283].call(Optional.class, (Object)account), (Object)"*");
        account = ShortTypeHandling.castToString((Object)object);
        Object object2 = callSiteArray[284].call(callSiteArray[285].call(Optional.class, (Object)region), (Object)"*");
        region = ShortTypeHandling.castToString((Object)object2);
        return (Collection)ScriptBytecodeAdapter.castToType((Object)callSiteArray[286].call((Object)this.cacheView, callSiteArray[287].callGetProperty(callSiteArray[288].callGetProperty(Namespace.class)), callSiteArray[289].call(Keys.class, (Object)"*", (Object)"*", (Object)account, (Object)region)), Collection.class);
    }

    public String buildServerGroupIdentifier(String account, String region, String serverGroupName) {
        CallSite[] callSiteArray = AmazonClusterProvider.$getCallSiteArray();
        return ShortTypeHandling.castToString((Object)callSiteArray[290].call(Keys.class, (Object)serverGroupName, (Object)account, (Object)region));
    }

    private static Map<String, Object> getLaunchTemplateForVersion(CacheData launchTemplate, String version) {
        Reference version2 = new Reference((Object)version);
        CallSite[] callSiteArray = AmazonClusterProvider.$getCallSiteArray();
        if (!DefaultTypeTransformation.booleanUnbox((Object)launchTemplate)) {
            return (Map)ScriptBytecodeAdapter.castToType(null, Map.class);
        }
        Map launchTemplateAttrs = (Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[291].callGetProperty((Object)launchTemplate), Map.class);
        List versions = (List)ScriptBytecodeAdapter.asType((Object)callSiteArray[292].call((Object)launchTemplateAttrs, (Object)"versions"), List.class);
        if (ScriptBytecodeAdapter.compareEqual((Object)((String)version2.get()), (Object)"$Latest")) {
            return (Map)ScriptBytecodeAdapter.asType((Object)callSiteArray[293].call((Object)launchTemplateAttrs, (Object)"latestVersion"), Map.class);
        }
        if (ScriptBytecodeAdapter.compareEqual((Object)((String)version2.get()), (Object)"$Default")) {
            public final class _getLaunchTemplateForVersion_closure26
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;

                public _getLaunchTemplateForVersion_closure26(Object _outerInstance, Object _thisObject) {
                    CallSite[] callSiteArray = _getLaunchTemplateForVersion_closure26.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(Object it) {
                    CallSite[] callSiteArray = _getLaunchTemplateForVersion_closure26.$getCallSiteArray();
                    return (Boolean)ScriptBytecodeAdapter.asType((Object)callSiteArray[0].call(it, (Object)"defaultVersion"), Boolean.class);
                }

                @Generated
                public Object doCall() {
                    CallSite[] callSiteArray = _getLaunchTemplateForVersion_closure26.$getCallSiteArray();
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _getLaunchTemplateForVersion_closure26.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[1];
                    stringArray[0] = "getAt";
                    return new CallSiteArray(_getLaunchTemplateForVersion_closure26.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _getLaunchTemplateForVersion_closure26.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            }
            return (Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[294].call((Object)versions, (Object)new _getLaunchTemplateForVersion_closure26(AmazonClusterProvider.class, AmazonClusterProvider.class)), Map.class);
        }
        public final class _getLaunchTemplateForVersion_closure27
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference version;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _getLaunchTemplateForVersion_closure27(Object _outerInstance, Object _thisObject, Reference version) {
                Reference reference;
                CallSite[] callSiteArray = _getLaunchTemplateForVersion_closure27.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.version = reference = version;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _getLaunchTemplateForVersion_closure27.$getCallSiteArray();
                return ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[0].call(it, (Object)"versionNumber"), (Object)callSiteArray[1].call(this.version.get()));
            }

            @Generated
            public String getVersion() {
                CallSite[] callSiteArray = _getLaunchTemplateForVersion_closure27.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.version.get());
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _getLaunchTemplateForVersion_closure27.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getLaunchTemplateForVersion_closure27.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "getAt";
                stringArray[1] = "toInteger";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[2];
                _getLaunchTemplateForVersion_closure27.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_getLaunchTemplateForVersion_closure27.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _getLaunchTemplateForVersion_closure27.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        return (Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[295].call((Object)versions, (Object)new _getLaunchTemplateForVersion_closure27(AmazonClusterProvider.class, AmazonClusterProvider.class, version2)), Map.class);
    }

    private static void updateServerGroupLaunchSettings(Map<String, AmazonServerGroup> serverGroups, Collection<CacheData> launchData) {
        Reference serverGroups2 = new Reference(serverGroups);
        CallSite[] callSiteArray = AmazonClusterProvider.$getCallSiteArray();
        Reference ld = new Reference(null);
        Iterator iterator = (Iterator)ScriptBytecodeAdapter.castToType((Object)callSiteArray[296].call(launchData), Iterator.class);
        while (iterator.hasNext()) {
            ld.set(iterator.next());
            if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[297].callSafe(callSiteArray[298].callGetPropertySafe(ld.get()), callSiteArray[299].callGetProperty(callSiteArray[300].callGetProperty(Namespace.class))))) continue;
            public final class _updateServerGroupLaunchSettings_closure28
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference serverGroups;
                private /* synthetic */ Reference ld;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;

                public _updateServerGroupLaunchSettings_closure28(Object _outerInstance, Object _thisObject, Reference serverGroups, Reference ld) {
                    Reference reference;
                    Reference reference2;
                    CallSite[] callSiteArray = _updateServerGroupLaunchSettings_closure28.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                    this.serverGroups = reference2 = serverGroups;
                    this.ld = reference = ld;
                }

                public Object doCall(Object it) {
                    CallSite[] callSiteArray = _updateServerGroupLaunchSettings_closure28.$getCallSiteArray();
                    Object serverGroup = callSiteArray[0].call(this.serverGroups.get(), it);
                    if (ScriptBytecodeAdapter.compareNotEqual((Object)serverGroup, null)) {
                        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[1].call(serverGroup))) {
                            return callSiteArray[2].callStatic(AmazonClusterProvider.class, serverGroup, this.ld.get());
                        }
                        Object object = callSiteArray[3].callGetProperty(this.ld.get());
                        ScriptBytecodeAdapter.setProperty((Object)object, null, (Object)serverGroup, (String)"launchConfig");
                        return object;
                    }
                    return null;
                }

                @Generated
                public Map getServerGroups() {
                    CallSite[] callSiteArray = _updateServerGroupLaunchSettings_closure28.$getCallSiteArray();
                    return (Map)ScriptBytecodeAdapter.castToType((Object)this.serverGroups.get(), Map.class);
                }

                @Generated
                public Object getLd() {
                    CallSite[] callSiteArray = _updateServerGroupLaunchSettings_closure28.$getCallSiteArray();
                    return this.ld.get();
                }

                @Generated
                public Object doCall() {
                    CallSite[] callSiteArray = _updateServerGroupLaunchSettings_closure28.$getCallSiteArray();
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _updateServerGroupLaunchSettings_closure28.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                    stringArray[0] = "getAt";
                    stringArray[1] = "getLaunchTemplateSpecification";
                    stringArray[2] = "populateServerGroupWithLtOrMip";
                    stringArray[3] = "attributes";
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[4];
                    _updateServerGroupLaunchSettings_closure28.$createCallSiteArray_1(stringArray);
                    return new CallSiteArray(_updateServerGroupLaunchSettings_closure28.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _updateServerGroupLaunchSettings_closure28.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            }
            callSiteArray[301].call(callSiteArray[302].call(callSiteArray[303].callGetProperty(ld.get()), callSiteArray[304].callGetProperty(callSiteArray[305].callGetProperty(Namespace.class))), (Object)new _updateServerGroupLaunchSettings_closure28(AmazonClusterProvider.class, AmazonClusterProvider.class, serverGroups2, ld));
        }
    }

    private static void populateServerGroupWithLtOrMip(AmazonServerGroup serverGroup, CacheData launchData) {
        Reference serverGroup2 = new Reference((Object)serverGroup);
        CallSite[] callSiteArray = AmazonClusterProvider.$getCallSiteArray();
        Object ltSpec = callSiteArray[306].call((Object)((AmazonServerGroup)serverGroup2.get()));
        Object object = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[307].call((Object)log)) ? callSiteArray[308].call((Object)log, (Object)new GStringImpl(new Object[]{callSiteArray[309].callGroovyObjectGetProperty((Object)((AmazonServerGroup)serverGroup2.get())), ltSpec}, new String[]{"Attempting to populate server group ", " with launch template ", "."})) : null;
        Reference ec2Lt = new Reference((Object)((Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[310].callStatic(AmazonClusterProvider.class, (Object)launchData, (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((String)ScriptBytecodeAdapter.asType((Object)callSiteArray[311].call(ltSpec, (Object)"version"), String.class)), String.class)), Map.class)));
        if (!DefaultTypeTransformation.booleanUnbox((Object)((Map)ec2Lt.get()))) {
            return;
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[312].callGetPropertySafe(callSiteArray[313].callGroovyObjectGetProperty((Object)((AmazonServerGroup)serverGroup2.get()))))) {
            Map map = (Map)ec2Lt.get();
            ScriptBytecodeAdapter.setGroovyObjectProperty((Object)map, AmazonClusterProvider.class, (GroovyObject)((AmazonServerGroup)serverGroup2.get()), (String)"launchTemplate");
        } else if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[314].callGetPropertySafe(callSiteArray[315].callGroovyObjectGetProperty((Object)((AmazonServerGroup)serverGroup2.get()))))) {
            Object mip = callSiteArray[316].callGetProperty(callSiteArray[317].callGroovyObjectGetProperty((Object)((AmazonServerGroup)serverGroup2.get())));
            if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[318].call(callSiteArray[319].call(mip, (Object)"launchTemplate"), (Object)"overrides"))) {
                public final class _populateServerGroupWithLtOrMip_closure29
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference ec2Lt;
                    private /* synthetic */ Reference serverGroup;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;
                    private static /* synthetic */ SoftReference $callSiteArray;

                    public _populateServerGroupWithLtOrMip_closure29(Object _outerInstance, Object _thisObject, Reference ec2Lt, Reference serverGroup) {
                        Reference reference;
                        Reference reference2;
                        CallSite[] callSiteArray = _populateServerGroupWithLtOrMip_closure29.$getCallSiteArray();
                        super(_outerInstance, _thisObject);
                        this.ec2Lt = reference2 = ec2Lt;
                        this.serverGroup = reference = serverGroup;
                    }

                    public Object doCall(Object it) {
                        CallSite[] callSiteArray = _populateServerGroupWithLtOrMip_closure29.$getCallSiteArray();
                        List list = ScriptBytecodeAdapter.createList((Object[])new Object[]{callSiteArray[0].call(callSiteArray[1].call(this.ec2Lt.get(), (Object)"launchTemplateData"), (Object)"instanceType")});
                        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)list, _populateServerGroupWithLtOrMip_closure29.class, (GroovyObject)this, (String)"allowedInstanceTypes");
                        Object object = callSiteArray[2].call(callSiteArray[3].callGetProperty(callSiteArray[4].callGroovyObjectGetProperty(this.serverGroup.get())), (Object)"instancesDistribution");
                        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, _populateServerGroupWithLtOrMip_closure29.class, (GroovyObject)this, (String)"instancesDistribution");
                        List list2 = ScriptBytecodeAdapter.createList((Object[])new Object[]{this.ec2Lt.get()});
                        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)list2, _populateServerGroupWithLtOrMip_closure29.class, (GroovyObject)this, (String)"launchTemplates");
                        return list2;
                    }

                    @Generated
                    public Map getEc2Lt() {
                        CallSite[] callSiteArray = _populateServerGroupWithLtOrMip_closure29.$getCallSiteArray();
                        return (Map)ScriptBytecodeAdapter.castToType((Object)this.ec2Lt.get(), Map.class);
                    }

                    @Generated
                    public AmazonServerGroup getServerGroup() {
                        CallSite[] callSiteArray = _populateServerGroupWithLtOrMip_closure29.$getCallSiteArray();
                        return (AmazonServerGroup)ScriptBytecodeAdapter.castToType((Object)this.serverGroup.get(), AmazonServerGroup.class);
                    }

                    @Generated
                    public Object doCall() {
                        CallSite[] callSiteArray = _populateServerGroupWithLtOrMip_closure29.$getCallSiteArray();
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _populateServerGroupWithLtOrMip_closure29.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                        stringArray[0] = "getAt";
                        stringArray[1] = "getAt";
                        stringArray[2] = "getAt";
                        stringArray[3] = "mixedInstancesPolicy";
                        stringArray[4] = "asg";
                    }

                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                        String[] stringArray = new String[5];
                        _populateServerGroupWithLtOrMip_closure29.$createCallSiteArray_1(stringArray);
                        return new CallSiteArray(_populateServerGroupWithLtOrMip_closure29.class, stringArray);
                    }

                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                        CallSiteArray callSiteArray;
                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                            callSiteArray = _populateServerGroupWithLtOrMip_closure29.$createCallSiteArray();
                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                        }
                        return callSiteArray.array;
                    }
                }
                Object object2 = callSiteArray[320].call(callSiteArray[321].callConstructor(AmazonServerGroup.MixedInstancesPolicySettings.class), (Object)new _populateServerGroupWithLtOrMip_closure29(AmazonClusterProvider.class, AmazonClusterProvider.class, ec2Lt, serverGroup2));
                ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object2, AmazonClusterProvider.class, (GroovyObject)((AmazonServerGroup)serverGroup2.get()), (String)"mixedInstancesPolicy");
            } else {
                Reference overrides = new Reference(callSiteArray[322].callConstructor(ArrayList.class, callSiteArray[323].call(callSiteArray[324].call(mip, (Object)"launchTemplate"), (Object)"overrides")));
                Reference types = new Reference((Object)ScriptBytecodeAdapter.createList((Object[])new Object[0]));
                public final class _populateServerGroupWithLtOrMip_closure30
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference types;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;
                    private static /* synthetic */ SoftReference $callSiteArray;

                    public _populateServerGroupWithLtOrMip_closure30(Object _outerInstance, Object _thisObject, Reference types) {
                        Reference reference;
                        CallSite[] callSiteArray = _populateServerGroupWithLtOrMip_closure30.$getCallSiteArray();
                        super(_outerInstance, _thisObject);
                        this.types = reference = types;
                    }

                    public Object doCall(Object it) {
                        CallSite[] callSiteArray = _populateServerGroupWithLtOrMip_closure30.$getCallSiteArray();
                        return callSiteArray[0].call(this.types.get(), callSiteArray[1].call(it, (Object)"instanceType"));
                    }

                    @Generated
                    public Object getTypes() {
                        CallSite[] callSiteArray = _populateServerGroupWithLtOrMip_closure30.$getCallSiteArray();
                        return this.types.get();
                    }

                    @Generated
                    public Object doCall() {
                        CallSite[] callSiteArray = _populateServerGroupWithLtOrMip_closure30.$getCallSiteArray();
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _populateServerGroupWithLtOrMip_closure30.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                        stringArray[0] = "add";
                        stringArray[1] = "getAt";
                    }

                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                        String[] stringArray = new String[2];
                        _populateServerGroupWithLtOrMip_closure30.$createCallSiteArray_1(stringArray);
                        return new CallSiteArray(_populateServerGroupWithLtOrMip_closure30.class, stringArray);
                    }

                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                        CallSiteArray callSiteArray;
                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                            callSiteArray = _populateServerGroupWithLtOrMip_closure30.$createCallSiteArray();
                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                        }
                        return callSiteArray.array;
                    }
                }
                callSiteArray[325].call(overrides.get(), (Object)new _populateServerGroupWithLtOrMip_closure30(AmazonClusterProvider.class, AmazonClusterProvider.class, types));
                public final class _populateServerGroupWithLtOrMip_closure31
                extends Closure
                implements GeneratedClosure {
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;
                    private static /* synthetic */ SoftReference $callSiteArray;

                    public _populateServerGroupWithLtOrMip_closure31(Object _outerInstance, Object _thisObject) {
                        CallSite[] callSiteArray = _populateServerGroupWithLtOrMip_closure31.$getCallSiteArray();
                        super(_outerInstance, _thisObject);
                    }

                    public Object doCall(Object it) {
                        CallSite[] callSiteArray = _populateServerGroupWithLtOrMip_closure31.$getCallSiteArray();
                        return ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[0].callGetProperty(it), (Object)"instanceType");
                    }

                    @Generated
                    public Object doCall() {
                        CallSite[] callSiteArray = _populateServerGroupWithLtOrMip_closure31.$getCallSiteArray();
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _populateServerGroupWithLtOrMip_closure31.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                        String[] stringArray = new String[1];
                        stringArray[0] = "key";
                        return new CallSiteArray(_populateServerGroupWithLtOrMip_closure31.class, stringArray);
                    }

                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                        CallSiteArray callSiteArray;
                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                            callSiteArray = _populateServerGroupWithLtOrMip_closure31.$createCallSiteArray();
                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                        }
                        return callSiteArray.array;
                    }
                }
                Map ec2LtDataMinusType = (Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[326].call(callSiteArray[327].callGetPropertySafe((Object)((Map)ec2Lt.get())), (Object)new _populateServerGroupWithLtOrMip_closure31(AmazonClusterProvider.class, AmazonClusterProvider.class)), Map.class);
                callSiteArray[328].callSafe((Object)((Map)ec2Lt.get()), (Object)"launchTemplateData", (Object)ec2LtDataMinusType);
                public final class _populateServerGroupWithLtOrMip_closure32
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference types;
                    private /* synthetic */ Reference serverGroup;
                    private /* synthetic */ Reference ec2Lt;
                    private /* synthetic */ Reference overrides;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;
                    private static /* synthetic */ SoftReference $callSiteArray;

                    public _populateServerGroupWithLtOrMip_closure32(Object _outerInstance, Object _thisObject, Reference types, Reference serverGroup, Reference ec2Lt, Reference overrides) {
                        Reference reference;
                        Reference reference2;
                        Reference reference3;
                        Reference reference4;
                        CallSite[] callSiteArray = _populateServerGroupWithLtOrMip_closure32.$getCallSiteArray();
                        super(_outerInstance, _thisObject);
                        this.types = reference4 = types;
                        this.serverGroup = reference3 = serverGroup;
                        this.ec2Lt = reference2 = ec2Lt;
                        this.overrides = reference = overrides;
                    }

                    public Object doCall(Object it) {
                        CallSite[] callSiteArray = _populateServerGroupWithLtOrMip_closure32.$getCallSiteArray();
                        Object object = callSiteArray[0].call(this.types.get());
                        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, _populateServerGroupWithLtOrMip_closure32.class, (GroovyObject)this, (String)"allowedInstanceTypes");
                        Object object2 = callSiteArray[1].call(callSiteArray[2].callGetProperty(callSiteArray[3].callGroovyObjectGetProperty(this.serverGroup.get())), (Object)"instancesDistribution");
                        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object2, _populateServerGroupWithLtOrMip_closure32.class, (GroovyObject)this, (String)"instancesDistribution");
                        List list = ScriptBytecodeAdapter.createList((Object[])new Object[]{this.ec2Lt.get()});
                        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)list, _populateServerGroupWithLtOrMip_closure32.class, (GroovyObject)this, (String)"launchTemplates");
                        Object object3 = this.overrides.get();
                        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object3, _populateServerGroupWithLtOrMip_closure32.class, (GroovyObject)this, (String)"launchTemplateOverridesForInstanceType");
                        return object3;
                    }

                    @Generated
                    public Object getTypes() {
                        CallSite[] callSiteArray = _populateServerGroupWithLtOrMip_closure32.$getCallSiteArray();
                        return this.types.get();
                    }

                    @Generated
                    public AmazonServerGroup getServerGroup() {
                        CallSite[] callSiteArray = _populateServerGroupWithLtOrMip_closure32.$getCallSiteArray();
                        return (AmazonServerGroup)ScriptBytecodeAdapter.castToType((Object)this.serverGroup.get(), AmazonServerGroup.class);
                    }

                    @Generated
                    public Map getEc2Lt() {
                        CallSite[] callSiteArray = _populateServerGroupWithLtOrMip_closure32.$getCallSiteArray();
                        return (Map)ScriptBytecodeAdapter.castToType((Object)this.ec2Lt.get(), Map.class);
                    }

                    @Generated
                    public Object getOverrides() {
                        CallSite[] callSiteArray = _populateServerGroupWithLtOrMip_closure32.$getCallSiteArray();
                        return this.overrides.get();
                    }

                    @Generated
                    public Object doCall() {
                        CallSite[] callSiteArray = _populateServerGroupWithLtOrMip_closure32.$getCallSiteArray();
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _populateServerGroupWithLtOrMip_closure32.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                        stringArray[0] = "sort";
                        stringArray[1] = "getAt";
                        stringArray[2] = "mixedInstancesPolicy";
                        stringArray[3] = "asg";
                    }

                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                        String[] stringArray = new String[4];
                        _populateServerGroupWithLtOrMip_closure32.$createCallSiteArray_1(stringArray);
                        return new CallSiteArray(_populateServerGroupWithLtOrMip_closure32.class, stringArray);
                    }

                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                        CallSiteArray callSiteArray;
                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                            callSiteArray = _populateServerGroupWithLtOrMip_closure32.$createCallSiteArray();
                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                        }
                        return callSiteArray.array;
                    }
                }
                Object object3 = callSiteArray[329].call(callSiteArray[330].callConstructor(AmazonServerGroup.MixedInstancesPolicySettings.class), (Object)new _populateServerGroupWithLtOrMip_closure32(AmazonClusterProvider.class, AmazonClusterProvider.class, types, serverGroup2, ec2Lt, overrides));
                ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object3, AmazonClusterProvider.class, (GroovyObject)((AmazonServerGroup)serverGroup2.get()), (String)"mixedInstancesPolicy");
            }
        }
    }

    private void updateServerGroupBuildInfo(Map<String, AmazonServerGroup> serverGroups, Collection<CacheData> launchData, Collection<CacheData> imageData) {
        Reference serverGroups2 = new Reference(serverGroups);
        CallSite[] callSiteArray = AmazonClusterProvider.$getCallSiteArray();
        public final class _updateServerGroupBuildInfo_closure33
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _updateServerGroupBuildInfo_closure33(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _updateServerGroupBuildInfo_closure33.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object image) {
                CallSite[] callSiteArray = _updateServerGroupBuildInfo_closure33.$getCallSiteArray();
                return ScriptBytecodeAdapter.createMap((Object[])new Object[]{callSiteArray[0].callGetProperty(image), image});
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _updateServerGroupBuildInfo_closure33.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "id";
                return new CallSiteArray(_updateServerGroupBuildInfo_closure33.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _updateServerGroupBuildInfo_closure33.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        Reference images = new Reference((Object)((Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[331].callSafe(imageData, (Object)new _updateServerGroupBuildInfo_closure33(this, this)), Map.class)));
        public final class _updateServerGroupBuildInfo_closure34
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference serverGroups;
            private /* synthetic */ Reference images;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _updateServerGroupBuildInfo_closure34(Object _outerInstance, Object _thisObject, Reference serverGroups, Reference images) {
                Reference reference;
                Reference reference2;
                CallSite[] callSiteArray = _updateServerGroupBuildInfo_closure34.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.serverGroups = reference2 = serverGroups;
                this.images = reference = images;
            }

            public Object doCall(Object ld) {
                CallSite[] callSiteArray = _updateServerGroupBuildInfo_closure34.$getCallSiteArray();
                if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[0].callSafe(callSiteArray[1].callGetPropertySafe(ld), callSiteArray[2].callGetProperty(callSiteArray[3].callGetProperty(Namespace.class))))) {
                    Object serverGroup = callSiteArray[4].call(this.serverGroups.get(), callSiteArray[5].call(callSiteArray[6].call(callSiteArray[7].callGetProperty(ld), callSiteArray[8].callGetProperty(callSiteArray[9].callGetProperty(Namespace.class)))));
                    Object imageId = callSiteArray[10].callSafe(callSiteArray[11].call(callSiteArray[12].callGetProperty(ld), callSiteArray[13].callGetProperty(callSiteArray[14].callGetProperty(Namespace.class))));
                    if (DefaultTypeTransformation.booleanUnbox((Object)serverGroup) && DefaultTypeTransformation.booleanUnbox((Object)imageId) && DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[15].call(this.images.get(), imageId))) {
                        Object object = callSiteArray[16].callGetProperty(callSiteArray[17].call(this.images.get(), imageId));
                        ScriptBytecodeAdapter.setProperty((Object)object, null, (Object)serverGroup, (String)"image");
                        Object object2 = callSiteArray[18].callCurrent((GroovyObject)this, callSiteArray[19].call(this.images.get(), imageId));
                        ScriptBytecodeAdapter.setProperty((Object)object2, null, (Object)serverGroup, (String)"buildInfo");
                        return object2;
                    }
                    return null;
                }
                return null;
            }

            @Generated
            public Map getServerGroups() {
                CallSite[] callSiteArray = _updateServerGroupBuildInfo_closure34.$getCallSiteArray();
                return (Map)ScriptBytecodeAdapter.castToType((Object)this.serverGroups.get(), Map.class);
            }

            @Generated
            public Map getImages() {
                CallSite[] callSiteArray = _updateServerGroupBuildInfo_closure34.$getCallSiteArray();
                return (Map)ScriptBytecodeAdapter.castToType((Object)this.images.get(), Map.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _updateServerGroupBuildInfo_closure34.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "containsKey";
                stringArray[1] = "relationships";
                stringArray[2] = "ns";
                stringArray[3] = "SERVER_GROUPS";
                stringArray[4] = "getAt";
                stringArray[5] = "first";
                stringArray[6] = "getAt";
                stringArray[7] = "relationships";
                stringArray[8] = "ns";
                stringArray[9] = "SERVER_GROUPS";
                stringArray[10] = "first";
                stringArray[11] = "getAt";
                stringArray[12] = "relationships";
                stringArray[13] = "ns";
                stringArray[14] = "IMAGES";
                stringArray[15] = "containsKey";
                stringArray[16] = "attributes";
                stringArray[17] = "getAt";
                stringArray[18] = "getBuildInfoFromImage";
                stringArray[19] = "getAt";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[20];
                _updateServerGroupBuildInfo_closure34.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_updateServerGroupBuildInfo_closure34.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _updateServerGroupBuildInfo_closure34.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[332].call(launchData, (Object)new _updateServerGroupBuildInfo_closure34(this, this, serverGroups2, images));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != AmazonClusterProvider.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    private Collection<CacheData> resolveRelationshipDataForCollection(Collection<CacheData> sources, String relationship) {
        Reference relationship2 = new Reference((Object)relationship);
        CallSite[] callSiteArray = AmazonClusterProvider.$getCallSiteArray();
        return this.resolveRelationshipDataForCollection(sources, (String)relationship2.get(), null);
    }

    @Generated
    private Collection<CacheData> resolveRelationshipData(CacheData source, String relationship, Closure<Boolean> relFilter) {
        CallSite[] callSiteArray = AmazonClusterProvider.$getCallSiteArray();
        return this.resolveRelationshipData(source, relationship, relFilter, null);
    }

    @Generated
    @Internal
    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Generated
    @Internal
    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    @Generated
    @Internal
    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    static {
        Object object = AmazonClusterProvider.$getCallSiteArray()[333].call(LoggerFactory.class, (Object)"com.netflix.spinnaker.clouddriver.aws.provider.view.AmazonClusterProvider");
        log = (Logger)ScriptBytecodeAdapter.castToType((Object)object, Logger.class);
    }

    @Generated
    public List<ExternalHealthProvider> getExternalHealthProviders() {
        return this.externalHealthProviders;
    }

    @Generated
    public void setExternalHealthProviders(List<ExternalHealthProvider> list) {
        this.externalHealthProviders = list;
    }

    @Generated
    public String getDefaultBuildHost() {
        return this.defaultBuildHost;
    }

    @Generated
    public void setDefaultBuildHost(String string) {
        this.defaultBuildHost = string;
    }

    @Generated
    public Boolean getSqlEnabled() {
        return this.sqlEnabled;
    }

    @Generated
    public void setSqlEnabled(Boolean bl) {
        this.sqlEnabled = bl;
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "getAll";
        stringArray[1] = "ns";
        stringArray[2] = "CLUSTERS";
        stringArray[3] = "translateClusters";
        stringArray[4] = "mapResponse";
        stringArray[5] = "getClusters0";
        stringArray[6] = "getClusters0";
        stringArray[7] = "getServerGroupKey";
        stringArray[8] = "get";
        stringArray[9] = "ns";
        stringArray[10] = "SERVER_GROUPS";
        stringArray[11] = "getAt";
        stringArray[12] = "attributes";
        stringArray[13] = "id";
        stringArray[14] = "<$constructor$>";
        stringArray[15] = "attributes";
        stringArray[16] = "first";
        stringArray[17] = "values";
        stringArray[18] = "getLaunchTemplateSpecification";
        stringArray[19] = "get";
        stringArray[20] = "getLaunchTemplateKey";
        stringArray[21] = "get";
        stringArray[22] = "ns";
        stringArray[23] = "LAUNCH_TEMPLATES";
        stringArray[24] = "updateServerGroupLaunchSettings";
        stringArray[25] = "get";
        stringArray[26] = "get";
        stringArray[27] = "attributes";
        stringArray[28] = "get";
        stringArray[29] = "getLaunchConfigKey";
        stringArray[30] = "getAt";
        stringArray[31] = "attributes";
        stringArray[32] = "get";
        stringArray[33] = "ns";
        stringArray[34] = "LAUNCH_CONFIGS";
        stringArray[35] = "updateServerGroupLaunchSettings";
        stringArray[36] = "get";
        stringArray[37] = "attributes";
        stringArray[38] = "get";
        stringArray[39] = "ns";
        stringArray[40] = "IMAGES";
        stringArray[41] = "getImageKey";
        stringArray[42] = "attributes";
        stringArray[43] = "getBuildInfoFromImage";
        stringArray[44] = "getAsgInstanceKeys";
        stringArray[45] = "values";
        stringArray[46] = "translateInstances";
        stringArray[47] = "resolveRelationshipData";
        stringArray[48] = "ns";
        stringArray[49] = "INSTANCES";
        stringArray[50] = "none";
        stringArray[51] = "getServerGroup";
        stringArray[52] = "id";
        stringArray[53] = "collectEntries";
        stringArray[54] = "groupBy";
        stringArray[55] = "inject";
        stringArray[56] = "instances";
        stringArray[57] = "<$constructor$>";
        stringArray[58] = "collectEntries";
        stringArray[59] = "collectEntries";
        stringArray[60] = "ns";
        stringArray[61] = "CLUSTERS";
        stringArray[62] = "ns";
        stringArray[63] = "SERVER_GROUPS";
        stringArray[64] = "ns";
        stringArray[65] = "LAUNCH_CONFIGS";
        stringArray[66] = "ns";
        stringArray[67] = "INSTANCES";
        stringArray[68] = "ns";
        stringArray[69] = "LAUNCH_TEMPLATES";
        stringArray[70] = "include";
        stringArray[71] = "ns";
        stringArray[72] = "INSTANCES";
        stringArray[73] = "ns";
        stringArray[74] = "LAUNCH_CONFIGS";
        stringArray[75] = "ns";
        stringArray[76] = "LAUNCH_TEMPLATES";
        stringArray[77] = "putAt";
        stringArray[78] = "ns";
        stringArray[79] = "SERVER_GROUPS";
        stringArray[80] = "include";
        stringArray[81] = "ns";
        stringArray[82] = "IMAGES";
        stringArray[83] = "ns";
        stringArray[84] = "SERVER_GROUPS";
        stringArray[85] = "putAt";
        stringArray[86] = "ns";
        stringArray[87] = "LAUNCH_CONFIGS";
        stringArray[88] = "include";
        stringArray[89] = "ns";
        stringArray[90] = "IMAGES";
        stringArray[91] = "ns";
        stringArray[92] = "SERVER_GROUPS";
        stringArray[93] = "putAt";
        stringArray[94] = "ns";
        stringArray[95] = "LAUNCH_TEMPLATES";
        stringArray[96] = "include";
        stringArray[97] = "ns";
        stringArray[98] = "SERVER_GROUPS";
        stringArray[99] = "putAt";
        stringArray[100] = "ns";
        stringArray[101] = "INSTANCES";
        stringArray[102] = "getAllByApplication";
        stringArray[103] = "resolveRelationshipDataForCollection";
        stringArray[104] = "getAt";
        stringArray[105] = "ns";
        stringArray[106] = "CLUSTERS";
        stringArray[107] = "ns";
        stringArray[108] = "LOAD_BALANCERS";
        stringArray[109] = "none";
        stringArray[110] = "resolveRelationshipDataForCollection";
        stringArray[111] = "getAt";
        stringArray[112] = "ns";
        stringArray[113] = "CLUSTERS";
        stringArray[114] = "ns";
        stringArray[115] = "TARGET_GROUPS";
        stringArray[116] = "none";
        stringArray[117] = "addAll";
        stringArray[118] = "resolveRelationshipDataForCollection";
        stringArray[119] = "getAt";
        stringArray[120] = "ns";
        stringArray[121] = "LAUNCH_CONFIGS";
        stringArray[122] = "ns";
        stringArray[123] = "IMAGES";
        stringArray[124] = "none";
        stringArray[125] = "addAll";
        stringArray[126] = "resolveRelationshipDataForCollection";
        stringArray[127] = "getAt";
        stringArray[128] = "ns";
        stringArray[129] = "LAUNCH_TEMPLATES";
        stringArray[130] = "ns";
        stringArray[131] = "IMAGES";
        stringArray[132] = "none";
        stringArray[133] = "translateLoadBalancers";
        stringArray[134] = "translateTargetGroups";
        stringArray[135] = "translateServerGroups";
        stringArray[136] = "getAt";
        stringArray[137] = "ns";
        stringArray[138] = "SERVER_GROUPS";
        stringArray[139] = "getAt";
        stringArray[140] = "ns";
        stringArray[141] = "INSTANCES";
        stringArray[142] = "getAt";
        stringArray[143] = "ns";
        stringArray[144] = "LAUNCH_CONFIGS";
        stringArray[145] = "getAt";
        stringArray[146] = "ns";
        stringArray[147] = "LAUNCH_TEMPLATES";
        stringArray[148] = "collect";
        stringArray[149] = "getAt";
        stringArray[150] = "ns";
        stringArray[151] = "CLUSTERS";
        stringArray[152] = "resolveRelationshipDataForCollection";
        stringArray[153] = "ns";
        stringArray[154] = "LOAD_BALANCERS";
        stringArray[155] = "resolveRelationshipDataForCollection";
        stringArray[156] = "ns";
        stringArray[157] = "TARGET_GROUPS";
        stringArray[158] = "resolveRelationshipDataForCollection";
        stringArray[159] = "ns";
        stringArray[160] = "SERVER_GROUPS";
        stringArray[161] = "include";
        stringArray[162] = "ns";
        stringArray[163] = "INSTANCES";
        stringArray[164] = "ns";
        stringArray[165] = "LAUNCH_CONFIGS";
        stringArray[166] = "ns";
        stringArray[167] = "LAUNCH_TEMPLATES";
        stringArray[168] = "translateLoadBalancers";
        stringArray[169] = "translateTargetGroups";
        stringArray[170] = "translateServerGroups";
        stringArray[171] = "resolveRelationshipDataForCollection";
        stringArray[172] = "ns";
        stringArray[173] = "SERVER_GROUPS";
        stringArray[174] = "none";
        stringArray[175] = "translateServerGroups";
        stringArray[176] = "collect";
        stringArray[177] = "supportsGetAllByApplication";
        stringArray[178] = "allClustersByApplication";
        stringArray[179] = "filterIdentifiers";
        stringArray[180] = "ns";
        stringArray[181] = "CLUSTERS";
        stringArray[182] = "getClusterKey";
        stringArray[183] = "getAll";
        stringArray[184] = "ns";
        stringArray[185] = "CLUSTERS";
        stringArray[186] = "translateClusters";
        stringArray[187] = "supportsGetAllByApplication";
        stringArray[188] = "filterIdentifiers";
        stringArray[189] = "ns";
        stringArray[190] = "CLUSTERS";
        stringArray[191] = "getClusterKey";
        stringArray[192] = "getAll";
        stringArray[193] = "ns";
        stringArray[194] = "CLUSTERS";
        stringArray[195] = "translateClusters";
        stringArray[196] = "mapResponse";
        stringArray[197] = "translateInstances";
        stringArray[198] = "collectEntries";
        stringArray[199] = "updateServerGroupLaunchSettings";
        stringArray[200] = "updateServerGroupLaunchSettings";
        stringArray[201] = "updateServerGroupBuildInfo";
        stringArray[202] = "updateServerGroupBuildInfo";
        stringArray[203] = "resolveRelationshipDataForCollection";
        stringArray[204] = "ns";
        stringArray[205] = "INSTANCES";
        stringArray[206] = "none";
        stringArray[207] = "translateInstances";
        stringArray[208] = "collectEntries";
        stringArray[209] = "collectEntries";
        stringArray[210] = "findAll";
        stringArray[211] = "collectEntries";
        stringArray[212] = "findAll";
        stringArray[213] = "getAll";
        stringArray[214] = "ns";
        stringArray[215] = "LAUNCH_CONFIGS";
        stringArray[216] = "keySet";
        stringArray[217] = "each";
        stringArray[218] = "getAll";
        stringArray[219] = "ns";
        stringArray[220] = "LAUNCH_TEMPLATES";
        stringArray[221] = "keySet";
        stringArray[222] = "each";
        stringArray[223] = "getAll";
        stringArray[224] = "ns";
        stringArray[225] = "IMAGES";
        stringArray[226] = "keySet";
        stringArray[227] = "each";
        stringArray[228] = "collectEntries";
        stringArray[229] = "addHealthToInstances";
        stringArray[230] = "each";
        stringArray[231] = "getAll";
        stringArray[232] = "ns";
        stringArray[233] = "HEALTH";
        stringArray[234] = "keySet";
        stringArray[235] = "none";
        stringArray[236] = "each";
        stringArray[237] = "each";
        stringArray[238] = "values";
        stringArray[239] = "flatten";
        stringArray[240] = "findResults";
        stringArray[241] = "getAll";
        stringArray[242] = "findAll";
        stringArray[243] = "getAt";
        stringArray[244] = "relationships";
        stringArray[245] = "getAll";
        stringArray[246] = "value";
        stringArray[247] = "find";
        stringArray[248] = "tags";
        stringArray[249] = "attributes";
        stringArray[250] = "parseName";
        stringArray[251] = "packageName";
        stringArray[252] = "version";
        stringArray[253] = "commit";
        stringArray[254] = "buildJobName";
        stringArray[255] = "buildJobName";
        stringArray[256] = "buildNumber";
        stringArray[257] = "value";
        stringArray[258] = "find";
        stringArray[259] = "tags";
        stringArray[260] = "attributes";
        stringArray[261] = "containsKey";
        stringArray[262] = "jenkins";
        stringArray[263] = "value";
        stringArray[264] = "find";
        stringArray[265] = "tags";
        stringArray[266] = "attributes";
        stringArray[267] = "filterIdentifiers";
        stringArray[268] = "ns";
        stringArray[269] = "CLUSTERS";
        stringArray[270] = "getClusterKey";
        stringArray[271] = "getAll";
        stringArray[272] = "ns";
        stringArray[273] = "CLUSTERS";
        stringArray[274] = "translateClusters";
        stringArray[275] = "get";
        stringArray[276] = "ns";
        stringArray[277] = "CLUSTERS";
        stringArray[278] = "getClusterKey";
        stringArray[279] = "getAt";
        stringArray[280] = "translateClusters";
        stringArray[281] = "getCluster";
        stringArray[282] = "orElse";
        stringArray[283] = "ofNullable";
        stringArray[284] = "orElse";
        stringArray[285] = "ofNullable";
        stringArray[286] = "filterIdentifiers";
        stringArray[287] = "ns";
        stringArray[288] = "SERVER_GROUPS";
        stringArray[289] = "getServerGroupKey";
        stringArray[290] = "getServerGroupKey";
        stringArray[291] = "attributes";
        stringArray[292] = "getAt";
        stringArray[293] = "getAt";
        stringArray[294] = "find";
        stringArray[295] = "find";
        stringArray[296] = "iterator";
        stringArray[297] = "containsKey";
        stringArray[298] = "relationships";
        stringArray[299] = "ns";
        stringArray[300] = "SERVER_GROUPS";
        stringArray[301] = "each";
        stringArray[302] = "getAt";
        stringArray[303] = "relationships";
        stringArray[304] = "ns";
        stringArray[305] = "SERVER_GROUPS";
        stringArray[306] = "getLaunchTemplateSpecification";
        stringArray[307] = "isDebugEnabled";
        stringArray[308] = "debug";
        stringArray[309] = "name";
        stringArray[310] = "getLaunchTemplateForVersion";
        stringArray[311] = "getAt";
        stringArray[312] = "launchTemplate";
        stringArray[313] = "asg";
        stringArray[314] = "mixedInstancesPolicy";
        stringArray[315] = "asg";
        stringArray[316] = "mixedInstancesPolicy";
        stringArray[317] = "asg";
        stringArray[318] = "getAt";
        stringArray[319] = "getAt";
        stringArray[320] = "tap";
        stringArray[321] = "<$constructor$>";
        stringArray[322] = "<$constructor$>";
        stringArray[323] = "getAt";
        stringArray[324] = "getAt";
        stringArray[325] = "each";
        stringArray[326] = "findAll";
        stringArray[327] = "launchTemplateData";
        stringArray[328] = "replace";
        stringArray[329] = "tap";
        stringArray[330] = "<$constructor$>";
        stringArray[331] = "collectEntries";
        stringArray[332] = "each";
        stringArray[333] = "getLogger";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[334];
        AmazonClusterProvider.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(AmazonClusterProvider.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = AmazonClusterProvider.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

