/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.aws.security;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.netflix.spinnaker.clouddriver.aws.security.AmazonClientProvider;
import com.netflix.spinnaker.clouddriver.aws.security.DefaultAWSAccountInfoLookup;
import com.netflix.spinnaker.clouddriver.security.AbstractAccountCredentials;
import com.netflix.spinnaker.fiat.model.resources.Permissions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class AmazonCredentials
extends AbstractAccountCredentials<AWSCredentials> {
    private static final String CLOUD_PROVIDER = "aws";
    private final String name;
    private final String environment;
    private final String accountType;
    private final String accountId;
    private final String defaultKeyPair;
    private final Boolean enabled;
    private final List<String> requiredGroupMembership;
    private final Permissions permissions;
    private final List<AWSRegion> regions;
    private final List<String> defaultSecurityGroups;
    private final List<LifecycleHook> lifecycleHooks;
    private final boolean allowPrivateThirdPartyImages;
    private final AWSCredentialsProvider credentialsProvider;

    public static AmazonCredentials fromAWSCredentials(String name, String environment, String accountType, AWSCredentialsProvider credentialsProvider, AmazonClientProvider amazonClientProvider) {
        return AmazonCredentials.fromAWSCredentials(name, environment, accountType, null, credentialsProvider, amazonClientProvider);
    }

    public static AmazonCredentials fromAWSCredentials(String name, String environment, String accountType, String defaultKeyPair, AWSCredentialsProvider credentialsProvider, AmazonClientProvider amazonClientProvider) {
        DefaultAWSAccountInfoLookup lookup = new DefaultAWSAccountInfoLookup(credentialsProvider, amazonClientProvider);
        String accountId = lookup.findAccountId();
        List<AWSRegion> regions = lookup.listRegions(new String[0]);
        return new AmazonCredentials(name, environment, accountType, accountId, defaultKeyPair, true, regions, null, null, null, null, false, credentialsProvider);
    }

    public AmazonCredentials(@JsonProperty(value="name") String name, @JsonProperty(value="environment") String environment, @JsonProperty(value="accountType") String accountType, @JsonProperty(value="accountId") String accountId, @JsonProperty(value="defaultKeyPair") String defaultKeyPair, @JsonProperty(value="enabled") Boolean enabled, @JsonProperty(value="regions") List<AWSRegion> regions, @JsonProperty(value="defaultSecurityGroups") List<String> defaultSecurityGroups, @JsonProperty(value="requiredGroupMembership") List<String> requiredGroupMembership, @JsonProperty(value="permissions") Permissions permissions, @JsonProperty(value="lifecycleHooks") List<LifecycleHook> lifecycleHooks, @JsonProperty(value="allowPrivateThirdPartyImages") Boolean allowPrivateThirdPartyImages) {
        this(name, environment, accountType, accountId, defaultKeyPair, enabled, regions, defaultSecurityGroups, requiredGroupMembership, permissions, lifecycleHooks, allowPrivateThirdPartyImages, null);
    }

    public AmazonCredentials(AmazonCredentials source, AWSCredentialsProvider credentialsProvider) {
        this(source.getName(), source.getEnvironment(), source.getAccountType(), source.getAccountId(), source.getDefaultKeyPair(), source.isEnabled(), source.getRegions(), source.getDefaultSecurityGroups(), source.getRequiredGroupMembership(), source.getPermissions(), source.getLifecycleHooks(), source.getAllowPrivateThirdPartyImages(), credentialsProvider);
    }

    AmazonCredentials(String name, String environment, String accountType, String accountId, String defaultKeyPair, Boolean enabled, List<AWSRegion> regions, List<String> defaultSecurityGroups, List<String> requiredGroupMembership, Permissions permissions, List<LifecycleHook> lifecycleHooks, boolean allowPrivateThirdPartyImages, AWSCredentialsProvider credentialsProvider) {
        this.name = Objects.requireNonNull(name, "name");
        this.environment = Objects.requireNonNull(environment, "environment");
        this.accountType = Objects.requireNonNull(accountType, "accountType");
        this.accountId = Objects.requireNonNull(accountId, "accountId");
        this.defaultKeyPair = defaultKeyPair;
        this.enabled = enabled != null ? enabled : true;
        this.regions = regions == null ? Collections.emptyList() : Collections.unmodifiableList(regions);
        this.defaultSecurityGroups = defaultSecurityGroups == null ? null : Collections.unmodifiableList(defaultSecurityGroups);
        this.requiredGroupMembership = requiredGroupMembership == null ? Collections.emptyList() : Collections.unmodifiableList(requiredGroupMembership);
        this.permissions = permissions == null ? Permissions.EMPTY : permissions;
        this.lifecycleHooks = lifecycleHooks == null ? Collections.emptyList() : Collections.unmodifiableList(lifecycleHooks);
        this.allowPrivateThirdPartyImages = allowPrivateThirdPartyImages;
        this.credentialsProvider = credentialsProvider;
    }

    public String getName() {
        return this.name;
    }

    public String getEnvironment() {
        return this.environment;
    }

    public String getAccountType() {
        return this.accountType;
    }

    public String getAccountId() {
        return this.accountId;
    }

    public String getDefaultKeyPair() {
        return this.defaultKeyPair;
    }

    public List<AWSRegion> getRegions() {
        return this.regions;
    }

    public List<String> getDefaultSecurityGroups() {
        return this.defaultSecurityGroups;
    }

    public List<LifecycleHook> getLifecycleHooks() {
        return this.lifecycleHooks;
    }

    public boolean getAllowPrivateThirdPartyImages() {
        return this.allowPrivateThirdPartyImages;
    }

    @JsonIgnore
    public AWSCredentialsProvider getCredentialsProvider() {
        return this.credentialsProvider;
    }

    @JsonIgnore
    public AWSCredentials getCredentials() {
        return this.credentialsProvider.getCredentials();
    }

    public String getCloudProvider() {
        return CLOUD_PROVIDER;
    }

    public List<String> getRequiredGroupMembership() {
        return this.requiredGroupMembership;
    }

    public Permissions getPermissions() {
        return this.permissions;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public static class LifecycleHook {
        private final String roleARN;
        private final String notificationTargetARN;
        private final String lifecycleTransition;
        private final Integer heartbeatTimeout;
        private final String defaultResult;

        public LifecycleHook(@JsonProperty(value="roleARN") String roleARN, @JsonProperty(value="notificationTargetARN") String notificationTargetARN, @JsonProperty(value="lifecycleTransition") String lifecycleTransition, @JsonProperty(value="heartbeatTimeout") Integer heartbeatTimeout, @JsonProperty(value="defaultResult") String defaultResult) {
            this.roleARN = roleARN;
            this.notificationTargetARN = notificationTargetARN;
            this.lifecycleTransition = lifecycleTransition;
            this.heartbeatTimeout = heartbeatTimeout;
            this.defaultResult = defaultResult;
        }

        public String getRoleARN() {
            return this.roleARN;
        }

        public String getNotificationTargetARN() {
            return this.notificationTargetARN;
        }

        public String getLifecycleTransition() {
            return this.lifecycleTransition;
        }

        public Integer getHeartbeatTimeout() {
            return this.heartbeatTimeout;
        }

        public String getDefaultResult() {
            return this.defaultResult;
        }
    }

    public static class AWSRegion {
        private final String name;
        private final Boolean deprecated;
        private final List<String> availabilityZones;
        private final List<String> preferredZones;

        public AWSRegion(@JsonProperty(value="name") String name, @JsonProperty(value="availabilityZones") List<String> availabilityZones, @JsonProperty(value="preferredZones") List<String> preferredZones, @JsonProperty(value="deprecated") Boolean deprecated) {
            this.name = Objects.requireNonNull(name, "name");
            this.availabilityZones = availabilityZones == null ? Collections.emptyList() : Collections.unmodifiableList(availabilityZones);
            ArrayList<String> preferred = preferredZones == null || preferredZones.isEmpty() ? new ArrayList<String>(this.availabilityZones) : new ArrayList<String>(preferredZones);
            preferred.retainAll(this.availabilityZones);
            this.preferredZones = Collections.unmodifiableList(preferred);
            if (deprecated == null) {
                deprecated = Boolean.FALSE;
            }
            this.deprecated = deprecated;
        }

        public AWSRegion(String name, List<String> availabilityZones) {
            this(name, availabilityZones, Collections.emptyList(), null);
        }

        public String getName() {
            return this.name;
        }

        public Collection<String> getAvailabilityZones() {
            return this.availabilityZones;
        }

        public Collection<String> getPreferredZones() {
            return this.preferredZones;
        }

        public Boolean getDeprecated() {
            return this.deprecated;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AWSRegion awsRegion = (AWSRegion)o;
            return this.name.equals(awsRegion.name) && this.availabilityZones.equals(awsRegion.availabilityZones) && this.preferredZones.equals(awsRegion.preferredZones);
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + this.availabilityZones.hashCode() + this.preferredZones.hashCode();
            return result;
        }
    }
}

