/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.aws.deploy.description;

import com.amazonaws.services.elasticloadbalancingv2.model.ActionTypeEnum;
import com.amazonaws.services.elasticloadbalancingv2.model.AuthenticateOidcActionConfig;
import com.amazonaws.services.elasticloadbalancingv2.model.Certificate;
import com.amazonaws.services.elasticloadbalancingv2.model.ProtocolEnum;
import com.amazonaws.services.elasticloadbalancingv2.model.RedirectActionConfig;
import com.netflix.spinnaker.clouddriver.aws.deploy.description.UpsertAmazonLoadBalancerDescription;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class UpsertAmazonLoadBalancerV2Description
extends UpsertAmazonLoadBalancerDescription {
    public List<Listener> listeners = new ArrayList<Listener>();
    public List<TargetGroup> targetGroups = new ArrayList<TargetGroup>();
    public Boolean deletionProtection = false;
    public Boolean loadBalancingCrossZone;
    public String ipAddressType = "ipv4";

    public static class Rule {
        private String priority;
        private List<Action> actions;
        private List<RuleCondition> conditions;

        public String getPriority() {
            return this.priority;
        }

        public void setPriority(String priority) {
            this.priority = priority;
        }

        public List<Action> getActions() {
            return this.actions;
        }

        public void setActions(List<Action> actions) {
            this.actions = actions;
        }

        public List<RuleCondition> getConditions() {
            return this.conditions;
        }

        public void setConditions(List<RuleCondition> conditions) {
            this.conditions = conditions;
        }
    }

    public static class RuleCondition {
        private String field;
        private List<String> values;

        public String getField() {
            return this.field;
        }

        public void setField(String field) {
            this.field = field;
        }

        public List<String> getValues() {
            return this.values;
        }

        public void setValues(List<String> values) {
            this.values = values;
        }
    }

    public static class Attributes {
        private Integer deregistrationDelay;
        private Boolean stickinessEnabled;
        private String stickinessType;
        private Integer stickinessDuration;
        private Boolean proxyProtocolV2;
        private Boolean deregistrationDelayConnectionTermination;
        private Boolean multiValueHeadersEnabled;

        public Integer getDeregistrationDelay() {
            return this.deregistrationDelay;
        }

        public void setDeregistrationDelay(Integer deregistrationDelay) {
            this.deregistrationDelay = deregistrationDelay;
        }

        public Boolean getStickinessEnabled() {
            return this.stickinessEnabled;
        }

        public void setStickinessEnabled(Boolean stickinessEnabled) {
            this.stickinessEnabled = stickinessEnabled;
        }

        public String getStickinessType() {
            return this.stickinessType;
        }

        public void setStickinessType(String stickinessType) {
            this.stickinessType = stickinessType;
        }

        public Integer getStickinessDuration() {
            return this.stickinessDuration;
        }

        public void setStickinessDuration(Integer stickinessDuration) {
            this.stickinessDuration = stickinessDuration;
        }

        public Boolean getProxyProtocolV2() {
            return this.proxyProtocolV2;
        }

        public void setProxyProtocolV2(Boolean proxyProtocolV2) {
            this.proxyProtocolV2 = proxyProtocolV2;
        }

        public Boolean getMultiValueHeadersEnabled() {
            return this.multiValueHeadersEnabled;
        }

        public void setMultiValueHeadersEnabled(Boolean multiValueHeadersEnabled) {
            this.multiValueHeadersEnabled = multiValueHeadersEnabled;
        }

        public Boolean getDeregistrationDelayConnectionTermination() {
            return this.deregistrationDelayConnectionTermination;
        }

        public void setDeregistrationDelayConnectionTermination(Boolean deregistrationDelayConnectionTermination) {
            this.deregistrationDelayConnectionTermination = deregistrationDelayConnectionTermination;
        }
    }

    public static class Action {
        private String type = ActionTypeEnum.Forward.toString();
        private String targetGroupName;
        private AuthenticateOidcActionConfig authenticateOidcActionConfig;
        private RedirectActionConfig redirectActionConfig;

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getTargetGroupName() {
            return this.targetGroupName;
        }

        public void setTargetGroupName(String targetGroupName) {
            this.targetGroupName = targetGroupName;
        }

        public AuthenticateOidcActionConfig getAuthenticateOidcActionConfig() {
            return this.authenticateOidcActionConfig;
        }

        public void setAuthenticateOidcActionConfig(AuthenticateOidcActionConfig authenticateOidcActionConfig) {
            this.authenticateOidcActionConfig = authenticateOidcActionConfig;
        }

        public RedirectActionConfig getRedirectActionConfig() {
            return this.redirectActionConfig;
        }

        public void setRedirectActionConfig(RedirectActionConfig redirectActionConfig) {
            this.redirectActionConfig = redirectActionConfig;
        }
    }

    public static class Listener {
        private List<Certificate> certificates;
        private ProtocolEnum protocol;
        private Integer port;
        private String sslPolicy;
        private List<Action> defaultActions;
        private List<Rule> rules = new ArrayList<Rule>();

        public List<Certificate> getCertificates() {
            return this.certificates;
        }

        public void setCertificates(List<Certificate> certificates) {
            this.certificates = certificates;
        }

        public ProtocolEnum getProtocol() {
            return this.protocol;
        }

        public void setProtocol(ProtocolEnum protocol) {
            this.protocol = protocol;
        }

        public Integer getPort() {
            return this.port;
        }

        public void setPort(Integer port) {
            this.port = port;
        }

        public String getSslPolicy() {
            return this.sslPolicy;
        }

        public void setSslPolicy(String sslPolicy) {
            this.sslPolicy = sslPolicy;
        }

        public List<Action> getDefaultActions() {
            return this.defaultActions;
        }

        public void setDefaultActions(List<Action> defaultActions) {
            this.defaultActions = defaultActions;
        }

        public List<Rule> getRules() {
            return this.rules;
        }

        public void setRules(List<Rule> rules) {
            this.rules = rules;
        }

        public Boolean compare(com.amazonaws.services.elasticloadbalancingv2.model.Listener awsListener, List<com.amazonaws.services.elasticloadbalancingv2.model.Action> actions, List<com.amazonaws.services.elasticloadbalancingv2.model.Rule> existingRules, List<com.amazonaws.services.elasticloadbalancingv2.model.Rule> rules) {
            Boolean rulesSame;
            int certificateCount;
            int awsCertificateCount;
            Boolean certificatesSame;
            if (existingRules == null) {
                existingRules = new ArrayList<com.amazonaws.services.elasticloadbalancingv2.model.Rule>();
            }
            if (rules == null) {
                rules = new ArrayList<com.amazonaws.services.elasticloadbalancingv2.model.Rule>();
            }
            if ((certificatesSame = Boolean.valueOf((awsCertificateCount = awsListener.getCertificates() != null ? awsListener.getCertificates().size() : 0) == (certificateCount = this.certificates != null ? this.certificates.size() : 0))).booleanValue()) {
                HashSet awsListenerArns = new HashSet();
                HashSet thisListenerArns = new HashSet();
                if (awsListener.getCertificates() != null) {
                    awsListener.getCertificates().forEach(cert -> awsListenerArns.add(cert.getCertificateArn()));
                }
                if (this.certificates != null) {
                    this.certificates.forEach(cert -> thisListenerArns.add(cert.getCertificateArn()));
                }
                certificatesSame = awsListenerArns.equals(thisListenerArns);
            }
            if ((rulesSame = Boolean.valueOf(existingRules.size() == rules.size() + 1)).booleanValue()) {
                for (com.amazonaws.services.elasticloadbalancingv2.model.Rule existingRule : existingRules) {
                    boolean match = true;
                    if (!existingRule.isDefault().booleanValue()) {
                        match = false;
                        for (com.amazonaws.services.elasticloadbalancingv2.model.Rule rule : rules) {
                            if (!existingRule.getActions().equals(rule.getActions()) || !existingRule.getConditions().equals(rule.getConditions()) || !existingRule.getPriority().equals(rule.getPriority())) continue;
                            match = true;
                            break;
                        }
                    }
                    if ((rulesSame = Boolean.valueOf(match)).booleanValue()) continue;
                    break;
                }
            }
            Boolean actionsSame = awsListener.getDefaultActions().containsAll(actions) && actions.containsAll(awsListener.getDefaultActions());
            return this.protocol != null && this.protocol.toString().equals(awsListener.getProtocol()) && this.port != null && this.port.equals(awsListener.getPort()) && actionsSame != false && rulesSame != false && certificatesSame != false;
        }
    }

    public static class TargetGroup {
        private String name;
        private ProtocolEnum protocol;
        private Integer port;
        private Attributes attributes;
        private String targetType = "instance";
        private ProtocolEnum healthCheckProtocol;
        private String healthCheckPath;
        private String healthCheckPort;
        private Integer healthCheckInterval = 10;
        private Integer healthCheckTimeout = 5;
        private Integer unhealthyThreshold = 2;
        private Integer healthyThreshold = 10;
        private String healthCheckMatcher = "200-299";

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public ProtocolEnum getProtocol() {
            return this.protocol;
        }

        public void setProtocol(ProtocolEnum protocol) {
            this.protocol = protocol;
        }

        public Integer getPort() {
            return this.port;
        }

        public void setPort(Integer port) {
            this.port = port;
        }

        public Attributes getAttributes() {
            return this.attributes;
        }

        public void setAttributes(Attributes attributes) {
            this.attributes = attributes;
        }

        public String getTargetType() {
            return this.targetType;
        }

        public void setTargetType(String targetType) {
            this.targetType = targetType;
        }

        public ProtocolEnum getHealthCheckProtocol() {
            return this.healthCheckProtocol;
        }

        public void setHealthCheckProtocol(ProtocolEnum healthCheckProtocol) {
            this.healthCheckProtocol = healthCheckProtocol;
        }

        public String getHealthCheckPath() {
            return this.healthCheckPath;
        }

        public void setHealthCheckPath(String healthCheckPath) {
            this.healthCheckPath = healthCheckPath;
        }

        public String getHealthCheckPort() {
            return this.healthCheckPort;
        }

        public void setHealthCheckPort(String healthCheckPort) {
            this.healthCheckPort = healthCheckPort;
        }

        public Integer getHealthCheckInterval() {
            return this.healthCheckInterval;
        }

        public void setHealthCheckInterval(Integer healthCheckInterval) {
            this.healthCheckInterval = healthCheckInterval;
        }

        public Integer getHealthCheckTimeout() {
            return this.healthCheckTimeout;
        }

        public void setHealthCheckTimeout(Integer healthCheckTimeout) {
            this.healthCheckTimeout = healthCheckTimeout;
        }

        public Integer getUnhealthyThreshold() {
            return this.unhealthyThreshold;
        }

        public void setUnhealthyThreshold(Integer unhealthyThreshold) {
            this.unhealthyThreshold = unhealthyThreshold;
        }

        public Integer getHealthyThreshold() {
            return this.healthyThreshold;
        }

        public void setHealthyThreshold(Integer healthyThreshold) {
            this.healthyThreshold = healthyThreshold;
        }

        public String getHealthCheckMatcher() {
            return this.healthCheckMatcher;
        }

        public void setHealthCheckMatcher(String healthCheckMatcher) {
            this.healthCheckMatcher = healthCheckMatcher;
        }

        public Boolean compare(com.amazonaws.services.elasticloadbalancingv2.model.TargetGroup awsTargetGroup) {
            return this.name.equals(awsTargetGroup.getTargetGroupName()) && this.protocol.toString().equals(awsTargetGroup.getProtocol()) && this.port.equals(awsTargetGroup.getPort()) && this.healthCheckProtocol.toString().equals(awsTargetGroup.getHealthCheckProtocol()) && this.healthCheckPath.equals(awsTargetGroup.getHealthCheckPath()) && this.healthCheckPort.equals(awsTargetGroup.getHealthCheckPort()) && this.healthCheckInterval.equals(awsTargetGroup.getHealthCheckIntervalSeconds()) && this.healthCheckTimeout.equals(awsTargetGroup.getHealthCheckTimeoutSeconds()) && this.healthyThreshold.equals(awsTargetGroup.getHealthyThresholdCount()) && this.unhealthyThreshold.equals(awsTargetGroup.getUnhealthyThresholdCount()) && this.healthCheckMatcher.equals(awsTargetGroup.getMatcher().getHttpCode());
        }
    }
}

