/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.aws.deploy.ops.loadbalancer;

import com.amazonaws.services.ec2.model.IpPermission;
import com.amazonaws.services.ec2.model.SecurityGroup;
import com.amazonaws.services.ec2.model.UserIdGroupPair;
import com.netflix.spinnaker.clouddriver.aws.deploy.description.UpsertSecurityGroupDescription;
import com.netflix.spinnaker.clouddriver.aws.deploy.ops.securitygroup.SecurityGroupIngressConverter;
import com.netflix.spinnaker.clouddriver.aws.deploy.ops.securitygroup.SecurityGroupLookupFactory;
import com.netflix.spinnaker.clouddriver.aws.security.NetflixAmazonCredentials;
import com.netflix.spinnaker.clouddriver.helpers.OperationPoller;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;

@Component
public class IngressLoadBalancerBuilder {
    public IngressLoadBalancerGroupResult ingressApplicationLoadBalancerGroup(String application, String region, String credentialAccount, NetflixAmazonCredentials credentials, String vpcId, Collection<Integer> ports, SecurityGroupLookupFactory securityGroupLookupFactory) throws FailedSecurityGroupIngressException {
        SecurityGroupLookupFactory.SecurityGroupLookup securityGroupLookup = securityGroupLookupFactory.getInstance(region);
        SecurityGroupLookupFactory.SecurityGroupUpdater applicationLoadBalancerSecurityGroupUpdater = this.getOrCreateSecurityGroup(application + "-elb", region, "Application ELB Security Group for " + application, credentialAccount, credentials, vpcId, securityGroupLookup);
        SecurityGroupLookupFactory.SecurityGroupUpdater applicationSecurityGroupUpdater = this.getOrCreateSecurityGroup(application, region, "Application Security Group for " + application, credentialAccount, credentials, vpcId, securityGroupLookup);
        SecurityGroup source = applicationLoadBalancerSecurityGroupUpdater.getSecurityGroup();
        SecurityGroup target = applicationSecurityGroupUpdater.getSecurityGroup();
        List<IpPermission> currentPermissions = SecurityGroupIngressConverter.flattenPermissions(target);
        List<IpPermission> targetPermissions = ports.stream().map(port -> this.newIpPermissionWithSourceAndPort(source.getGroupId(), (int)port)).collect(Collectors.toList());
        this.filterOutExistingPermissions(targetPermissions, currentPermissions);
        if (!targetPermissions.isEmpty()) {
            try {
                applicationSecurityGroupUpdater.addIngress(targetPermissions);
            }
            catch (Exception e) {
                throw new FailedSecurityGroupIngressException(e);
            }
        }
        return new IngressLoadBalancerGroupResult(source.getGroupId(), source.getGroupName());
    }

    private SecurityGroupLookupFactory.SecurityGroupUpdater getOrCreateSecurityGroup(String groupName, String region, String descriptionText, String credentialAccount, NetflixAmazonCredentials credentials, String vpcId, SecurityGroupLookupFactory.SecurityGroupLookup securityGroupLookup) {
        return (SecurityGroupLookupFactory.SecurityGroupUpdater)OperationPoller.retryWithBackoff(o -> {
            SecurityGroupLookupFactory.SecurityGroupUpdater securityGroupUpdater = securityGroupLookup.getSecurityGroupByName(credentialAccount, groupName, vpcId).orElse(null);
            if (securityGroupUpdater == null) {
                UpsertSecurityGroupDescription description = new UpsertSecurityGroupDescription();
                description.setName(groupName);
                description.setDescription(descriptionText);
                description.setVpcId(vpcId);
                description.setRegion(region);
                description.setCredentials(credentials);
                return securityGroupLookup.createSecurityGroup(description);
            }
            return securityGroupUpdater;
        }, (long)500L, (int)3);
    }

    private void filterOutExistingPermissions(List<IpPermission> permissionsToAdd, List<IpPermission> existingPermissions) {
        permissionsToAdd.forEach(permission -> permission.getUserIdGroupPairs().removeIf(pair -> existingPermissions.stream().anyMatch(p -> p.getFromPort().equals(permission.getFromPort()) && p.getToPort().equals(permission.getToPort()) && pair.getGroupId() != null && p.getUserIdGroupPairs().stream().anyMatch(gp -> gp.getGroupId() != null && gp.getGroupId().equals(pair.getGroupId())))));
        permissionsToAdd.removeIf(permission -> permission.getUserIdGroupPairs().isEmpty());
    }

    private IpPermission newIpPermissionWithSourceAndPort(String sourceGroupId, int port) {
        return new IpPermission().withIpProtocol("tcp").withFromPort(Integer.valueOf(port)).withToPort(Integer.valueOf(port)).withUserIdGroupPairs(new UserIdGroupPair[]{new UserIdGroupPair().withGroupId(sourceGroupId)});
    }

    static class FailedSecurityGroupIngressException
    extends Exception {
        FailedSecurityGroupIngressException(Exception e) {
            super(e);
        }
    }

    public static class IngressLoadBalancerGroupResult {
        public final String groupId;
        public final String groupName;

        IngressLoadBalancerGroupResult(String groupId, String groupName) {
            this.groupId = groupId;
            this.groupName = groupName;
        }
    }
}

