/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.aws.security;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.netflix.spinnaker.clouddriver.aws.security.AmazonCredentials;
import com.netflix.spinnaker.clouddriver.aws.security.NetflixSTSAssumeRoleSessionCredentialsProvider;
import com.netflix.spinnaker.fiat.model.resources.Permissions;
import java.util.List;
import java.util.Objects;

public class AssumeRoleAmazonCredentials
extends AmazonCredentials {
    static final String DEFAULT_SESSION_NAME = "Spinnaker";
    private final String assumeRole;
    private final String sessionName;
    private final String externalId;

    static AWSCredentialsProvider createSTSCredentialsProvider(AWSCredentialsProvider credentialsProvider, String accountId, String assumeRole, String sessionName, String externalId) {
        String assumeRoleValue = Objects.requireNonNull(assumeRole, "assumeRole");
        if (!assumeRoleValue.startsWith("arn:")) {
            assumeRoleValue = String.format("arn:aws:iam::%s:%s", Objects.requireNonNull(accountId, "accountId"), assumeRoleValue);
        }
        return credentialsProvider == null ? null : new NetflixSTSAssumeRoleSessionCredentialsProvider(credentialsProvider, assumeRoleValue, Objects.requireNonNull(sessionName, "sessionName"), accountId, externalId);
    }

    public AssumeRoleAmazonCredentials(@JsonProperty(value="name") String name, @JsonProperty(value="environment") String environment, @JsonProperty(value="accountType") String accountType, @JsonProperty(value="accountId") String accountId, @JsonProperty(value="defaultKeyPair") String defaultKeyPair, @JsonProperty(value="enabled") Boolean enabled, @JsonProperty(value="regions") List<AmazonCredentials.AWSRegion> regions, @JsonProperty(value="defaultSecurityGroups") List<String> defaultSecurityGroups, @JsonProperty(value="requiredGroupMembership") List<String> requiredGroupMembership, @JsonProperty(value="permissions") Permissions permissions, @JsonProperty(value="lifecycleHooks") List<AmazonCredentials.LifecycleHook> lifecycleHooks, @JsonProperty(value="allowPrivateThirdPartyImages") boolean allowPrivateThirdPartyImages, @JsonProperty(value="assumeRole") String assumeRole, @JsonProperty(value="sessionName") String sessionName, @JsonProperty(value="externalId") String externalId) {
        this(name, environment, accountType, accountId, defaultKeyPair, enabled, regions, defaultSecurityGroups, requiredGroupMembership, permissions, lifecycleHooks, allowPrivateThirdPartyImages, null, assumeRole, sessionName, externalId);
    }

    public AssumeRoleAmazonCredentials(AssumeRoleAmazonCredentials copy, AWSCredentialsProvider credentialsProvider) {
        this(copy.getName(), copy.getEnvironment(), copy.getAccountType(), copy.getAccountId(), copy.getDefaultKeyPair(), copy.isEnabled(), copy.getRegions(), copy.getDefaultSecurityGroups(), copy.getRequiredGroupMembership(), copy.getPermissions(), copy.getLifecycleHooks(), copy.getAllowPrivateThirdPartyImages(), credentialsProvider, copy.getAssumeRole(), copy.getSessionName(), copy.getExternalId());
    }

    AssumeRoleAmazonCredentials(String name, String environment, String accountType, String accountId, String defaultKeyPair, Boolean enabled, List<AmazonCredentials.AWSRegion> regions, List<String> defaultSecurityGroups, List<String> requiredGroupMembership, Permissions permissions, List<AmazonCredentials.LifecycleHook> lifecycleHooks, boolean allowPrivateThirdPartyImages, AWSCredentialsProvider credentialsProvider, String assumeRole, String sessionName, String externalId) {
        super(name, environment, accountType, accountId, defaultKeyPair, enabled, regions, defaultSecurityGroups, requiredGroupMembership, permissions, lifecycleHooks, allowPrivateThirdPartyImages, AssumeRoleAmazonCredentials.createSTSCredentialsProvider(credentialsProvider, accountId, assumeRole, sessionName == null ? DEFAULT_SESSION_NAME : sessionName, externalId));
        this.assumeRole = assumeRole;
        this.sessionName = sessionName == null ? DEFAULT_SESSION_NAME : sessionName;
        this.externalId = externalId;
    }

    public String getAssumeRole() {
        return this.assumeRole;
    }

    public String getSessionName() {
        return this.sessionName;
    }

    public String getExternalId() {
        return this.externalId;
    }
}

