/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.aws.deploy.asg.asgbuilders;

import com.amazonaws.services.autoscaling.AmazonAutoScaling;
import com.amazonaws.services.autoscaling.model.CreateAutoScalingGroupRequest;
import com.amazonaws.services.autoscaling.model.LaunchTemplateSpecification;
import com.amazonaws.services.ec2.AmazonEC2;
import com.amazonaws.services.ec2.model.LaunchTemplate;
import com.netflix.spinnaker.clouddriver.aws.deploy.asg.AsgConfigHelper;
import com.netflix.spinnaker.clouddriver.aws.deploy.asg.AsgLifecycleHookWorker;
import com.netflix.spinnaker.clouddriver.aws.deploy.asg.AutoScalingWorker;
import com.netflix.spinnaker.clouddriver.aws.deploy.asg.asgbuilders.AsgBuilder;
import com.netflix.spinnaker.clouddriver.aws.services.LaunchTemplateService;
import com.netflix.spinnaker.clouddriver.aws.services.SecurityGroupService;
import com.netflix.spinnaker.clouddriver.data.task.Task;
import com.netflix.spinnaker.config.AwsConfiguration;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsgWithLaunchTemplateBuilder
extends AsgBuilder {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AsgWithLaunchTemplateBuilder.class);
    private LaunchTemplateService ltService;
    private SecurityGroupService securityGroupService;
    private AwsConfiguration.DeployDefaults deployDefaults;

    public AsgWithLaunchTemplateBuilder(LaunchTemplateService ltService, SecurityGroupService securityGroupService, AwsConfiguration.DeployDefaults deployDefaults, AmazonAutoScaling autoScaling, AmazonEC2 ec2, AsgLifecycleHookWorker asgLifecycleHookWorker) {
        super(autoScaling, ec2, asgLifecycleHookWorker);
        this.ltService = ltService;
        this.securityGroupService = securityGroupService;
        this.deployDefaults = deployDefaults;
    }

    @Override
    protected CreateAutoScalingGroupRequest buildRequest(Task task, String taskPhase, String asgName, AutoScalingWorker.AsgConfiguration config) {
        config = AsgConfigHelper.setAppSecurityGroups(config, this.securityGroupService, this.deployDefaults);
        LaunchTemplate lt = this.ltService.createLaunchTemplate(config, asgName, AsgConfigHelper.createName(asgName, null));
        LaunchTemplateSpecification ltSpec = new LaunchTemplateSpecification().withLaunchTemplateId(lt.getLaunchTemplateId()).withVersion(lt.getLatestVersionNumber().toString());
        task.updateStatus(taskPhase, "Deploying ASG " + asgName + " with launch template " + lt.getLaunchTemplateId());
        CreateAutoScalingGroupRequest request = this.buildPartialRequest(task, taskPhase, asgName, config);
        return request.withLaunchTemplate(ltSpec);
    }
}

