/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.aws.lifecycle;

import com.netflix.spinnaker.clouddriver.aws.security.NetflixAmazonCredentials;
import com.netflix.spinnaker.clouddriver.security.AccountCredentials;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class ARN {
    static final Pattern PATTERN = Pattern.compile("arn:aws(?:-cn|-us-gov)?:.*:(.*):(\\d+):(.*)");
    String arn;
    String region;
    String name;
    NetflixAmazonCredentials account;

    ARN(Collection<? extends AccountCredentials> accountCredentials, String arn) {
        this.arn = arn;
        Matcher sqsMatcher = PATTERN.matcher(arn);
        if (!sqsMatcher.matches()) {
            throw new IllegalArgumentException(arn + " is not a valid SNS or SQS ARN");
        }
        this.region = sqsMatcher.group(1);
        this.name = sqsMatcher.group(3);
        String accountId = sqsMatcher.group(2);
        this.account = (NetflixAmazonCredentials)accountCredentials.stream().filter(c -> accountId.equals(c.getAccountId())).findFirst().orElseThrow(() -> new IllegalArgumentException("No account credentials found for " + accountId));
    }

    ARN(NetflixAmazonCredentials netflixAmazonCredentials, String arn) {
        this.arn = arn;
        Matcher sqsMatcher = PATTERN.matcher(arn);
        if (!sqsMatcher.matches()) {
            throw new IllegalArgumentException(arn + " is not a valid SNS or SQS ARN");
        }
        this.region = sqsMatcher.group(1);
        this.name = sqsMatcher.group(3);
        String accountId = sqsMatcher.group(2);
        if (!accountId.equals(netflixAmazonCredentials.getAccountId())) {
            throw new IllegalArgumentException("No account credentials found for " + accountId);
        }
        this.account = netflixAmazonCredentials;
    }
}

