/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.aws.lifecycle;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.netflix.spectator.api.Registry;
import com.netflix.spinnaker.clouddriver.aws.deploy.ops.discovery.AwsEurekaSupport;
import com.netflix.spinnaker.clouddriver.aws.lifecycle.InstanceTerminationConfigurationProperties;
import com.netflix.spinnaker.clouddriver.aws.lifecycle.InstanceTerminationLifecycleWorker;
import com.netflix.spinnaker.clouddriver.aws.security.AmazonClientProvider;
import com.netflix.spinnaker.clouddriver.aws.security.NetflixAmazonCredentials;
import com.netflix.spinnaker.credentials.CredentialsRepository;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.regex.Pattern;
import javax.annotation.PostConstruct;
import javax.inject.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.context.annotation.DependsOn;
import org.springframework.stereotype.Component;

@Component
@DependsOn(value={"amazonCredentialsLoader"})
@ConditionalOnExpression(value="${aws.lifecycle-subscribers.instance-termination.enabled:false} && ${caching.write-enabled:true}")
public class InstanceTerminationLifecycleWorkerProvider {
    private static final String REGION_TEMPLATE_PATTERN = Pattern.quote("{{region}}");
    private static final String ACCOUNT_ID_TEMPLATE_PATTERN = Pattern.quote("{{accountId}}");
    private static final Logger log = LoggerFactory.getLogger(InstanceTerminationLifecycleWorkerProvider.class);
    private final ObjectMapper objectMapper;
    private final AmazonClientProvider amazonClientProvider;
    private final CredentialsRepository<NetflixAmazonCredentials> credentialsRepository;
    private final InstanceTerminationConfigurationProperties properties;
    private final Provider<AwsEurekaSupport> discoverySupport;
    private final Registry registry;

    @Autowired
    InstanceTerminationLifecycleWorkerProvider(@Qualifier(value="amazonObjectMapper") ObjectMapper objectMapper, AmazonClientProvider amazonClientProvider, CredentialsRepository<NetflixAmazonCredentials> credentialsRepository, InstanceTerminationConfigurationProperties properties, Provider<AwsEurekaSupport> discoverySupport, Registry registry) {
        this.objectMapper = objectMapper;
        this.amazonClientProvider = amazonClientProvider;
        this.credentialsRepository = credentialsRepository;
        this.properties = properties;
        this.discoverySupport = discoverySupport;
        this.registry = registry;
    }

    @PostConstruct
    public void start() {
        NetflixAmazonCredentials credentials = (NetflixAmazonCredentials)this.credentialsRepository.getOne(this.properties.getAccountName());
        ExecutorService executorService = Executors.newFixedThreadPool(credentials.getRegions().size(), new ThreadFactoryBuilder().setNameFormat(InstanceTerminationLifecycleWorkerProvider.class.getSimpleName() + "-%d").build());
        credentials.getRegions().forEach(region -> {
            InstanceTerminationLifecycleWorker worker = new InstanceTerminationLifecycleWorker(this.objectMapper, this.amazonClientProvider, this.credentialsRepository, new InstanceTerminationConfigurationProperties(this.properties.getAccountName(), this.properties.getQueueARN().replaceAll(REGION_TEMPLATE_PATTERN, region.getName()).replaceAll(ACCOUNT_ID_TEMPLATE_PATTERN, credentials.getAccountId()), this.properties.getTopicARN().replaceAll(REGION_TEMPLATE_PATTERN, region.getName()).replaceAll(ACCOUNT_ID_TEMPLATE_PATTERN, credentials.getAccountId()), this.properties.getVisibilityTimeout(), this.properties.getWaitTimeSeconds(), this.properties.getSqsMessageRetentionPeriodSeconds(), this.properties.getEurekaUpdateStatusRetryMax()), this.discoverySupport, this.registry);
            try {
                executorService.submit(worker);
            }
            catch (RejectedExecutionException e) {
                log.error("Could not start " + worker.getWorkerName(), (Throwable)e);
            }
        });
    }
}

