/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.aws.controllers;

import com.netflix.spinnaker.clouddriver.aws.model.AmazonCloudFormationStack;
import com.netflix.spinnaker.clouddriver.aws.provider.view.AmazonCloudFormationProvider;
import com.netflix.spinnaker.kork.web.exceptions.NotFoundException;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.AntPathMatcher;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.HandlerMapping;

@RequestMapping(value={"/aws/cloudFormation/stacks"})
@RestController
class CloudFormationController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CloudFormationController.class);
    private AmazonCloudFormationProvider cloudFormationProvider;

    @Autowired
    public CloudFormationController(AmazonCloudFormationProvider cloudFormationProvider) {
        this.cloudFormationProvider = cloudFormationProvider;
    }

    @RequestMapping(method={RequestMethod.GET})
    List<AmazonCloudFormationStack> list(@RequestParam String accountName, @RequestParam(required=false, defaultValue="*") String region) {
        log.debug("Cloud formation list stacks for account {}", (Object)accountName);
        return this.cloudFormationProvider.list(accountName, region);
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/**"})
    AmazonCloudFormationStack get(HttpServletRequest request) {
        String pattern = (String)request.getAttribute(HandlerMapping.BEST_MATCHING_PATTERN_ATTRIBUTE);
        String stackId = new AntPathMatcher().extractPathWithinPattern(pattern, request.getRequestURI());
        log.debug("Cloud formation get stack with id {}", (Object)stackId);
        return this.cloudFormationProvider.get(stackId).orElseThrow(() -> new NotFoundException(String.format("Cloud Formation stackId %s not found.", stackId)));
    }
}

