/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.aws.deploy;

import com.netflix.frigga.Names;
import com.netflix.spinnaker.clouddriver.aws.deploy.AmazonResourceTagger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(name={"aws.defaults.resourceTagging.enabled"}, havingValue="true", matchIfMissing=true)
public class DefaultAmazonResourceTagger
implements AmazonResourceTagger {
    private final String clusterTag;
    private final String applicationTag;

    @Autowired
    public DefaultAmazonResourceTagger(@Value(value="${aws.defaults.resourceTagging.applicationTag:spinnaker:application}") String applicationTag, @Value(value="${aws.defaults.resourceTagging.clusterTag:spinnaker:cluster}") String clusterTag) {
        this.clusterTag = clusterTag;
        this.applicationTag = applicationTag;
    }

    @Override
    @NotNull
    public Collection<AmazonResourceTagger.Tag> volumeTags(@Nullable Map<String, String> blockDeviceTags, @NotNull String serverGroupName) {
        Names names = Names.parseName((String)serverGroupName);
        ArrayList<AmazonResourceTagger.Tag> tags = new ArrayList<AmazonResourceTagger.Tag>();
        tags.add(AmazonResourceTagger.Tag.of(this.applicationTag, names.getApp()));
        tags.add(AmazonResourceTagger.Tag.of(this.clusterTag, names.getCluster()));
        tags.addAll(Optional.ofNullable(blockDeviceTags).orElse(Collections.emptyMap()).entrySet().stream().map(e -> AmazonResourceTagger.Tag.of((String)e.getKey(), (String)e.getValue())).collect(Collectors.toList()));
        return tags;
    }
}

