/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.aws.deploy;

import com.netflix.spinnaker.clouddriver.aws.deploy.description.ModifyServerGroupLaunchTemplateDescription;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.reflect.FieldUtils;

public class ModifyServerGroupUtils {
    public static Set<String> getNonMetadataFieldsSetInReq(ModifyServerGroupLaunchTemplateDescription reqDescription) {
        ModifyServerGroupLaunchTemplateDescription descWithDefaults = new ModifyServerGroupLaunchTemplateDescription();
        HashSet<String> nonMetadataFieldsSet = new HashSet<String>();
        Set allFieldNames = FieldUtils.getAllFieldsList(reqDescription.getClass()).stream().map(Field::getName).collect(Collectors.toSet());
        allFieldNames.stream().forEach(fieldName -> {
            if (fieldName.contains("$") || fieldName.equals("metaClass")) {
                return;
            }
            Object defaultValue = descWithDefaults.getProperty((String)fieldName);
            Object requestedValue = reqDescription.getProperty((String)fieldName);
            boolean isMetadataField = ModifyServerGroupLaunchTemplateDescription.getMetadataFieldNames().contains(fieldName);
            if (!Objects.equals(requestedValue, defaultValue) && !isMetadataField) {
                nonMetadataFieldsSet.add((String)fieldName);
            }
        });
        return nonMetadataFieldsSet;
    }
}

