/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.aws.deploy.asg.asgbuilders;

import com.amazonaws.services.autoscaling.AmazonAutoScaling;
import com.amazonaws.services.autoscaling.model.AlreadyExistsException;
import com.amazonaws.services.autoscaling.model.AutoScalingGroup;
import com.amazonaws.services.autoscaling.model.CreateAutoScalingGroupRequest;
import com.amazonaws.services.autoscaling.model.DescribeAutoScalingGroupsRequest;
import com.amazonaws.services.autoscaling.model.DescribeAutoScalingGroupsResult;
import com.amazonaws.services.autoscaling.model.EnableMetricsCollectionRequest;
import com.amazonaws.services.autoscaling.model.SuspendProcessesRequest;
import com.amazonaws.services.autoscaling.model.Tag;
import com.amazonaws.services.autoscaling.model.UpdateAutoScalingGroupRequest;
import com.amazonaws.services.ec2.AmazonEC2;
import com.amazonaws.services.ec2.model.DescribeSubnetsResult;
import com.amazonaws.services.ec2.model.Subnet;
import com.google.common.collect.ImmutableMap;
import com.netflix.spinnaker.clouddriver.aws.deploy.asg.AsgLifecycleHookWorker;
import com.netflix.spinnaker.clouddriver.aws.deploy.asg.AutoScalingWorker;
import com.netflix.spinnaker.clouddriver.aws.model.SubnetData;
import com.netflix.spinnaker.clouddriver.aws.model.SubnetTarget;
import com.netflix.spinnaker.clouddriver.data.task.Task;
import com.netflix.spinnaker.kork.core.RetrySupport;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AsgBuilder {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AsgBuilder.class);
    private final RetrySupport retrySupport = new RetrySupport();
    private AmazonAutoScaling autoScaling;
    private AmazonEC2 ec2;
    private AsgLifecycleHookWorker asgLifecycleHookWorker;

    AsgBuilder(AmazonAutoScaling autoScaling, AmazonEC2 ec2, AsgLifecycleHookWorker asgLifecycleHookWorker) {
        this.autoScaling = autoScaling;
        this.ec2 = ec2;
        this.asgLifecycleHookWorker = asgLifecycleHookWorker;
    }

    protected abstract CreateAutoScalingGroupRequest buildRequest(Task var1, String var2, String var3, AutoScalingWorker.AsgConfiguration var4);

    public String build(Task task, String taskPhase, String asgName, AutoScalingWorker.AsgConfiguration cfg) {
        return this.createAsg(task, taskPhase, this.buildRequest(task, taskPhase, asgName, cfg), cfg);
    }

    protected CreateAutoScalingGroupRequest buildPartialRequest(Task task, String taskPhase, String name, AutoScalingWorker.AsgConfiguration cfg) {
        CreateAutoScalingGroupRequest request = new CreateAutoScalingGroupRequest().withAutoScalingGroupName(name).withMinSize(Integer.valueOf(cfg.getMinInstances())).withMaxSize(Integer.valueOf(cfg.getMaxInstances())).withDesiredCapacity(Integer.valueOf(cfg.getDesiredInstances())).withLoadBalancerNames(cfg.getClassicLoadBalancers()).withTargetGroupARNs(cfg.getTargetGroupArns()).withDefaultCooldown(cfg.getCooldown()).withHealthCheckGracePeriod(cfg.getHealthCheckGracePeriod()).withHealthCheckType(cfg.getHealthCheckType()).withTerminationPolicies(cfg.getTerminationPolicies());
        if (cfg.getTags() != null && !cfg.getTags().isEmpty()) {
            task.updateStatus(taskPhase, "Adding tags for " + name);
            cfg.getTags().entrySet().stream().forEach(e -> request.withTags(new Tag[]{new Tag().withKey((String)e.getKey()).withValue((String)e.getValue()).withPropagateAtLaunch(Boolean.valueOf(true))}));
        }
        boolean filterForSubnetPurposeTags = cfg.getSubnetIds() == null || cfg.getSubnetIds().isEmpty();
        String subnetIds = String.join((CharSequence)",", this.getSubnetIds(this.getSubnets(filterForSubnetPurposeTags, cfg.getSubnetType(), cfg.getAvailabilityZones()), cfg.getSubnetIds(), cfg.getAvailabilityZones()));
        List<Subnet> subnets = this.getSubnets(true, cfg.getSubnetType(), cfg.getAvailabilityZones());
        if (StringUtils.isNotEmpty((CharSequence)subnetIds)) {
            task.updateStatus(taskPhase, " > Deploying to subnetIds: " + subnetIds);
            request.withVPCZoneIdentifier(subnetIds);
        } else {
            if (StringUtils.isNotEmpty((CharSequence)cfg.getSubnetType()) && (subnets == null || subnets.isEmpty())) {
                throw new RuntimeException(String.format("No suitable subnet was found for internal subnet purpose '%s'!", cfg.getSubnetType()));
            }
            task.updateStatus(taskPhase, "Deploying to availabilityZones: " + cfg.getAvailabilityZones());
            request.withAvailabilityZones(cfg.getAvailabilityZones());
        }
        if (cfg.getCapacityRebalance() != null) {
            task.updateStatus(taskPhase, "Setting capacity rebalance to " + cfg.getCapacityRebalance() + " for " + name);
            request.withCapacityRebalance(cfg.getCapacityRebalance());
        }
        return request;
    }

    private String createAsg(Task task, String taskPhase, CreateAutoScalingGroupRequest request, AutoScalingWorker.AsgConfiguration cfg) {
        Exception e;
        String asgName = request.getAutoScalingGroupName();
        RuntimeException ex = (RuntimeException)this.retrySupport.retry(() -> {
            try {
                this.autoScaling.createAutoScalingGroup(request);
                return null;
            }
            catch (AlreadyExistsException e) {
                if (!this.shouldProceedWithExistingState(this.autoScaling, asgName, request, task, taskPhase)) {
                    return e;
                }
                log.debug("Determined pre-existing ASG is desired state, continuing...", (Throwable)e);
                return null;
            }
        }, 10, 1000L, false);
        if (ex != null) {
            throw ex;
        }
        if (cfg.getLifecycleHooks() != null && !cfg.getLifecycleHooks().isEmpty() && (e = (Exception)this.retrySupport.retry(() -> {
            task.updateStatus(taskPhase, "Creating lifecycle hooks for: " + asgName);
            this.asgLifecycleHookWorker.attach(task, cfg.getLifecycleHooks(), asgName);
            return null;
        }, 10, 1000L, false)) != null) {
            task.updateStatus(taskPhase, "Unable to attach lifecycle hooks to ASG (" + asgName + "): " + e.getMessage());
        }
        if (cfg.getSuspendedProcesses() != null && !cfg.getSuspendedProcesses().isEmpty()) {
            task.updateStatus(taskPhase, "Suspending processes for: " + asgName);
            this.retrySupport.retry(() -> this.autoScaling.suspendProcesses(new SuspendProcessesRequest().withAutoScalingGroupName(asgName).withScalingProcesses(cfg.getSuspendedProcesses())), 10, 1000L, false);
        }
        if (cfg.getEnabledMetrics() != null && !cfg.getEnabledMetrics().isEmpty() && cfg.getInstanceMonitoring() != null && cfg.getInstanceMonitoring().booleanValue()) {
            task.updateStatus(taskPhase, "Enabling metrics collection for: " + asgName);
            this.retrySupport.retry(() -> this.autoScaling.enableMetricsCollection(new EnableMetricsCollectionRequest().withAutoScalingGroupName(asgName).withGranularity("1Minute").withMetrics(cfg.getEnabledMetrics())), 10, 1000L, false);
        }
        this.retrySupport.retry(() -> {
            task.updateStatus(taskPhase, String.format("Setting size of %s in %s/%s to [min=%s, max=%s, desired=%s]", asgName, cfg.getCredentials().getName(), cfg.getRegion(), cfg.getMinInstances(), cfg.getMaxInstances(), cfg.getDesiredInstances()));
            this.autoScaling.updateAutoScalingGroup(new UpdateAutoScalingGroupRequest().withAutoScalingGroupName(asgName).withMinSize(Integer.valueOf(cfg.getMinInstances())).withMaxSize(Integer.valueOf(cfg.getMaxInstances())).withDesiredCapacity(Integer.valueOf(cfg.getDesiredInstances())));
            return true;
        }, 10, 1000L, false);
        task.updateStatus(taskPhase, "Deployed EC2 server group named " + asgName);
        return asgName;
    }

    private boolean shouldProceedWithExistingState(AmazonAutoScaling autoScaling, String asgName, CreateAutoScalingGroupRequest request, Task task, String taskPhase) {
        ImmutableMap predicates;
        Set failedPredicates;
        DescribeAutoScalingGroupsResult result = autoScaling.describeAutoScalingGroups(new DescribeAutoScalingGroupsRequest().withAutoScalingGroupNames(new String[]{asgName}));
        if (result.getAutoScalingGroups().isEmpty()) {
            log.error("Attempted to find pre-existing ASG but none was found: " + asgName);
            return true;
        }
        AutoScalingGroup existingAsg = (AutoScalingGroup)result.getAutoScalingGroups().get(0);
        List<String> existingAsgSubnetIds = null;
        if (StringUtils.isNotEmpty((CharSequence)existingAsg.getVPCZoneIdentifier())) {
            existingAsgSubnetIds = this.sortList(Arrays.asList(existingAsg.getVPCZoneIdentifier().split(",")));
        }
        List<String> requestedSubnetIds = null;
        if (StringUtils.isNotEmpty((CharSequence)request.getVPCZoneIdentifier())) {
            requestedSubnetIds = this.sortList(Arrays.asList(request.getVPCZoneIdentifier().split(",")));
        }
        if (!(failedPredicates = (predicates = ImmutableMap.builder().put((Object)"launch configuration", (Object)Objects.equals(existingAsg.getLaunchConfigurationName(), request.getLaunchConfigurationName())).put((Object)"launch template", (Object)Objects.equals(existingAsg.getLaunchTemplate(), request.getLaunchTemplate())).put((Object)"mixed instances policy", (Object)Objects.equals(existingAsg.getMixedInstancesPolicy(), request.getMixedInstancesPolicy())).put((Object)"availability zones", (Object)Objects.equals(this.sortList(existingAsg.getAvailabilityZones()), this.sortList(request.getAvailabilityZones()))).put((Object)"subnets", (Object)Objects.equals(existingAsgSubnetIds, requestedSubnetIds)).put((Object)"load balancers", (Object)Objects.equals(this.sortList(existingAsg.getLoadBalancerNames()), this.sortList(request.getLoadBalancerNames()))).put((Object)"target groups", (Object)Objects.equals(this.sortList(existingAsg.getTargetGroupARNs()), this.sortList(request.getTargetGroupARNs()))).put((Object)"cooldown", (Object)(existingAsg.getDefaultCooldown() == request.getDefaultCooldown() ? 1 : 0)).put((Object)"health check grace period", (Object)(existingAsg.getHealthCheckGracePeriod() == request.getHealthCheckGracePeriod() ? 1 : 0)).put((Object)"health check type", (Object)Objects.equals(existingAsg.getHealthCheckType(), request.getHealthCheckType())).put((Object)"termination policies", (Object)Objects.equals(this.sortList(existingAsg.getTerminationPolicies()), this.sortList(request.getTerminationPolicies()))).build()).entrySet().stream().filter(p -> (Boolean)p.getValue() == false).map(Map.Entry::getKey).collect(Collectors.toSet())).isEmpty()) {
            task.updateStatus(taskPhase, String.format("%s already exists and does not seem to match desired state on: %s", asgName, String.join((CharSequence)",", failedPredicates)));
            log.debug("Failed predicates: " + (Map)predicates);
            return false;
        }
        if (existingAsg.getCreatedTime().toInstant().isBefore(Instant.now().minus(1L, ChronoUnit.HOURS))) {
            task.updateStatus(taskPhase, asgName + " already exists and appears to be valid, but falls outside of safety window for idempotent deploy (1 hour)");
            return false;
        }
        return true;
    }

    private List<String> getSubnetIds(List<Subnet> allSubnetsForTypeAndAvailabilityZone, List<String> subnetIds, List<String> availabilityZones) {
        List<String> allSubnetIds = allSubnetsForTypeAndAvailabilityZone.stream().map(s -> s.getSubnetId()).collect(Collectors.toList());
        List invalidSubnetIds = null;
        if (subnetIds != null && !subnetIds.isEmpty()) {
            invalidSubnetIds = subnetIds.stream().filter(it -> !allSubnetIds.contains(it)).collect(Collectors.toList());
        }
        if (invalidSubnetIds != null && !invalidSubnetIds.isEmpty()) {
            throw new IllegalStateException(String.format("One or more subnet ids are not valid (invalidSubnetIds: %s, availabilityZones: %s)", String.join((CharSequence)",", invalidSubnetIds), String.join((CharSequence)",", availabilityZones)));
        }
        return subnetIds != null && !subnetIds.isEmpty() ? subnetIds : allSubnetIds;
    }

    private List<Subnet> getSubnets(boolean filterForSubnetPurposeTags, String subnetType, List<String> availabilityZones) {
        if (StringUtils.isEmpty((CharSequence)subnetType)) {
            return Collections.emptyList();
        }
        DescribeSubnetsResult result = this.ec2.describeSubnets();
        ArrayList<Subnet> mySubnets = new ArrayList<Subnet>();
        for (Subnet subnet : result.getSubnets()) {
            if (availabilityZones != null && !availabilityZones.isEmpty() && !availabilityZones.contains(subnet.getAvailabilityZone())) continue;
            if (filterForSubnetPurposeTags) {
                SubnetData sd = SubnetData.from(subnet);
                if (sd.getPurpose() == null || !sd.getPurpose().equals(subnetType) || sd.getTarget() != null && sd.getTarget() != SubnetTarget.EC2) continue;
                mySubnets.add(subnet);
                continue;
            }
            mySubnets.add(subnet);
        }
        return mySubnets;
    }

    private List<String> sortList(List<String> list) {
        return list.stream().sorted(Comparator.naturalOrder()).collect(Collectors.toList());
    }
}

