/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.aws.deploy.asg.asgbuilders;

import com.amazonaws.services.autoscaling.AmazonAutoScaling;
import com.amazonaws.services.autoscaling.model.CreateAutoScalingGroupRequest;
import com.amazonaws.services.ec2.AmazonEC2;
import com.netflix.spinnaker.clouddriver.aws.deploy.asg.AsgLifecycleHookWorker;
import com.netflix.spinnaker.clouddriver.aws.deploy.asg.AutoScalingWorker;
import com.netflix.spinnaker.clouddriver.aws.deploy.asg.LaunchConfigurationBuilder;
import com.netflix.spinnaker.clouddriver.aws.deploy.asg.asgbuilders.AsgBuilder;
import com.netflix.spinnaker.clouddriver.data.task.Task;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsgWithLaunchConfigurationBuilder
extends AsgBuilder {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AsgWithLaunchConfigurationBuilder.class);
    private LaunchConfigurationBuilder lcBuilder;

    public AsgWithLaunchConfigurationBuilder(LaunchConfigurationBuilder lcBuilder, AmazonAutoScaling autoScaling, AmazonEC2 ec2, AsgLifecycleHookWorker asgLifecycleHookWorker) {
        super(autoScaling, ec2, asgLifecycleHookWorker);
        this.lcBuilder = lcBuilder;
    }

    @Override
    protected CreateAutoScalingGroupRequest buildRequest(Task task, String taskPhase, String asgName, AutoScalingWorker.AsgConfiguration cfg) {
        LaunchConfigurationBuilder.LaunchConfigurationSettings settings = LaunchConfigurationBuilder.LaunchConfigurationSettings.builder().account(cfg.getCredentials().getName()).environment(cfg.getCredentials().getEnvironment()).accountType(cfg.getCredentials().getAccountType()).region(cfg.getRegion()).baseName(asgName).suffix(null).ami(cfg.getAmi()).iamRole(cfg.getIamRole()).classicLinkVpcId(cfg.getClassicLinkVpcId()).classicLinkVpcSecurityGroups(cfg.getClassicLinkVpcSecurityGroups()).instanceType(cfg.getInstanceType()).keyPair(cfg.getKeyPair()).base64UserData(cfg.getBase64UserData()).associatePublicIpAddress(cfg.getAssociatePublicIpAddress()).kernelId(cfg.getKernelId()).ramdiskId(cfg.getRamdiskId()).ebsOptimized(cfg.getEbsOptimized() != null ? cfg.getEbsOptimized() : false).spotMaxPrice(cfg.getSpotMaxPrice()).instanceMonitoring(cfg.getInstanceMonitoring() != null ? cfg.getInstanceMonitoring() : false).blockDevices(cfg.getBlockDevices()).securityGroups(cfg.getSecurityGroups()).build();
        String launchConfigName = this.lcBuilder.buildLaunchConfiguration(cfg.getApplication(), cfg.getSubnetType(), settings, cfg.getLegacyUdf(), cfg.getUserDataOverride());
        task.updateStatus(taskPhase, "Deploying ASG " + asgName + " with launch configuration " + launchConfigName);
        CreateAutoScalingGroupRequest request = this.buildPartialRequest(task, taskPhase, asgName, cfg);
        return request.withLaunchConfigurationName(launchConfigName);
    }
}

