/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.aws.deploy.converters;

import com.netflix.spinnaker.clouddriver.aws.AmazonOperation;
import com.netflix.spinnaker.clouddriver.aws.deploy.description.UpsertAmazonLoadBalancerClassicDescription;
import com.netflix.spinnaker.clouddriver.aws.deploy.description.UpsertAmazonLoadBalancerDescription;
import com.netflix.spinnaker.clouddriver.aws.deploy.description.UpsertAmazonLoadBalancerV2Description;
import com.netflix.spinnaker.clouddriver.aws.deploy.ops.loadbalancer.UpsertAmazonLoadBalancerAtomicOperation;
import com.netflix.spinnaker.clouddriver.aws.deploy.ops.loadbalancer.UpsertAmazonLoadBalancerV2AtomicOperation;
import com.netflix.spinnaker.clouddriver.aws.model.AmazonLoadBalancerType;
import com.netflix.spinnaker.clouddriver.aws.security.NetflixAmazonCredentials;
import com.netflix.spinnaker.clouddriver.orchestration.AtomicOperation;
import com.netflix.spinnaker.clouddriver.security.AbstractAtomicOperationsCredentialsSupport;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Component;

@AmazonOperation(value="upsertLoadBalancer")
@Component(value="upsertAmazonLoadBalancerDescription")
class UpsertAmazonLoadBalancerAtomicOperationConverter
extends AbstractAtomicOperationsCredentialsSupport {
    UpsertAmazonLoadBalancerAtomicOperationConverter() {
    }

    private void sanitizeInput(Map input) {
        if (!input.containsKey("loadBalancerType")) {
            input.put("loadBalancerType", AmazonLoadBalancerType.CLASSIC.toString());
        }
    }

    public AtomicOperation convertOperation(Map input) {
        this.sanitizeInput(input);
        if (input.get("loadBalancerType").equals(AmazonLoadBalancerType.CLASSIC.toString())) {
            return new UpsertAmazonLoadBalancerAtomicOperation(this.convertDescription(input));
        }
        return new UpsertAmazonLoadBalancerV2AtomicOperation(this.convertDescription(input));
    }

    public UpsertAmazonLoadBalancerDescription convertDescription(Map input) {
        this.sanitizeInput(input);
        HashMap<String, AmazonLoadBalancerType> description = new HashMap<String, AmazonLoadBalancerType>();
        description.putAll(input);
        description.put("loadBalancerType", AmazonLoadBalancerType.getByValue((String)description.get("loadBalancerType")));
        UpsertAmazonLoadBalancerDescription converted = description.get("loadBalancerType") == AmazonLoadBalancerType.CLASSIC ? (UpsertAmazonLoadBalancerDescription)this.getObjectMapper().convertValue(description, UpsertAmazonLoadBalancerClassicDescription.class) : (UpsertAmazonLoadBalancerDescription)this.getObjectMapper().convertValue(description, UpsertAmazonLoadBalancerV2Description.class);
        converted.setCredentials((NetflixAmazonCredentials)this.getCredentialsObject((String)input.get("credentials")));
        return converted;
    }
}

