/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.aws.deploy.ops;

import com.amazonaws.services.ec2.model.DeregisterImageRequest;
import com.netflix.spinnaker.clouddriver.aws.deploy.description.DeleteAmazonImageDescription;
import com.netflix.spinnaker.clouddriver.aws.security.AmazonClientProvider;
import com.netflix.spinnaker.clouddriver.data.task.Task;
import com.netflix.spinnaker.clouddriver.data.task.TaskRepository;
import com.netflix.spinnaker.clouddriver.orchestration.AtomicOperation;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

public class DeleteAmazonImageAtomicOperation
implements AtomicOperation<Void> {
    private static final String BASE_PHASE = "DELETE_IMAGE";
    private final DeleteAmazonImageDescription description;
    @Autowired
    private AmazonClientProvider amazonClientProvider;

    private static Task getTask() {
        return (Task)TaskRepository.threadLocalTask.get();
    }

    public DeleteAmazonImageAtomicOperation(DeleteAmazonImageDescription description) {
        this.description = description;
    }

    public Void operate(List priorOutputs) {
        DeleteAmazonImageAtomicOperation.getTask().updateStatus(BASE_PHASE, String.format("Initializing Delete Image operation for %s", this.description));
        this.amazonClientProvider.getAmazonEC2(this.description.getCredentials(), this.description.getRegion()).deregisterImage(new DeregisterImageRequest().withImageId(this.description.getImageId()));
        DeleteAmazonImageAtomicOperation.getTask().updateStatus(BASE_PHASE, String.format("Deleted Image %s in %s", this.description.getImageId(), this.description.getRegion()));
        return null;
    }
}

