/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.aws.deploy.ops;

import com.amazonaws.services.ec2.model.AmazonEC2Exception;
import com.amazonaws.services.ec2.model.DeleteSnapshotRequest;
import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Registry;
import com.netflix.spinnaker.clouddriver.aws.deploy.description.DeleteAmazonSnapshotDescription;
import com.netflix.spinnaker.clouddriver.aws.security.AmazonClientProvider;
import com.netflix.spinnaker.clouddriver.data.task.Task;
import com.netflix.spinnaker.clouddriver.data.task.TaskRepository;
import com.netflix.spinnaker.clouddriver.orchestration.AtomicOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class DeleteAmazonSnapshotAtomicOperation
implements AtomicOperation<Void> {
    private static final String BASE_PHASE = "DELETE_SNAPSHOT";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final DeleteAmazonSnapshotDescription description;
    private final Registry registry;
    private final Id deleteSnapshotTaskId;
    @Autowired
    private AmazonClientProvider amazonClientProvider;

    public DeleteAmazonSnapshotAtomicOperation(DeleteAmazonSnapshotDescription description, Registry registry) {
        this.description = description;
        this.registry = registry;
        this.deleteSnapshotTaskId = registry.createId("tasks.DeleteAmazonSnapshot");
    }

    private static Task getTask() {
        return (Task)TaskRepository.threadLocalTask.get();
    }

    public Void operate(List priorOutputs) {
        DeleteAmazonSnapshotAtomicOperation.getTask().updateStatus(BASE_PHASE, String.format("Initializing Delete Snapshot operation for %s", this.description));
        try {
            this.amazonClientProvider.getAmazonEC2(this.description.getCredentials(), this.description.getRegion()).deleteSnapshot(new DeleteSnapshotRequest().withSnapshotId(this.description.getSnapshotId()));
        }
        catch (AmazonEC2Exception e) {
            if (e.getStatusCode() == 400 && e.getErrorCode().equalsIgnoreCase("InvalidSnapshot.NotFound")) {
                this.log.debug("Snapshot does not exist, ignoring.");
            }
            throw e;
        }
        catch (Exception e) {
            this.registry.counter(this.deleteSnapshotTaskId.withTag("success", false).withTag("region", this.description.getRegion()).withTag("account", this.description.getAccount())).increment();
            this.log.error(String.format("Failed to delete snapshotId: %s , region: %s , account: %s", this.description.getSnapshotId(), this.description.getRegion(), this.description.getAccount()), (Throwable)e);
            throw e;
        }
        this.registry.counter(this.deleteSnapshotTaskId.withTag("success", true).withTag("region", this.description.getRegion()).withTag("account", this.description.getAccount())).increment();
        DeleteAmazonSnapshotAtomicOperation.getTask().updateStatus(BASE_PHASE, String.format("Deleted Snapshot %s in %s", this.description.getSnapshotId(), this.description.getRegion()));
        return null;
    }
}

