/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.aws.deploy.preprocessors;

import com.netflix.spinnaker.clouddriver.aws.deploy.description.AllowLaunchDescription;
import com.netflix.spinnaker.clouddriver.orchestration.AtomicOperationDescriptionPreProcessor;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class CredentialsAccountNormalizationPreProcessor
implements AtomicOperationDescriptionPreProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CredentialsAccountNormalizationPreProcessor.class);

    public boolean supports(Class descriptionClass) {
        return !AllowLaunchDescription.class.isAssignableFrom(descriptionClass);
    }

    public Map process(Map description) {
        String account = (String)description.get("account");
        String credentials = (String)description.get("credentials");
        if (account != null && credentials != null && !account.equals(credentials)) {
            log.warn("Passed 'account' ({}) and 'credentials' ({}), but values are not equal", (Object)account, (Object)credentials);
            description.put("account", credentials);
        }
        if (credentials == null && account != null) {
            description.put("credentials", account);
        }
        if (account == null && credentials != null) {
            description.put("account", credentials);
        }
        return description;
    }
}

