/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.aws.deploy.validators;

import com.amazonaws.services.elasticloadbalancingv2.model.AuthenticateOidcActionConfig;
import com.amazonaws.services.elasticloadbalancingv2.model.TargetTypeEnum;
import com.netflix.spinnaker.clouddriver.aws.AmazonOperation;
import com.netflix.spinnaker.clouddriver.aws.deploy.description.UpsertAmazonLoadBalancerClassicDescription;
import com.netflix.spinnaker.clouddriver.aws.deploy.description.UpsertAmazonLoadBalancerDescription;
import com.netflix.spinnaker.clouddriver.aws.deploy.description.UpsertAmazonLoadBalancerV2Description;
import com.netflix.spinnaker.clouddriver.aws.deploy.validators.AmazonDescriptionValidationSupport;
import com.netflix.spinnaker.clouddriver.aws.model.AmazonLoadBalancerType;
import com.netflix.spinnaker.clouddriver.aws.security.AmazonCredentials;
import com.netflix.spinnaker.clouddriver.deploy.ValidationErrors;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;

@AmazonOperation(value="upsertLoadBalancer")
@Component(value="createAmazonLoadBalancerDescriptionValidator")
class CreateAmazonLoadBalancerDescriptionValidator
extends AmazonDescriptionValidationSupport<UpsertAmazonLoadBalancerDescription> {
    CreateAmazonLoadBalancerDescriptionValidator() {
    }

    private void validateActions(List<UpsertAmazonLoadBalancerV2Description.Action> actions, Set<String> allTargetGroupNames, Set<String> unusedTargetGroupNames, ValidationErrors errors) {
        for (UpsertAmazonLoadBalancerV2Description.Action action : actions) {
            AuthenticateOidcActionConfig config;
            if (action.getType().equals("forward")) {
                String targetGroupName = action.getTargetGroupName();
                if (!allTargetGroupNames.contains(targetGroupName)) {
                    errors.rejectValue("listeners", "createAmazonLoadBalancerDescription.listeners.invalid.targetGroup");
                }
                unusedTargetGroupNames.remove(action.getTargetGroupName());
            }
            if (!action.getType().equals("authenticate-oidc") || (config = action.getAuthenticateOidcActionConfig()).getClientId() != null) continue;
            errors.rejectValue("listeners", "createAmazonLoadBalancerDescription.listeners.invalid.oidcConfig");
        }
    }

    @Override
    public void validate(List priorDescriptions, UpsertAmazonLoadBalancerDescription description, ValidationErrors errors) {
        if (description.getName() == null && description.getClusterName() == null) {
            errors.rejectValue("clusterName", "createAmazonLoadBalancerDescription.missing.name.or.clusterName");
        }
        if (description.getSubnetType() == null && description.getAvailabilityZones() == null) {
            errors.rejectValue("availabilityZones", "createAmazonLoadBalancerDescription.missing.subnetType.or.availabilityZones");
        }
        if (description.getAvailabilityZones() != null) {
            for (Map.Entry<String, List<String>> entry : description.getAvailabilityZones().entrySet()) {
                String region = entry.getKey();
                List<String> azs = entry.getValue();
                AmazonCredentials.AWSRegion aWSRegion = description.getCredentials().getRegions().stream().filter(r -> r.getName().equals(region)).findFirst().orElse(null);
                if (aWSRegion == null) {
                    errors.rejectValue("availabilityZones", "createAmazonLoadBalancerDescription.region.not.configured");
                }
                if (description.getSubnetType() == null && azs == null) {
                    errors.rejectValue("availabilityZones", "createAmazonLoadBalancerDescription.missing.subnetType.or.availabilityZones");
                    break;
                }
                if (description.getSubnetType() != null || aWSRegion == null || aWSRegion.getAvailabilityZones().containsAll(azs)) continue;
                errors.rejectValue("availabilityZones", "createAmazonLoadBalancerDescription.zone.not.configured");
            }
        }
        switch (description.getLoadBalancerType()) {
            case CLASSIC: {
                UpsertAmazonLoadBalancerClassicDescription classicDescription = (UpsertAmazonLoadBalancerClassicDescription)description;
                if (classicDescription.getListeners() == null || classicDescription.getListeners().size() == 0) {
                    errors.rejectValue("listeners", "createAmazonLoadBalancerDescription.listeners.empty");
                }
                if (classicDescription.getDeregistrationDelay() == null || classicDescription.getDeregistrationDelay() >= 1 && classicDescription.getDeregistrationDelay() <= 3600) break;
                errors.rejectValue("deregistrationDelay", "createAmazonLoadBalancerDescription.deregistrationDelay.invalid");
                break;
            }
            case APPLICATION: 
            case NETWORK: {
                List list;
                HashSet uniquePorts;
                UpsertAmazonLoadBalancerV2Description albDescription = (UpsertAmazonLoadBalancerV2Description)description;
                if (albDescription.targetGroups == null || albDescription.targetGroups.size() == 0) {
                    errors.rejectValue("targetGroups", "createAmazonLoadBalancerDescription.targetGroups.empty");
                }
                HashSet<String> allTargetGroupNames = new HashSet<String>();
                for (UpsertAmazonLoadBalancerV2Description.TargetGroup targetGroup : albDescription.targetGroups) {
                    allTargetGroupNames.add(targetGroup.getName());
                    if (targetGroup.getName() == null || targetGroup.getName().isEmpty()) {
                        errors.rejectValue("targetGroups", "createAmazonLoadBalancerDescription.targetGroups.name.missing");
                    }
                    if (TargetTypeEnum.Lambda.toString().equalsIgnoreCase(targetGroup.getTargetType())) {
                        this.validateLambdaTargetGroup(albDescription, targetGroup, errors);
                        continue;
                    }
                    if (targetGroup.getProtocol() == null) {
                        errors.rejectValue("targetGroups", "createAmazonLoadBalancerDescription.targetGroups.protocol.missing");
                    }
                    if (targetGroup.getPort() != null) continue;
                    errors.rejectValue("targetGroups", "createAmazonLoadBalancerDescription.targetGroups.port.missing");
                }
                HashSet<String> unusedTargetGroupNames = new HashSet<String>();
                unusedTargetGroupNames.addAll(allTargetGroupNames);
                for (UpsertAmazonLoadBalancerV2Description.Listener listener : albDescription.listeners) {
                    if (listener.getDefaultActions().size() == 0) {
                        errors.rejectValue("listeners", "createAmazonLoadBalancerDescription.listeners.missing.defaultAction");
                    }
                    this.validateActions(listener.getDefaultActions(), allTargetGroupNames, unusedTargetGroupNames, errors);
                    for (UpsertAmazonLoadBalancerV2Description.Rule rule : listener.getRules()) {
                        this.validateActions(rule.getActions(), allTargetGroupNames, unusedTargetGroupNames, errors);
                    }
                }
                if (unusedTargetGroupNames.size() > 0) {
                    errors.rejectValue("targetGroups", "createAmazonLoadBalancerDescription.targetGroups.unused");
                }
                if ((uniquePorts = new HashSet(list = albDescription.listeners.stream().map(UpsertAmazonLoadBalancerV2Description.Listener::getPort).collect(Collectors.toList()))).size() == list.size()) break;
                errors.rejectValue("listeners", "Multiple listeners cannot use the same port");
                break;
            }
            default: {
                errors.rejectValue("loadBalancerType", "createAmazonLoadBalancerDescription.loadBalancerType.invalid");
            }
        }
    }

    private void validateLambdaTargetGroup(UpsertAmazonLoadBalancerV2Description albDescription, UpsertAmazonLoadBalancerV2Description.TargetGroup targetGroup, ValidationErrors errors) {
        if (!AmazonLoadBalancerType.APPLICATION.toString().equalsIgnoreCase(albDescription.getLoadBalancerType().toString())) {
            errors.rejectValue("loadBalancerType", "createAmazonLoadBalancerDescription.loadBalancerType.invalid");
        }
    }
}

