/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.aws.deploy.validators;

import com.netflix.spinnaker.clouddriver.aws.AmazonOperation;
import com.netflix.spinnaker.clouddriver.aws.deploy.description.DeleteAmazonSnapshotDescription;
import com.netflix.spinnaker.clouddriver.aws.deploy.validators.AmazonDescriptionValidationSupport;
import com.netflix.spinnaker.clouddriver.aws.security.NetflixAmazonCredentials;
import com.netflix.spinnaker.clouddriver.deploy.ValidationErrors;
import com.netflix.spinnaker.credentials.CredentialsRepository;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@AmazonOperation(value="deleteSnapshot")
@Component
public class DeleteAmazonSnapshotDescriptionValidator
extends AmazonDescriptionValidationSupport<DeleteAmazonSnapshotDescription> {
    CredentialsRepository<NetflixAmazonCredentials> credentialsRepository;

    @Autowired
    public DeleteAmazonSnapshotDescriptionValidator(CredentialsRepository<NetflixAmazonCredentials> credentialsRepository) {
        this.credentialsRepository = credentialsRepository;
    }

    @Override
    public void validate(List priorDescriptions, DeleteAmazonSnapshotDescription description, ValidationErrors errors) {
        String key = DeleteAmazonSnapshotDescription.class.getSimpleName();
        this.validateRegion(description, description.getRegion(), key, errors);
        if (description.getRegion().equals("") || description.getRegion() == null) {
            errors.rejectValue("region", "deleteAmazonSnapshotDescription.region.empty");
        }
        if (description.getSnapshotId().equals("") || description.getSnapshotId() == null) {
            errors.rejectValue("snapshotId", "deleteAmazonSnapshotDescription.snapshotId.empty");
        }
    }
}

