/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.aws.deploy.validators;

import com.netflix.spinnaker.clouddriver.aws.AmazonOperation;
import com.netflix.spinnaker.clouddriver.aws.deploy.InstanceTypeUtils;
import com.netflix.spinnaker.clouddriver.aws.deploy.ModifyServerGroupUtils;
import com.netflix.spinnaker.clouddriver.aws.deploy.description.ModifyServerGroupLaunchTemplateDescription;
import com.netflix.spinnaker.clouddriver.aws.deploy.validators.AmazonDescriptionValidationSupport;
import com.netflix.spinnaker.clouddriver.aws.deploy.validators.BasicAmazonDeployDescriptionValidator;
import com.netflix.spinnaker.clouddriver.aws.model.AmazonBlockDevice;
import com.netflix.spinnaker.clouddriver.aws.security.NetflixAmazonCredentials;
import com.netflix.spinnaker.clouddriver.deploy.ValidationErrors;
import com.netflix.spinnaker.clouddriver.security.AccountCredentials;
import com.netflix.spinnaker.credentials.CredentialsRepository;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@AmazonOperation(value="updateLaunchTemplate")
@Component(value="modifyServerGroupLaunchTemplateDescriptionValidator")
public class ModifyServerGroupLaunchTemplateValidator
extends AmazonDescriptionValidationSupport<ModifyServerGroupLaunchTemplateDescription> {
    private CredentialsRepository<NetflixAmazonCredentials> credentialsRepository;

    @Autowired
    public ModifyServerGroupLaunchTemplateValidator(CredentialsRepository<NetflixAmazonCredentials> credentialsRepository) {
        this.credentialsRepository = credentialsRepository;
    }

    @Override
    public void validate(List priorDescriptions, ModifyServerGroupLaunchTemplateDescription description, ValidationErrors errors) {
        if (!this.areNonMetadataFieldsSet(description)) {
            errors.rejectValue("multiple fields", "modifyservergrouplaunchtemplatedescription.launchTemplateAndServerGroupFields.empty", "No changes requested to launch template or related server group fields for modifyServerGroupLaunchTemplate operation.");
        }
        String key = ModifyServerGroupLaunchTemplateDescription.class.getSimpleName();
        this.validateRegion(description, description.getRegion(), key, errors);
        if (description.getCredentials() == null) {
            errors.rejectValue("credentials", "modifyservergrouplaunchtemplatedescription.credentials.empty");
        } else {
            AccountCredentials credentials = (AccountCredentials)this.credentialsRepository.getOne(description.getCredentials().getName());
            if (credentials == null) {
                errors.rejectValue("credentials", "modifyservergrouplaunchtemplatedescription.credentials.invalid");
            }
        }
        if (description.getRegion() == null) {
            errors.rejectValue("region", "modifyservergrouplaunchtemplatedescription.region.empty");
        }
        if (StringUtils.isBlank((CharSequence)description.getAsgName())) {
            errors.rejectValue("asgName", "modifyservergrouplaunchtemplatedescription.asgName.empty");
        }
        if (description.getAssociatePublicIpAddress() != null && description.getAssociatePublicIpAddress() != null && description.getAssociatePublicIpAddress().booleanValue() && description.getSubnetType() == null) {
            errors.rejectValue("associatePublicIpAddress", "modifyservergrouplaunchtemplatedescription.associatePublicIpAddress.subnetType.not.supplied");
        }
        if (description.getBlockDevices() != null) {
            for (AmazonBlockDevice device : description.getBlockDevices()) {
                BasicAmazonDeployDescriptionValidator.BlockDeviceRules.validate(device, errors);
            }
        }
        if (description.getUnlimitedCpuCredits() != null && !InstanceTypeUtils.isBurstingSupportedByAllTypes(description.getAllInstanceTypes())) {
            errors.rejectValue("unlimitedCpuCredits", "modifyservergrouplaunchtemplatedescription.bursting.not.supported.by.instanceType");
        }
        if (description.getSpotInstancePools() != null && description.getSpotInstancePools() > 0 && !description.getSpotAllocationStrategy().equals("lowest-price")) {
            errors.rejectValue("spotInstancePools", "modifyservergrouplaunchtemplatedescription.spotInstancePools.not.supported.for.spotAllocationStrategy");
        }
    }

    private boolean areNonMetadataFieldsSet(ModifyServerGroupLaunchTemplateDescription descToValidate) {
        return !ModifyServerGroupUtils.getNonMetadataFieldsSetInReq(descToValidate).isEmpty();
    }
}

