/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.aws.lifecycle;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.spinnaker.cats.agent.Agent;
import com.netflix.spinnaker.cats.agent.AgentProvider;
import com.netflix.spinnaker.clouddriver.aws.lifecycle.LaunchFailureConfigurationProperties;
import com.netflix.spinnaker.clouddriver.aws.lifecycle.LaunchFailureNotificationAgent;
import com.netflix.spinnaker.clouddriver.aws.provider.AwsProvider;
import com.netflix.spinnaker.clouddriver.aws.security.AmazonClientProvider;
import com.netflix.spinnaker.clouddriver.aws.security.NetflixAmazonCredentials;
import com.netflix.spinnaker.clouddriver.tags.EntityTagger;
import com.netflix.spinnaker.credentials.Credentials;
import com.netflix.spinnaker.credentials.CredentialsRepository;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class LaunchFailureNotificationAgentProvider
implements AgentProvider {
    private static final String REGION_TEMPLATE_PATTERN = Pattern.quote("{{region}}");
    private static final String ACCOUNT_ID_TEMPLATE_PATTERN = Pattern.quote("{{accountId}}");
    private final ObjectMapper objectMapper;
    private final AmazonClientProvider amazonClientProvider;
    private final CredentialsRepository<NetflixAmazonCredentials> credentialsRepository;
    private final LaunchFailureConfigurationProperties properties;
    private final EntityTagger entityTagger;

    LaunchFailureNotificationAgentProvider(ObjectMapper objectMapper, AmazonClientProvider amazonClientProvider, CredentialsRepository<NetflixAmazonCredentials> credentialsRepository, LaunchFailureConfigurationProperties properties, EntityTagger entityTagger) {
        this.objectMapper = objectMapper;
        this.amazonClientProvider = amazonClientProvider;
        this.credentialsRepository = credentialsRepository;
        this.properties = properties;
        this.entityTagger = entityTagger;
    }

    public boolean supports(String providerName) {
        return providerName.equalsIgnoreCase(AwsProvider.PROVIDER_NAME);
    }

    public Collection<Agent> agents(Credentials credentials) {
        NetflixAmazonCredentials netflixAmazonCredentials = (NetflixAmazonCredentials)credentials;
        if (!credentials.getName().equals(this.properties.getAccountName())) {
            return Collections.emptyList();
        }
        List<Agent> agents = netflixAmazonCredentials.getRegions().stream().map(region -> new LaunchFailureNotificationAgent(this.objectMapper, this.amazonClientProvider, netflixAmazonCredentials, this.credentialsRepository, new LaunchFailureConfigurationProperties(this.properties.getAccountName(), this.properties.getTopicARN().replaceAll(REGION_TEMPLATE_PATTERN, region.getName()).replaceAll(ACCOUNT_ID_TEMPLATE_PATTERN, netflixAmazonCredentials.getAccountId()), this.properties.getQueueARN().replaceAll(REGION_TEMPLATE_PATTERN, region.getName()).replaceAll(ACCOUNT_ID_TEMPLATE_PATTERN, netflixAmazonCredentials.getAccountId()), this.properties.getMaxMessagesPerCycle(), this.properties.getVisibilityTimeout(), this.properties.getWaitTimeSeconds()), this.entityTagger)).collect(Collectors.toList());
        return agents;
    }
}

