/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.aws.provider.agent;

import com.amazonaws.services.ec2.AmazonEC2;
import com.amazonaws.services.ec2.model.DescribeLaunchTemplateVersionsRequest;
import com.amazonaws.services.ec2.model.DescribeLaunchTemplateVersionsResult;
import com.amazonaws.services.ec2.model.DescribeLaunchTemplatesRequest;
import com.amazonaws.services.ec2.model.DescribeLaunchTemplatesResult;
import com.amazonaws.services.ec2.model.LaunchTemplate;
import com.amazonaws.services.ec2.model.LaunchTemplateVersion;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.spectator.api.Registry;
import com.netflix.spinnaker.cats.agent.AccountAware;
import com.netflix.spinnaker.cats.agent.AgentDataType;
import com.netflix.spinnaker.cats.agent.CacheResult;
import com.netflix.spinnaker.cats.agent.CachingAgent;
import com.netflix.spinnaker.cats.agent.DefaultCacheResult;
import com.netflix.spinnaker.cats.cache.DefaultCacheData;
import com.netflix.spinnaker.cats.provider.ProviderCache;
import com.netflix.spinnaker.clouddriver.aws.data.Keys;
import com.netflix.spinnaker.clouddriver.aws.provider.AwsProvider;
import com.netflix.spinnaker.clouddriver.aws.security.AmazonClientProvider;
import com.netflix.spinnaker.clouddriver.aws.security.NetflixAmazonCredentials;
import com.netflix.spinnaker.clouddriver.core.provider.agent.Namespace;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AmazonLaunchTemplateCachingAgent
implements CachingAgent,
AccountAware {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final AmazonClientProvider amazonClientProvider;
    private final NetflixAmazonCredentials account;
    private final ObjectMapper objectMapper;
    private final String region;
    private static final String[] DEFAULT_VERSIONS = new String[]{"$Default", "$Latest"};
    private static final TypeReference<Map<String, Object>> ATTRIBUTES = new TypeReference<Map<String, Object>>(){};
    private static final Set<AgentDataType> types = new HashSet<AgentDataType>(Collections.singletonList(AgentDataType.Authority.AUTHORITATIVE.forType(Namespace.LAUNCH_TEMPLATES.getNs())));

    public AmazonLaunchTemplateCachingAgent(AmazonClientProvider amazonClientProvider, NetflixAmazonCredentials account, String region, ObjectMapper objectMapper, Registry registry) {
        this.amazonClientProvider = amazonClientProvider;
        this.account = account;
        this.region = region;
        this.objectMapper = objectMapper;
    }

    public Collection<AgentDataType> getProvidedDataTypes() {
        return types;
    }

    public CacheResult loadData(ProviderCache providerCache) {
        AmazonEC2 ec2 = this.amazonClientProvider.getAmazonEC2(this.account, this.region);
        List<LaunchTemplate> launchTemplates = this.getLaunchTemplates(ec2);
        List<LaunchTemplateVersion> launchTemplateVersions = this.getLaunchTemplateVersions(ec2, DEFAULT_VERSIONS);
        ArrayList<DefaultCacheData> cachedData = new ArrayList<DefaultCacheData>();
        for (LaunchTemplate launchTemplate : launchTemplates) {
            Set versions = launchTemplateVersions.stream().filter(t -> t.getLaunchTemplateId().equals(launchTemplate.getLaunchTemplateId())).collect(Collectors.toSet());
            Optional<LaunchTemplateVersion> latest = versions.stream().filter(v -> v.getVersionNumber().equals(launchTemplate.getLatestVersionNumber())).findFirst();
            if (latest.isEmpty()) {
                this.log.debug("No latest version found for template {}", (Object)launchTemplate);
                continue;
            }
            String key = Keys.getLaunchTemplateKey(launchTemplate.getLaunchTemplateName(), this.account.getName(), this.region);
            Map attributes = (Map)this.objectMapper.convertValue((Object)launchTemplate, ATTRIBUTES);
            attributes.put("application", Keys.parse(key).get("application"));
            attributes.put("latestVersion", latest.get());
            attributes.put("versions", versions);
            Set images = versions.stream().map(i -> Keys.getImageKey(i.getLaunchTemplateData().getImageId(), this.account.getName(), this.region)).collect(Collectors.toSet());
            Map relationships = Collections.singletonMap(Namespace.IMAGES.ns, images);
            cachedData.add(new DefaultCacheData(key, attributes, relationships));
        }
        return new DefaultCacheResult(Collections.singletonMap(Namespace.LAUNCH_TEMPLATES.ns, cachedData));
    }

    private List<LaunchTemplate> getLaunchTemplates(AmazonEC2 ec2) {
        ArrayList<LaunchTemplate> launchTemplates = new ArrayList<LaunchTemplate>();
        DescribeLaunchTemplatesRequest request = new DescribeLaunchTemplatesRequest();
        while (true) {
            DescribeLaunchTemplatesResult result = ec2.describeLaunchTemplates(request);
            launchTemplates.addAll(result.getLaunchTemplates());
            if (result.getNextToken() == null) break;
            request.withNextToken(result.getNextToken());
        }
        return launchTemplates;
    }

    private List<LaunchTemplateVersion> getLaunchTemplateVersions(AmazonEC2 ec2, String ... versions) {
        ArrayList<LaunchTemplateVersion> launchTemplateVersions = new ArrayList<LaunchTemplateVersion>();
        DescribeLaunchTemplateVersionsRequest request = new DescribeLaunchTemplateVersionsRequest().withVersions(versions);
        while (true) {
            DescribeLaunchTemplateVersionsResult result = ec2.describeLaunchTemplateVersions(request);
            launchTemplateVersions.addAll(result.getLaunchTemplateVersions());
            if (result.getNextToken() == null) break;
            request.withNextToken(result.getNextToken());
        }
        return launchTemplateVersions;
    }

    public String getAgentType() {
        return String.format("%s/%s/%s", this.account.getName(), this.region, this.getClass().getSimpleName());
    }

    public String getProviderName() {
        return AwsProvider.PROVIDER_NAME;
    }

    public String getAccountName() {
        return this.account.getName();
    }
}

