/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.aws.provider.agent;

import com.netflix.spectator.api.Gauge;
import com.netflix.spectator.api.Registry;
import com.netflix.spinnaker.clouddriver.aws.security.NetflixAmazonCredentials;
import org.slf4j.Logger;

public interface DriftMetric {
    public Registry getRegistry();

    public NetflixAmazonCredentials getAccount();

    public String getRegion();

    public Logger getLog();

    public String getAgentType();

    default public Gauge getDriftMetricGauge() {
        return this.getRegistry().gauge("cache.drift", new String[]{"agent", this.getClass().getSimpleName(), "account", this.getAccount().getName(), "region", this.getRegion()});
    }

    default public void recordDrift(Long start) {
        if (start != null && start != 0L) {
            Long drift = this.getRegistry().clock().wallTime() - start;
            this.getLog().info("{}/drift - {} milliseconds", (Object)this.getAgentType(), (Object)drift);
            this.getDriftMetricGauge().set((double)drift.longValue());
        }
    }
}

