/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.aws.provider.view;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.spinnaker.cats.cache.Cache;
import com.netflix.spinnaker.cats.cache.CacheFilter;
import com.netflix.spinnaker.cats.cache.RelationshipCacheFilter;
import com.netflix.spinnaker.clouddriver.aws.cache.Keys;
import com.netflix.spinnaker.clouddriver.aws.model.AmazonCloudFormationStack;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class AmazonCloudFormationProvider {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AmazonCloudFormationProvider.class);
    private final Cache cacheView;
    private final ObjectMapper objectMapper;

    @Autowired
    public AmazonCloudFormationProvider(Cache cacheView, @Qualifier(value="amazonObjectMapper") ObjectMapper objectMapper) {
        this.cacheView = cacheView;
        this.objectMapper = objectMapper;
    }

    public List<AmazonCloudFormationStack> list(String accountName, String region) {
        String filter = Keys.getCloudFormationKey("*", region, accountName);
        log.debug("List all stacks with filter {}", (Object)filter);
        return this.loadResults(this.cacheView.filterIdentifiers(Keys.Namespace.STACKS.getNs(), filter));
    }

    public Optional<AmazonCloudFormationStack> get(String stackId) {
        String filter = Keys.getCloudFormationKey(stackId, "*", "*");
        log.debug("Get stack with filter {}", (Object)filter);
        return this.loadResults(this.cacheView.filterIdentifiers(Keys.Namespace.STACKS.getNs(), filter)).stream().findFirst();
    }

    List<AmazonCloudFormationStack> loadResults(Collection<String> identifiers) {
        return this.cacheView.getAll(Keys.Namespace.STACKS.getNs(), identifiers, (CacheFilter)RelationshipCacheFilter.none()).stream().map(data -> {
            log.debug("Cloud formation cached properties {}", (Object)data.getAttributes());
            return (AmazonCloudFormationStack)this.objectMapper.convertValue((Object)data.getAttributes(), AmazonCloudFormationStack.class);
        }).collect(Collectors.toList());
    }
}

