/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.aws.security;

import java.util.regex.Pattern;

public interface EddaTemplater {
    public static EddaTemplater defaultTemplater() {
        return new PatternReplacementTemplater();
    }

    public static EddaTemplater stringFormat() {
        return new StringFormatTemplater();
    }

    public static EddaTemplater pattern() {
        return new PatternReplacementTemplater();
    }

    public static EddaTemplater pattern(String pattern) {
        return new PatternReplacementTemplater(pattern);
    }

    public String getUrl(String var1, String var2);

    public static class PatternReplacementTemplater
    implements EddaTemplater {
        private final String replacementPattern;

        public PatternReplacementTemplater() {
            this("{{region}}");
        }

        public PatternReplacementTemplater(String replacementPattern) {
            this.replacementPattern = Pattern.quote(replacementPattern);
        }

        @Override
        public String getUrl(String template, String region) {
            return template.replaceAll(this.replacementPattern, region);
        }
    }

    public static class StringFormatTemplater
    implements EddaTemplater {
        @Override
        public String getUrl(String template, String region) {
            return String.format(template, region);
        }
    }
}

