/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.aws.security;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class EddaTimeoutConfig {
    public static final EddaTimeoutConfig DEFAULT = new Builder().build();
    private static final long EDDA_RETRY_BASE_MILLIS = 50L;
    private static final int EDDA_RETRY_BACKOFF_MILLIS = 10;
    private static final int EDDA_RETRY_MAX_ATTEMPTS = 3;
    private static final int EDDA_CONNECT_TIMEOUT_MILLIS = 1000;
    private static final int EDDA_CONNECT_REQUEST_TIMEOUT_MILLIS = 10000;
    private static final int EDDA_SOCKET_TIMEOUT_MILLIS = 5000;
    private final long retryBase;
    private final int backoffMillis;
    private final int maxAttempts;
    private final int connectTimeout;
    private final int connectionRequestTimeout;
    private final int socketTimeout;
    private final Set<String> disabledRegions;
    private boolean albEnabled;

    public EddaTimeoutConfig(long retryBase, int backoffMillis, int maxAttempts, int connectTimeout, int connectionRequestTimeout, int socketTimeout, Collection<String> disabledRegions, boolean albEnabled) {
        this.retryBase = retryBase;
        this.backoffMillis = backoffMillis;
        this.maxAttempts = maxAttempts;
        this.connectTimeout = connectTimeout;
        this.connectionRequestTimeout = connectionRequestTimeout;
        this.socketTimeout = socketTimeout;
        this.disabledRegions = disabledRegions == null || disabledRegions.isEmpty() ? Collections.emptySet() : Collections.unmodifiableSet(new LinkedHashSet<String>(disabledRegions));
        this.albEnabled = albEnabled;
    }

    public long getRetryBase() {
        return this.retryBase;
    }

    public int getBackoffMillis() {
        return this.backoffMillis;
    }

    public int getMaxAttempts() {
        return this.maxAttempts;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public int getConnectionRequestTimeout() {
        return this.connectionRequestTimeout;
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public Set<String> getDisabledRegions() {
        return this.disabledRegions;
    }

    public boolean getAlbEnabled() {
        return this.albEnabled;
    }

    public static class Builder {
        private long retryBase = 50L;
        private int backoffMillis = 10;
        private int maxAttempts = 3;
        private int connectTimeout = 1000;
        private int connectionRequestTimeout = 10000;
        private int socketTimeout = 5000;
        private List<String> disabledRegions = null;
        private boolean albEnabled = false;

        public EddaTimeoutConfig build() {
            return new EddaTimeoutConfig(this.retryBase, this.backoffMillis, this.maxAttempts, this.connectTimeout, this.connectionRequestTimeout, this.socketTimeout, this.disabledRegions, this.albEnabled);
        }

        public long getRetryBase() {
            return this.retryBase;
        }

        public void setRetryBase(long retryBase) {
            this.retryBase = retryBase;
        }

        public int getBackoffMillis() {
            return this.backoffMillis;
        }

        public void setBackoffMillis(int backoffMillis) {
            this.backoffMillis = backoffMillis;
        }

        public int getMaxAttempts() {
            return this.maxAttempts;
        }

        public void setMaxAttempts(int maxAttempts) {
            this.maxAttempts = maxAttempts;
        }

        public int getConnectTimeout() {
            return this.connectTimeout;
        }

        public void setConnectTimeout(int connectTimeout) {
            this.connectTimeout = connectTimeout;
        }

        public int getConnectionRequestTimeout() {
            return this.connectionRequestTimeout;
        }

        public void setConnectionRequestTimeout(int connectionRequestTimeout) {
            this.connectionRequestTimeout = connectionRequestTimeout;
        }

        public int getSocketTimeout() {
            return this.socketTimeout;
        }

        public void setSocketTimeout(int socketTimeout) {
            this.socketTimeout = socketTimeout;
        }

        public List<String> getDisabledRegions() {
            return this.disabledRegions;
        }

        public void setDisabledRegions(List<String> disabledRegions) {
            this.disabledRegions = disabledRegions;
        }

        public boolean getAlbEnabled() {
            return this.albEnabled;
        }

        public void setAlbEnabled(boolean albEnabled) {
            this.albEnabled = albEnabled;
        }
    }
}

