/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.aws.security;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSSessionCredentials;
import com.amazonaws.auth.AWSSessionCredentialsProvider;
import com.amazonaws.auth.STSAssumeRoleSessionCredentialsProvider;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.services.securitytoken.AWSSecurityTokenService;
import com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient;
import com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClientBuilder;
import com.netflix.spinnaker.clouddriver.aws.security.sdkclient.SpinnakerAwsRegionProvider;
import java.io.Closeable;

public class NetflixSTSAssumeRoleSessionCredentialsProvider
implements AWSSessionCredentialsProvider,
Closeable {
    private final String accountId;
    private final STSAssumeRoleSessionCredentialsProvider delegate;

    public NetflixSTSAssumeRoleSessionCredentialsProvider(AWSCredentialsProvider longLivedCredentialsProvider, String roleArn, String roleSessionName, String accountId, String externalId) {
        this.accountId = accountId;
        SpinnakerAwsRegionProvider chain = new SpinnakerAwsRegionProvider();
        String region = chain.getRegion();
        AWSSecurityTokenServiceClientBuilder stsClientBuilder = (AWSSecurityTokenServiceClientBuilder)AWSSecurityTokenServiceClient.builder().withCredentials(longLivedCredentialsProvider);
        if (roleArn.contains("aws-us-gov")) {
            stsClientBuilder.withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration("sts.us-gov-west-1.amazonaws.com", region));
        } else if (roleArn.contains("aws-cn")) {
            stsClientBuilder.withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration("sts.cn-north-1.amazonaws.com.cn", region));
        } else {
            stsClientBuilder.withRegion(region);
        }
        this.delegate = new STSAssumeRoleSessionCredentialsProvider.Builder(roleArn, roleSessionName).withExternalId(externalId).withStsClient((AWSSecurityTokenService)stsClientBuilder.build()).build();
    }

    public String getAccountId() {
        return this.accountId;
    }

    public AWSSessionCredentials getCredentials() {
        return this.delegate.getCredentials();
    }

    public void refresh() {
        this.delegate.refresh();
    }

    @Override
    public void close() {
        this.delegate.close();
    }
}

