/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.aws.security.sdkclient;

import com.amazonaws.Request;
import com.amazonaws.handlers.RequestHandler2;
import com.google.common.util.concurrent.RateLimiter;
import com.netflix.spectator.api.Counter;
import java.util.Objects;

public class RateLimitingRequestHandler
extends RequestHandler2 {
    private final Counter counter;
    private final RateLimiter rateLimiter;

    public RateLimitingRequestHandler(Counter counter, RateLimiter rateLimiter) {
        this.counter = Objects.requireNonNull(counter);
        this.rateLimiter = Objects.requireNonNull(rateLimiter);
    }

    public void beforeRequest(Request<?> request) {
        double rateLimitedSeconds = this.rateLimiter.acquire();
        long rateLimitedMillis = Double.valueOf(rateLimitedSeconds * 1000.0).longValue();
        this.counter.increment(rateLimitedMillis);
        super.beforeRequest(request);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        RateLimitingRequestHandler that = (RateLimitingRequestHandler)((Object)o);
        return Objects.equals(this.rateLimiter, that.rateLimiter);
    }

    public int hashCode() {
        return Objects.hash(this.rateLimiter);
    }
}

