/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.aws.security.sdkclient;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.autoscaling.model.AutoScalingGroup;
import com.amazonaws.services.autoscaling.model.DescribeAutoScalingGroupsRequest;
import com.amazonaws.services.autoscaling.model.DescribeAutoScalingGroupsResult;
import com.amazonaws.services.autoscaling.model.DescribeLaunchConfigurationsRequest;
import com.amazonaws.services.autoscaling.model.DescribeLaunchConfigurationsResult;
import com.amazonaws.services.autoscaling.model.DescribePoliciesRequest;
import com.amazonaws.services.autoscaling.model.DescribePoliciesResult;
import com.amazonaws.services.autoscaling.model.DescribeScheduledActionsRequest;
import com.amazonaws.services.autoscaling.model.DescribeScheduledActionsResult;
import com.amazonaws.services.autoscaling.model.LaunchConfiguration;
import com.amazonaws.services.autoscaling.model.ScalingPolicy;
import com.amazonaws.services.autoscaling.model.ScheduledUpdateGroupAction;
import com.amazonaws.services.cloudwatch.model.DescribeAlarmsRequest;
import com.amazonaws.services.cloudwatch.model.DescribeAlarmsResult;
import com.amazonaws.services.cloudwatch.model.MetricAlarm;
import com.amazonaws.services.ec2.model.ClassicLinkInstance;
import com.amazonaws.services.ec2.model.DescribeClassicLinkInstancesRequest;
import com.amazonaws.services.ec2.model.DescribeClassicLinkInstancesResult;
import com.amazonaws.services.ec2.model.DescribeImagesRequest;
import com.amazonaws.services.ec2.model.DescribeImagesResult;
import com.amazonaws.services.ec2.model.DescribeInstancesRequest;
import com.amazonaws.services.ec2.model.DescribeInstancesResult;
import com.amazonaws.services.ec2.model.DescribeLaunchTemplateVersionsRequest;
import com.amazonaws.services.ec2.model.DescribeLaunchTemplateVersionsResult;
import com.amazonaws.services.ec2.model.DescribeLaunchTemplatesRequest;
import com.amazonaws.services.ec2.model.DescribeLaunchTemplatesResult;
import com.amazonaws.services.ec2.model.DescribeReservedInstancesOfferingsRequest;
import com.amazonaws.services.ec2.model.DescribeReservedInstancesOfferingsResult;
import com.amazonaws.services.ec2.model.DescribeSecurityGroupsRequest;
import com.amazonaws.services.ec2.model.DescribeSecurityGroupsResult;
import com.amazonaws.services.ec2.model.DescribeSubnetsRequest;
import com.amazonaws.services.ec2.model.DescribeSubnetsResult;
import com.amazonaws.services.ec2.model.DescribeVpcClassicLinkRequest;
import com.amazonaws.services.ec2.model.DescribeVpcClassicLinkResult;
import com.amazonaws.services.ec2.model.DescribeVpcsRequest;
import com.amazonaws.services.ec2.model.DescribeVpcsResult;
import com.amazonaws.services.ec2.model.Image;
import com.amazonaws.services.ec2.model.Instance;
import com.amazonaws.services.ec2.model.LaunchTemplate;
import com.amazonaws.services.ec2.model.LaunchTemplateVersion;
import com.amazonaws.services.ec2.model.Reservation;
import com.amazonaws.services.ec2.model.ReservedInstancesOffering;
import com.amazonaws.services.ec2.model.SecurityGroup;
import com.amazonaws.services.ec2.model.Subnet;
import com.amazonaws.services.ec2.model.Vpc;
import com.amazonaws.services.ec2.model.VpcClassicLink;
import com.amazonaws.services.elasticloadbalancing.model.DescribeLoadBalancersRequest;
import com.amazonaws.services.elasticloadbalancing.model.DescribeLoadBalancersResult;
import com.amazonaws.services.elasticloadbalancing.model.LoadBalancerDescription;
import com.amazonaws.services.elasticloadbalancingv2.AmazonElasticLoadBalancing;
import com.amazonaws.services.elasticloadbalancingv2.model.DescribeTargetGroupsRequest;
import com.amazonaws.services.elasticloadbalancingv2.model.DescribeTargetGroupsResult;
import com.amazonaws.services.elasticloadbalancingv2.model.LoadBalancer;
import com.amazonaws.services.elasticloadbalancingv2.model.TargetGroup;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Registry;
import com.netflix.spinnaker.clouddriver.aws.security.EddaTimeoutConfig;
import com.netflix.spinnaker.clouddriver.aws.security.sdkclient.EddaException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.web.client.HttpClientErrorException;

public class AmazonClientInvocationHandler
implements InvocationHandler {
    private static final Logger log = LoggerFactory.getLogger(AmazonClientInvocationHandler.class);
    public static final ThreadLocal<Long> lastModified = new ThreadLocal();
    private final String edda;
    private final HttpClient httpClient;
    private final Object delegate;
    private final String serviceName;
    private final ObjectMapper objectMapper;
    private final EddaTimeoutConfig eddaTimeoutConfig;
    private final Registry registry;
    private final Map<String, String> metricTags;
    private static final Function<AmazonWebServiceRequest, Collection<String>> LAUNCH_TEMPLATE_VERSION_EXTRACTOR = r -> {
        if (r == null) {
            return Collections.emptyList();
        }
        DescribeLaunchTemplateVersionsRequest req = (DescribeLaunchTemplateVersionsRequest)r;
        if (req.getLaunchTemplateId() == null) {
            return Collections.emptyList();
        }
        if (req.getVersions() == null || req.getVersions().isEmpty()) {
            String defaultId = req.getLaunchTemplateId() + ":$Default";
            return Collections.singletonList(defaultId);
        }
        return req.getVersions().stream().map(v -> req.getLaunchTemplateId() + ":" + v).collect(Collectors.toCollection(ArrayList::new));
    };

    public AmazonClientInvocationHandler(Object delegate, String serviceName, String edda, HttpClient httpClient, ObjectMapper objectMapper, EddaTimeoutConfig eddaTimeoutConfig, Registry registry, Map<String, String> metricTags) {
        this.edda = edda;
        this.httpClient = httpClient;
        this.objectMapper = objectMapper;
        this.delegate = delegate;
        this.serviceName = serviceName;
        this.eddaTimeoutConfig = eddaTimeoutConfig == null ? EddaTimeoutConfig.DEFAULT : eddaTimeoutConfig;
        this.registry = registry;
        this.metricTags = ImmutableMap.copyOf(metricTags);
    }

    /*
     * Loose catch block
     */
    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object object;
        Id id = this.registry.createId("awsClientProxy.invoke", this.metricTags).withTag("method", method.getName());
        long startTime = System.nanoTime();
        boolean wasDelegated = false;
        try {
            if (!this.eddaTimeoutConfig.getAlbEnabled() && method.getDeclaringClass().equals(AmazonElasticLoadBalancing.class)) {
                throw new NoSuchMethodException();
            }
            Method thisMethod = this.getClass().getMethod(method.getName(), args != null && args.length > 0 ? AmazonClientInvocationHandler.getClassArgs(args) : new Class[]{});
            object = thisMethod.invoke((Object)this, args);
            this.registry.timer(id.withTag("requestMode", wasDelegated ? "sdkClient" : "edda")).record(System.nanoTime() - startTime, TimeUnit.NANOSECONDS);
        }
        catch (NoSuchMethodException e) {
            wasDelegated = true;
            Object object2 = method.invoke(this.delegate, args);
            this.registry.timer(id.withTag("requestMode", wasDelegated ? "sdkClient" : "edda")).record(System.nanoTime() - startTime, TimeUnit.NANOSECONDS);
            return object2;
            {
                catch (InvocationTargetException ite) {
                    try {
                        throw ite.getCause();
                    }
                    catch (Throwable throwable) {
                        this.registry.timer(id.withTag("requestMode", wasDelegated ? "sdkClient" : "edda")).record(System.nanoTime() - startTime, TimeUnit.NANOSECONDS);
                        throw throwable;
                    }
                }
            }
        }
        return object;
    }

    static Class[] getClassArgs(Object[] args) {
        ArrayList classes = new ArrayList();
        for (Object object : args) {
            classes.add(object.getClass());
        }
        return classes.toArray(new Class[classes.size()]);
    }

    public DescribeAutoScalingGroupsResult describeAutoScalingGroups() {
        return this.describeAutoScalingGroups(null);
    }

    public DescribeAutoScalingGroupsResult describeAutoScalingGroups(DescribeAutoScalingGroupsRequest request) {
        return new DescribeAutoScalingGroupsResult().withAutoScalingGroups(this.describe((AmazonWebServiceRequest)request, "autoScalingGroupNames", "autoScalingGroups", AutoScalingGroup.class));
    }

    public DescribeAlarmsResult describeAlarms() {
        return this.describeAlarms(null);
    }

    public DescribeAlarmsResult describeAlarms(DescribeAlarmsRequest request) {
        return new DescribeAlarmsResult().withMetricAlarms(this.describe((AmazonWebServiceRequest)request, "alarmNames", "alarms", MetricAlarm.class));
    }

    public DescribeScheduledActionsResult describeScheduledActions() {
        return this.describeScheduledActions(null);
    }

    public DescribeScheduledActionsResult describeScheduledActions(DescribeScheduledActionsRequest request) {
        return new DescribeScheduledActionsResult().withScheduledUpdateGroupActions(this.describe((AmazonWebServiceRequest)request, "scheduledActionNames", "scheduledActions", ScheduledUpdateGroupAction.class));
    }

    public DescribePoliciesResult describePolicies() {
        return this.describePolicies(null);
    }

    public DescribePoliciesResult describePolicies(DescribePoliciesRequest request) {
        return new DescribePoliciesResult().withScalingPolicies(this.describe((AmazonWebServiceRequest)request, "policyNames", "scalingPolicies", ScalingPolicy.class));
    }

    public DescribeLaunchTemplatesResult describeLaunchTemplates() {
        return this.describeLaunchTemplates(null);
    }

    public DescribeLaunchTemplatesResult describeLaunchTemplates(DescribeLaunchTemplatesRequest request) {
        return new DescribeLaunchTemplatesResult().withLaunchTemplates(this.describe((AmazonWebServiceRequest)request, "launchTemplateNames", "launchTemplates", LaunchTemplate.class));
    }

    public DescribeLaunchTemplateVersionsResult describeLaunchTemplateVersions() {
        return this.describeLaunchTemplateVersions(null);
    }

    public DescribeLaunchTemplateVersionsResult describeLaunchTemplateVersions(DescribeLaunchTemplateVersionsRequest request) {
        return new DescribeLaunchTemplateVersionsResult().withLaunchTemplateVersions(this.describe((AmazonWebServiceRequest)request, LAUNCH_TEMPLATE_VERSION_EXTRACTOR, "launchTemplateVersions", LaunchTemplateVersion.class));
    }

    public DescribeImagesResult describeImages() {
        return this.describeImages(null);
    }

    public DescribeImagesResult describeImages(DescribeImagesRequest request) {
        return new DescribeImagesResult().withImages(this.describe((AmazonWebServiceRequest)request, "imageIds", "images", Image.class));
    }

    public DescribeInstancesResult describeInstances() {
        return this.describeInstances(null);
    }

    public DescribeInstancesResult describeInstances(DescribeInstancesRequest request) {
        return new DescribeInstancesResult().withReservations(new Reservation[]{new Reservation().withReservationId("1234").withInstances(this.describe((AmazonWebServiceRequest)request, "instanceIds", "../view/instances", Instance.class))});
    }

    public DescribeLaunchConfigurationsResult describeLaunchConfigurations() {
        return this.describeLaunchConfigurations(null);
    }

    public DescribeLaunchConfigurationsResult describeLaunchConfigurations(DescribeLaunchConfigurationsRequest request) {
        return new DescribeLaunchConfigurationsResult().withLaunchConfigurations(this.describe((AmazonWebServiceRequest)request, "launchConfigurationNames", "launchConfigurations", LaunchConfiguration.class));
    }

    public DescribeReservedInstancesOfferingsResult describeReservedInstancesOfferings() {
        return this.describeReservedInstancesOfferings(null);
    }

    public DescribeReservedInstancesOfferingsResult describeReservedInstancesOfferings(DescribeReservedInstancesOfferingsRequest request) {
        return new DescribeReservedInstancesOfferingsResult().withReservedInstancesOfferings(this.describe((AmazonWebServiceRequest)request, "reservedInstancesOfferingIds", "reservedInstancesOfferings", ReservedInstancesOffering.class));
    }

    public DescribeSecurityGroupsResult describeSecurityGroups() {
        return this.describeSecurityGroups(null);
    }

    public DescribeSecurityGroupsResult describeSecurityGroups(DescribeSecurityGroupsRequest request) {
        return new DescribeSecurityGroupsResult().withSecurityGroups(this.describe((AmazonWebServiceRequest)request, "groupIds", "securityGroups", SecurityGroup.class));
    }

    public DescribeSubnetsResult describeSubnets() {
        return this.describeSubnets(null);
    }

    public DescribeSubnetsResult describeSubnets(DescribeSubnetsRequest request) {
        return new DescribeSubnetsResult().withSubnets(this.describe((AmazonWebServiceRequest)request, "subnetIds", "subnets", Subnet.class));
    }

    public DescribeVpcsResult describeVpcs() {
        return this.describeVpcs(null);
    }

    public DescribeVpcsResult describeVpcs(DescribeVpcsRequest request) {
        return new DescribeVpcsResult().withVpcs(this.describe((AmazonWebServiceRequest)request, "vpcIds", "vpcs", Vpc.class));
    }

    public DescribeVpcClassicLinkResult describeVpcClassicLink() {
        return this.describeVpcClassicLink(null);
    }

    public DescribeVpcClassicLinkResult describeVpcClassicLink(DescribeVpcClassicLinkRequest request) {
        return new DescribeVpcClassicLinkResult().withVpcs(this.describe((AmazonWebServiceRequest)request, "vpcIds", "vpcClassicLinks", VpcClassicLink.class));
    }

    public DescribeClassicLinkInstancesResult describeClassicLinkInstances() {
        return this.describeClassicLinkInstances(null);
    }

    public DescribeClassicLinkInstancesResult describeClassicLinkInstances(DescribeClassicLinkInstancesRequest request) {
        return new DescribeClassicLinkInstancesResult().withInstances(this.describe((AmazonWebServiceRequest)request, "instanceIds", "classicLinkInstances", ClassicLinkInstance.class));
    }

    public DescribeLoadBalancersResult describeLoadBalancers() {
        return this.describeLoadBalancers((DescribeLoadBalancersRequest)null);
    }

    public DescribeLoadBalancersResult describeLoadBalancers(DescribeLoadBalancersRequest request) {
        return new DescribeLoadBalancersResult().withLoadBalancerDescriptions(this.describe((AmazonWebServiceRequest)request, "loadBalancerNames", "loadBalancers", LoadBalancerDescription.class));
    }

    public com.amazonaws.services.elasticloadbalancingv2.model.DescribeLoadBalancersResult describeLoadBalancers(com.amazonaws.services.elasticloadbalancingv2.model.DescribeLoadBalancersRequest request) {
        return new com.amazonaws.services.elasticloadbalancingv2.model.DescribeLoadBalancersResult().withLoadBalancers(this.describe((AmazonWebServiceRequest)request, "names", "appLoadBalancers", LoadBalancer.class));
    }

    public DescribeTargetGroupsResult describeTargetGroups() {
        return this.describeTargetGroups(null);
    }

    public DescribeTargetGroupsResult describeTargetGroups(DescribeTargetGroupsRequest request) {
        return new DescribeTargetGroupsResult().withTargetGroups(this.describe((AmazonWebServiceRequest)request, "names", "targetGroups", TargetGroup.class));
    }

    private <T> List<T> describe(AmazonWebServiceRequest request, String idKey, String object, Class<T> singleType) {
        return this.describe(request, (AmazonWebServiceRequest r) -> AmazonClientInvocationHandler.getRequestIds(r, idKey), object, singleType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> List<T> describe(AmazonWebServiceRequest request, Function<AmazonWebServiceRequest, Collection<String>> idExtractor, String object, Class<T> singleType) {
        lastModified.set(null);
        HashMap<String, String> metricTags = new HashMap<String, String>(this.metricTags);
        metricTags.put("collection", object);
        try {
            Collection<String> ids = idExtractor.apply(request);
            metricTags.put("collectionMode", ids.isEmpty() ? "full" : "byId");
            JavaType singleMeta = this.objectMapper.getTypeFactory().constructParametrizedType(Metadata.class, Metadata.class, new Class[]{singleType});
            Long mtime = null;
            ArrayList results = new ArrayList();
            Id deserializeJsonTimer = this.registry.createId("edda.deserializeJson", metricTags);
            Id resultSizeCounter = this.registry.createId("edda.resultSize", metricTags);
            if (ids.isEmpty()) {
                HttpEntity entity = this.getHttpEntity(metricTags, object, null);
                try {
                    JavaType listMeta = this.objectMapper.getTypeFactory().constructParametrizedType(List.class, List.class, new JavaType[]{singleMeta});
                    List metadataResults = (List)this.registry.timer(deserializeJsonTimer).record(() -> (List)this.objectMapper.readValue(entity.getContent(), listMeta));
                    for (Metadata meta : metadataResults) {
                        mtime = mtime == null ? meta.mtime : Math.min(mtime, meta.mtime);
                        results.add(meta.data);
                    }
                }
                finally {
                    EntityUtils.consume((HttpEntity)entity);
                }
            } else {
                for (String id : ids) {
                    HttpEntity entity = this.getHttpEntity(metricTags, object, id);
                    try {
                        Metadata result = (Metadata)this.registry.timer(deserializeJsonTimer).record(() -> (Metadata)this.objectMapper.readValue(entity.getContent(), singleMeta));
                        mtime = mtime == null ? result.mtime : Math.min(mtime, result.mtime);
                        results.add(result.data);
                    }
                    finally {
                        EntityUtils.consume((HttpEntity)entity);
                    }
                }
            }
            this.registry.counter(resultSizeCounter).increment((long)results.size());
            lastModified.set(mtime);
            return results;
        }
        catch (Exception e) {
            log.error(e.getMessage() + " (retries exhausted)");
            this.registry.counter(this.registry.createId("edda.failures", metricTags)).increment();
            AmazonServiceException ex = new AmazonServiceException("Edda failed locating the managed objects requested.", e);
            if (e.getCause() instanceof HttpClientErrorException) {
                ex.setStatusCode(((HttpClientErrorException)e.getCause()).getRawStatusCode());
            } else {
                ex.setStatusCode(400);
            }
            ex.setServiceName(this.serviceName);
            ex.setErrorType(AmazonServiceException.ErrorType.Unknown);
            throw ex;
        }
    }

    private static Collection<String> getRequestIds(AmazonWebServiceRequest request, String idFieldName) {
        if (request == null) {
            return Collections.emptySet();
        }
        try {
            Field field = request.getClass().getDeclaredField(idFieldName);
            field.setAccessible(true);
            Collection collection = (Collection)field.get(request);
            return collection == null ? Collections.emptySet() : collection;
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpEntity getHttpEntity(Map<String, String> metricTags, String objectName, String key) throws EddaException {
        String url = this.edda + "/REST/v2/aws/" + objectName + (String)(key == null ? ";_expand" : "/" + key) + ";_meta";
        HttpGet get = new HttpGet(url);
        get.setConfig(RequestConfig.custom().setConnectTimeout(this.eddaTimeoutConfig.getConnectTimeout()).setConnectionRequestTimeout(this.eddaTimeoutConfig.getConnectionRequestTimeout()).setSocketTimeout(this.eddaTimeoutConfig.getSocketTimeout()).build());
        long retryDelay = this.eddaTimeoutConfig.getRetryBase();
        int retryAttempts = 0;
        Object lastExceptionMessage = "";
        Object lastUrl = "";
        Random r = new Random();
        Exception ex = null;
        Id httpExecuteTime = this.registry.createId("edda.httpExecute", metricTags);
        Id httpErrors = this.registry.createId("edda.errors", metricTags).withTag("errorType", "http");
        Id networkErrors = this.registry.createId("edda.errors", metricTags).withTag("errorType", "network");
        Id retryDelayMillis = this.registry.createId("edda.retryDelayMillis", metricTags);
        Id retries = this.registry.createId("edda.retries", metricTags);
        while (retryAttempts < this.eddaTimeoutConfig.getMaxAttempts()) {
            HttpEntity entity = null;
            try {
                HttpResponse response = (HttpResponse)this.registry.timer(httpExecuteTime).record(() -> this.httpClient.execute((HttpUriRequest)get));
                int statusCode = response.getStatusLine().getStatusCode();
                entity = response.getEntity();
                if (statusCode != 200) {
                    lastExceptionMessage = response.getProtocolVersion().toString() + " " + response.getStatusLine().getStatusCode() + " " + response.getStatusLine().getReasonPhrase();
                    this.registry.counter(httpErrors.withTag("statusCode", Integer.toString(statusCode))).increment();
                    throw new HttpClientErrorException(HttpStatus.valueOf((int)statusCode), (String)lastExceptionMessage);
                }
                HttpEntity httpEntity = entity;
                return httpEntity;
            }
            catch (Exception e) {
                lastExceptionMessage = e.getClass().getSimpleName() + ": " + e.getMessage();
                ex = e;
                this.registry.counter(networkErrors.withTag("exceptionType", e.getClass().getSimpleName())).increment();
            }
            finally {
                lastUrl = url;
            }
            EntityUtils.consumeQuietly((HttpEntity)entity);
            String exceptionFormat = "Edda request {} failed with {}";
            log.warn("Edda request {} failed with {}", new Object[]{url, lastExceptionMessage, ex});
            try {
                this.registry.counter(retryDelayMillis).increment(retryDelay);
                Thread.sleep(retryDelay);
            }
            catch (InterruptedException inter) {
                break;
            }
            this.registry.counter(retries).increment();
            ++retryAttempts;
            retryDelay += (long)r.nextInt(this.eddaTimeoutConfig.getBackoffMillis());
        }
        throw new EddaException("Edda request " + (String)lastUrl + " failed with " + (String)lastExceptionMessage, ex);
    }

    private static class Metadata<T> {
        final Long mtime;
        final T data;

        @JsonCreator
        public Metadata(@JsonProperty(value="mtime") Long mtime, @JsonProperty(value="data") T data) {
            this.mtime = mtime;
            this.data = data;
        }
    }
}

