/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.aws.services;

import com.amazonaws.services.autoscaling.model.LaunchTemplateSpecification;
import com.amazonaws.services.ec2.AmazonEC2;
import com.amazonaws.services.ec2.model.CreateLaunchTemplateRequest;
import com.amazonaws.services.ec2.model.CreateLaunchTemplateVersionRequest;
import com.amazonaws.services.ec2.model.CreateLaunchTemplateVersionResult;
import com.amazonaws.services.ec2.model.CreditSpecificationRequest;
import com.amazonaws.services.ec2.model.DeleteLaunchTemplateVersionsRequest;
import com.amazonaws.services.ec2.model.DeleteLaunchTemplateVersionsResponseErrorItem;
import com.amazonaws.services.ec2.model.DeleteLaunchTemplateVersionsResult;
import com.amazonaws.services.ec2.model.DescribeLaunchTemplateVersionsRequest;
import com.amazonaws.services.ec2.model.DescribeLaunchTemplateVersionsResult;
import com.amazonaws.services.ec2.model.LaunchTemplate;
import com.amazonaws.services.ec2.model.LaunchTemplateBlockDeviceMappingRequest;
import com.amazonaws.services.ec2.model.LaunchTemplateEbsBlockDeviceRequest;
import com.amazonaws.services.ec2.model.LaunchTemplateEnclaveOptionsRequest;
import com.amazonaws.services.ec2.model.LaunchTemplateIamInstanceProfileSpecificationRequest;
import com.amazonaws.services.ec2.model.LaunchTemplateInstanceMarketOptionsRequest;
import com.amazonaws.services.ec2.model.LaunchTemplateInstanceMetadataOptionsRequest;
import com.amazonaws.services.ec2.model.LaunchTemplateInstanceNetworkInterfaceSpecification;
import com.amazonaws.services.ec2.model.LaunchTemplateInstanceNetworkInterfaceSpecificationRequest;
import com.amazonaws.services.ec2.model.LaunchTemplateLicenseConfigurationRequest;
import com.amazonaws.services.ec2.model.LaunchTemplatePlacementRequest;
import com.amazonaws.services.ec2.model.LaunchTemplateSpotMarketOptionsRequest;
import com.amazonaws.services.ec2.model.LaunchTemplateTagSpecificationRequest;
import com.amazonaws.services.ec2.model.LaunchTemplateVersion;
import com.amazonaws.services.ec2.model.LaunchTemplatesMonitoringRequest;
import com.amazonaws.services.ec2.model.MarketType;
import com.amazonaws.services.ec2.model.RequestLaunchTemplateData;
import com.amazonaws.services.ec2.model.ResponseError;
import com.amazonaws.services.ec2.model.ResponseLaunchTemplateData;
import com.amazonaws.services.ec2.model.Tag;
import com.netflix.spinnaker.clouddriver.aws.deploy.AmazonResourceTagger;
import com.netflix.spinnaker.clouddriver.aws.deploy.InstanceTypeUtils;
import com.netflix.spinnaker.clouddriver.aws.deploy.asg.AsgConfigHelper;
import com.netflix.spinnaker.clouddriver.aws.deploy.asg.AutoScalingWorker;
import com.netflix.spinnaker.clouddriver.aws.deploy.description.ModifyServerGroupLaunchTemplateDescription;
import com.netflix.spinnaker.clouddriver.aws.deploy.userdata.LocalFileUserDataProperties;
import com.netflix.spinnaker.clouddriver.aws.deploy.userdata.UserDataProviderAggregator;
import com.netflix.spinnaker.clouddriver.aws.model.AmazonBlockDevice;
import com.netflix.spinnaker.clouddriver.aws.security.NetflixAmazonCredentials;
import com.netflix.spinnaker.clouddriver.aws.userdata.UserDataInput;
import com.netflix.spinnaker.clouddriver.aws.userdata.UserDataOverride;
import com.netflix.spinnaker.kork.core.RetrySupport;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LaunchTemplateService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LaunchTemplateService.class);
    private final AmazonEC2 ec2;
    private final UserDataProviderAggregator userDataProviderAggregator;
    private final LocalFileUserDataProperties localFileUserDataProperties;
    private final Collection<AmazonResourceTagger> amazonResourceTaggers;
    private final RetrySupport retrySupport = new RetrySupport();
    private static final String UNLIMITED_CPU_CREDITS = "unlimited";
    private static final String STANDARD_CPU_CREDITS = "standard";

    public LaunchTemplateService(AmazonEC2 ec2, UserDataProviderAggregator userDataProviderAggregator, LocalFileUserDataProperties localFileUserDataProperties, Collection<AmazonResourceTagger> amazonResourceTaggers) {
        this.ec2 = ec2;
        this.userDataProviderAggregator = userDataProviderAggregator;
        this.localFileUserDataProperties = localFileUserDataProperties;
        this.amazonResourceTaggers = amazonResourceTaggers;
    }

    public Optional<LaunchTemplateVersion> getLaunchTemplateVersion(LaunchTemplateSpecification launchTemplateSpecification) {
        ArrayList versions = new ArrayList();
        String version = launchTemplateSpecification.getVersion();
        DescribeLaunchTemplateVersionsRequest request = new DescribeLaunchTemplateVersionsRequest().withLaunchTemplateId(launchTemplateSpecification.getLaunchTemplateId());
        while (true) {
            DescribeLaunchTemplateVersionsResult result = this.ec2.describeLaunchTemplateVersions(request);
            versions.addAll(result.getLaunchTemplateVersions());
            if (result.getNextToken() == null) break;
            request.withNextToken(result.getNextToken());
        }
        if ("$Latest".equals(version)) {
            return versions.stream().max(Comparator.comparing(LaunchTemplateVersion::getVersionNumber));
        }
        if ("$Default".equals(version)) {
            return versions.stream().filter(LaunchTemplateVersion::isDefaultVersion).findFirst();
        }
        return versions.stream().filter(i -> i.getVersionNumber().equals(Long.parseLong(version))).findFirst();
    }

    public LaunchTemplate createLaunchTemplate(AutoScalingWorker.AsgConfiguration asgConfig, String asgName, String launchTemplateName) {
        RequestLaunchTemplateData data = this.buildLaunchTemplateData(asgConfig, asgName, launchTemplateName);
        log.info("Creating launch template with name {}", (Object)launchTemplateName);
        return (LaunchTemplate)this.retrySupport.retry(() -> {
            CreateLaunchTemplateRequest launchTemplateRequest = new CreateLaunchTemplateRequest().withLaunchTemplateName(launchTemplateName).withLaunchTemplateData(data);
            return this.ec2.createLaunchTemplate(launchTemplateRequest).getLaunchTemplate();
        }, 3, Duration.ofMillis(3000L), false);
    }

    public LaunchTemplateVersion modifyLaunchTemplate(NetflixAmazonCredentials credentials, ModifyServerGroupLaunchTemplateDescription description, LaunchTemplateVersion sourceLtVersion, boolean shouldUseMixedInstancesPolicy) {
        RequestLaunchTemplateData data = this.buildLaunchTemplateDataForModify(credentials, description, sourceLtVersion, shouldUseMixedInstancesPolicy);
        CreateLaunchTemplateVersionResult result = this.ec2.createLaunchTemplateVersion(new CreateLaunchTemplateVersionRequest().withLaunchTemplateId(sourceLtVersion.getLaunchTemplateId()).withLaunchTemplateData(data));
        log.info(String.format("Created new launch template version %s for launch template ID %s", result.getLaunchTemplateVersion().getVersionNumber(), result.getLaunchTemplateVersion().getLaunchTemplateId()));
        return result.getLaunchTemplateVersion();
    }

    public void deleteLaunchTemplateVersion(String launchTemplateId, Long versionToDelete) {
        log.info(String.format("Attempting to delete launch template version %s for launch template ID %s.", versionToDelete, launchTemplateId));
        DeleteLaunchTemplateVersionsResult result = this.ec2.deleteLaunchTemplateVersions(new DeleteLaunchTemplateVersionsRequest().withLaunchTemplateId(launchTemplateId).withVersions(new String[]{String.valueOf(versionToDelete)}));
        if (result.getUnsuccessfullyDeletedLaunchTemplateVersions() != null && !result.getUnsuccessfullyDeletedLaunchTemplateVersions().isEmpty()) {
            DeleteLaunchTemplateVersionsResponseErrorItem responseErrorItem = (DeleteLaunchTemplateVersionsResponseErrorItem)result.getUnsuccessfullyDeletedLaunchTemplateVersions().get(0);
            ResponseError failureResponseError = responseErrorItem.getResponseError();
            List<String> codesConsideredSuccess = List.of("launchTemplateIdDoesNotExist", "launchTemplateVersionDoesNotExist");
            if (failureResponseError != null && !codesConsideredSuccess.contains(failureResponseError.getCode())) {
                throw new RuntimeException(String.format("Failed to delete launch template version %s for launch template ID %s because of error '%s'", responseErrorItem.getVersionNumber(), responseErrorItem.getLaunchTemplateId(), failureResponseError.getCode()));
            }
        }
    }

    private RequestLaunchTemplateData buildLaunchTemplateDataForModify(NetflixAmazonCredentials credentials, ModifyServerGroupLaunchTemplateDescription modifyDesc, LaunchTemplateVersion sourceLtVersion, boolean shouldUseMixedInstancesPolicy) {
        ResponseLaunchTemplateData sourceLtData = sourceLtVersion.getLaunchTemplateData();
        RequestLaunchTemplateData request = new RequestLaunchTemplateData().withImageId(modifyDesc.getImageId() != null ? modifyDesc.getImageId() : sourceLtData.getImageId()).withKernelId(StringUtils.isNotBlank((CharSequence)modifyDesc.getKernelId()) ? modifyDesc.getKernelId() : sourceLtData.getKernelId()).withInstanceType(StringUtils.isNotBlank((CharSequence)modifyDesc.getInstanceType()) ? modifyDesc.getInstanceType() : sourceLtData.getInstanceType()).withRamDiskId(StringUtils.isNotBlank((CharSequence)modifyDesc.getRamdiskId()) ? modifyDesc.getRamdiskId() : sourceLtData.getRamDiskId()).withEbsOptimized(Optional.ofNullable(modifyDesc.getEbsOptimized()).orElseGet(() -> ((ResponseLaunchTemplateData)sourceLtData).getEbsOptimized()));
        if (StringUtils.isNotBlank((CharSequence)modifyDesc.getKeyPair())) {
            request.withKeyName(modifyDesc.getKeyPair());
        } else if (StringUtils.isNotBlank((CharSequence)sourceLtData.getKeyName())) {
            request.withKeyName(sourceLtData.getKeyName());
        }
        if (StringUtils.isNotBlank((CharSequence)modifyDesc.getIamRole())) {
            request.withIamInstanceProfile(new LaunchTemplateIamInstanceProfileSpecificationRequest().withName(modifyDesc.getIamRole()));
        } else if (sourceLtData.getIamInstanceProfile() != null && StringUtils.isNotBlank((CharSequence)sourceLtData.getIamInstanceProfile().getName())) {
            request.withIamInstanceProfile(new LaunchTemplateIamInstanceProfileSpecificationRequest().withName(sourceLtData.getIamInstanceProfile().getName()));
        }
        if (modifyDesc.getInstanceMonitoring() != null) {
            request.setMonitoring(new LaunchTemplatesMonitoringRequest().withEnabled(modifyDesc.getInstanceMonitoring()));
        } else if (sourceLtData.getMonitoring() != null && sourceLtData.getMonitoring().getEnabled() != null) {
            request.setMonitoring(new LaunchTemplatesMonitoringRequest().withEnabled(sourceLtData.getMonitoring().getEnabled()));
        }
        if (modifyDesc.getBlockDevices() != null) {
            request.setBlockDeviceMappings(this.buildDeviceMapping(modifyDesc.getBlockDevices()));
        } else if (sourceLtData.getBlockDeviceMappings() != null) {
            request.setBlockDeviceMappings(this.buildDeviceMapping(AsgConfigHelper.transformLaunchTemplateBlockDeviceMapping(sourceLtData.getBlockDeviceMappings())));
        }
        Optional<LaunchTemplateTagSpecificationRequest> tagSpecification = this.tagSpecification(this.amazonResourceTaggers, null, modifyDesc.getAsgName());
        if (tagSpecification.isPresent()) {
            request = request.withTagSpecifications(new LaunchTemplateTagSpecificationRequest[]{tagSpecification.get()});
        }
        String base64UserData = this.localFileUserDataProperties != null && !this.localFileUserDataProperties.isEnabled() ? sourceLtData.getUserData() : null;
        this.setUserData(request, modifyDesc.getAsgName(), sourceLtVersion.getLaunchTemplateName(), modifyDesc.getRegion(), modifyDesc.getAccount(), credentials.getEnvironment(), credentials.getAccountType(), modifyDesc.getIamRole(), modifyDesc.getImageId(), base64UserData, modifyDesc.getLegacyUdf(), modifyDesc.getUserDataOverride());
        if (modifyDesc.getRequireIMDV2() != null) {
            request.setMetadataOptions(new LaunchTemplateInstanceMetadataOptionsRequest().withHttpTokens(modifyDesc.getRequireIMDV2() != false ? "required" : ""));
        } else if (sourceLtData.getMetadataOptions() != null) {
            request.setMetadataOptions(new LaunchTemplateInstanceMetadataOptionsRequest().withHttpTokens(sourceLtData.getMetadataOptions().getHttpTokens()));
        }
        if (!shouldUseMixedInstancesPolicy) {
            this.setSpotInstanceMarketOptions(request, modifyDesc.getSpotPrice());
        }
        if (modifyDesc.getUnlimitedCpuCredits() != null) {
            this.setCreditSpecification(request, modifyDesc.getUnlimitedCpuCredits());
        } else if (sourceLtData.getCreditSpecification() != null) {
            Boolean unlimitedCpuCreditsFromSrcAsg = AsgConfigHelper.getUnlimitedCpuCreditsFromAncestorLt(sourceLtData.getCreditSpecification(), InstanceTypeUtils.isBurstingSupportedByAllTypes(modifyDesc.getAllInstanceTypes()));
            this.setCreditSpecification(request, unlimitedCpuCreditsFromSrcAsg);
        }
        LaunchTemplateInstanceNetworkInterfaceSpecification defaultInterface = sourceLtData.getNetworkInterfaces() != null && !sourceLtData.getNetworkInterfaces().isEmpty() ? sourceLtData.getNetworkInterfaces().stream().filter(i -> i.getDeviceIndex() == 0).findFirst().orElseGet(LaunchTemplateInstanceNetworkInterfaceSpecification::new) : new LaunchTemplateInstanceNetworkInterfaceSpecification();
        LaunchTemplateInstanceNetworkInterfaceSpecificationRequest[] launchTemplateInstanceNetworkInterfaceSpecificationRequestArray = new LaunchTemplateInstanceNetworkInterfaceSpecificationRequest[1];
        launchTemplateInstanceNetworkInterfaceSpecificationRequestArray[0] = new LaunchTemplateInstanceNetworkInterfaceSpecificationRequest().withAssociatePublicIpAddress(Optional.ofNullable(modifyDesc.getAssociatePublicIpAddress()).orElseGet(() -> defaultInterface.getAssociatePublicIpAddress())).withIpv6AddressCount(Integer.valueOf(modifyDesc.getAssociateIPv6Address() != null ? (modifyDesc.getAssociateIPv6Address().booleanValue() ? 1 : 0) : (defaultInterface.getIpv6AddressCount() != null && defaultInterface.getIpv6AddressCount() > 0 ? 1 : 0))).withGroups((Collection)(modifyDesc.getSecurityGroups() != null && !modifyDesc.getSecurityGroups().isEmpty() ? modifyDesc.getSecurityGroups() : defaultInterface.getGroups())).withDeviceIndex(Integer.valueOf(0));
        request.withNetworkInterfaces(launchTemplateInstanceNetworkInterfaceSpecificationRequestArray);
        if (modifyDesc.getEnableEnclave() != null) {
            request.setEnclaveOptions(new LaunchTemplateEnclaveOptionsRequest().withEnabled(modifyDesc.getEnableEnclave()));
        } else if (sourceLtData.getEnclaveOptions() != null) {
            request.setEnclaveOptions(new LaunchTemplateEnclaveOptionsRequest().withEnabled(sourceLtData.getEnclaveOptions().getEnabled()));
        }
        return request;
    }

    private RequestLaunchTemplateData buildLaunchTemplateData(AutoScalingWorker.AsgConfiguration asgConfig, String asgName, String launchTemplateName) {
        RequestLaunchTemplateData request = new RequestLaunchTemplateData().withImageId(asgConfig.getAmi()).withKernelId(asgConfig.getKernelId()).withInstanceType(asgConfig.getInstanceType()).withRamDiskId(asgConfig.getRamdiskId()).withEbsOptimized(asgConfig.getEbsOptimized()).withKeyName(asgConfig.getKeyPair()).withIamInstanceProfile(new LaunchTemplateIamInstanceProfileSpecificationRequest().withName(asgConfig.getIamRole())).withMonitoring(new LaunchTemplatesMonitoringRequest().withEnabled(asgConfig.getInstanceMonitoring()));
        Optional<LaunchTemplateTagSpecificationRequest> tagSpecification = this.tagSpecification(this.amazonResourceTaggers, asgConfig.getBlockDeviceTags(), asgName);
        if (tagSpecification.isPresent()) {
            request = request.withTagSpecifications(new LaunchTemplateTagSpecificationRequest[]{tagSpecification.get()});
        }
        if (asgConfig.getPlacement() != null) {
            request = request.withPlacement(new LaunchTemplatePlacementRequest().withAffinity(asgConfig.getPlacement().getAffinity()).withAvailabilityZone(asgConfig.getPlacement().getAvailabilityZone()).withGroupName(asgConfig.getPlacement().getGroupName()).withHostId(asgConfig.getPlacement().getHostId()).withTenancy(asgConfig.getPlacement().getTenancy()).withHostResourceGroupArn(asgConfig.getPlacement().getHostResourceGroupArn()).withPartitionNumber(asgConfig.getPlacement().getPartitionNumber()).withSpreadDomain(asgConfig.getPlacement().getSpreadDomain()));
        }
        if (asgConfig.getLicenseSpecifications() != null) {
            request = request.withLicenseSpecifications((Collection)asgConfig.getLicenseSpecifications().stream().map(licenseSpecification -> new LaunchTemplateLicenseConfigurationRequest().withLicenseConfigurationArn(licenseSpecification.getArn())).collect(Collectors.toList()));
        }
        this.setUserData(request, asgName, launchTemplateName, asgConfig.getRegion(), asgConfig.getCredentials().getName(), asgConfig.getCredentials().getEnvironment(), asgConfig.getCredentials().getAccountType(), asgConfig.getIamRole(), asgConfig.getAmi(), asgConfig.getBase64UserData(), asgConfig.getLegacyUdf(), asgConfig.getUserDataOverride());
        if (asgConfig.getRequireIMDSv2() != null && asgConfig.getRequireIMDSv2().booleanValue()) {
            request.setMetadataOptions(new LaunchTemplateInstanceMetadataOptionsRequest().withHttpTokens("required"));
        }
        if (!asgConfig.shouldUseMixedInstancesPolicy()) {
            this.setSpotInstanceMarketOptions(request, asgConfig.getSpotMaxPrice());
        }
        this.setCreditSpecification(request, asgConfig.getUnlimitedCpuCredits());
        request.withNetworkInterfaces(new LaunchTemplateInstanceNetworkInterfaceSpecificationRequest[]{new LaunchTemplateInstanceNetworkInterfaceSpecificationRequest().withAssociatePublicIpAddress(asgConfig.getAssociatePublicIpAddress()).withIpv6AddressCount(Integer.valueOf(asgConfig.getAssociateIPv6Address() != false ? 1 : 0)).withGroups(asgConfig.getSecurityGroups()).withDeviceIndex(Integer.valueOf(0))});
        if (asgConfig.getEnableEnclave() != null) {
            request.setEnclaveOptions(new LaunchTemplateEnclaveOptionsRequest().withEnabled(asgConfig.getEnableEnclave()));
        }
        if (asgConfig.getBlockDevices() != null && !asgConfig.getBlockDevices().isEmpty()) {
            request.setBlockDeviceMappings(this.buildDeviceMapping(asgConfig.getBlockDevices()));
        }
        return request;
    }

    private void setCreditSpecification(RequestLaunchTemplateData request, Boolean unlimitedCpuCredits) {
        if (unlimitedCpuCredits != null) {
            request.setCreditSpecification(new CreditSpecificationRequest().withCpuCredits(unlimitedCpuCredits != false ? UNLIMITED_CPU_CREDITS : STANDARD_CPU_CREDITS));
        }
    }

    private void setSpotInstanceMarketOptions(RequestLaunchTemplateData request, String maxSpotPrice) {
        if (maxSpotPrice != null && StringUtils.isNotEmpty((CharSequence)maxSpotPrice.trim())) {
            request.setInstanceMarketOptions(new LaunchTemplateInstanceMarketOptionsRequest().withMarketType(MarketType.Spot).withSpotOptions(new LaunchTemplateSpotMarketOptionsRequest().withMaxPrice(maxSpotPrice)));
        }
    }

    private void setUserData(RequestLaunchTemplateData request, String asgName, String launchTemplateName, String region, String account, String env, String accType, String iamRole, String imageId, String base64UserData, Boolean legacyUdf, UserDataOverride userDataOverride) {
        UserDataInput userDataRequest = UserDataInput.builder().launchTemplate(Boolean.valueOf(true)).asgName(asgName).launchSettingName(launchTemplateName).region(region).account(account).environment(env).accountType(accType).iamRole(iamRole).imageId(imageId).userDataOverride(userDataOverride).base64UserData(base64UserData).legacyUdf(legacyUdf).build();
        request.setUserData(this.userDataProviderAggregator.aggregate(userDataRequest));
    }

    private List<LaunchTemplateBlockDeviceMappingRequest> buildDeviceMapping(List<AmazonBlockDevice> amazonBlockDevices) {
        if (amazonBlockDevices == null || amazonBlockDevices.isEmpty()) {
            return null;
        }
        ArrayList<LaunchTemplateBlockDeviceMappingRequest> mappings = new ArrayList<LaunchTemplateBlockDeviceMappingRequest>();
        for (AmazonBlockDevice blockDevice : amazonBlockDevices) {
            LaunchTemplateBlockDeviceMappingRequest mapping = new LaunchTemplateBlockDeviceMappingRequest().withDeviceName(blockDevice.getDeviceName());
            if (blockDevice.getVirtualName() != null) {
                mapping.setVirtualName(blockDevice.getVirtualName());
            } else {
                mapping.setEbs(this.getLaunchTemplateEbsBlockDeviceRequest(blockDevice));
            }
            mappings.add(mapping);
        }
        return mappings;
    }

    private LaunchTemplateEbsBlockDeviceRequest getLaunchTemplateEbsBlockDeviceRequest(AmazonBlockDevice blockDevice) {
        LaunchTemplateEbsBlockDeviceRequest blockDeviceRequest = new LaunchTemplateEbsBlockDeviceRequest().withVolumeSize(blockDevice.getSize());
        if (blockDevice.getDeleteOnTermination() != null) {
            blockDeviceRequest.setDeleteOnTermination(blockDevice.getDeleteOnTermination());
        }
        if (blockDevice.getVolumeType() != null) {
            blockDeviceRequest.setVolumeType(blockDevice.getVolumeType());
        }
        if (blockDevice.getIops() != null) {
            blockDeviceRequest.setIops(blockDevice.getIops());
        }
        if (blockDevice.getSnapshotId() != null) {
            blockDeviceRequest.setSnapshotId(blockDevice.getSnapshotId());
        }
        if (blockDevice.getEncrypted() != null) {
            blockDeviceRequest.setEncrypted(blockDevice.getEncrypted());
        }
        if (blockDevice.getKmsKeyId() != null) {
            blockDeviceRequest.setKmsKeyId(blockDevice.getKmsKeyId());
        }
        return blockDeviceRequest;
    }

    @NotNull
    private Optional<LaunchTemplateTagSpecificationRequest> tagSpecification(Collection<AmazonResourceTagger> amazonResourceTaggers, @Nullable Map<String, String> blockDeviceTags, @NotNull String serverGroupName) {
        List volumeTags;
        if (amazonResourceTaggers != null && !amazonResourceTaggers.isEmpty() && !(volumeTags = amazonResourceTaggers.stream().flatMap(t -> t.volumeTags(blockDeviceTags, serverGroupName).stream()).map(t -> new Tag(t.getKey(), t.getValue())).collect(Collectors.toList())).isEmpty()) {
            return Optional.of(new LaunchTemplateTagSpecificationRequest().withResourceType("volume").withTags(volumeTags));
        }
        return Optional.empty();
    }
}

