/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.aws.deploy.handlers;

import com.amazonaws.services.autoscaling.model.AutoScalingGroup;
import com.amazonaws.services.autoscaling.model.DescribeAutoScalingGroupsRequest;
import com.amazonaws.services.ec2.model.DescribeSecurityGroupsRequest;
import com.google.common.annotations.VisibleForTesting;
import com.netflix.frigga.Names;
import com.netflix.spinnaker.clouddriver.aws.AmazonCloudProvider;
import com.netflix.spinnaker.clouddriver.aws.deploy.AmiIdResolver;
import com.netflix.spinnaker.clouddriver.aws.deploy.InstanceTypeUtils;
import com.netflix.spinnaker.clouddriver.aws.deploy.ResolvedAmiResult;
import com.netflix.spinnaker.clouddriver.aws.deploy.asg.AsgConfigHelper;
import com.netflix.spinnaker.clouddriver.aws.deploy.asg.AutoScalingWorker;
import com.netflix.spinnaker.clouddriver.aws.deploy.asg.LaunchTemplateRollOutConfig;
import com.netflix.spinnaker.clouddriver.aws.deploy.description.BasicAmazonDeployDescription;
import com.netflix.spinnaker.clouddriver.aws.deploy.ops.loadbalancer.LoadBalancerLookupHelper;
import com.netflix.spinnaker.clouddriver.aws.deploy.ops.loadbalancer.TargetGroupLookupHelper;
import com.netflix.spinnaker.clouddriver.aws.deploy.ops.loadbalancer.UpsertAmazonLoadBalancerResult;
import com.netflix.spinnaker.clouddriver.aws.deploy.scalingpolicy.ScalingPolicyCopier;
import com.netflix.spinnaker.clouddriver.aws.model.AmazonAsgLifecycleHook;
import com.netflix.spinnaker.clouddriver.aws.model.AmazonBlockDevice;
import com.netflix.spinnaker.clouddriver.aws.security.NetflixAmazonCredentials;
import com.netflix.spinnaker.clouddriver.aws.services.RegionScopedProviderFactory;
import com.netflix.spinnaker.clouddriver.data.task.Task;
import com.netflix.spinnaker.clouddriver.data.task.TaskRepository;
import com.netflix.spinnaker.clouddriver.deploy.DeployDescription;
import com.netflix.spinnaker.clouddriver.deploy.DeployHandler;
import com.netflix.spinnaker.clouddriver.deploy.DeploymentResult;
import com.netflix.spinnaker.clouddriver.orchestration.events.CreateServerGroupEvent;
import com.netflix.spinnaker.config.AwsConfiguration;
import com.netflix.spinnaker.credentials.CredentialsRepository;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.lang.ref.SoftReference;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.ArrayUtil;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicAmazonDeployHandler
implements DeployHandler<BasicAmazonDeployDescription>,
GroovyObject {
    private static final String BASE_PHASE = "DEPLOY";
    private static final String SUBNET_ID_OVERRIDE_TAG = "SPINNAKER_SUBNET_ID_OVERRIDE";
    private final RegionScopedProviderFactory regionScopedProviderFactory;
    private final CredentialsRepository<NetflixAmazonCredentials> accountCredentialsRepository;
    private final AwsConfiguration.AmazonServerGroupProvider amazonServerGroupProvider;
    private final AwsConfiguration.DeployDefaults deployDefaults;
    private final ScalingPolicyCopier scalingPolicyCopier;
    private final InstanceTypeUtils.BlockDeviceConfig blockDeviceConfig;
    private final LaunchTemplateRollOutConfig launchTemplateRollOutConfig;
    private List<CreateServerGroupEvent> deployEvents;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo$;
    private static /* synthetic */ SoftReference $callSiteArray;

    public BasicAmazonDeployHandler(RegionScopedProviderFactory regionScopedProviderFactory, CredentialsRepository<NetflixAmazonCredentials> accountCredentialsRepository, AwsConfiguration.AmazonServerGroupProvider amazonServerGroupProvider, AwsConfiguration.DeployDefaults deployDefaults, ScalingPolicyCopier scalingPolicyCopier, InstanceTypeUtils.BlockDeviceConfig blockDeviceConfig, LaunchTemplateRollOutConfig launchTemplateRollOutConfig) {
        LaunchTemplateRollOutConfig launchTemplateRollOutConfig2;
        InstanceTypeUtils.BlockDeviceConfig blockDeviceConfig2;
        ScalingPolicyCopier scalingPolicyCopier2;
        AwsConfiguration.DeployDefaults deployDefaults2;
        AwsConfiguration.AmazonServerGroupProvider amazonServerGroupProvider2;
        RegionScopedProviderFactory regionScopedProviderFactory2;
        MetaClass metaClass;
        List list;
        CallSite[] callSiteArray = BasicAmazonDeployHandler.$getCallSiteArray();
        this.deployEvents = list = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.regionScopedProviderFactory = regionScopedProviderFactory2 = regionScopedProviderFactory;
        CredentialsRepository<NetflixAmazonCredentials> credentialsRepository = accountCredentialsRepository;
        this.accountCredentialsRepository = credentialsRepository;
        this.amazonServerGroupProvider = amazonServerGroupProvider2 = amazonServerGroupProvider;
        this.deployDefaults = deployDefaults2 = deployDefaults;
        this.scalingPolicyCopier = scalingPolicyCopier2 = scalingPolicyCopier;
        this.blockDeviceConfig = blockDeviceConfig2 = blockDeviceConfig;
        this.launchTemplateRollOutConfig = launchTemplateRollOutConfig2 = launchTemplateRollOutConfig;
    }

    private static Task getTask() {
        CallSite[] callSiteArray = BasicAmazonDeployHandler.$getCallSiteArray();
        return (Task)ScriptBytecodeAdapter.castToType((Object)callSiteArray[0].call(callSiteArray[1].callGetProperty(TaskRepository.class)), Task.class);
    }

    public boolean handles(DeployDescription description) {
        CallSite[] callSiteArray = BasicAmazonDeployHandler.$getCallSiteArray();
        return description instanceof BasicAmazonDeployDescription;
    }

    public DeploymentResult handle(BasicAmazonDeployDescription description, List priorOutputs) {
        Reference description2 = new Reference((Object)description);
        CallSite[] callSiteArray = BasicAmazonDeployHandler.$getCallSiteArray();
        Object deploymentResult = callSiteArray[2].callConstructor(DeploymentResult.class);
        callSiteArray[3].call(callSiteArray[4].callGroovyObjectGetProperty((Object)this), (Object)BASE_PHASE, (Object)new GStringImpl(new Object[]{callSiteArray[5].callGroovyObjectGetProperty((Object)((BasicAmazonDeployDescription)description2.get()))}, new String[]{"Preparing deployment to ", "..."}));
        Map.Entry entry = null;
        Iterator iterator = (Iterator)ScriptBytecodeAdapter.castToType((Object)callSiteArray[6].call(callSiteArray[7].callGroovyObjectGetProperty((Object)((BasicAmazonDeployDescription)description2.get()))), Iterator.class);
        if (iterator != null) {
            while (iterator.hasNext()) {
                Object object;
                Object object2;
                entry = (Map.Entry)ScriptBytecodeAdapter.castToType(iterator.next(), Map.Entry.class);
                Reference region = new Reference((Object)ShortTypeHandling.castToString((Object)callSiteArray[8].callGetProperty((Object)entry)));
                Object sourceRegionScopedProvider = callSiteArray[9].callCurrent((GroovyObject)this, callSiteArray[10].callGroovyObjectGetProperty((Object)this), callSiteArray[11].callGroovyObjectGetProperty((Object)((BasicAmazonDeployDescription)description2.get())));
                description2.set((Object)((BasicAmazonDeployDescription)ScriptBytecodeAdapter.castToType((Object)callSiteArray[12].callCurrent((GroovyObject)this, sourceRegionScopedProvider, callSiteArray[13].callGetProperty(callSiteArray[14].callGroovyObjectGetProperty((Object)((BasicAmazonDeployDescription)description2.get()))), callSiteArray[15].callGetProperty(callSiteArray[16].callGroovyObjectGetProperty((Object)((BasicAmazonDeployDescription)description2.get()))), (Object)((BasicAmazonDeployDescription)description2.get())), BasicAmazonDeployDescription.class)));
                List availabilityZones = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[17].callGetProperty((Object)entry), List.class);
                Object subnetType = callSiteArray[18].callGroovyObjectGetProperty((Object)((BasicAmazonDeployDescription)description2.get()));
                public final class _handle_closure1
                extends Closure
                implements GeneratedClosure {
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;
                    private static /* synthetic */ SoftReference $callSiteArray;

                    public _handle_closure1(Object _outerInstance, Object _thisObject) {
                        CallSite[] callSiteArray = _handle_closure1.$getCallSiteArray();
                        super(_outerInstance, _thisObject);
                    }

                    public Object doCall(Object it) {
                        CallSite[] callSiteArray = _handle_closure1.$getCallSiteArray();
                        return it instanceof UpsertAmazonLoadBalancerResult;
                    }

                    @Generated
                    public Object doCall() {
                        CallSite[] callSiteArray = _handle_closure1.$getCallSiteArray();
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _handle_closure1.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                        String[] stringArray = new String[]{};
                        return new CallSiteArray(_handle_closure1.class, stringArray);
                    }

                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                        CallSiteArray callSiteArray;
                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                            callSiteArray = _handle_closure1.$createCallSiteArray();
                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                        }
                        return callSiteArray.array;
                    }
                }
                List suppliedLoadBalancers = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[19].callSafe(callSiteArray[20].callGetPropertySafe(callSiteArray[21].call((Object)priorOutputs, (Object)new _handle_closure1(this, this))), (Object)((String)region.get())), List.class);
                if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[22].callGroovyObjectGetProperty((Object)((BasicAmazonDeployDescription)description2.get())))) {
                    List list = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
                    ScriptBytecodeAdapter.setGroovyObjectProperty((Object)list, BasicAmazonDeployHandler.class, (GroovyObject)((BasicAmazonDeployDescription)description2.get()), (String)"loadBalancers");
                }
                callSiteArray[23].call(callSiteArray[24].callGroovyObjectGetProperty((Object)((BasicAmazonDeployDescription)description2.get())), DefaultTypeTransformation.booleanUnbox((Object)(object2 = callSiteArray[25].callGetPropertySafe((Object)suppliedLoadBalancers))) ? object2 : ScriptBytecodeAdapter.createList((Object[])new Object[0]));
                Object regionScopedProvider = callSiteArray[26].call((Object)this.regionScopedProviderFactory, callSiteArray[27].callGroovyObjectGetProperty((Object)((BasicAmazonDeployDescription)description2.get())), (Object)((String)region.get()));
                Object loadBalancers = callSiteArray[28].call(callSiteArray[29].callCurrent((GroovyObject)this), regionScopedProvider, callSiteArray[30].callGroovyObjectGetProperty((Object)((BasicAmazonDeployDescription)description2.get())));
                if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[31].callGetProperty(loadBalancers))) {
                    throw (Throwable)callSiteArray[32].callConstructor(IllegalStateException.class, (Object)new GStringImpl(new Object[]{callSiteArray[33].callGetProperty(loadBalancers)}, new String[]{"Unable to find classic load balancers named ", ""}));
                }
                Object targetGroups = callSiteArray[34].call(callSiteArray[35].callCurrent((GroovyObject)this), regionScopedProvider, callSiteArray[36].callGroovyObjectGetProperty((Object)((BasicAmazonDeployDescription)description2.get())));
                if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[37].callGetProperty(targetGroups))) {
                    throw (Throwable)callSiteArray[38].callConstructor(IllegalStateException.class, (Object)new GStringImpl(new Object[]{callSiteArray[39].callGetProperty(targetGroups)}, new String[]{"Unable to find target groups named ", ""}));
                }
                Object amazonEC2 = callSiteArray[40].callGetProperty(regionScopedProvider);
                String classicLinkVpcId = null;
                List classicLinkVpcSecurityGroups = null;
                if (!DefaultTypeTransformation.booleanUnbox((Object)subnetType)) {
                    Object result = callSiteArray[41].call(amazonEC2);
                    public final class _handle_closure2
                    extends Closure
                    implements GeneratedClosure {
                        private static /* synthetic */ ClassInfo $staticClassInfo;
                        public static transient /* synthetic */ boolean __$stMC;
                        private static /* synthetic */ SoftReference $callSiteArray;

                        public _handle_closure2(Object _outerInstance, Object _thisObject) {
                            CallSite[] callSiteArray = _handle_closure2.$getCallSiteArray();
                            super(_outerInstance, _thisObject);
                        }

                        public Object doCall(Object it) {
                            CallSite[] callSiteArray = _handle_closure2.$getCallSiteArray();
                            return callSiteArray[0].callGetProperty(it);
                        }

                        @Generated
                        public Object doCall() {
                            CallSite[] callSiteArray = _handle_closure2.$getCallSiteArray();
                            return this.doCall(null);
                        }

                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                            if (((Object)((Object)this)).getClass() != _handle_closure2.class) {
                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                            }
                            ClassInfo classInfo = $staticClassInfo;
                            if (classInfo == null) {
                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                            }
                            return classInfo.getMetaClass();
                        }

                        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                            String[] stringArray = new String[1];
                            stringArray[0] = "classicLinkEnabled";
                            return new CallSiteArray(_handle_closure2.class, stringArray);
                        }

                        private static /* synthetic */ CallSite[] $getCallSiteArray() {
                            CallSiteArray callSiteArray;
                            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                                callSiteArray = _handle_closure2.$createCallSiteArray();
                                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                            }
                            return callSiteArray.array;
                        }
                    }
                    classicLinkVpcId = ShortTypeHandling.castToString((Object)callSiteArray[42].callGetPropertySafe(callSiteArray[43].call(callSiteArray[44].callGetProperty(result), (Object)new _handle_closure2(this, this))));
                    if (DefaultTypeTransformation.booleanUnbox((Object)classicLinkVpcId)) {
                        Set classicLinkGroupNames = (Set)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.createList((Object[])new Object[0]), Set.class);
                        Object object3 = callSiteArray[46].callGroovyObjectGetProperty((Object)((BasicAmazonDeployDescription)description2.get()));
                        callSiteArray[45].call((Object)classicLinkGroupNames, DefaultTypeTransformation.booleanUnbox((Object)object3) ? object3 : ScriptBytecodeAdapter.createList((Object[])new Object[0]));
                        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[47].callGroovyObjectGetProperty((Object)this.deployDefaults))) {
                            callSiteArray[48].call((Object)classicLinkGroupNames, callSiteArray[49].callGroovyObjectGetProperty((Object)this.deployDefaults));
                        }
                        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[50].callGroovyObjectGetProperty((Object)((BasicAmazonDeployDescription)description2.get()))) && DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[51].callGroovyObjectGetProperty((Object)((BasicAmazonDeployDescription)description2.get())))) {
                            public final class _handle_closure3
                            extends Closure
                            implements GeneratedClosure {
                                private static /* synthetic */ ClassInfo $staticClassInfo;
                                public static transient /* synthetic */ boolean __$stMC;
                                private static /* synthetic */ SoftReference $callSiteArray;

                                public _handle_closure3(Object _outerInstance, Object _thisObject) {
                                    CallSite[] callSiteArray = _handle_closure3.$getCallSiteArray();
                                    super(_outerInstance, _thisObject);
                                }

                                public Object doCall(Object it) {
                                    CallSite[] callSiteArray = _handle_closure3.$getCallSiteArray();
                                    return callSiteArray[0].call(it, ScriptBytecodeAdapter.bitwiseNegate((Object)"sg-[0-9a-f]+"));
                                }

                                @Generated
                                public Object doCall() {
                                    CallSite[] callSiteArray = _handle_closure3.$getCallSiteArray();
                                    return this.doCall(null);
                                }

                                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                    if (((Object)((Object)this)).getClass() != _handle_closure3.class) {
                                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                    }
                                    ClassInfo classInfo = $staticClassInfo;
                                    if (classInfo == null) {
                                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                    }
                                    return classInfo.getMetaClass();
                                }

                                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                                    String[] stringArray = new String[1];
                                    stringArray[0] = "matches";
                                    return new CallSiteArray(_handle_closure3.class, stringArray);
                                }

                                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                                    CallSiteArray callSiteArray;
                                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                                        callSiteArray = _handle_closure3.$createCallSiteArray();
                                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                                    }
                                    return callSiteArray.array;
                                }
                            }
                            Object object4 = callSiteArray[52].call((Object)classicLinkGroupNames, (Object)new _handle_closure3(this, this));
                            Reference groupIds = new Reference(DefaultTypeTransformation.booleanUnbox((Object)object4) ? object4 : ScriptBytecodeAdapter.createList((Object[])new Object[0]));
                            callSiteArray[53].call((Object)classicLinkGroupNames, groupIds.get());
                            if (DefaultTypeTransformation.booleanUnbox((Object)groupIds.get())) {
                                Object describeSG = callSiteArray[54].call(callSiteArray[55].callConstructor(DescribeSecurityGroupsRequest.class), groupIds.get());
                                Object object5 = sourceRegionScopedProvider;
                                Object provider = DefaultTypeTransformation.booleanUnbox((Object)object5) ? object5 : regionScopedProvider;
                                public final class _handle_closure4
                                extends Closure
                                implements GeneratedClosure {
                                    private /* synthetic */ Reference description;
                                    private /* synthetic */ Reference groupIds;
                                    private static /* synthetic */ ClassInfo $staticClassInfo;
                                    public static transient /* synthetic */ boolean __$stMC;
                                    private static /* synthetic */ SoftReference $callSiteArray;

                                    public _handle_closure4(Object _outerInstance, Object _thisObject, Reference description, Reference groupIds) {
                                        Reference reference;
                                        Reference reference2;
                                        CallSite[] callSiteArray = _handle_closure4.$getCallSiteArray();
                                        super(_outerInstance, _thisObject);
                                        this.description = reference2 = description;
                                        this.groupIds = reference = groupIds;
                                    }

                                    public Object doCall(Object it) {
                                        CallSite[] callSiteArray = _handle_closure4.$getCallSiteArray();
                                        if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[0].callGetProperty(it), (Object)callSiteArray[1].callGroovyObjectGetProperty(this.description.get())) && DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[2].call(this.groupIds.get(), callSiteArray[3].callGetProperty(it)))) {
                                            return callSiteArray[4].callGetProperty(it);
                                        }
                                        return null;
                                    }

                                    @Generated
                                    public BasicAmazonDeployDescription getDescription() {
                                        CallSite[] callSiteArray = _handle_closure4.$getCallSiteArray();
                                        return (BasicAmazonDeployDescription)ScriptBytecodeAdapter.castToType((Object)this.description.get(), BasicAmazonDeployDescription.class);
                                    }

                                    @Generated
                                    public Object getGroupIds() {
                                        CallSite[] callSiteArray = _handle_closure4.$getCallSiteArray();
                                        return this.groupIds.get();
                                    }

                                    @Generated
                                    public Object doCall() {
                                        CallSite[] callSiteArray = _handle_closure4.$getCallSiteArray();
                                        return this.doCall(null);
                                    }

                                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                        if (((Object)((Object)this)).getClass() != _handle_closure4.class) {
                                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                        }
                                        ClassInfo classInfo = $staticClassInfo;
                                        if (classInfo == null) {
                                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                        }
                                        return classInfo.getMetaClass();
                                    }

                                    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                                        stringArray[0] = "vpcId";
                                        stringArray[1] = "classicLinkVpcId";
                                        stringArray[2] = "contains";
                                        stringArray[3] = "groupId";
                                        stringArray[4] = "groupName";
                                    }

                                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                                        String[] stringArray = new String[5];
                                        _handle_closure4.$createCallSiteArray_1(stringArray);
                                        return new CallSiteArray(_handle_closure4.class, stringArray);
                                    }

                                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                                        CallSiteArray callSiteArray;
                                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                                            callSiteArray = _handle_closure4.$createCallSiteArray();
                                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                                        }
                                        return callSiteArray.array;
                                    }
                                }
                                Object object6 = callSiteArray[56].call(callSiteArray[57].callGetProperty(callSiteArray[58].call(callSiteArray[59].callGetProperty(provider), describeSG)), (Object)new _handle_closure4(this, this, description2, groupIds));
                                Object resolvedNames = DefaultTypeTransformation.booleanUnbox((Object)object6) ? object6 : ScriptBytecodeAdapter.createList((Object[])new Object[0]);
                                if (ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[60].call(resolvedNames), (Object)callSiteArray[61].call(groupIds.get()))) {
                                    throw (Throwable)callSiteArray[62].callConstructor(IllegalStateException.class, (Object)new GStringImpl(new Object[]{groupIds.get(), resolvedNames}, new String[]{"failed to look up classic link security groups, had ", " found ", ""}));
                                }
                                callSiteArray[63].call((Object)classicLinkGroupNames, resolvedNames);
                            }
                        }
                        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[64].callGroovyObjectGetProperty((Object)this.deployDefaults))) {
                            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[65].callGroovyObjectGetProperty((Object)((BasicAmazonDeployDescription)description2.get())))) {
                                Object srcName = callSiteArray[66].call(Names.class, callSiteArray[67].callGetProperty(callSiteArray[68].callGroovyObjectGetProperty((Object)((BasicAmazonDeployDescription)description2.get()))));
                                boolean mismatch = false;
                                if (ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[69].callGetProperty(srcName), (Object)callSiteArray[70].callGroovyObjectGetProperty((Object)((BasicAmazonDeployDescription)description2.get())))) {
                                    callSiteArray[71].call((Object)classicLinkGroupNames, callSiteArray[72].callGetProperty(srcName));
                                    mismatch = true;
                                }
                                if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[73].callGetProperty(srcName)) && (mismatch || ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[74].callGetProperty(srcName), (Object)callSiteArray[75].callGroovyObjectGetProperty((Object)((BasicAmazonDeployDescription)description2.get()))))) {
                                    callSiteArray[76].call((Object)classicLinkGroupNames, callSiteArray[77].call((Object)new GStringImpl(new Object[]{callSiteArray[78].callGetProperty(srcName), callSiteArray[79].callGetProperty(srcName)}, new String[]{"", "-", ""})));
                                    mismatch = true;
                                }
                                if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[80].callGetProperty(srcName)) && (mismatch || ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[81].callGetProperty(srcName), (Object)callSiteArray[82].callGroovyObjectGetProperty((Object)((BasicAmazonDeployDescription)description2.get()))))) {
                                    Object object7;
                                    callSiteArray[83].call((Object)classicLinkGroupNames, (Object)new GStringImpl(new Object[]{callSiteArray[84].callGetProperty(srcName), DefaultTypeTransformation.booleanUnbox((Object)(object7 = callSiteArray[85].callGetProperty(srcName))) ? object7 : "", callSiteArray[86].callGetProperty(srcName)}, new String[]{"", "-", "-", ""}));
                                }
                            }
                            List groupNamesToLookUp = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
                            if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[87].call((Object)classicLinkGroupNames, callSiteArray[88].callGroovyObjectGetProperty((Object)((BasicAmazonDeployDescription)description2.get()))))) {
                                callSiteArray[89].call((Object)groupNamesToLookUp, callSiteArray[90].callGroovyObjectGetProperty((Object)((BasicAmazonDeployDescription)description2.get())));
                            }
                            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[91].callGroovyObjectGetProperty((Object)((BasicAmazonDeployDescription)description2.get())))) {
                                String stackGroup = ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{callSiteArray[92].callGroovyObjectGetProperty((Object)((BasicAmazonDeployDescription)description2.get())), callSiteArray[93].callGroovyObjectGetProperty((Object)((BasicAmazonDeployDescription)description2.get()))}, new String[]{"", "-", ""}));
                                if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[94].call((Object)classicLinkGroupNames, (Object)stackGroup))) {
                                    callSiteArray[95].call((Object)groupNamesToLookUp, (Object)stackGroup);
                                }
                            }
                            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[96].callGroovyObjectGetProperty((Object)((BasicAmazonDeployDescription)description2.get())))) {
                                Object object8;
                                String clusterGroup = ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{callSiteArray[97].callGroovyObjectGetProperty((Object)((BasicAmazonDeployDescription)description2.get())), DefaultTypeTransformation.booleanUnbox((Object)(object8 = callSiteArray[98].callGroovyObjectGetProperty((Object)((BasicAmazonDeployDescription)description2.get())))) ? object8 : "", callSiteArray[99].callGroovyObjectGetProperty((Object)((BasicAmazonDeployDescription)description2.get()))}, new String[]{"", "-", "-", ""}));
                                if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[100].call((Object)classicLinkGroupNames, (Object)clusterGroup))) {
                                    callSiteArray[101].call((Object)groupNamesToLookUp, (Object)clusterGroup);
                                }
                            }
                            if (DefaultTypeTransformation.booleanUnbox((Object)groupNamesToLookUp) && ScriptBytecodeAdapter.compareLessThan((Object)callSiteArray[102].call((Object)classicLinkGroupNames), (Object)callSiteArray[103].callGroovyObjectGetProperty((Object)this.deployDefaults))) {
                                Object appGroups = callSiteArray[104].call(callSiteArray[105].callGetProperty(regionScopedProvider), (Object)groupNamesToLookUp, (Object)classicLinkVpcId, (Object)false);
                                String name = null;
                                Iterator iterator2 = (Iterator)ScriptBytecodeAdapter.castToType((Object)callSiteArray[106].call((Object)groupNamesToLookUp), Iterator.class);
                                if (iterator2 != null) {
                                    while (iterator2.hasNext()) {
                                        name = ShortTypeHandling.castToString(iterator2.next());
                                        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[107].call(appGroups, (Object)name))) continue;
                                        if (ScriptBytecodeAdapter.compareLessThan((Object)callSiteArray[108].call((Object)classicLinkGroupNames), (Object)callSiteArray[109].callGroovyObjectGetProperty((Object)this.deployDefaults))) {
                                            callSiteArray[110].call((Object)classicLinkGroupNames, (Object)name);
                                            continue;
                                        }
                                        callSiteArray[111].call(callSiteArray[112].callGroovyObjectGetProperty((Object)this), (Object)BASE_PHASE, (Object)new GStringImpl(new Object[]{name, callSiteArray[113].callGroovyObjectGetProperty((Object)this.deployDefaults)}, new String[]{"Not adding ", " to classicLinkVpcSecurityGroups, already have ", " groups"}));
                                    }
                                }
                            }
                        }
                        classicLinkVpcSecurityGroups = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[114].call((Object)classicLinkGroupNames), List.class);
                        callSiteArray[115].call(callSiteArray[116].callGroovyObjectGetProperty((Object)this), (Object)BASE_PHASE, (Object)new GStringImpl(new Object[]{classicLinkGroupNames}, new String[]{"Attaching ", " as classicLinkVpcSecurityGroups"}));
                    }
                }
                public final class _handle_closure5
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference region;
                    private /* synthetic */ Reference description;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;
                    private static /* synthetic */ SoftReference $callSiteArray;

                    public _handle_closure5(Object _outerInstance, Object _thisObject, Reference region, Reference description) {
                        Reference reference;
                        Reference reference2;
                        CallSite[] callSiteArray = _handle_closure5.$getCallSiteArray();
                        super(_outerInstance, _thisObject);
                        this.region = reference2 = region;
                        this.description = reference = description;
                    }

                    public Object doCall(Object it) {
                        CallSite[] callSiteArray = _handle_closure5.$getCallSiteArray();
                        if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                            return it instanceof ResolvedAmiResult && ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[0].callGetProperty(it), (Object)this.region.get()) && (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[1].callGetProperty(it), (Object)callSiteArray[2].callGroovyObjectGetProperty(this.description.get())) || ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[3].callGetProperty(it), (Object)callSiteArray[4].callGroovyObjectGetProperty(this.description.get())));
                        }
                        return it instanceof ResolvedAmiResult && ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[5].callGetProperty(it), (Object)this.region.get()) && (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[6].callGetProperty(it), (Object)callSiteArray[7].callGroovyObjectGetProperty(this.description.get())) || ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[8].callGetProperty(it), (Object)callSiteArray[9].callGroovyObjectGetProperty(this.description.get())));
                    }

                    @Generated
                    public String getRegion() {
                        CallSite[] callSiteArray = _handle_closure5.$getCallSiteArray();
                        return ShortTypeHandling.castToString((Object)this.region.get());
                    }

                    @Generated
                    public BasicAmazonDeployDescription getDescription() {
                        CallSite[] callSiteArray = _handle_closure5.$getCallSiteArray();
                        return (BasicAmazonDeployDescription)ScriptBytecodeAdapter.castToType((Object)this.description.get(), BasicAmazonDeployDescription.class);
                    }

                    @Generated
                    public Object doCall() {
                        CallSite[] callSiteArray = _handle_closure5.$getCallSiteArray();
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _handle_closure5.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                        stringArray[0] = "region";
                        stringArray[1] = "amiName";
                        stringArray[2] = "amiName";
                        stringArray[3] = "amiId";
                        stringArray[4] = "amiName";
                        stringArray[5] = "region";
                        stringArray[6] = "amiName";
                        stringArray[7] = "amiName";
                        stringArray[8] = "amiId";
                        stringArray[9] = "amiName";
                    }

                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                        String[] stringArray = new String[10];
                        _handle_closure5.$createCallSiteArray_1(stringArray);
                        return new CallSiteArray(_handle_closure5.class, stringArray);
                    }

                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                        CallSiteArray callSiteArray;
                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                            callSiteArray = _handle_closure5.$createCallSiteArray();
                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                        }
                        return callSiteArray.array;
                    }
                }
                ResolvedAmiResult ami = (ResolvedAmiResult)ScriptBytecodeAdapter.castToType((Object)(DefaultTypeTransformation.booleanUnbox((Object)(object = callSiteArray[117].call((Object)priorOutputs, (Object)new _handle_closure5(this, this, region, description2)))) ? object : callSiteArray[118].call(AmiIdResolver.class, amazonEC2, (Object)((String)region.get()), callSiteArray[119].callGroovyObjectGetProperty((Object)((BasicAmazonDeployDescription)description2.get())), callSiteArray[120].callGetProperty(callSiteArray[121].callGroovyObjectGetProperty((Object)((BasicAmazonDeployDescription)description2.get()))))), ResolvedAmiResult.class);
                if (!DefaultTypeTransformation.booleanUnbox((Object)ami)) {
                    throw (Throwable)callSiteArray[122].callConstructor(IllegalArgumentException.class, (Object)new GStringImpl(new Object[]{callSiteArray[123].callGroovyObjectGetProperty((Object)((BasicAmazonDeployDescription)description2.get())), (String)region.get()}, new String[]{"unable to resolve AMI imageId from ", " in ", ""}));
                }
                callSiteArray[124].call(InstanceTypeUtils.class, amazonEC2, (Object)ami, callSiteArray[125].call((Object)((BasicAmazonDeployDescription)description2.get())));
                Object account = callSiteArray[126].call(this.accountCredentialsRepository, callSiteArray[127].callGetProperty(callSiteArray[128].callGroovyObjectGetProperty((Object)((BasicAmazonDeployDescription)description2.get()))));
                if (ScriptBytecodeAdapter.compareEqual((Object)account, null)) {
                    throw (Throwable)callSiteArray[129].callConstructor(IllegalArgumentException.class, (Object)new GStringImpl(new Object[]{callSiteArray[130].callGetProperty(callSiteArray[131].callGroovyObjectGetProperty((Object)((BasicAmazonDeployDescription)description2.get())))}, new String[]{"Account with name ", " could not be found."}));
                }
                if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[132].callGroovyObjectGetProperty((Object)((BasicAmazonDeployDescription)description2.get())))) {
                    Object object9 = callSiteArray[133].call(AsgConfigHelper.class, callSiteArray[134].callGroovyObjectGetProperty((Object)ami));
                    ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object9, BasicAmazonDeployHandler.class, (GroovyObject)((BasicAmazonDeployDescription)description2.get()), (String)"blockDevices");
                } else if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[135].callGroovyObjectGetProperty((Object)((BasicAmazonDeployDescription)description2.get())), null)) {
                    Object object10 = callSiteArray[136].call((Object)this.blockDeviceConfig, callSiteArray[137].callGroovyObjectGetProperty((Object)((BasicAmazonDeployDescription)description2.get())));
                    ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object10, BasicAmazonDeployHandler.class, (GroovyObject)((BasicAmazonDeployDescription)description2.get()), (String)"blockDevices");
                }
                if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[138].callGroovyObjectGetProperty((Object)((BasicAmazonDeployDescription)description2.get())), (Object)"")) {
                    Object var46_46 = null;
                    ScriptBytecodeAdapter.setGroovyObjectProperty(var46_46, BasicAmazonDeployHandler.class, (GroovyObject)((BasicAmazonDeployDescription)description2.get()), (String)"spotPrice");
                }
                Object[] objectArray = new Object[6];
                objectArray[0] = "min";
                Object object11 = callSiteArray[140].callGetProperty(callSiteArray[141].callGroovyObjectGetProperty((Object)((BasicAmazonDeployDescription)description2.get())));
                objectArray[1] = DefaultTypeTransformation.booleanUnbox((Object)object11) ? object11 : Integer.valueOf(0);
                objectArray[2] = "max";
                Object object12 = callSiteArray[142].callGetProperty(callSiteArray[143].callGroovyObjectGetProperty((Object)((BasicAmazonDeployDescription)description2.get())));
                objectArray[3] = DefaultTypeTransformation.booleanUnbox((Object)object12) ? object12 : Integer.valueOf(0);
                objectArray[4] = "desired";
                Object object13 = callSiteArray[144].callGetProperty(callSiteArray[145].callGroovyObjectGetProperty((Object)((BasicAmazonDeployDescription)description2.get())));
                objectArray[5] = DefaultTypeTransformation.booleanUnbox((Object)object13) ? object13 : Integer.valueOf(0);
                Object capacity = callSiteArray[139].callConstructor(DeploymentResult.Deployment.Capacity.class, (Object)ScriptBytecodeAdapter.createMap((Object[])objectArray));
                Object autoScalingWorker = callSiteArray[146].callConstructor(AutoScalingWorker.class, regionScopedProvider, (Object)this.launchTemplateRollOutConfig);
                Object object14 = callSiteArray[215].callGroovyObjectGetProperty((Object)((BasicAmazonDeployDescription)description2.get()));
                Object asgConfig = callSiteArray[147].call(callSiteArray[148].call(callSiteArray[149].call(callSiteArray[150].call(callSiteArray[151].call(callSiteArray[152].call(callSiteArray[153].call(callSiteArray[154].call(callSiteArray[155].call(callSiteArray[156].call(callSiteArray[157].call(callSiteArray[158].call(callSiteArray[159].call(callSiteArray[160].call(callSiteArray[161].call(callSiteArray[162].call(callSiteArray[163].call(callSiteArray[164].call(callSiteArray[165].call(callSiteArray[166].call(callSiteArray[167].call(callSiteArray[168].call(callSiteArray[169].call(callSiteArray[170].call(callSiteArray[171].call(callSiteArray[172].call(callSiteArray[173].call(callSiteArray[174].call(callSiteArray[175].call(callSiteArray[176].call(callSiteArray[177].call(callSiteArray[178].call(callSiteArray[179].call(callSiteArray[180].call(callSiteArray[181].call(callSiteArray[182].call(callSiteArray[183].call(callSiteArray[184].call(callSiteArray[185].call(callSiteArray[186].call(callSiteArray[187].call(callSiteArray[188].call(callSiteArray[189].call(callSiteArray[190].call(callSiteArray[191].call(callSiteArray[192].call(callSiteArray[193].call(callSiteArray[194].call(callSiteArray[195].call(callSiteArray[196].call(callSiteArray[197].call(callSiteArray[198].call(callSiteArray[199].call(callSiteArray[200].call(callSiteArray[201].call(callSiteArray[202].call(callSiteArray[203].call(callSiteArray[204].call(AutoScalingWorker.AsgConfiguration.class), callSiteArray[205].callGroovyObjectGetProperty((Object)((BasicAmazonDeployDescription)description2.get()))), (Object)((String)region.get())), callSiteArray[206].callGroovyObjectGetProperty((Object)((BasicAmazonDeployDescription)description2.get()))), callSiteArray[207].callGroovyObjectGetProperty((Object)((BasicAmazonDeployDescription)description2.get()))), callSiteArray[208].callGroovyObjectGetProperty((Object)((BasicAmazonDeployDescription)description2.get()))), callSiteArray[209].callGroovyObjectGetProperty((Object)ami)), (Object)classicLinkVpcId), (Object)classicLinkVpcSecurityGroups), callSiteArray[210].callGetProperty(capacity)), callSiteArray[211].callGetProperty(capacity)), callSiteArray[212].callGetProperty(capacity)), callSiteArray[213].callGroovyObjectGetProperty((Object)((BasicAmazonDeployDescription)description2.get()))), callSiteArray[214].callStatic(BasicAmazonDeployHandler.class, (Object)((BasicAmazonDeployDescription)description2.get()), (Object)this.deployDefaults)), DefaultTypeTransformation.booleanUnbox((Object)object14) ? object14 : callSiteArray[216].callGetPropertySafe(account)), callSiteArray[217].callGroovyObjectGetProperty((Object)((BasicAmazonDeployDescription)description2.get()))), callSiteArray[218].callGroovyObjectGetProperty((Object)((BasicAmazonDeployDescription)description2.get()))), callSiteArray[219].callGroovyObjectGetProperty((Object)((BasicAmazonDeployDescription)description2.get()))), callSiteArray[220].callGroovyObjectGetProperty((Object)((BasicAmazonDeployDescription)description2.get()))), callSiteArray[221].callGroovyObjectGetProperty((Object)((BasicAmazonDeployDescription)description2.get()))), callSiteArray[222].callGroovyObjectGetProperty((Object)((BasicAmazonDeployDescription)description2.get()))), (Object)availabilityZones), subnetType), callSiteArray[223].callGroovyObjectGetProperty((Object)((BasicAmazonDeployDescription)description2.get()))), callSiteArray[224].callGetProperty(loadBalancers)), callSiteArray[225].callGetProperty(targetGroups)), callSiteArray[226].callGroovyObjectGetProperty((Object)((BasicAmazonDeployDescription)description2.get()))), callSiteArray[227].callGroovyObjectGetProperty((Object)((BasicAmazonDeployDescription)description2.get()))), callSiteArray[228].callGroovyObjectGetProperty((Object)((BasicAmazonDeployDescription)description2.get()))), callSiteArray[229].callGroovyObjectGetProperty((Object)((BasicAmazonDeployDescription)description2.get()))), callSiteArray[230].callGroovyObjectGetProperty((Object)((BasicAmazonDeployDescription)description2.get()))), callSiteArray[231].callGroovyObjectGetProperty((Object)((BasicAmazonDeployDescription)description2.get()))), callSiteArray[232].callGroovyObjectGetProperty((Object)((BasicAmazonDeployDescription)description2.get()))), callSiteArray[233].callGroovyObjectGetProperty((Object)((BasicAmazonDeployDescription)description2.get()))), callSiteArray[234].callGroovyObjectGetProperty((Object)((BasicAmazonDeployDescription)description2.get()))), callSiteArray[235].callGroovyObjectGetProperty((Object)((BasicAmazonDeployDescription)description2.get()))), ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[236].callGroovyObjectGetProperty((Object)((BasicAmazonDeployDescription)description2.get())), null) ? callSiteArray[237].call(InstanceTypeUtils.class, callSiteArray[238].callGroovyObjectGetProperty((Object)((BasicAmazonDeployDescription)description2.get()))) : callSiteArray[239].callGroovyObjectGetProperty((Object)((BasicAmazonDeployDescription)description2.get()))), callSiteArray[240].callSafe(callSiteArray[241].callGroovyObjectGetProperty((Object)((BasicAmazonDeployDescription)description2.get())))), callSiteArray[242].callGroovyObjectGetProperty((Object)((BasicAmazonDeployDescription)description2.get()))), callSiteArray[243].callGroovyObjectGetProperty((Object)((BasicAmazonDeployDescription)description2.get()))), callSiteArray[244].callGetProperty(callSiteArray[245].callStatic(BasicAmazonDeployHandler.class, (Object)this.deployDefaults, (Object)((BasicAmazonDeployDescription)description2.get())))), callSiteArray[246].callGroovyObjectGetProperty((Object)((BasicAmazonDeployDescription)description2.get()))), callSiteArray[247].callStatic(BasicAmazonDeployHandler.class, account, (Object)((BasicAmazonDeployDescription)description2.get()))), callSiteArray[248].callGroovyObjectGetProperty((Object)((BasicAmazonDeployDescription)description2.get()))), callSiteArray[249].callGroovyObjectGetProperty((Object)((BasicAmazonDeployDescription)description2.get()))), callSiteArray[250].callGroovyObjectGetProperty((Object)((BasicAmazonDeployDescription)description2.get()))), callSiteArray[251].callGroovyObjectGetProperty((Object)((BasicAmazonDeployDescription)description2.get()))), ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[252].callGroovyObjectGetProperty((Object)((BasicAmazonDeployDescription)description2.get())), null) ? callSiteArray[253].callGroovyObjectGetProperty((Object)((BasicAmazonDeployDescription)description2.get())) : callSiteArray[254].callStatic(BasicAmazonDeployHandler.class, callSiteArray[255].call((Object)((BasicAmazonDeployDescription)description2.get())))), callSiteArray[256].callGroovyObjectGetProperty((Object)((BasicAmazonDeployDescription)description2.get()))), callSiteArray[257].callGroovyObjectGetProperty((Object)((BasicAmazonDeployDescription)description2.get()))), callSiteArray[258].callGroovyObjectGetProperty((Object)((BasicAmazonDeployDescription)description2.get()))), callSiteArray[259].callGroovyObjectGetProperty((Object)((BasicAmazonDeployDescription)description2.get()))), callSiteArray[260].callGroovyObjectGetProperty((Object)((BasicAmazonDeployDescription)description2.get()))), callSiteArray[261].callGroovyObjectGetProperty((Object)((BasicAmazonDeployDescription)description2.get()))), callSiteArray[262].callGroovyObjectGetProperty((Object)((BasicAmazonDeployDescription)description2.get()))), callSiteArray[263].callGroovyObjectGetProperty((Object)((BasicAmazonDeployDescription)description2.get()))), callSiteArray[264].callGroovyObjectGetProperty((Object)((BasicAmazonDeployDescription)description2.get()))));
                Object asgName = callSiteArray[265].call(autoScalingWorker, asgConfig);
                callSiteArray[266].call(callSiteArray[267].callGetProperty(deploymentResult), callSiteArray[268].call((Object)new GStringImpl(new Object[]{(String)region.get(), asgName}, new String[]{"", ":", ""})));
                Object object15 = asgName;
                callSiteArray[269].call(callSiteArray[270].callGetProperty(deploymentResult), (Object)((String)region.get()), object15);
                if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[271].callGroovyObjectGetProperty((Object)((BasicAmazonDeployDescription)description2.get()))) && DefaultTypeTransformation.booleanUnbox((Object)sourceRegionScopedProvider)) {
                    callSiteArray[272].callCurrent((GroovyObject)this, ArrayUtil.createArray((Object)callSiteArray[273].callGroovyObjectGetProperty((Object)this), (Object)sourceRegionScopedProvider, (Object)callSiteArray[274].callGetProperty(sourceRegionScopedProvider), (Object)callSiteArray[275].callGroovyObjectGetProperty((Object)((BasicAmazonDeployDescription)description2.get())), (Object)callSiteArray[276].callGetProperty(callSiteArray[277].callGroovyObjectGetProperty((Object)((BasicAmazonDeployDescription)description2.get()))), (Object)asgName, (Object)callSiteArray[278].callGetProperty(callSiteArray[279].callGroovyObjectGetProperty((Object)((BasicAmazonDeployDescription)description2.get()))), (Object)((String)region.get())));
                }
                callSiteArray[280].call(callSiteArray[281].callGroovyObjectGetProperty((Object)((BasicAmazonDeployDescription)description2.get())), callSiteArray[282].callConstructor(CreateServerGroupEvent.class, callSiteArray[283].callGetProperty(AmazonCloudProvider.class), callSiteArray[284].callGetProperty(account), (Object)((String)region.get()), asgName));
                callSiteArray[285].call(callSiteArray[286].callGetProperty(deploymentResult), callSiteArray[287].callConstructor(DeploymentResult.Deployment.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"cloudProvider", "aws", "account", callSiteArray[288].call((Object)((BasicAmazonDeployDescription)description2.get())), "location", (String)region.get(), "serverGroupName", asgName, "capacity", capacity})));
            }
        }
        callSiteArray[289].call(callSiteArray[290].callGroovyObjectGetProperty((Object)this), (Object)BASE_PHASE, (Object)new GStringImpl(new Object[]{callSiteArray[291].callGetProperty(deploymentResult)}, new String[]{"Created the following deployments: ", ""}));
        return (DeploymentResult)ScriptBytecodeAdapter.castToType((Object)deploymentResult, DeploymentResult.class);
    }

    @VisibleForTesting
    LoadBalancerLookupHelper loadBalancerLookupHelper() {
        CallSite[] callSiteArray = BasicAmazonDeployHandler.$getCallSiteArray();
        return (LoadBalancerLookupHelper)ScriptBytecodeAdapter.castToType((Object)callSiteArray[292].callConstructor(LoadBalancerLookupHelper.class), LoadBalancerLookupHelper.class);
    }

    @VisibleForTesting
    TargetGroupLookupHelper targetGroupLookupHelper() {
        CallSite[] callSiteArray = BasicAmazonDeployHandler.$getCallSiteArray();
        return (TargetGroupLookupHelper)ScriptBytecodeAdapter.castToType((Object)callSiteArray[293].callConstructor(TargetGroupLookupHelper.class), TargetGroupLookupHelper.class);
    }

    @VisibleForTesting
    BasicAmazonDeployDescription copySourceAttributes(RegionScopedProviderFactory.RegionScopedProvider sourceRegionScopedProvider, String sourceAsgName, Boolean useSourceCapacity, BasicAmazonDeployDescription description) {
        CallSite[] callSiteArray = BasicAmazonDeployHandler.$getCallSiteArray();
        Boolean copySourceSubnetIdOverrides = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[294].callGroovyObjectGetProperty((Object)description)) && !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[295].callGroovyObjectGetProperty((Object)description));
        if (DefaultTypeTransformation.booleanUnbox((Object)copySourceSubnetIdOverrides) && DefaultTypeTransformation.booleanUnbox((Object)sourceRegionScopedProvider) && DefaultTypeTransformation.booleanUnbox((Object)sourceAsgName)) {
            Object serverGroup = callSiteArray[296].call((Object)this.amazonServerGroupProvider, callSiteArray[297].callGetPropertySafe(callSiteArray[298].callGroovyObjectGetProperty((Object)sourceRegionScopedProvider)), callSiteArray[299].callGroovyObjectGetProperty((Object)sourceRegionScopedProvider), (Object)sourceAsgName);
            if (DefaultTypeTransformation.booleanUnbox((Object)serverGroup)) {
                public final class _copySourceAttributes_closure6
                extends Closure
                implements GeneratedClosure {
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;
                    private static /* synthetic */ SoftReference $callSiteArray;

                    public _copySourceAttributes_closure6(Object _outerInstance, Object _thisObject) {
                        CallSite[] callSiteArray = _copySourceAttributes_closure6.$getCallSiteArray();
                        super(_outerInstance, _thisObject);
                    }

                    public Object doCall(Object it) {
                        CallSite[] callSiteArray = _copySourceAttributes_closure6.$getCallSiteArray();
                        return ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[0].callGetProperty(it), (Object)ScriptBytecodeAdapter.getField(_copySourceAttributes_closure6.class, BasicAmazonDeployHandler.class, (String)"SUBNET_ID_OVERRIDE_TAG"));
                    }

                    @Generated
                    public Object doCall() {
                        CallSite[] callSiteArray = _copySourceAttributes_closure6.$getCallSiteArray();
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _copySourceAttributes_closure6.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                        String[] stringArray = new String[1];
                        stringArray[0] = "key";
                        return new CallSiteArray(_copySourceAttributes_closure6.class, stringArray);
                    }

                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                        CallSiteArray callSiteArray;
                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                            callSiteArray = _copySourceAttributes_closure6.$createCallSiteArray();
                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                        }
                        return callSiteArray.array;
                    }
                }
                String subnetIdTag = ShortTypeHandling.castToString((Object)callSiteArray[300].callGetPropertySafe(callSiteArray[301].call(callSiteArray[302].callGetProperty(callSiteArray[303].callGetProperty(serverGroup)), (Object)new _copySourceAttributes_closure6(this, this))));
                if (DefaultTypeTransformation.booleanUnbox((Object)subnetIdTag)) {
                    Object object = callSiteArray[304].call((Object)subnetIdTag, (Object)",");
                    ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, BasicAmazonDeployHandler.class, (GroovyObject)description, (String)"subnetIds");
                }
            }
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[305].callGroovyObjectGetProperty((Object)description))) {
            Object object = callSiteArray[306].call(callSiteArray[307].callGroovyObjectGetProperty((Object)description), (Object)",");
            callSiteArray[308].call(callSiteArray[309].callGroovyObjectGetProperty((Object)description), (Object)SUBNET_ID_OVERRIDE_TAG, object);
        }
        Object object = callSiteArray[310].callStatic(BasicAmazonDeployHandler.class, callSiteArray[311].callGroovyObjectGetProperty((Object)description));
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, BasicAmazonDeployHandler.class, (GroovyObject)description, (String)"tags");
        Object object2 = callSiteArray[312].callStatic(BasicAmazonDeployHandler.class, callSiteArray[313].callGroovyObjectGetProperty((Object)description));
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object2, BasicAmazonDeployHandler.class, (GroovyObject)description, (String)"blockDeviceTags");
        if (!(DefaultTypeTransformation.booleanUnbox((Object)useSourceCapacity) || DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[314].callGroovyObjectGetProperty((Object)description)))) {
            return description;
        }
        if (!DefaultTypeTransformation.booleanUnbox((Object)sourceRegionScopedProvider)) {
            if (DefaultTypeTransformation.booleanUnbox((Object)useSourceCapacity)) {
                throw (Throwable)callSiteArray[315].callConstructor(IllegalStateException.class, (Object)"useSourceCapacity requested, but no source available");
            }
            return description;
        }
        description = (BasicAmazonDeployDescription)ScriptBytecodeAdapter.castToType((Object)callSiteArray[316].call((Object)description), BasicAmazonDeployDescription.class);
        Object sourceAutoScaling = callSiteArray[317].callGroovyObjectGetProperty((Object)sourceRegionScopedProvider);
        Object ancestorAsgs = callSiteArray[318].callGetProperty(callSiteArray[319].call(sourceAutoScaling, callSiteArray[320].callConstructor(DescribeAutoScalingGroupsRequest.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"autoScalingGroupNames", ScriptBytecodeAdapter.createList((Object[])new Object[]{sourceAsgName})}))));
        Object sourceAsg = callSiteArray[321].call(ancestorAsgs, (Object)0);
        if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[322].callGetPropertySafe(sourceAsg)) && ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[323].callGetPropertySafe(sourceAsg), null) && ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[324].callGetPropertySafe(sourceAsg), null)) {
                if (DefaultTypeTransformation.booleanUnbox((Object)useSourceCapacity)) {
                    throw (Throwable)callSiteArray[325].callConstructor(IllegalStateException.class, (Object)"useSourceCapacity requested, but no source ASG found");
                }
                return description;
            }
        } else if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[326].callGetPropertySafe(sourceAsg)) && ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[327].callGetPropertySafe(sourceAsg), null) && ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[328].callGetPropertySafe(sourceAsg), null)) {
            if (DefaultTypeTransformation.booleanUnbox((Object)useSourceCapacity)) {
                throw (Throwable)callSiteArray[329].callConstructor(IllegalStateException.class, (Object)"useSourceCapacity requested, but no source ASG found");
            }
            return description;
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)useSourceCapacity)) {
            Object object3 = callSiteArray[330].callGetProperty(sourceAsg);
            ScriptBytecodeAdapter.setProperty((Object)object3, null, (Object)callSiteArray[331].callGroovyObjectGetProperty((Object)description), (String)"min");
            Object object4 = callSiteArray[332].callGetProperty(sourceAsg);
            ScriptBytecodeAdapter.setProperty((Object)object4, null, (Object)callSiteArray[333].callGroovyObjectGetProperty((Object)description), (String)"max");
            Object object5 = callSiteArray[334].callGetProperty(sourceAsg);
            ScriptBytecodeAdapter.setProperty((Object)object5, null, (Object)callSiteArray[335].callGroovyObjectGetProperty((Object)description), (String)"desired");
        }
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[336].callGroovyObjectGetProperty((Object)description))) {
            return description;
        }
        Object object6 = callSiteArray[337].callCurrent((GroovyObject)this, (Object)sourceRegionScopedProvider, sourceAsg, (Object)description);
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object6, BasicAmazonDeployHandler.class, (GroovyObject)description, (String)"blockDevices");
        return description;
    }

    @VisibleForTesting
    void copyScalingPoliciesAndScheduledActions(Task task, RegionScopedProviderFactory.RegionScopedProvider sourceRegionScopedProvider, NetflixAmazonCredentials sourceCredentials, NetflixAmazonCredentials targetCredentials, String sourceAsgName, String targetAsgName, String sourceRegion, String targetRegion) {
        CallSite[] callSiteArray = BasicAmazonDeployHandler.$getCallSiteArray();
        if (!DefaultTypeTransformation.booleanUnbox((Object)sourceRegionScopedProvider)) {
            return;
        }
        Object asgReferenceCopier = callSiteArray[338].call((Object)sourceRegionScopedProvider, (Object)targetCredentials, (Object)targetRegion);
        callSiteArray[339].call((Object)this.scalingPolicyCopier, ArrayUtil.createArray((Object)task, (Object)sourceAsgName, (Object)targetAsgName, (Object)((Object)sourceCredentials), (Object)((Object)targetCredentials), (Object)sourceRegion, (Object)targetRegion));
        callSiteArray[340].call(asgReferenceCopier, (Object)task, (Object)sourceAsgName, (Object)targetAsgName);
    }

    @VisibleForTesting
    static List<AmazonAsgLifecycleHook> getLifecycleHooks(NetflixAmazonCredentials credentials, BasicAmazonDeployDescription description) {
        CallSite[] callSiteArray = BasicAmazonDeployHandler.$getCallSiteArray();
        Object object = callSiteArray[341].callGroovyObjectGetProperty((Object)description);
        List lifecycleHooks = (List)ScriptBytecodeAdapter.castToType((Object)(DefaultTypeTransformation.booleanUnbox((Object)object) ? object : ScriptBytecodeAdapter.createList((Object[])new Object[0])), List.class);
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[342].callGroovyObjectGetProperty((Object)description)) && ScriptBytecodeAdapter.compareGreaterThan((Object)callSiteArray[343].callSafe(callSiteArray[344].callGetProperty((Object)credentials)), (Object)0)) {
            public final class _getLifecycleHooks_closure7
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;

                public _getLifecycleHooks_closure7(Object _outerInstance, Object _thisObject) {
                    CallSite[] callSiteArray = _getLifecycleHooks_closure7.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(Object it) {
                    CallSite[] callSiteArray = _getLifecycleHooks_closure7.$getCallSiteArray();
                    return callSiteArray[0].callConstructor(AmazonAsgLifecycleHook.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"roleARN", callSiteArray[1].callGetProperty(it), "notificationTargetARN", callSiteArray[2].callGetProperty(it), "lifecycleTransition", callSiteArray[3].call(AmazonAsgLifecycleHook.Transition.class, callSiteArray[4].callGetProperty(it)), "heartbeatTimeout", callSiteArray[5].callGetProperty(it), "defaultResult", DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[6].callGetProperty(it)) ? callSiteArray[7].call(AmazonAsgLifecycleHook.DefaultResult.class, callSiteArray[8].callGetProperty(it)) : null}));
                }

                @Generated
                public Object doCall() {
                    CallSite[] callSiteArray = _getLifecycleHooks_closure7.$getCallSiteArray();
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _getLifecycleHooks_closure7.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                    stringArray[0] = "<$constructor$>";
                    stringArray[1] = "roleARN";
                    stringArray[2] = "notificationTargetARN";
                    stringArray[3] = "valueOfName";
                    stringArray[4] = "lifecycleTransition";
                    stringArray[5] = "heartbeatTimeout";
                    stringArray[6] = "defaultResult";
                    stringArray[7] = "valueOf";
                    stringArray[8] = "defaultResult";
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[9];
                    _getLifecycleHooks_closure7.$createCallSiteArray_1(stringArray);
                    return new CallSiteArray(_getLifecycleHooks_closure7.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _getLifecycleHooks_closure7.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            }
            callSiteArray[345].call((Object)lifecycleHooks, callSiteArray[346].call(callSiteArray[347].callGetProperty((Object)credentials), (Object)new _getLifecycleHooks_closure7(BasicAmazonDeployHandler.class, BasicAmazonDeployHandler.class)));
        }
        return lifecycleHooks;
    }

    @VisibleForTesting
    public static Boolean getDefaultUnlimitedCpuCredits(Set<String> instanceTypes) {
        CallSite[] callSiteArray = BasicAmazonDeployHandler.$getCallSiteArray();
        return (Boolean)ScriptBytecodeAdapter.castToType((Object)(DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[348].call(InstanceTypeUtils.class, instanceTypes)) ? Boolean.valueOf(false) : null), Boolean.class);
    }

    public static String iamRole(BasicAmazonDeployDescription description, AwsConfiguration.DeployDefaults deployDefaults) {
        CallSite[] callSiteArray = BasicAmazonDeployHandler.$getCallSiteArray();
        Object object = callSiteArray[349].callGroovyObjectGetProperty((Object)description);
        Object iamRole = DefaultTypeTransformation.booleanUnbox((Object)object) ? object : callSiteArray[350].callGroovyObjectGetProperty((Object)deployDefaults);
        return ShortTypeHandling.castToString((Object)(DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[351].callGroovyObjectGetProperty((Object)description)) ? callSiteArray[352].call(iamRole, callSiteArray[353].call(Pattern.class, (Object)"{{application}}"), callSiteArray[354].callGroovyObjectGetProperty((Object)description)) : iamRole));
    }

    @VisibleForTesting
    static Map<String, String> cleanTags(Map<String, String> tags) {
        CallSite[] callSiteArray = BasicAmazonDeployHandler.$getCallSiteArray();
        public final class _cleanTags_closure8
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _cleanTags_closure8(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _cleanTags_closure8.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _cleanTags_closure8.$getCallSiteArray();
                return !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[0].call(callSiteArray[1].callGetProperty(it), (Object)"aws:"));
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _cleanTags_closure8.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _cleanTags_closure8.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "startsWith";
                stringArray[1] = "key";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[2];
                _cleanTags_closure8.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_cleanTags_closure8.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _cleanTags_closure8.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        return (Map)ScriptBytecodeAdapter.castToType((Object)(DefaultTypeTransformation.booleanUnbox(tags) ? callSiteArray[355].call(tags, (Object)new _cleanTags_closure8(BasicAmazonDeployHandler.class, BasicAmazonDeployHandler.class)) : ScriptBytecodeAdapter.createMap((Object[])new Object[0])), Map.class);
    }

    @VisibleForTesting
    static BasicAmazonDeployDescription applyAppStackDetailTags(AwsConfiguration.DeployDefaults deployDefaults, BasicAmazonDeployDescription description) {
        CallSite[] callSiteArray = BasicAmazonDeployHandler.$getCallSiteArray();
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[356].callGroovyObjectGetProperty((Object)deployDefaults))) {
            return description;
        }
        description = (BasicAmazonDeployDescription)ScriptBytecodeAdapter.castToType((Object)callSiteArray[357].call((Object)description), BasicAmazonDeployDescription.class);
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[358].callGroovyObjectGetProperty((Object)description))) {
            Object object = callSiteArray[359].callGroovyObjectGetProperty((Object)description);
            callSiteArray[360].call(callSiteArray[361].callGroovyObjectGetProperty((Object)description), (Object)"spinnaker:application", object);
        } else {
            callSiteArray[362].call(callSiteArray[363].callGroovyObjectGetProperty((Object)description), (Object)"spinnaker:application");
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[364].callGroovyObjectGetProperty((Object)description))) {
            Object object = callSiteArray[365].callGroovyObjectGetProperty((Object)description);
            callSiteArray[366].call(callSiteArray[367].callGroovyObjectGetProperty((Object)description), (Object)"spinnaker:stack", object);
        } else {
            callSiteArray[368].call(callSiteArray[369].callGroovyObjectGetProperty((Object)description), (Object)"spinnaker:stack");
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[370].callGroovyObjectGetProperty((Object)description))) {
            Object object = callSiteArray[371].callGroovyObjectGetProperty((Object)description);
            callSiteArray[372].call(callSiteArray[373].callGroovyObjectGetProperty((Object)description), (Object)"spinnaker:details", object);
        } else {
            callSiteArray[374].call(callSiteArray[375].callGroovyObjectGetProperty((Object)description), (Object)"spinnaker:details");
        }
        return description;
    }

    private RegionScopedProviderFactory.RegionScopedProvider buildSourceRegionScopedProvider(Task task, BasicAmazonDeployDescription.Source source) {
        CallSite[] callSiteArray = BasicAmazonDeployHandler.$getCallSiteArray();
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[376].callGroovyObjectGetProperty((Object)source)) && DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[377].callGroovyObjectGetProperty((Object)source)) && DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[378].callGroovyObjectGetProperty((Object)source))) {
            Object sourceRegion = callSiteArray[379].callGroovyObjectGetProperty((Object)source);
            Object sourceAsgCredentials = callSiteArray[380].call(this.accountCredentialsRepository, callSiteArray[381].callGroovyObjectGetProperty((Object)source));
            Object regionScopedProvider = callSiteArray[382].call((Object)this.regionScopedProviderFactory, sourceAsgCredentials, sourceRegion);
            Object sourceAsgs = callSiteArray[383].call(callSiteArray[384].callGetProperty(regionScopedProvider), callSiteArray[385].callConstructor(DescribeAutoScalingGroupsRequest.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"autoScalingGroupNames", ScriptBytecodeAdapter.createList((Object[])new Object[]{callSiteArray[386].callGroovyObjectGetProperty((Object)source)})})));
            if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[387].callGetProperty(sourceAsgs))) {
                callSiteArray[388].call((Object)task, (Object)BASE_PHASE, (Object)new GStringImpl(new Object[]{callSiteArray[389].callGroovyObjectGetProperty((Object)source), callSiteArray[390].callGroovyObjectGetProperty((Object)source), callSiteArray[391].callGroovyObjectGetProperty((Object)source)}, new String[]{"Unable to locate source asg (", ":", ":", ")"}));
                return (RegionScopedProviderFactory.RegionScopedProvider)ScriptBytecodeAdapter.castToType(null, RegionScopedProviderFactory.RegionScopedProvider.class);
            }
            return (RegionScopedProviderFactory.RegionScopedProvider)ScriptBytecodeAdapter.castToType((Object)regionScopedProvider, RegionScopedProviderFactory.RegionScopedProvider.class);
        }
        return (RegionScopedProviderFactory.RegionScopedProvider)ScriptBytecodeAdapter.castToType(null, RegionScopedProviderFactory.RegionScopedProvider.class);
    }

    public List<AmazonBlockDevice> buildBlockDeviceMappingsFromSourceAsg(RegionScopedProviderFactory.RegionScopedProvider sourceAsgRegionScopedProvider, AutoScalingGroup sourceAsg, BasicAmazonDeployDescription newAsgDescription) {
        CallSite[] callSiteArray = BasicAmazonDeployHandler.$getCallSiteArray();
        if (ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[392].callGroovyObjectGetProperty((Object)newAsgDescription), null)) {
            return (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[393].callGroovyObjectGetProperty((Object)newAsgDescription), List.class);
        }
        if (ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[394].call((Object)newAsgDescription), (Object)callSiteArray[395].call(AsgConfigHelper.class, (Object)sourceAsg, (Object)sourceAsgRegionScopedProvider))) {
            public final class _buildBlockDeviceMappingsFromSourceAsg_closure9
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;

                public _buildBlockDeviceMappingsFromSourceAsg_closure9(Object _outerInstance, Object _thisObject) {
                    CallSite[] callSiteArray = _buildBlockDeviceMappingsFromSourceAsg_closure9.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(Object it) {
                    CallSite[] callSiteArray = _buildBlockDeviceMappingsFromSourceAsg_closure9.$getCallSiteArray();
                    return ScriptBytecodeAdapter.createMap((Object[])new Object[]{"deviceName", callSiteArray[0].callGetProperty(it), "virtualName", callSiteArray[1].callGetProperty(it), "size", callSiteArray[2].callGetProperty(it)});
                }

                @Generated
                public Object doCall() {
                    CallSite[] callSiteArray = _buildBlockDeviceMappingsFromSourceAsg_closure9.$getCallSiteArray();
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _buildBlockDeviceMappingsFromSourceAsg_closure9.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                    stringArray[0] = "deviceName";
                    stringArray[1] = "virtualName";
                    stringArray[2] = "size";
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[3];
                    _buildBlockDeviceMappingsFromSourceAsg_closure9.$createCallSiteArray_1(stringArray);
                    return new CallSiteArray(_buildBlockDeviceMappingsFromSourceAsg_closure9.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _buildBlockDeviceMappingsFromSourceAsg_closure9.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            }
            public final class _buildBlockDeviceMappingsFromSourceAsg_closure10
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;

                public _buildBlockDeviceMappingsFromSourceAsg_closure10(Object _outerInstance, Object _thisObject) {
                    CallSite[] callSiteArray = _buildBlockDeviceMappingsFromSourceAsg_closure10.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(Object it) {
                    CallSite[] callSiteArray = _buildBlockDeviceMappingsFromSourceAsg_closure10.$getCallSiteArray();
                    return callSiteArray[0].callGetProperty(it);
                }

                @Generated
                public Object doCall() {
                    CallSite[] callSiteArray = _buildBlockDeviceMappingsFromSourceAsg_closure10.$getCallSiteArray();
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _buildBlockDeviceMappingsFromSourceAsg_closure10.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[1];
                    stringArray[0] = "deviceName";
                    return new CallSiteArray(_buildBlockDeviceMappingsFromSourceAsg_closure10.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _buildBlockDeviceMappingsFromSourceAsg_closure10.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            }
            Object blockDevicesForSourceAsg = callSiteArray[396].call(callSiteArray[397].call(callSiteArray[398].call(AsgConfigHelper.class, (Object)sourceAsg, (Object)sourceAsgRegionScopedProvider), (Object)new _buildBlockDeviceMappingsFromSourceAsg_closure9(this, this)), (Object)new _buildBlockDeviceMappingsFromSourceAsg_closure10(this, this));
            public final class _buildBlockDeviceMappingsFromSourceAsg_closure11
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;

                public _buildBlockDeviceMappingsFromSourceAsg_closure11(Object _outerInstance, Object _thisObject) {
                    CallSite[] callSiteArray = _buildBlockDeviceMappingsFromSourceAsg_closure11.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(Object it) {
                    CallSite[] callSiteArray = _buildBlockDeviceMappingsFromSourceAsg_closure11.$getCallSiteArray();
                    return ScriptBytecodeAdapter.createMap((Object[])new Object[]{"deviceName", callSiteArray[0].callGetProperty(it), "virtualName", callSiteArray[1].callGetProperty(it), "size", callSiteArray[2].callGetProperty(it)});
                }

                @Generated
                public Object doCall() {
                    CallSite[] callSiteArray = _buildBlockDeviceMappingsFromSourceAsg_closure11.$getCallSiteArray();
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _buildBlockDeviceMappingsFromSourceAsg_closure11.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                    stringArray[0] = "deviceName";
                    stringArray[1] = "virtualName";
                    stringArray[2] = "size";
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[3];
                    _buildBlockDeviceMappingsFromSourceAsg_closure11.$createCallSiteArray_1(stringArray);
                    return new CallSiteArray(_buildBlockDeviceMappingsFromSourceAsg_closure11.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _buildBlockDeviceMappingsFromSourceAsg_closure11.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            }
            public final class _buildBlockDeviceMappingsFromSourceAsg_closure12
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;

                public _buildBlockDeviceMappingsFromSourceAsg_closure12(Object _outerInstance, Object _thisObject) {
                    CallSite[] callSiteArray = _buildBlockDeviceMappingsFromSourceAsg_closure12.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(Object it) {
                    CallSite[] callSiteArray = _buildBlockDeviceMappingsFromSourceAsg_closure12.$getCallSiteArray();
                    return callSiteArray[0].callGetProperty(it);
                }

                @Generated
                public Object doCall() {
                    CallSite[] callSiteArray = _buildBlockDeviceMappingsFromSourceAsg_closure12.$getCallSiteArray();
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _buildBlockDeviceMappingsFromSourceAsg_closure12.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[1];
                    stringArray[0] = "deviceName";
                    return new CallSiteArray(_buildBlockDeviceMappingsFromSourceAsg_closure12.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _buildBlockDeviceMappingsFromSourceAsg_closure12.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            }
            Object defaultBlockDevicesForSourceInsType = callSiteArray[399].call(callSiteArray[400].call(callSiteArray[401].call((Object)this.blockDeviceConfig, callSiteArray[402].call(AsgConfigHelper.class, (Object)sourceAsg, (Object)sourceAsgRegionScopedProvider)), (Object)new _buildBlockDeviceMappingsFromSourceAsg_closure11(this, this)), (Object)new _buildBlockDeviceMappingsFromSourceAsg_closure12(this, this));
            int isDefaultMappingUsedInSourceAsg = 0;
            isDefaultMappingUsedInSourceAsg = !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass() ? (int)(ScriptBytecodeAdapter.compareEqual((Object)blockDevicesForSourceAsg, (Object)defaultBlockDevicesForSourceInsType) ? 1 : 0) : (int)(ScriptBytecodeAdapter.compareEqual((Object)blockDevicesForSourceAsg, (Object)defaultBlockDevicesForSourceInsType) ? 1 : 0);
            if (isDefaultMappingUsedInSourceAsg != 0) {
                return (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[403].call((Object)this.blockDeviceConfig, callSiteArray[404].call((Object)newAsgDescription)), List.class);
            }
        }
        return (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[405].call(AsgConfigHelper.class, (Object)sourceAsg, (Object)sourceAsgRegionScopedProvider), List.class);
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != BasicAmazonDeployHandler.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    static {
        Object object = BasicAmazonDeployHandler.$getCallSiteArray()[406].call(LoggerFactory.class, (Object)"com.netflix.spinnaker.clouddriver.aws.deploy.handlers.BasicAmazonDeployHandler");
        log = (Logger)ScriptBytecodeAdapter.castToType((Object)object, Logger.class);
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "get";
        stringArray[1] = "threadLocalTask";
        stringArray[2] = "<$constructor$>";
        stringArray[3] = "updateStatus";
        stringArray[4] = "task";
        stringArray[5] = "availabilityZones";
        stringArray[6] = "iterator";
        stringArray[7] = "availabilityZones";
        stringArray[8] = "key";
        stringArray[9] = "buildSourceRegionScopedProvider";
        stringArray[10] = "task";
        stringArray[11] = "source";
        stringArray[12] = "copySourceAttributes";
        stringArray[13] = "asgName";
        stringArray[14] = "source";
        stringArray[15] = "useSourceCapacity";
        stringArray[16] = "source";
        stringArray[17] = "value";
        stringArray[18] = "subnetType";
        stringArray[19] = "getAt";
        stringArray[20] = "loadBalancers";
        stringArray[21] = "findAll";
        stringArray[22] = "loadBalancers";
        stringArray[23] = "addAll";
        stringArray[24] = "loadBalancers";
        stringArray[25] = "name";
        stringArray[26] = "forRegion";
        stringArray[27] = "credentials";
        stringArray[28] = "getLoadBalancersByName";
        stringArray[29] = "loadBalancerLookupHelper";
        stringArray[30] = "loadBalancers";
        stringArray[31] = "unknownLoadBalancers";
        stringArray[32] = "<$constructor$>";
        stringArray[33] = "unknownLoadBalancers";
        stringArray[34] = "getTargetGroupsByName";
        stringArray[35] = "targetGroupLookupHelper";
        stringArray[36] = "targetGroups";
        stringArray[37] = "unknownTargetGroups";
        stringArray[38] = "<$constructor$>";
        stringArray[39] = "unknownTargetGroups";
        stringArray[40] = "amazonEC2";
        stringArray[41] = "describeVpcClassicLink";
        stringArray[42] = "vpcId";
        stringArray[43] = "find";
        stringArray[44] = "vpcs";
        stringArray[45] = "addAll";
        stringArray[46] = "classicLinkVpcSecurityGroups";
        stringArray[47] = "classicLinkSecurityGroupName";
        stringArray[48] = "addAll";
        stringArray[49] = "classicLinkSecurityGroupName";
        stringArray[50] = "classicLinkVpcId";
        stringArray[51] = "classicLinkVpcSecurityGroups";
        stringArray[52] = "findAll";
        stringArray[53] = "removeAll";
        stringArray[54] = "withGroupIds";
        stringArray[55] = "<$constructor$>";
        stringArray[56] = "findResults";
        stringArray[57] = "securityGroups";
        stringArray[58] = "describeSecurityGroups";
        stringArray[59] = "amazonEC2";
        stringArray[60] = "size";
        stringArray[61] = "size";
        stringArray[62] = "<$constructor$>";
        stringArray[63] = "addAll";
        stringArray[64] = "addAppGroupsToClassicLink";
        stringArray[65] = "source";
        stringArray[66] = "parseName";
        stringArray[67] = "asgName";
        stringArray[68] = "source";
        stringArray[69] = "app";
        stringArray[70] = "application";
        stringArray[71] = "remove";
        stringArray[72] = "app";
        stringArray[73] = "stack";
        stringArray[74] = "stack";
        stringArray[75] = "stack";
        stringArray[76] = "remove";
        stringArray[77] = "toString";
        stringArray[78] = "app";
        stringArray[79] = "stack";
        stringArray[80] = "detail";
        stringArray[81] = "detail";
        stringArray[82] = "freeFormDetails";
        stringArray[83] = "remove";
        stringArray[84] = "app";
        stringArray[85] = "stack";
        stringArray[86] = "detail";
        stringArray[87] = "contains";
        stringArray[88] = "application";
        stringArray[89] = "add";
        stringArray[90] = "application";
        stringArray[91] = "stack";
        stringArray[92] = "application";
        stringArray[93] = "stack";
        stringArray[94] = "contains";
        stringArray[95] = "add";
        stringArray[96] = "freeFormDetails";
        stringArray[97] = "application";
        stringArray[98] = "stack";
        stringArray[99] = "freeFormDetails";
        stringArray[100] = "contains";
        stringArray[101] = "add";
        stringArray[102] = "size";
        stringArray[103] = "maxClassicLinkSecurityGroups";
        stringArray[104] = "getSecurityGroupIds";
        stringArray[105] = "securityGroupService";
        stringArray[106] = "iterator";
        stringArray[107] = "containsKey";
        stringArray[108] = "size";
        stringArray[109] = "maxClassicLinkSecurityGroups";
        stringArray[110] = "add";
        stringArray[111] = "updateStatus";
        stringArray[112] = "task";
        stringArray[113] = "maxClassicLinkSecurityGroups";
        stringArray[114] = "toList";
        stringArray[115] = "updateStatus";
        stringArray[116] = "task";
        stringArray[117] = "find";
        stringArray[118] = "resolveAmiIdFromAllSources";
        stringArray[119] = "amiName";
        stringArray[120] = "accountId";
        stringArray[121] = "credentials";
        stringArray[122] = "<$constructor$>";
        stringArray[123] = "amiName";
        stringArray[124] = "validateCompatibilityWithAmi";
        stringArray[125] = "getAllInstanceTypes";
        stringArray[126] = "getOne";
        stringArray[127] = "name";
        stringArray[128] = "credentials";
        stringArray[129] = "<$constructor$>";
        stringArray[130] = "name";
        stringArray[131] = "credentials";
        stringArray[132] = "useAmiBlockDeviceMappings";
        stringArray[133] = "convertBlockDevices";
        stringArray[134] = "blockDeviceMappings";
        stringArray[135] = "blockDevices";
        stringArray[136] = "getBlockDevicesForInstanceType";
        stringArray[137] = "instanceType";
        stringArray[138] = "spotPrice";
        stringArray[139] = "<$constructor$>";
        stringArray[140] = "min";
        stringArray[141] = "capacity";
        stringArray[142] = "max";
        stringArray[143] = "capacity";
        stringArray[144] = "desired";
        stringArray[145] = "capacity";
        stringArray[146] = "<$constructor$>";
        stringArray[147] = "build";
        stringArray[148] = "capacityRebalance";
        stringArray[149] = "launchTemplateOverridesForInstanceType";
        stringArray[150] = "spotInstancePools";
        stringArray[151] = "spotAllocationStrategy";
        stringArray[152] = "onDemandPercentageAboveBaseCapacity";
        stringArray[153] = "onDemandBaseCapacity";
        stringArray[154] = "onDemandAllocationStrategy";
        stringArray[155] = "licenseSpecifications";
        stringArray[156] = "placement";
        stringArray[157] = "unlimitedCpuCredits";
        stringArray[158] = "associateIPv6Address";
        stringArray[159] = "enableEnclave";
        stringArray[160] = "requireIMDSv2";
        stringArray[161] = "setLaunchTemplate";
        stringArray[162] = "lifecycleHooks";
        stringArray[163] = "blockDeviceTags";
        stringArray[164] = "tags";
        stringArray[165] = "userDataOverride";
        stringArray[166] = "legacyUdf";
        stringArray[167] = "base64UserData";
        stringArray[168] = "ebsOptimized";
        stringArray[169] = "instanceMonitoring";
        stringArray[170] = "ramdiskId";
        stringArray[171] = "kernelId";
        stringArray[172] = "suspendedProcesses";
        stringArray[173] = "spotMaxPrice";
        stringArray[174] = "terminationPolicies";
        stringArray[175] = "healthCheckType";
        stringArray[176] = "healthCheckGracePeriod";
        stringArray[177] = "enabledMetrics";
        stringArray[178] = "cooldown";
        stringArray[179] = "targetGroupArns";
        stringArray[180] = "classicLoadBalancers";
        stringArray[181] = "subnetIds";
        stringArray[182] = "subnetType";
        stringArray[183] = "availabilityZones";
        stringArray[184] = "instanceType";
        stringArray[185] = "blockDevices";
        stringArray[186] = "associatePublicIpAddress";
        stringArray[187] = "startDisabled";
        stringArray[188] = "ignoreSequence";
        stringArray[189] = "sequence";
        stringArray[190] = "keyPair";
        stringArray[191] = "iamRole";
        stringArray[192] = "securityGroups";
        stringArray[193] = "desiredInstances";
        stringArray[194] = "maxInstances";
        stringArray[195] = "minInstances";
        stringArray[196] = "classicLinkVpcSecurityGroups";
        stringArray[197] = "classicLinkVpcId";
        stringArray[198] = "ami";
        stringArray[199] = "freeFormDetails";
        stringArray[200] = "stack";
        stringArray[201] = "credentials";
        stringArray[202] = "region";
        stringArray[203] = "application";
        stringArray[204] = "builder";
        stringArray[205] = "application";
        stringArray[206] = "credentials";
        stringArray[207] = "stack";
        stringArray[208] = "freeFormDetails";
        stringArray[209] = "amiId";
        stringArray[210] = "min";
        stringArray[211] = "max";
        stringArray[212] = "desired";
        stringArray[213] = "securityGroups";
        stringArray[214] = "iamRole";
        stringArray[215] = "keyPair";
        stringArray[216] = "defaultKeyPair";
        stringArray[217] = "sequence";
        stringArray[218] = "ignoreSequence";
        stringArray[219] = "startDisabled";
        stringArray[220] = "associatePublicIpAddress";
        stringArray[221] = "blockDevices";
        stringArray[222] = "instanceType";
        stringArray[223] = "subnetIds";
        stringArray[224] = "classicLoadBalancers";
        stringArray[225] = "targetGroupARNs";
        stringArray[226] = "cooldown";
        stringArray[227] = "enabledMetrics";
        stringArray[228] = "healthCheckGracePeriod";
        stringArray[229] = "healthCheckType";
        stringArray[230] = "terminationPolicies";
        stringArray[231] = "spotPrice";
        stringArray[232] = "suspendedProcesses";
        stringArray[233] = "kernelId";
        stringArray[234] = "ramdiskId";
        stringArray[235] = "instanceMonitoring";
        stringArray[236] = "ebsOptimized";
        stringArray[237] = "getDefaultEbsOptimizedFlag";
        stringArray[238] = "instanceType";
        stringArray[239] = "ebsOptimized";
        stringArray[240] = "trim";
        stringArray[241] = "base64UserData";
        stringArray[242] = "legacyUdf";
        stringArray[243] = "userDataOverride";
        stringArray[244] = "tags";
        stringArray[245] = "applyAppStackDetailTags";
        stringArray[246] = "blockDeviceTags";
        stringArray[247] = "getLifecycleHooks";
        stringArray[248] = "setLaunchTemplate";
        stringArray[249] = "requireIMDSv2";
        stringArray[250] = "enableEnclave";
        stringArray[251] = "associateIPv6Address";
        stringArray[252] = "unlimitedCpuCredits";
        stringArray[253] = "unlimitedCpuCredits";
        stringArray[254] = "getDefaultUnlimitedCpuCredits";
        stringArray[255] = "getAllowedInstanceTypes";
        stringArray[256] = "placement";
        stringArray[257] = "licenseSpecifications";
        stringArray[258] = "onDemandAllocationStrategy";
        stringArray[259] = "onDemandBaseCapacity";
        stringArray[260] = "onDemandPercentageAboveBaseCapacity";
        stringArray[261] = "spotAllocationStrategy";
        stringArray[262] = "spotInstancePools";
        stringArray[263] = "launchTemplateOverridesForInstanceType";
        stringArray[264] = "capacityRebalance";
        stringArray[265] = "deploy";
        stringArray[266] = "leftShift";
        stringArray[267] = "serverGroupNames";
        stringArray[268] = "toString";
        stringArray[269] = "putAt";
        stringArray[270] = "serverGroupNameByRegion";
        stringArray[271] = "copySourceScalingPoliciesAndActions";
        stringArray[272] = "copyScalingPoliciesAndScheduledActions";
        stringArray[273] = "task";
        stringArray[274] = "amazonCredentials";
        stringArray[275] = "credentials";
        stringArray[276] = "asgName";
        stringArray[277] = "source";
        stringArray[278] = "region";
        stringArray[279] = "source";
        stringArray[280] = "leftShift";
        stringArray[281] = "events";
        stringArray[282] = "<$constructor$>";
        stringArray[283] = "ID";
        stringArray[284] = "accountId";
        stringArray[285] = "add";
        stringArray[286] = "deployments";
        stringArray[287] = "<$constructor$>";
        stringArray[288] = "getAccount";
        stringArray[289] = "updateStatus";
        stringArray[290] = "task";
        stringArray[291] = "deployments";
        stringArray[292] = "<$constructor$>";
        stringArray[293] = "<$constructor$>";
        stringArray[294] = "copySourceSubnetIdOverrides";
        stringArray[295] = "subnetIds";
        stringArray[296] = "getServerGroup";
        stringArray[297] = "name";
        stringArray[298] = "amazonCredentials";
        stringArray[299] = "region";
        stringArray[300] = "value";
        stringArray[301] = "find";
        stringArray[302] = "tags";
        stringArray[303] = "asg";
        stringArray[304] = "split";
        stringArray[305] = "subnetIds";
        stringArray[306] = "join";
        stringArray[307] = "subnetIds";
        stringArray[308] = "putAt";
        stringArray[309] = "tags";
        stringArray[310] = "cleanTags";
        stringArray[311] = "tags";
        stringArray[312] = "cleanTags";
        stringArray[313] = "blockDeviceTags";
        stringArray[314] = "copySourceCustomBlockDeviceMappings";
        stringArray[315] = "<$constructor$>";
        stringArray[316] = "clone";
        stringArray[317] = "autoScaling";
        stringArray[318] = "autoScalingGroups";
        stringArray[319] = "describeAutoScalingGroups";
        stringArray[320] = "<$constructor$>";
        stringArray[321] = "getAt";
        stringArray[322] = "launchConfigurationName";
        stringArray[323] = "launchTemplate";
        stringArray[324] = "mixedInstancesPolicy";
        stringArray[325] = "<$constructor$>";
        stringArray[326] = "launchConfigurationName";
        stringArray[327] = "launchTemplate";
        stringArray[328] = "mixedInstancesPolicy";
        stringArray[329] = "<$constructor$>";
        stringArray[330] = "minSize";
        stringArray[331] = "capacity";
        stringArray[332] = "maxSize";
        stringArray[333] = "capacity";
        stringArray[334] = "desiredCapacity";
        stringArray[335] = "capacity";
        stringArray[336] = "copySourceCustomBlockDeviceMappings";
        stringArray[337] = "buildBlockDeviceMappingsFromSourceAsg";
        stringArray[338] = "getAsgReferenceCopier";
        stringArray[339] = "copyScalingPolicies";
        stringArray[340] = "copyScheduledActionsForAsg";
        stringArray[341] = "lifecycleHooks";
        stringArray[342] = "includeAccountLifecycleHooks";
        stringArray[343] = "size";
        stringArray[344] = "lifecycleHooks";
        stringArray[345] = "addAll";
        stringArray[346] = "collect";
        stringArray[347] = "lifecycleHooks";
        stringArray[348] = "isBurstingSupportedByAllTypes";
        stringArray[349] = "iamRole";
        stringArray[350] = "iamRole";
        stringArray[351] = "application";
        stringArray[352] = "replaceAll";
        stringArray[353] = "quote";
        stringArray[354] = "application";
        stringArray[355] = "findAll";
        stringArray[356] = "addAppStackDetailTags";
        stringArray[357] = "clone";
        stringArray[358] = "application";
        stringArray[359] = "application";
        stringArray[360] = "putAt";
        stringArray[361] = "tags";
        stringArray[362] = "remove";
        stringArray[363] = "tags";
        stringArray[364] = "stack";
        stringArray[365] = "stack";
        stringArray[366] = "putAt";
        stringArray[367] = "tags";
        stringArray[368] = "remove";
        stringArray[369] = "tags";
        stringArray[370] = "freeFormDetails";
        stringArray[371] = "freeFormDetails";
        stringArray[372] = "putAt";
        stringArray[373] = "tags";
        stringArray[374] = "remove";
        stringArray[375] = "tags";
        stringArray[376] = "account";
        stringArray[377] = "region";
        stringArray[378] = "asgName";
        stringArray[379] = "region";
        stringArray[380] = "getOne";
        stringArray[381] = "account";
        stringArray[382] = "forRegion";
        stringArray[383] = "describeAutoScalingGroups";
        stringArray[384] = "autoScaling";
        stringArray[385] = "<$constructor$>";
        stringArray[386] = "asgName";
        stringArray[387] = "autoScalingGroups";
        stringArray[388] = "updateStatus";
        stringArray[389] = "account";
        stringArray[390] = "region";
        stringArray[391] = "asgName";
        stringArray[392] = "blockDevices";
        stringArray[393] = "blockDevices";
        stringArray[394] = "getInstanceType";
        stringArray[395] = "getTopLevelInstanceTypeForAsg";
        stringArray[396] = "sort";
        stringArray[397] = "collect";
        stringArray[398] = "getBlockDeviceMappingForAsg";
        stringArray[399] = "sort";
        stringArray[400] = "collect";
        stringArray[401] = "getBlockDevicesForInstanceType";
        stringArray[402] = "getTopLevelInstanceTypeForAsg";
        stringArray[403] = "getBlockDevicesForInstanceType";
        stringArray[404] = "getInstanceType";
        stringArray[405] = "getBlockDeviceMappingForAsg";
        stringArray[406] = "getLogger";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[407];
        BasicAmazonDeployHandler.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(BasicAmazonDeployHandler.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = BasicAmazonDeployHandler.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

