/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.aws.deploy.ops;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.cloudformation.AmazonCloudFormation;
import com.amazonaws.services.cloudformation.model.DeleteChangeSetRequest;
import com.netflix.spinnaker.clouddriver.aws.deploy.description.DeleteCloudFormationChangeSetDescription;
import com.netflix.spinnaker.clouddriver.aws.security.AmazonClientProvider;
import com.netflix.spinnaker.clouddriver.data.task.Task;
import com.netflix.spinnaker.clouddriver.data.task.TaskRepository;
import com.netflix.spinnaker.clouddriver.orchestration.AtomicOperation;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class DeleteCloudFormationChangeSetAtomicOperation
implements AtomicOperation<Map> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DeleteCloudFormationChangeSetAtomicOperation.class);
    private static final String BASE_PHASE = "DELETE_CLOUDFORMATION_CHANGESET";
    @Autowired
    AmazonClientProvider amazonClientProvider;
    private DeleteCloudFormationChangeSetDescription description;

    public DeleteCloudFormationChangeSetAtomicOperation(DeleteCloudFormationChangeSetDescription deployCloudFormationDescription) {
        this.description = deployCloudFormationDescription;
    }

    public Map operate(List priorOutputs) {
        Task task = (Task)TaskRepository.threadLocalTask.get();
        AmazonCloudFormation amazonCloudFormation = this.amazonClientProvider.getAmazonCloudFormation(this.description.getCredentials(), this.description.getRegion());
        DeleteChangeSetRequest deleteChangeSetRequest = new DeleteChangeSetRequest().withStackName(this.description.getStackName()).withChangeSetName(this.description.getChangeSetName());
        try {
            task.updateStatus(BASE_PHASE, "Deleting CloudFormation ChangeSet");
            amazonCloudFormation.deleteChangeSet(deleteChangeSetRequest);
        }
        catch (AmazonServiceException e) {
            log.error("Error removing change set " + this.description.getChangeSetName() + " on stack " + this.description.getStackName(), (Throwable)e);
            throw e;
        }
        return Collections.emptyMap();
    }
}

